/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ora;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ideimpl.db.panels.table.IndexEditorPanel;
import oracle.ideimpl.db.panels.table.IndexPartitioningPanel;
import oracle.ideimpl.db.panels.table.IndexPropertiesPanel;
import oracle.ideimpl.db.panels.table.StoragePanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Index;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.validators.ValidationException;

public class IndexPanelLibrary
extends PanelLibrary<Index> {
    public IndexPanelLibrary() {
        super("INDEX");
        this.addPanel(UIBundle.get("DEFINITION"), IndexEditorPanel.class, "f1_odbindexdef_html", "columnExpressions");
        this.addPanel(UIBundle.get("INDEX_PANEL_LABEL_PROPERTIES"), IndexPropertiesPanel.class, "f1_odbindexprops_html", "keyCompression", "parallelDegree");
        this.addPanel(UIBundle.get("STORAGE_INFO_TITLE"), StoragePanel.class, "f1_odbtastoropts_html", "OracleStorageProperties");
        this.addPanel(UIBundle.get("IPP_TITLE"), IndexPartitioningPanel.class, "f1_odbtaindexpartitions_html", "OracleIndexPartitions");
    }

    @Override
    protected List<String> getTitles(Index index, DBObjectProvider dBObjectProvider, boolean bl) {
        if (bl && (index.getTable() == null || !this.isIndexValidForEditting(index, dBObjectProvider))) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(UIBundle.get("DEFINITION"));
        arrayList.add(UIBundle.get("INDEX_PANEL_LABEL_PROPERTIES"));
        arrayList.add(UIBundle.get("STORAGE_INFO_TITLE"));
        arrayList.add(UIBundle.get("IPP_TITLE"));
        return arrayList;
    }

    protected boolean isIndexValidForEditting(Index index, DBObjectProvider dBObjectProvider) {
        if (TemporaryObjectID.findOriginalObject((DBObject)index) != null && dBObjectProvider instanceof Database) {
            try {
                dBObjectProvider.validateObjectProperty((DBObject)index, "columnExpressions");
            }
            catch (ValidationException validationException) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean canEditObject(Index index, DBObjectProvider dBObjectProvider) {
        return true;
    }
}

