/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.hive.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.event.SwingDBObjectPropertyListener;
import oracle.ide.panels.Navigable;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.hive.components.HivePartitionsComponentWrapper;
import oracle.ideimpl.db.hive.panels.HiveStoragePanel;
import oracle.ideimpl.db.hive.resource.HiveUIBundle;
import oracle.ideimpl.db.panels.BaseChildrenEditorPanel;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.ChildTableTabPanel;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.hive.HivePartition;
import oracle.javatools.db.hive.HivePropertyMetadata;
import oracle.javatools.db.property.DisplayNames;
import oracle.javatools.db.property.Property;
import oracle.javatools.ui.table.GenericTable;

public class HivePartitionsPanel
extends BaseChildrenEditorPanel<HivePartition, Table> {
    public HivePartitionsPanel() {
        super("HivePartitionsPanel");
        this.getComponentFactory().setAllowRecreate(false);
    }

    @Override
    protected ChildObjectEditorPanel createChildPanel() {
        return new BottomTabs();
    }

    @Override
    protected Class<HivePartition> getChildClass() {
        return HivePartition.class;
    }

    protected HivePartition[] getChildren() {
        HivePartitionsComponentWrapper hivePartitionsComponentWrapper = this.getTableWrapper();
        return (HivePartition[])((ComponentWrapper)hivePartitionsComponentWrapper).getPropertyValue();
    }

    @Override
    protected void selectChild(HivePartition hivePartition) {
        HivePartition hivePartition2 = (HivePartition)this.getCurrentChild();
        if (hivePartition2 != hivePartition && (hivePartition2 == null || this.exitChildPanel())) {
            HivePartitionsComponentWrapper hivePartitionsComponentWrapper = this.getTableWrapper();
            int n = ((HivePartitionsComponentWrapper.HivePartitionsTable)hivePartitionsComponentWrapper.getExtendedTable()).indexOf(hivePartition);
            if (n >= 0) {
                GenericTable genericTable = ((HivePartitionsComponentWrapper.HivePartitionsTable)hivePartitionsComponentWrapper.getExtendedTable()).getTable();
                if (genericTable.getSelectedRow() != n) {
                    genericTable.getSelectionModel().setSelectionInterval(n, n);
                }
                this.enterChildPanel(hivePartition);
            }
            this.setCurrentChild(hivePartition);
            this.getChildPanel().setVisible(hivePartition != null);
        }
    }

    private HivePartitionsComponentWrapper getTableWrapper() {
        return (HivePartitionsComponentWrapper)this.getOrCreateWrapper(Property.createPath((String[])new String[]{"HivePartitionProperties", "partitions"}));
    }

    @Override
    protected void initialiseComponents() {
        Object object;
        HivePartitionsComponentWrapper hivePartitionsComponentWrapper = this.getTableWrapper();
        DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
        dBUILayoutHelper.setMarginBottom(0);
        String string = Property.createPath((String[])new String[]{"HivePartitionProperties", "partitionColumns"});
        if (!this.isEditing() || this.getProvider().getPropertyManager().canAlterProperty((SystemObject)this.getOriginalObject(), (SystemObject)this.getUpdatedObject(), string)) {
            object = this.getOrCreateWrapper(string);
            ((ComponentWrapper)object).addListener(propertyChangeEvent -> this.columnsChanged(propertyChangeEvent));
            Component component = ((ComponentWrapper)object).getComponent();
            dBUILayoutHelper.add(component, 1, 1, true, this.isInFlatEditor());
            dBUILayoutHelper.nextRowWithGap();
            if (this.isInFlatEditor()) {
                component.setPreferredSize(new Dimension(200, 100));
            }
        }
        object = hivePartitionsComponentWrapper.getComponent();
        dBUILayoutHelper.add((Component)object, 1, 1, true, true);
        dBUILayoutHelper.nextRow();
        if (this.isInFlatEditor()) {
            ((Component)object).setPreferredSize(new Dimension(200, 100));
        }
        dBUILayoutHelper.add((Component)((Object)this.getChildPanel()), 1, 1, true, false);
        dBUILayoutHelper.layout();
        ((HivePartitionsComponentWrapper.HivePartitionsTable)hivePartitionsComponentWrapper.getExtendedTable()).getTable().getSelectionModel().addListSelectionListener(listSelectionEvent -> this.selectionChanged(listSelectionEvent));
    }

    private void selectionChanged(ListSelectionEvent listSelectionEvent) {
        if (this.isEntered() && !listSelectionEvent.getValueIsAdjusting()) {
            HivePartitionsComponentWrapper.HivePartitionsTable hivePartitionsTable = (HivePartitionsComponentWrapper.HivePartitionsTable)this.getTableWrapper().getExtendedTable();
            HivePartition hivePartition = hivePartitionsTable.getPartition(hivePartitionsTable.getTable().getSelectedRowInModel());
            this.selectChild(hivePartition);
        }
    }

    private void columnsChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.isEntered()) {
            this.commitCurrentWrapper();
            HivePartitionsPanel.columnsChanged(propertyChangeEvent, this.getTableWrapper(), this.getComponentFactoryUpdatedObject());
        }
    }

    @Override
    protected void initialisePanel() {
        HivePartition[] hivePartitionArray;
        if (this.getCurrentChild() == null && (hivePartitionArray = this.getChildren()).length > 0) {
            this.selectChild(hivePartitionArray[0]);
        }
    }

    static void columnsChanged(PropertyChangeEvent propertyChangeEvent, HivePartitionsComponentWrapper hivePartitionsComponentWrapper, DBObject dBObject) {
        DBObjectID[] dBObjectIDArray = (DBObjectID[])propertyChangeEvent.getNewValue();
        if (dBObjectIDArray == null || dBObjectIDArray.length == 0) {
            hivePartitionsComponentWrapper.resetPropertyValue(null);
        } else {
            HivePropertyMetadata.refactorValues((PropertyChangeEvent)propertyChangeEvent, (HivePartition[])((HivePartition[])hivePartitionsComponentWrapper.getPropertyValue()));
            hivePartitionsComponentWrapper.refreshObject(dBObject);
        }
    }

    private static class BottomTabs
    extends ChildTableTabPanel<HivePartition, Table> {
        BottomTabs() {
            super("PartitionTabs", Property.createPath((String[])new String[]{"HivePartitionProperties", "partitions"}), 0);
        }

        @Override
        protected Collection<Navigable> getTabs() {
            ArrayList<Navigable> arrayList = new ArrayList<Navigable>();
            arrayList.add(this.createNavigable(HiveUIBundle.get("DETAILS"), PartitionSpecPanel.class, new String[0]));
            arrayList.add(this.createNavigable(DisplayNames.getPropertyDisplayName((String)"hdfsLocation"), PartitionLocationPanel.class, Property.createPath((String[])new String[]{"HiveStorageProperties", "hdfsLocation"})));
            arrayList.add(this.createNavigable(HiveUIBundle.get("STORAGE_FORMAT"), PartitionFileFormatPanel.class, Property.createPath((String[])new String[]{"HiveStorageProperties", "predefinedFileFormat"}), Property.createPath((String[])new String[]{"HiveStorageProperties", "inputFormatClass"}), Property.createPath((String[])new String[]{"HiveStorageProperties", "outputFormatClass"})));
            arrayList.add(this.createNavigable(HiveUIBundle.get("SERDE"), PartitionSerDePanel.class, Property.createPath((String[])new String[]{"HiveStorageProperties", "serDeClass"}), Property.createPath((String[])new String[]{"HiveStorageProperties", "serDeProperties"})));
            return arrayList;
        }

        @Override
        protected boolean shouldValidateOnExit() {
            return false;
        }
    }

    public static class PartitionSerDePanel
    extends ChildObjectEditorPanel<HivePartition, Table> {
        public PartitionSerDePanel() {
            super("PartitionSerDePanel", Property.createPath((String[])new String[]{"HivePartitionProperties", "partitions"}));
        }

        @Override
        protected void initialiseChildComponents() {
            DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
            ComponentWrapper componentWrapper = this.getOrCreateWrapper(Property.createPath((String[])new String[]{"HiveStorageProperties", "serDeClass"}));
            dBUILayoutHelper.add(componentWrapper);
            dBUILayoutHelper.pushUp();
            dBUILayoutHelper.layout();
        }
    }

    public static class PartitionFileFormatPanel
    extends ChildObjectEditorPanel<HivePartition, Table> {
        public PartitionFileFormatPanel() {
            super("PartitionFileFormatPanel", Property.createPath((String[])new String[]{"HivePartitionProperties", "partitions"}));
        }

        @Override
        protected void initialiseChildComponents() {
            DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
            ComponentWrapper componentWrapper = this.getOrCreateWrapper(Property.createPath((String[])new String[]{"HiveStorageProperties", "predefinedFileFormat"}));
            dBUILayoutHelper.add(componentWrapper);
            dBUILayoutHelper.nextRow();
            final ComponentWrapper componentWrapper2 = this.getOrCreateWrapper(Property.createPath((String[])new String[]{"HiveStorageProperties", "inputFormatClass"}));
            dBUILayoutHelper.add(componentWrapper2);
            dBUILayoutHelper.nextRow();
            final ComponentWrapper componentWrapper3 = this.getOrCreateWrapper(Property.createPath((String[])new String[]{"HiveStorageProperties", "outputFormatClass"}));
            dBUILayoutHelper.add(componentWrapper3);
            dBUILayoutHelper.layout();
            componentWrapper.addListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (this.isEntered()) {
                        HiveStoragePanel.processPredefinedFormatChange(propertyChangeEvent.getNewValue() != null, this.getOriginalObject(), this.getPropertyHelper(), componentWrapper2, componentWrapper3);
                    }
                }
            });
        }
    }

    public static class PartitionLocationPanel
    extends ChildObjectEditorPanel<HivePartition, Table> {
        public PartitionLocationPanel() {
            super("PartitionLocationPanel", Property.createPath((String[])new String[]{"HivePartitionProperties", "partitions"}));
        }

        @Override
        protected void initialiseChildComponents() {
            DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
            dBUILayoutHelper.add(this.getOrCreateWrapper(Property.createPath((String[])new String[]{"HiveStorageProperties", "hdfsLocation"})));
            dBUILayoutHelper.pushUp();
            dBUILayoutHelper.layout();
        }
    }

    public static class PartitionSpecPanel
    extends ChildObjectEditorPanel<HivePartition, Table> {
        private JTextField m_specField = new JTextField();

        public PartitionSpecPanel() {
            super("PartitionSpecPanel", Property.createPath((String[])new String[]{"HivePartitionProperties", "partitions"}));
        }

        @Override
        protected void initialiseChildComponents() {
            DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
            JLabel jLabel = new JLabel();
            this.getComponentFactory().getResourceHelper().resLabel(jLabel, this.m_specField, HiveUIBundle.get("SPECIFICATION"), "Spec");
            this.m_specField.setEditable(false);
            this.m_specField.setBorder(null);
            this.m_specField.setBackground(null);
            dBUILayoutHelper.add(jLabel);
            dBUILayoutHelper.add(this.m_specField);
            dBUILayoutHelper.pushUp();
            dBUILayoutHelper.layout();
        }

        @Override
        protected void initialisePanel() {
            super.initialisePanel();
            this.refreshSpecLabel();
        }

        @Override
        protected boolean shouldValidateOnExit() {
            return false;
        }

        @Override
        protected DBObjectListener createComponentFactoryObjectListener() {
            return new SwingDBObjectPropertyListener(new String[]{"values"}){

                @Override
                protected void updateUI(DBObject dBObject, String string, PropertyChangeEvent propertyChangeEvent) {
                    this.refreshSpecLabel();
                }
            };
        }

        void refreshSpecLabel() {
            HivePartition hivePartition = (HivePartition)this.getChildObject();
            this.m_specField.setText(hivePartition == null ? "" : hivePartition.getName());
        }
    }
}

