/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.extension.rules;

import java.util.Map;
import oracle.ide.Context;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.extension.rules.RuleEvaluationContext;
import oracle.ide.extension.rules.RuleEvaluationException;
import oracle.ide.extension.rules.RuleFunctionParameter;
import oracle.ide.model.Element;
import oracle.ideimpl.db.extension.rules.AbstractRuleFunction;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.util.ModelUtil;

public final class ContextHasProvider
extends AbstractRuleFunction {
    public boolean evaluate(RuleEvaluationContext ruleEvaluationContext, Map<String, RuleFunctionParameter> map) throws RuleEvaluationException {
        boolean bl = false;
        Context context = ruleEvaluationContext.getIdeContext();
        Element element = context.getElement();
        String string = this.getParameterValue("provider-type", map);
        if (string == null || ModelUtil.areEqual((Object)string, (Object)DBObjectNodeUtil.getProviderType(element))) {
            String string2 = this.getParameterValue("database-type", map);
            String string3 = this.getParameterValue("database-version", map);
            if (string != null && string2 == null && string3 == null) {
                bl = true;
            } else {
                DBObjectProvider dBObjectProvider = DBObjectNodeUtil.findProvider(element);
                if (dBObjectProvider != null && (string2 == null || ModelUtil.areEqual((Object)string2, (Object)dBObjectProvider.getDescriptor().getDatabaseType()))) {
                    int n = -1;
                    if (ModelUtil.hasLength((String)string3)) {
                        try {
                            n = Integer.valueOf(string3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new RuleEvaluationException(numberFormatException.getMessage());
                        }
                    }
                    if (n == -1 || n == dBObjectProvider.getDescriptor().getDatabaseVersion()) {
                        bl = true;
                    }
                }
            }
        }
        return bl;
    }
}

