/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import javax.swing.DefaultListModel;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ideimpl.db.controls.ShuttlePanel;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.util.DBObjectSet;

public class DBObjectIDShuttlePanel
extends ShuttlePanel {
    private final Class<? extends DBObject> m_clz;
    private final DBObjectFilter m_filter;

    public DBObjectIDShuttlePanel(Class<? extends DBObject> clazz, DBObjectFilter dBObjectFilter, boolean bl, Integer n) {
        super(bl, n, DBTypeDisplayRegistry.getDisplayName(Metadata.getType(clazz)), new DBObjectRenderer(), clazz.getSimpleName() + "Shuttle");
        this.m_clz = clazz;
        this.m_filter = dBObjectFilter;
    }

    public DBObjectID[] getSelectedIDs() {
        DefaultListModel defaultListModel = this.getModel(true);
        ArrayList<DBObjectID> arrayList = new ArrayList<DBObjectID>();
        for (int i = 0; i < defaultListModel.getSize(); ++i) {
            arrayList.add(((DBObject)defaultListModel.get(i)).getID());
        }
        return arrayList.toArray(new DBObjectID[arrayList.size()]);
    }

    public void setSelectedIDs(DBObjectID[] dBObjectIDArray) {
        Object object;
        int n;
        DefaultListModel defaultListModel = this.getModel(false);
        DefaultListModel defaultListModel2 = this.getModel(true);
        List<DBObjectID> list = Arrays.asList(dBObjectIDArray);
        DBObjectSet dBObjectSet = new DBObjectSet();
        for (n = 0; n < defaultListModel.getSize(); ++n) {
            object = (DBObject)defaultListModel.get(n);
            dBObjectSet.add(object);
        }
        for (n = 0; n < defaultListModel2.getSize(); ++n) {
            object = (DBObject)defaultListModel2.get(n);
            dBObjectSet.add(object);
        }
        defaultListModel.removeAllElements();
        defaultListModel2.removeAllElements();
        DBObject[] dBObjectArray = new DBObject[list.size()];
        for (DBObject dBObject : dBObjectSet) {
            int n2 = list.indexOf(dBObject.getID());
            if (n2 >= 0) {
                dBObjectArray[n2] = dBObject;
                continue;
            }
            defaultListModel.addElement(dBObject);
        }
        for (int i = 0; i < dBObjectArray.length; ++i) {
            DBObject dBObject;
            dBObject = dBObjectArray[i];
            if (dBObject == null) {
                DBObjectID dBObjectID = list.get(i);
                if (dBObjectID instanceof ReferenceID) {
                    try {
                        dBObject = (DBObject)Metadata.getInstance().getObjectClass(dBObjectID.getType()).newInstance();
                        dBObject.setName(((ReferenceID)dBObjectID).getName());
                        dBObject.setID(dBObjectID);
                    }
                    catch (Exception exception) {
                        DBLog.getLogger((Object)this).log(Level.SEVERE, "Failed to create dummy object for ReferenceID", exception);
                    }
                } else {
                    try {
                        dBObject = dBObjectID.resolveID();
                    }
                    catch (DBException dBException) {
                        DBLog.getLogger((Object)this).warning(dBException.getMessage());
                    }
                }
            }
            defaultListModel2.addElement(dBObject);
        }
    }

    public void initialiseIDs(List<DBObject> list) {
        this.initialiseIDs(list, true);
    }

    public void initialiseIDs(List<DBObject> list, boolean bl) {
        this.clearList(false);
        if (bl) {
            this.clearList(true);
        }
        DefaultListModel defaultListModel = this.getModel(false);
        DefaultListModel defaultListModel2 = this.getModel(true);
        for (DBObject dBObject : list) {
            if (this.contains(defaultListModel2, dBObject) || this.m_filter != null && !this.m_filter.accept(dBObject)) continue;
            defaultListModel.addElement(dBObject);
        }
    }

    private boolean contains(DefaultListModel defaultListModel, DBObject dBObject) {
        boolean bl = false;
        Enumeration enumeration = defaultListModel.elements();
        while (enumeration.hasMoreElements()) {
            if (dBObject != enumeration.nextElement()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public Class<? extends DBObject> getReferencedClass() {
        return this.m_clz;
    }
}

