/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.controls.AbstractLazyCombo;
import oracle.ideimpl.db.controls.BigDataAccessParamsTable;
import oracle.ideimpl.db.controls.BigDataFieldsTable;
import oracle.ideimpl.db.controls.BigDataJsonEntriesTable;
import oracle.ideimpl.db.controls.BigDataTablePropertiesTable;
import oracle.ideimpl.db.controls.ExtendedTable;
import oracle.ideimpl.db.controls.TableCellEditorWithPopup;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameter;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameterMetadata;
import oracle.javatools.db.ora.bigdata.BigDataFields;
import oracle.javatools.db.ora.bigdata.BigDataJsonArray;
import oracle.javatools.db.ora.bigdata.BigDataJsonEntry;
import oracle.javatools.db.ora.bigdata.BigDataJsonObject;
import oracle.javatools.db.ora.bigdata.BigDataTableProperties;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ExtendedTextField;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Tuple;

class BigDataValueCellEditor
extends AbstractCellEditor
implements ExtendedTable.ExtendedTableCellEditor {
    private static final String BASE_NAME = "BigDataValueCellEditor";
    private final BigDataAccessParamsTable m_paramsTable;
    private final DBObjectProvider m_provider;
    private final Relation m_relation;
    private String m_parameterName;
    private TableCellEditor m_delegate;
    private ValueCellEditor m_defaultEd;
    private Map<String, TableCellEditor> m_delegates = new HashMap<String, TableCellEditor>();
    private final ExtendedTable.ExtendedTableModelListener m_childTableListener;

    BigDataValueCellEditor(BigDataAccessParamsTable bigDataAccessParamsTable, DBObjectProvider dBObjectProvider, Relation relation) {
        this.m_paramsTable = bigDataAccessParamsTable;
        this.m_provider = dBObjectProvider;
        this.m_relation = relation;
        this.m_childTableListener = new ExtendedTable.ExtendedTableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                BigDataValueCellEditor.this.m_paramsTable.fireCellEditedEvent();
            }

            @Override
            public void cellValueEdited(TableModelEvent tableModelEvent) {
                BigDataValueCellEditor.this.m_paramsTable.fireCellEditedEvent();
            }
        };
    }

    private TableCellEditor getDelegate() {
        TableCellEditor tableCellEditor = this.m_delegates.get(this.m_parameterName);
        if (tableCellEditor == null) {
            if (BigDataJsonEntry.getJsonEntryNames((String)this.m_parameterName) != null) {
                tableCellEditor = new JsonCellEditor();
            } else if (BigDataAccessParameterMetadata.isLocationParameter((String)this.m_parameterName)) {
                tableCellEditor = new LoggingCellEditor();
            } else if ("com.oracle.bigdata.fields".equals(this.m_parameterName)) {
                tableCellEditor = new FieldsCellEditor();
            } else if ("com.oracle.bigdata.tblproperties".equals(this.m_parameterName)) {
                tableCellEditor = new TablePropertiesCellEditor();
            } else if (BigDataAccessParameterMetadata.hasAllowedParameterValues((String)this.m_parameterName, (Relation)this.m_relation, (DBObjectProvider)this.m_provider)) {
                tableCellEditor = new AllowedValuesCellEditor();
            }
            if (tableCellEditor != null) {
                this.m_delegates.put(this.m_parameterName, tableCellEditor);
            }
        }
        if (tableCellEditor == null) {
            if (this.m_defaultEd == null) {
                this.m_defaultEd = new ValueCellEditor();
            }
            tableCellEditor = this.m_defaultEd;
        }
        return tableCellEditor;
    }

    @Override
    public boolean stopCellEditing() {
        if (this.m_delegate != null) {
            this.m_delegate.stopCellEditing();
        }
        boolean bl = super.stopCellEditing();
        this.m_delegate = null;
        return bl;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.m_parameterName = (String)jTable.getValueAt(n, 0);
        this.m_delegate = this.getDelegate();
        return this.m_delegate.getTableCellEditorComponent(jTable, object, bl, n, n2);
    }

    @Override
    public void prepareComponent(Component component) {
        if (this.m_delegate instanceof ExtendedTable.ExtendedTableCellEditor) {
            ((ExtendedTable.ExtendedTableCellEditor)this.m_delegate).prepareComponent(component);
        }
    }

    @Override
    public Object getCellEditorValue() {
        Object object = null;
        if (this.m_delegate != null) {
            object = this.m_delegate.getCellEditorValue();
        }
        return object;
    }

    private class JsonCellEditor
    extends PopupTableCellEditor<BigDataJsonEntriesTable> {
        private JsonCellEditor() {
        }

        @Override
        protected BigDataJsonEntriesTable createTable(BigDataAccessParameter bigDataAccessParameter) throws DBException {
            Tuple tuple = BigDataJsonEntry.getJsonEntryNames((String)BigDataValueCellEditor.this.m_parameterName);
            String string = null;
            SQLFragment sQLFragment = null;
            try {
                DBUtil.ensureObjectBuilt((DBObject)bigDataAccessParameter, (String[])new String[]{"parameterValueFragment"});
                sQLFragment = bigDataAccessParameter.getParameterValueFragment();
            }
            catch (DBException dBException) {
                BigDataAccessParameterMetadata.TemplateValue templateValue = BigDataAccessParameterMetadata.getParameterTemplateValue((String)BigDataValueCellEditor.this.m_parameterName);
                if (templateValue != null && ModelUtil.areEqual((Object)templateValue.toString(), (Object)bigDataAccessParameter.getParameterValue())) {
                    BigDataJsonObject bigDataJsonObject = new BigDataJsonObject();
                    bigDataJsonObject.addBigDataEntry(new BigDataJsonEntry((String)tuple.object1(), null));
                    sQLFragment = bigDataJsonObject;
                }
                DBLog.getLogger((Object)this).fine(dBException.getMessage());
                string = dBException.getMessage();
            }
            if (string == null) {
                Object object;
                if (!(sQLFragment instanceof BigDataJsonArray)) {
                    object = new BigDataJsonArray();
                    if (sQLFragment != null) {
                        object.addArgument(sQLFragment);
                    }
                    sQLFragment = object;
                }
                try {
                    object = new BigDataJsonEntriesTable((String)tuple.object1(), (String)tuple.object2());
                    ((BigDataJsonEntriesTable)object).setBigDataJsonArray((BigDataJsonArray)sQLFragment, bigDataAccessParameter, BigDataValueCellEditor.this.m_relation);
                    return object;
                }
                catch (IllegalStateException illegalStateException) {
                    DBLog.getLogger((Object)this).fine(illegalStateException.getMessage());
                }
            }
            throw new DBException((DBObject)bigDataAccessParameter, string);
        }

        @Override
        protected String getText(BigDataJsonEntriesTable bigDataJsonEntriesTable) {
            BigDataJsonArray bigDataJsonArray = bigDataJsonEntriesTable.getBigDataJsonArray();
            return bigDataJsonArray == null ? null : bigDataJsonArray.getSQLText();
        }

        @Override
        protected boolean supportsPopup(JTable jTable, Object object, int n, int n2) {
            return BigDataJsonEntry.getJsonEntryNames((String)BigDataValueCellEditor.this.m_parameterName) != null;
        }
    }

    private class LoggingCellEditor
    extends ValueCellEditor {
        private final JPanel m_panel;
        private final JLabel m_dirLabel;
        private final DBObjectChooser m_dirChooser;
        private final JLabel m_fileLabel;
        private final JTextField m_fileField;

        LoggingCellEditor() {
            this.m_dirLabel = new JLabel();
            this.m_dirChooser = new DBObjectChooser("DIRECTORY");
            this.m_fileLabel = new JLabel();
            this.m_fileField = new JTextField();
            this.m_dirChooser.setProvider(BigDataValueCellEditor.this.m_provider);
            this.m_dirChooser.setEditable(true);
            Schema schema = new Schema("SYS");
            this.m_dirChooser.setContextDBObjectID(TemporaryObjectID.createID((DBObject)schema));
            this.m_dirChooser.setOnlyReferenceIDNeeded(true);
            this.m_panel = new JPanel();
            DBUIResourceHelper dBUIResourceHelper = this.getResourceHelper();
            dBUIResourceHelper.resLabel(this.m_dirLabel, this.m_dirChooser, DBTypeDisplayRegistry.getSingularDisplayName("DIRECTORY") + ":", "Directory");
            dBUIResourceHelper.resLabel(this.m_fileLabel, this.m_fileField, UIBundle.get("EXTTAB_FILE_NAME_TEMP"), "FileName");
        }

        @Override
        protected boolean supportsPopup(JTable jTable, Object object, int n, int n2) {
            return true;
        }

        @Override
        protected void initPopup(JPanel jPanel) {
            Object object;
            String string = this.getEditor().getText();
            ReferenceID referenceID = null;
            Object object2 = null;
            if (string != null) {
                object = string.split(":", 2);
                if (((String[])object).length == 1) {
                    object2 = object[0];
                } else {
                    referenceID = new ReferenceID("DIRECTORY", "SYS", BigDataValueCellEditor.this.m_provider.getInternalName(object[0]));
                    object2 = object[1];
                }
            }
            this.m_dirChooser.setDBObjectID((DBObjectID)referenceID);
            if (ModelUtil.hasLength(object2) && this.isQuoted((String)object2)) {
                object2 = ((String)object2).substring(1, ((String)object2).length() - 1);
                object2 = ((String)object2).replace("''", "'");
            }
            this.m_fileField.setText((String)object2);
            jPanel.removeAll();
            object = new DBUILayoutHelper(jPanel);
            ((DBUILayoutHelper)object).setMargins(8);
            ((DBUILayoutHelper)object).add(this.m_dirLabel);
            ((DBUILayoutHelper)object).add(this.m_dirChooser);
            ((DBUILayoutHelper)object).nextRow();
            ((DBUILayoutHelper)object).add(this.m_fileLabel);
            ((DBUILayoutHelper)object).add(this.m_fileField);
            ((DBUILayoutHelper)object).layout();
        }

        private boolean isQuoted(String string) {
            int n = string.length();
            return n > 1 && string.charAt(0) == '\'' && string.charAt(n - 1) == '\'';
        }

        @Override
        protected Integer getPreferredPopupHeight() {
            return null;
        }

        @Override
        protected void commitPopup() {
            Object object;
            String string = DBUtil.getDBObjectName((DBObjectID)this.m_dirChooser.getDBObjectID());
            this.m_dirChooser.cancel();
            Object object2 = this.m_fileField.getText();
            if (ModelUtil.hasLength((String)object2) && !this.isQuoted((String)object2)) {
                object2 = "'" + ((String)object2).replace("'", "''") + "'";
            }
            if (ModelUtil.hasLength((String)string)) {
                object = BigDataValueCellEditor.this.m_provider.getExternalName(string, "DIRECTORY") + ":";
                if (object2 != null) {
                    object = (String)object + (String)object2;
                }
            } else {
                object = object2;
            }
            this.getEditor().setText((String)object);
        }
    }

    private class FieldsCellEditor
    extends PopupTableCellEditor<BigDataFieldsTable> {
        private FieldsCellEditor() {
        }

        @Override
        protected BigDataFieldsTable createTable(BigDataAccessParameter bigDataAccessParameter) throws DBException {
            DBUtil.ensureObjectBuilt((DBObject)bigDataAccessParameter, (String[])new String[]{"parameterValueFragment"});
            BigDataFields bigDataFields = (BigDataFields)bigDataAccessParameter.getParameterValueFragment();
            BigDataFieldsTable bigDataFieldsTable = new BigDataFieldsTable();
            bigDataFieldsTable.setFields(bigDataFields);
            return bigDataFieldsTable;
        }

        @Override
        protected String getText(BigDataFieldsTable bigDataFieldsTable) {
            return bigDataFieldsTable.getFields().getSQLText();
        }
    }

    private class TablePropertiesCellEditor
    extends PopupTableCellEditor<BigDataTablePropertiesTable> {
        private TablePropertiesCellEditor() {
        }

        @Override
        protected BigDataTablePropertiesTable createTable(BigDataAccessParameter bigDataAccessParameter) throws DBException {
            DBUtil.ensureObjectBuilt((DBObject)bigDataAccessParameter, (String[])new String[]{"parameterValueFragment"});
            BigDataTableProperties bigDataTableProperties = (BigDataTableProperties)bigDataAccessParameter.getParameterValueFragment();
            BigDataTablePropertiesTable bigDataTablePropertiesTable = new BigDataTablePropertiesTable();
            bigDataTablePropertiesTable.setTableProperties(bigDataTableProperties);
            return bigDataTablePropertiesTable;
        }

        @Override
        protected String getText(BigDataTablePropertiesTable bigDataTablePropertiesTable) {
            BigDataTableProperties bigDataTableProperties = bigDataTablePropertiesTable.getTableProperties();
            return bigDataTableProperties == null ? null : bigDataTableProperties.getSQLText();
        }
    }

    private class AllowedValuesCellEditor
    extends DefaultCellEditor
    implements ExtendedTable.ExtendedTableCellEditor {
        AllowedValuesCellEditor() {
            super(new AllowedValuesCombo());
            JComboBox jComboBox = (JComboBox)this.getComponent();
            jComboBox.setEditable(true);
            jComboBox.setName("BigDataValueCellEditor.AllowedValuesCombo");
            this.getEditorComponent().setName(jComboBox.getName() + "-editor");
            jComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    AllowedValuesCellEditor.this.selectFirstQuotedString();
                }
            });
        }

        private JTextComponent getEditorComponent() {
            JComboBox jComboBox = (JComboBox)this.getComponent();
            return (JTextComponent)jComboBox.getEditor().getEditorComponent();
        }

        @Override
        public Object getCellEditorValue() {
            return ((JComboBox)this.getComponent()).getEditor().getItem();
        }

        @Override
        public void prepareComponent(Component component) {
            final JTextComponent jTextComponent = this.getEditorComponent();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (jTextComponent.isVisible()) {
                        AllowedValuesCellEditor.this.selectFirstQuotedString();
                    }
                }
            });
        }

        private void selectFirstQuotedString() {
            JTextComponent jTextComponent = this.getEditorComponent();
            String string = jTextComponent.getText();
            int n = string.indexOf(39);
            if (n >= 0) {
                int n2;
                boolean bl = false;
                int n3 = n2 = n + 1;
                while (n2 < string.length()) {
                    if (string.charAt(n2) == '\'') {
                        if (n2 < string.length() - 1 && string.charAt(n2 + 1) == '\'') {
                            ++n2;
                        } else {
                            bl = true;
                            break;
                        }
                    }
                    ++n2;
                }
                if (bl) {
                    jTextComponent.select(n + 1, n2);
                }
            }
        }
    }

    private class ValueCellEditor
    extends TableCellEditorWithPopup
    implements ExtendedTable.ExtendedTableCellEditor {
        ValueCellEditor() {
            super(BigDataValueCellEditor.BASE_NAME, true, true, OracleIcons.getIcon((String)"edit.png"));
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            BigDataAccessParameterMetadata.TemplateValue templateValue = BigDataAccessParameterMetadata.getParameterTemplateValue((String)BigDataValueCellEditor.this.m_parameterName);
            if (templateValue != null && (object == null || "".equals(object))) {
                this.getEditor().setText(templateValue.toString());
            }
            return component;
        }

        @Override
        public void prepareComponent(Component component) {
            ExtendedTextField extendedTextField = this.getEditor();
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ JTextComponent val$ed;
                {
                    this.val$ed = jTextComponent;
                }

                @Override
                public void run() {
                    if (this.val$ed.isVisible()) {
                        this.val$ed.requestFocusInWindow();
                        final BigDataAccessParameterMetadata.TemplateValue templateValue = BigDataAccessParameterMetadata.getParameterTemplateValue((String)BigDataValueCellEditor.this.m_parameterName);
                        if (templateValue != null) {
                            final String string = templateValue.getBefore();
                            final String string2 = this.val$ed.getText();
                            if (string2 != null && string != null && string2.startsWith(string)) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (val$ed.isVisible()) {
                                            int n = string.length();
                                            if (string2.length() > n) {
                                                int n2 = -1;
                                                String string3 = templateValue.getAfter();
                                                if (string3 != null) {
                                                    char c = string3.charAt(0);
                                                    n2 = string2.indexOf(c, n);
                                                }
                                                if (n2 < 0) {
                                                    n2 = n;
                                                }
                                                val$ed.select(n, n2);
                                            }
                                        }
                                    }
                                });
                            }
                        }
                    }
                }
            });
        }

        @Override
        public Object getCellEditorValue() {
            return BigDataAccessParameterMetadata.checkLineBreaks((String)this.getEditor().getText());
        }

        protected final void layoutInvalidValuePopup(JPanel jPanel, String string) {
            DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper(jPanel);
            dBUILayoutHelper.setMargins(10);
            dBUILayoutHelper.add((Component)new JWrappedLabel(UIBundle.format("EXTTAB_INVALID_VALUE", string == null ? "" : string)), 2, 1);
            JButton jButton = new JButton();
            this.getResourceHelper().resButton(jButton, UIBundle.get("EXTTAB_CLEAR_VALUE"), "Clear");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ValueCellEditor.this.clearText();
                }
            });
            dBUILayoutHelper.nextRow();
            dBUILayoutHelper.add(jButton);
            dBUILayoutHelper.pushLeft();
            dBUILayoutHelper.nextRow();
            dBUILayoutHelper.pushUp();
            dBUILayoutHelper.layout();
        }

        private void clearText() {
            this.getEditor().setText(null);
            if (this.isPopupShowing()) {
                this.hidePopup();
                this.showPopup();
            }
        }

        @Override
        protected void initPopup(JPanel jPanel) {
        }

        @Override
        protected void commitPopup() {
        }

        @Override
        protected boolean supportsPopup(JTable jTable, Object object, int n, int n2) {
            return false;
        }
    }

    private class AllowedValuesCombo
    extends AbstractLazyCombo {
        private AllowedValuesCombo() {
        }

        @Override
        protected List getModelEntries() {
            return BigDataAccessParameterMetadata.getAllowedParameterValues((String)BigDataValueCellEditor.this.m_parameterName, (Relation)BigDataValueCellEditor.this.m_relation, (DBObjectProvider)BigDataValueCellEditor.this.m_provider);
        }
    }

    private abstract class PopupTableCellEditor<T extends ExtendedTable>
    extends ValueCellEditor {
        private T m_table;

        private PopupTableCellEditor() {
        }

        protected abstract T createTable(BigDataAccessParameter var1) throws DBException;

        protected abstract String getText(T var1);

        @Override
        protected void initPopup(JPanel jPanel) {
            jPanel.removeAll();
            this.m_table = null;
            String string = this.getEditor().getText();
            BigDataAccessParameter bigDataAccessParameter = (BigDataAccessParameter)BigDataValueCellEditor.this.m_provider.getObjectFactory().newObject(BigDataAccessParameter.class);
            bigDataAccessParameter.setName(BigDataValueCellEditor.this.m_parameterName);
            bigDataAccessParameter.setParameterValue(string);
            try {
                this.m_table = this.createTable(bigDataAccessParameter);
                jPanel.setLayout(new BorderLayout());
                jPanel.add((Component)((ExtendedTable)this.m_table).getComponent(), "Center");
                ((ExtendedTable)this.m_table).addTableModelListener(BigDataValueCellEditor.this.m_childTableListener);
            }
            catch (DBException dBException) {
                this.layoutInvalidValuePopup(jPanel, dBException.getMessage());
            }
            jPanel.setPreferredSize(null);
        }

        @Override
        protected Integer getPreferredPopupHeight() {
            return this.m_table == null ? null : super.getPreferredPopupHeight();
        }

        @Override
        protected void commitPopup() {
            if (this.m_table != null) {
                ((ExtendedTable)this.m_table).removeTableModelListener(BigDataValueCellEditor.this.m_childTableListener);
                ((ExtendedTable)this.m_table).stopCellEditing();
                if (((ExtendedTable)this.m_table).isModelDirty()) {
                    this.getEditor().setText(this.getText(this.m_table));
                }
            }
        }

        @Override
        protected boolean supportsPopup(JTable jTable, Object object, int n, int n2) {
            return true;
        }
    }
}

