/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ceditor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.AsynchronousController;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ActionMenuToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.db.compiler.PlSqlCompiler;
import oracle.ide.db.model.DBObjectPlSqlNode;
import oracle.ide.db.util.IconWithSmallOverlay;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.view.View;
import oracle.ideimpl.db.ceditor.DBEditorConnectionProvider;
import oracle.ideimpl.db.controls.AbstractLazyCombo;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Database;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.plsql.PlSqlCompilerOptions;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.icons.OracleIcons;

public class DBEditorConnectionPlugin
implements EditorPlugin {
    private static final int COMPILE_NODEBUG_COMMAND = Ide.findOrCreateCmdID((String)"DBEditorConnectionPlugin.COMPILE");
    private static final int COMPILE_DEBUG_COMMAND = Ide.findOrCreateCmdID((String)"DBEditorConnectionPlugin.COMPILE_DEBUG");
    private static final int COMPILE_COMMAND = Ide.findOrCreateCmdID((String)"DBEditorConnectionPlugin.COMPILE_COMMAND");
    private final LazyConnectionCombo m_picker = new LazyConnectionCombo();
    private final Controller m_controller;
    private final NodeListener m_nodeListener;
    private final DBEditorConnectionProvider.ConnectionProviderListener m_connListener;
    private CodeEditor m_ceditor;
    private Toolbar m_toolbar;
    private Node m_node;
    private ActionMenuToolButton m_compileButton;
    private IdeAction m_compileAction;
    private IdeAction m_compileDebugAction;
    private IdeAction m_compileNoDebugAction;

    public DBEditorConnectionPlugin() {
        this.m_picker.setName("DBEditorConnectionPlugin.m_picker");
        this.m_picker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DBEditorConnectionProvider.setURLConnection(DBEditorConnectionPlugin.this.m_node.getURL(), (String)DBEditorConnectionPlugin.this.m_picker.getSelectedItem(), true);
                DBEditorConnectionPlugin.this.updateConnectionToolbar();
            }
        });
        this.m_nodeListener = new NodeListener(){

            public void nodeSaved(NodeEvent nodeEvent) {
                DBEditorConnectionPlugin.this.compile(DBEditorConnectionPlugin.this.m_ceditor.getContext());
            }
        };
        this.m_connListener = new DBEditorConnectionProvider.ConnectionProviderListener(){

            @Override
            public void connectionsChanged() {
                DBEditorConnectionPlugin.this.m_picker.resetCombo();
            }
        };
        this.m_controller = new AsyncController();
    }

    public void install(BasicEditorPane basicEditorPane) {
        this.m_ceditor = CodeEditor.getCodeEditor((BasicEditorPane)basicEditorPane);
        this.m_node = this.m_ceditor.getContext().getNode();
        this.m_toolbar = this.m_ceditor.getToolbar();
        this.m_compileAction = this.createLocalAction(COMPILE_COMMAND, (View)this.m_ceditor, UIBundle.get("PLSQL_COMPILE"), this.getIcon(false));
        this.m_compileNoDebugAction = this.createLocalAction(COMPILE_NODEBUG_COMMAND, (View)this.m_ceditor, UIBundle.get("PLSQL_COMPILE"), this.getIcon(false));
        this.m_compileDebugAction = this.createLocalAction(COMPILE_DEBUG_COMMAND, (View)this.m_ceditor, UIBundle.get("PLSQL_COMPILE_FOR_DEBUG"), this.getIcon(true));
        this.m_compileButton = new ActionMenuToolButton((Action)this.m_compileAction);
        this.m_compileButton.setMenuActions((Action[])new IdeAction[]{this.m_compileNoDebugAction, this.m_compileDebugAction});
        this.m_toolbar.addSeparator();
        this.m_toolbar.add((Component)this.m_compileButton);
        this.m_toolbar.add(Box.createHorizontalGlue());
        this.m_toolbar.add((Component)this.m_picker);
        this.m_node.addNodeListener(this.m_nodeListener);
        DBEditorConnectionProvider dBEditorConnectionProvider = DBEditorConnectionProvider.getInstance();
        dBEditorConnectionProvider.addConnectionsListener(this.m_ceditor.getContext(), this.m_connListener);
        String string = DBEditorConnectionProvider.getDefaultConnection(this.m_node.getURL());
        if (string != null) {
            this.m_picker.setIfInList(string);
        }
        this.updateConnectionToolbar();
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        DBEditorConnectionProvider dBEditorConnectionProvider = DBEditorConnectionProvider.getInstance();
        if (dBEditorConnectionProvider != null) {
            dBEditorConnectionProvider.removeConnectionsListener(this.m_ceditor.getContext(), this.m_connListener);
        }
        this.m_node.removeNodeListener(this.m_nodeListener);
        DBEditorConnectionProvider.setURLConnection(this.m_node.getURL(), null, false);
        this.m_compileAction.removeController(this.m_controller);
        this.m_compileNoDebugAction.removeController(this.m_controller);
        this.m_compileDebugAction.removeController(this.m_controller);
        this.m_ceditor = null;
        this.m_toolbar = null;
        this.m_node = null;
        this.m_compileAction = null;
        this.m_compileNoDebugAction = null;
        this.m_compileDebugAction = null;
        this.m_compileButton = null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    private void updateConnectionToolbar() {
        if (this.m_compileButton != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                boolean bl;
                GlobalSettings globalSettings = GlobalSettings.getInstance();
                PlSqlCompilerOptions plSqlCompilerOptions = globalSettings == null ? null : globalSettings.getPlSqlCompilerOptions();
                boolean bl2 = bl = plSqlCompilerOptions != null && plSqlCompilerOptions.isGeneratePlSqlDebugInfo();
                if (bl) {
                    this.m_compileButton.setToolTipText(UIBundle.get("PLSQL_COMPILE_FOR_DEBUG"));
                } else {
                    this.m_compileButton.setToolTipText(UIBundle.get("PLSQL_COMPILE"));
                }
                this.m_compileButton.setIcon(this.getIcon(bl));
                if (this.m_ceditor != null && this.m_toolbar != null) {
                    CodeEditor.updateToolbarActions((Toolbar)this.m_toolbar);
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DBEditorConnectionPlugin.this.updateConnectionToolbar();
                    }
                });
            }
        }
    }

    private IdeAction createLocalAction(int n, View view, String string, Icon icon) {
        IdeAction.get((int)n);
        IdeAction ideAction = IdeAction.newLocalAction((int)n, (View)view);
        ideAction.putValue("Name", (Object)string);
        ideAction.putValue("SmallIcon", (Object)icon);
        ideAction.setEnabled(false);
        ideAction.addController(this.m_controller);
        return ideAction;
    }

    private void compile(Context context) {
        Database database = DBEditorConnectionProvider.getCurrentDatabase(context);
        Node node = context.getNode();
        if (database instanceof OracleDatabase && node instanceof DBObjectPlSqlNode) {
            PlSqlCompiler plSqlCompiler = PlSqlCompiler.getInstance();
            plSqlCompiler.compile((OracleDatabase)database, (DBObjectPlSqlNode)node);
        }
    }

    private Icon getIcon(boolean bl) {
        if (bl) {
            return new IconWithSmallOverlay(OracleIcons.getIcon((String)"generatedbobject.png"), OracleIcons.getIcon((String)"debug.png"), 12, 12, 0, 5);
        }
        return OracleIcons.getIcon((String)"generatedbobject.png");
    }

    private class LazyConnectionCombo
    extends AbstractLazyCombo {
        private LazyConnectionCombo() {
        }

        @Override
        protected Icon getIcon(Object object) {
            return OracleIcons.getIcon((String)"database.png");
        }

        @Override
        public String getNullText() {
            return UIBundle.get("EDITOR_NO_CONNECTION");
        }

        @Override
        protected List getModelEntries() {
            ArrayList<String> arrayList = new ArrayList<String>();
            DBEditorConnectionProvider dBEditorConnectionProvider = DBEditorConnectionProvider.getInstance();
            if (DBEditorConnectionPlugin.this.m_ceditor != null && dBEditorConnectionProvider != null) {
                arrayList.addAll(dBEditorConnectionProvider.getAvailableConnections(DBEditorConnectionPlugin.this.m_ceditor.getContext()));
            }
            return arrayList;
        }

        private void setIfInList(String string) {
            this.loadModel();
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.getModel();
            int n = defaultComboBoxModel.getIndexOf(string);
            if (n == -1) {
                n = 0;
            }
            this.setSelectedIndex(n);
        }

        private void resetCombo() {
            this.reset();
        }
    }

    private class AsyncController
    extends AsynchronousController {
        AsyncController() {
            super(false);
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            this.handleAsynchronously(ideAction, context);
            return true;
        }

        protected void handleEvent(IdeAction ideAction, Context context, AsynchronousController.TaskInfo taskInfo) {
            int n = ideAction.getCommandId();
            if (n == COMPILE_COMMAND) {
                DBEditorConnectionPlugin.this.compile(context);
            } else if (n == COMPILE_NODEBUG_COMMAND || n == COMPILE_DEBUG_COMMAND) {
                GlobalSettings globalSettings = GlobalSettings.getInstance();
                if (globalSettings != null) {
                    PlSqlCompilerOptions plSqlCompilerOptions = globalSettings.getPlSqlCompilerOptions();
                    if (plSqlCompilerOptions != null) {
                        plSqlCompilerOptions.setGeneratePlSqlDebugInfo(n == COMPILE_DEBUG_COMMAND);
                    }
                    DBEditorConnectionPlugin.this.updateConnectionToolbar();
                }
                DBEditorConnectionPlugin.this.compile(context);
            }
        }

        public boolean update(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (n == COMPILE_COMMAND || n == COMPILE_NODEBUG_COMMAND || n == COMPILE_DEBUG_COMMAND) {
                ideAction.setEnabled(DBEditorConnectionProvider.hasCurrentDatabase(context.getNode()));
                return true;
            }
            return false;
        }
    }
}

