/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db;

import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.db.DBObjectActions;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.model.BaseDBObjectTextNode;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.ide.model.Node;
import oracle.ide.view.View;
import oracle.ideimpl.db.ceditor.PlSqlQueryTester;
import oracle.ideimpl.db.ceditor.PlSqlSpecAndBodySynchronizer;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;

class DBObjectActionsController
implements Controller {
    DBObjectActionsController() {
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        DBObjectProvider dBObjectProvider;
        Node node;
        boolean bl = false;
        int n = ideAction.getCommandId();
        if (n == DBObjectActions.getDuplicateAction().getCommandId()) {
            bl = true;
        } else if (n == DBObjectActions.getNewObjectAction().getCommandId()) {
            DBEditorFactory dBEditorFactory;
            bl = true;
            DBObjectTypeNode dBObjectTypeNode = DBObjectNodeUtil.getSelectedElement(context, DBObjectTypeNode.class);
            if (dBObjectTypeNode != null && (dBEditorFactory = DBEditorFactoryRegistry.getCreateFactory(dBObjectTypeNode)) != null) {
                dBEditorFactory.launchDialog(DBEditorConfig.newCreateConfig(dBObjectTypeNode));
            }
        } else if (n == DBObjectActions.getPropertiesAction().getCommandId()) {
            DBObjectNode dBObjectNode = DBObjectNodeUtil.getSelectedElement(context, DBObjectNode.class);
            if (dBObjectNode != null && DBObjectNodeUtil.isOnlineNode(dBObjectNode)) {
                bl = true;
                DBEditorFactory dBEditorFactory = DBEditorFactoryRegistry.getEditFactory(dBObjectNode);
                if (dBEditorFactory != null) {
                    dBEditorFactory.editDBObject(dBObjectNode);
                }
            }
        } else if (n == DBObjectActions.getSynchronizeSpecAndBody().getCommandId()) {
            bl = true;
            Node node2 = context.getNode();
            if (node2 instanceof BaseDBObjectTextNode) {
                View view = context.getView();
                Integer n2 = view instanceof CodeEditor ? Integer.valueOf(((CodeEditor)view).getSelectionStart()) : null;
                PlSqlSpecAndBodySynchronizer.launch((BaseDBObjectTextNode)node2, n2);
            }
        } else if (n == DBObjectActions.getTestQueryAction().getCommandId()) {
            bl = true;
            PlSqlQueryTester.invokeTestQuery(context);
        } else if (n == IdeActions.getViewRefreshAction().getCommandId() && DBObjectNodeUtil.isOnlineNode(node = context.getNode()) && node instanceof DBObjectNode && (dBObjectProvider = DBObjectNodeUtil.findProvider(node)) != null) {
            DBUtil.forceObjectReset((String)((DBObjectNode)node).getObjectType(), (String)((DBObjectNode)node).getSchemaName(), (String)((DBObjectNode)node).getObjectName(), (DBObjectProvider)dBObjectProvider);
        }
        return bl;
    }

    public boolean update(IdeAction ideAction, Context context) {
        boolean bl = false;
        boolean bl2 = false;
        int n = ideAction.getCommandId();
        DBObjectNode dBObjectNode = DBObjectNodeUtil.getSelectedElement(context, DBObjectNode.class);
        if (n == DBObjectActions.getDuplicateAction().getCommandId()) {
            bl = true;
        } else if (n == DBObjectActions.getPropertiesAction().getCommandId()) {
            if (dBObjectNode != null) {
                bl = true;
                bl2 = DBObjectNodeUtil.isOnlineNode(dBObjectNode) && DBEditorFactoryRegistry.getEditFactory(dBObjectNode) != null;
            }
        } else if (n == DBObjectActions.getSynchronizeSpecAndBody().getCommandId()) {
            bl = true;
            if (dBObjectNode != null) {
                bl2 = true;
            }
        } else if (n == DBObjectActions.getTestQueryAction().getCommandId()) {
            bl = true;
            bl2 = PlSqlQueryTester.enableTestQuery(context);
        }
        if (bl) {
            ideAction.setEnabled(bl2);
        }
        return bl;
    }
}

