/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SelectObjectUsage;
import oracle.javatools.db.sql.SynonymUsage;

public class TreeNodeMaker {
    private boolean m_showChildren;
    private String[] m_childTypes;
    private boolean m_fkDeep;
    private final JTree m_tree;
    private ExecutorService m_es;

    public TreeNodeMaker() {
        this.m_tree = null;
        this.m_es = null;
    }

    public TreeNodeMaker(JTree jTree) {
        if (jTree != null && jTree.getModel() instanceof DefaultTreeModel) {
            this.m_tree = jTree;
            this.m_es = Executors.newSingleThreadExecutor();
            this.m_tree.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent ancestorEvent) {
                }

                @Override
                public void ancestorRemoved(AncestorEvent ancestorEvent) {
                    List<Runnable> list = TreeNodeMaker.this.m_es.shutdownNow();
                    for (Runnable runnable : list) {
                        ((NodeExpander)runnable).clearNode();
                    }
                    TreeNodeMaker.this.m_es = Executors.newSingleThreadExecutor();
                }

                @Override
                public void ancestorMoved(AncestorEvent ancestorEvent) {
                }
            });
        } else {
            this.m_tree = null;
            this.m_es = null;
        }
    }

    public TreeNodeMaker(boolean bl) {
        this.m_showChildren = bl;
        this.m_tree = null;
        this.m_es = null;
    }

    public TreeNodeMaker(boolean bl, String[] stringArray) {
        this.m_showChildren = bl;
        this.m_tree = null;
        this.m_es = null;
        this.setChildTypes(stringArray);
    }

    public void setShowChildren(boolean bl) {
        this.m_showChildren = bl;
    }

    public boolean getShowChildren() {
        return this.m_showChildren;
    }

    public void setChildTypes(String[] stringArray) {
        this.m_childTypes = stringArray;
        if (this.m_childTypes != null && this.m_childTypes.length == 0) {
            this.m_childTypes = null;
        }
    }

    public void setDeepFKs(boolean bl) {
        this.m_fkDeep = bl;
    }

    public DefaultMutableTreeNode createTreeNode(DBObject dBObject) {
        boolean bl = false;
        if (this.m_showChildren) {
            boolean bl2 = bl = dBObject instanceof Relation || dBObject instanceof Synonym;
        }
        if (!bl && this.m_fkDeep) {
            bl = dBObject instanceof FKConstraint;
        }
        if (bl) {
            return new LazyTreeNode(dBObject);
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(dBObject);
        return defaultMutableTreeNode;
    }

    private void createChildNodes(DBObject dBObject, DefaultMutableTreeNode defaultMutableTreeNode) {
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(UIBundle.get("DBOBJECT_TREE_LOADING_NODE")));
        NodeExpander nodeExpander = new NodeExpander(dBObject, defaultMutableTreeNode);
        if (this.m_tree != null) {
            this.m_es.execute(nodeExpander);
        } else {
            nodeExpander.expandNode();
        }
    }

    public DefaultMutableTreeNode createTreeNode(SQLFragment sQLFragment) {
        return this.createTreeNode(sQLFragment, false);
    }

    public DefaultMutableTreeNode createTreeNode(SQLFragment sQLFragment, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        block10: {
            Relation relation;
            SQLFragment sQLFragment2;
            block11: {
                DBObjectID dBObjectID;
                defaultMutableTreeNode = new DefaultMutableTreeNode(sQLFragment);
                if (sQLFragment instanceof FromObject && this.m_showChildren && (sQLFragment2 = ((FromObject)sQLFragment).getExpression()) instanceof JoinObject) {
                    relation = this.createTreeNode((SQLFragment)((JoinObject)sQLFragment2).getLeftExpression());
                    dBObjectID = this.createTreeNode((SQLFragment)((JoinObject)sQLFragment2).getRightExpression());
                    defaultMutableTreeNode.add((MutableTreeNode)relation);
                    defaultMutableTreeNode.add((MutableTreeNode)dBObjectID);
                }
                if (!bl || !(sQLFragment instanceof FromObject) || (sQLFragment2 = ((FromObject)sQLFragment).getExpression()) == null) break block10;
                if (!(sQLFragment2 instanceof DBObjectUsage)) break block11;
                relation = null;
                if (sQLFragment2 instanceof RelationUsage) {
                    dBObjectID = ((RelationUsage)sQLFragment2).getObjectID();
                    if (dBObjectID != null) {
                        try {
                            relation = (Relation)dBObjectID.resolveID();
                        }
                        catch (DBException dBException) {
                            DBLog.getLogger((Object)this).warning("Couldn't resolve relation : " + dBException.getMessage());
                        }
                    }
                } else if (sQLFragment2 instanceof SynonymUsage && (dBObjectID = ((SynonymUsage)sQLFragment2).getReferencedObject()) instanceof Relation) {
                    relation = (Relation)dBObjectID;
                }
                if (relation == null) break block10;
                dBObjectID = relation.getColumns();
                for (int i = 0; dBObjectID != null && i < ((Column[])dBObjectID).length; ++i) {
                    defaultMutableTreeNode.add(this.createTreeNode((DBObject)dBObjectID[i]));
                }
                break block10;
            }
            if (sQLFragment2 instanceof SQLQuery) {
                relation = ((SQLQuery)sQLFragment2).getSelectObjects();
                for (int i = 0; i < ((SelectObject[])relation).length; ++i) {
                    defaultMutableTreeNode.add(this.createTreeNode((SQLFragment)new SelectObjectUsage((SelectObject)relation[i], (FromObject)sQLFragment)));
                }
            }
        }
        return defaultMutableTreeNode;
    }

    public static int indexOfNode(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
        int n = 0;
        int n2 = -1;
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode2.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (defaultMutableTreeNode3 == defaultMutableTreeNode) {
                n2 = n;
                break;
            }
            ++n;
        }
        return n2;
    }

    public static DefaultMutableTreeNode findNode(Object object, DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = 0;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (defaultMutableTreeNode3.getUserObject() == object) {
                defaultMutableTreeNode2 = defaultMutableTreeNode3;
                break;
            }
            ++n;
        }
        return defaultMutableTreeNode2;
    }

    public static void expandAll(JTree jTree) {
        for (int i = 0; i < jTree.getRowCount(); ++i) {
            jTree.expandRow(i);
        }
    }

    private class LazyTreeNode
    extends DefaultMutableTreeNode {
        private boolean m_init;

        LazyTreeNode(DBObject dBObject) {
            super(dBObject);
        }

        private void init() {
            if (!this.m_init) {
                try {
                    this.m_init = true;
                    DBObject dBObject = (DBObject)this.getUserObject();
                    if (dBObject instanceof FKConstraint) {
                        DBObjectID dBObjectID;
                        DBObject dBObject2;
                        if (TreeNodeMaker.this.m_fkDeep && (dBObject2 = (dBObjectID = ((FKConstraint)dBObject).getReferenceID()).resolveID()) != null && dBObject2 instanceof Constraint) {
                            this.add(TreeNodeMaker.this.createTreeNode((DBObject)((Constraint)dBObject2).getRelation()));
                        }
                    } else if (TreeNodeMaker.this.m_showChildren) {
                        TreeNodeMaker.this.createChildNodes(dBObject, this);
                    }
                }
                catch (DBException dBException) {
                    DBLog.getLogger((Object)this).warning("Couldn't resolve fk " + dBException.getMessage());
                }
            }
        }

        public Enumeration children() {
            this.init();
            return super.children();
        }

        @Override
        public TreeNode getChildAfter(TreeNode treeNode) {
            this.init();
            return super.getChildAfter(treeNode);
        }

        @Override
        public TreeNode getChildAt(int n) {
            this.init();
            return super.getChildAt(n);
        }

        @Override
        public TreeNode getChildBefore(TreeNode treeNode) {
            this.init();
            return super.getChildBefore(treeNode);
        }

        @Override
        public int getChildCount() {
            this.init();
            return super.getChildCount();
        }

        @Override
        public TreeNode getLastChild() {
            this.init();
            return super.getLastChild();
        }

        @Override
        public void insert(MutableTreeNode mutableTreeNode, int n) {
            this.init();
            super.insert(mutableTreeNode, n);
        }

        @Override
        public boolean isLeaf() {
            if (this.m_init) {
                return super.isLeaf();
            }
            return false;
        }
    }

    private class NodeExpander
    implements Runnable {
        final DBObject m_parent;
        final DefaultMutableTreeNode m_node;

        public NodeExpander(DBObject dBObject, DefaultMutableTreeNode defaultMutableTreeNode) {
            this.m_parent = dBObject;
            this.m_node = defaultMutableTreeNode;
        }

        @Override
        public void run() {
            this.expandNode();
        }

        public void expandNode() {
            block11: {
                try {
                    Object object;
                    final ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
                    DBObject dBObject = this.m_parent;
                    String[] stringArray = TreeNodeMaker.this.m_childTypes;
                    this.checkThread();
                    if (dBObject instanceof Synonym) {
                        if (stringArray != null) {
                            object = new ArrayList<String>(Arrays.asList(stringArray));
                            object.remove("FKConstraint");
                            stringArray = object.toArray(new String[object.size()]);
                        }
                        object = DBUtil.getSynonymReference((Synonym)((Synonym)dBObject));
                        dBObject = object;
                    }
                    if (stringArray == null) {
                        object = dBObject.getOwnedObjects();
                        this.checkThread();
                        for (int i = 0; i < ((DBObject[])object).length; ++i) {
                            DefaultMutableTreeNode defaultMutableTreeNode = TreeNodeMaker.this.createTreeNode((DBObject)object[i]);
                            if (defaultMutableTreeNode == null) continue;
                            arrayList.add(defaultMutableTreeNode);
                        }
                    } else if (stringArray.length > 0) {
                        object = dBObject.getOwnedObjects(stringArray);
                        this.checkThread();
                        for (int i = 0; i < ((Object)object).length; ++i) {
                            DefaultMutableTreeNode defaultMutableTreeNode = TreeNodeMaker.this.createTreeNode((DBObject)object[i]);
                            if (defaultMutableTreeNode == null) continue;
                            arrayList.add(defaultMutableTreeNode);
                        }
                    }
                    object = new Runnable(){

                        @Override
                        public void run() {
                            NodeExpander.this.m_node.removeAllChildren();
                            for (MutableTreeNode mutableTreeNode : arrayList) {
                                NodeExpander.this.m_node.add(mutableTreeNode);
                            }
                            if (TreeNodeMaker.this.m_tree != null) {
                                ((DefaultTreeModel)TreeNodeMaker.this.m_tree.getModel()).nodeStructureChanged(NodeExpander.this.m_node);
                            }
                        }
                    };
                    if (SwingUtilities.isEventDispatchThread()) {
                        object.run();
                    } else {
                        SwingUtilities.invokeLater((Runnable)object);
                    }
                }
                catch (Exception exception) {
                    this.clearNode();
                    if (exception instanceof InterruptedException) break block11;
                    DBLog.getLogger((Object)TreeNodeMaker.this).log(Level.SEVERE, UIBundle.get("DBOBJECT_TREE_LOADING_ERROR_TITLE"), exception);
                }
            }
        }

        public void clearNode() {
            if (this.m_node instanceof LazyTreeNode) {
                this.m_node.removeAllChildren();
                TreeNodeMaker.this.m_tree.collapsePath(new TreePath(this.m_node.getPath()));
                ((LazyTreeNode)this.m_node).m_init = false;
            }
        }

        private void checkThread() throws InterruptedException {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
        }
    }
}

