/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.VetoableChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.db.dialogs.DBDialogHeader;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.WizardCallbacks;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public class SelectSchemaPanel
extends DefaultTraversablePanel {
    public static final String USE_DEFAULT_KEY = "USE_DEFAULT";
    private final JLabel m_lblSchemaName = new JLabel();
    private final DBObjectChooser m_pickerSchema = new DBObjectChooser("SCHEMA");
    private final JCheckBox m_useDefault = new JCheckBox();
    private final ItemListener m_listener = new CheckBoxListener();
    private DBObjectProvider m_prov = null;
    private DBObjectID m_previous = null;

    public SelectSchemaPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        DBUIResourceHelper dBUIResourceHelper = new DBUIResourceHelper("SelectSchemaPanel");
        dBUIResourceHelper.resLabel(this.m_lblSchemaName, this.m_pickerSchema, UIBundle.get("SCHEMA_INFO_LABEL_SCHEMA_NAME"), "Schema");
        ResourceUtils.resButton((AbstractButton)this.m_useDefault, (String)UIBundle.get("SCHEMA_USE_DEFAULT"));
        this.add(this.m_lblSchemaName, new GridBagConstraints(10, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add(this.m_pickerSchema, new GridBagConstraints(20, 10, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_useDefault, new GridBagConstraints(20, 20, 17, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 5), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(1, 100, 1, 1, 0.0, 1.0, 18, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    public String getHeaderTitle() {
        return UIBundle.get("SCHEMA_HEADER");
    }

    public String getHeaderDescription() {
        return UIBundle.get("SCHEMA_HEADER_DESC");
    }

    public void onEntry(TraversableContext traversableContext) {
        DBObjectProvider dBObjectProvider;
        this.m_prov = dBObjectProvider = (DBObjectProvider)traversableContext.find("oracle.javatools.db.DBObjectProvider");
        Schema schema = (Schema)traversableContext.find("NewObject");
        if (schema != null) {
            this.m_previous = schema.getID();
        }
        boolean bl = Boolean.TRUE == traversableContext.find(USE_DEFAULT_KEY);
        this.m_pickerSchema.setProvider(dBObjectProvider);
        this.m_pickerSchema.setDBObject((DBObject)schema);
        this.m_pickerSchema.setNullText("");
        this.m_useDefault.removeItemListener(this.m_listener);
        this.m_useDefault.setSelected(bl);
        this.m_useDefault.addItemListener(this.m_listener);
        this.enablePicker(bl);
        WizardCallbacks wizardCallbacks = traversableContext.getWizardCallbacks();
        if (wizardCallbacks != null) {
            wizardCallbacks.wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
            wizardCallbacks.wizardSetInitialFocus((Component)(this.m_pickerSchema.isEnabled() ? this.m_pickerSchema : this.m_useDefault));
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        traversableContext.remove("NewObject");
        if (!this.m_useDefault.isSelected()) {
            traversableContext.put("NewObject", (Object)this.m_pickerSchema.getOrCreateDBObject());
        } else {
            traversableContext.put("NewObject", null);
        }
        traversableContext.put(USE_DEFAULT_KEY, (Object)this.m_useDefault.isSelected());
    }

    private void enablePicker(boolean bl) {
        this.m_lblSchemaName.setEnabled(!bl);
        this.m_pickerSchema.setEnabled(!bl);
    }

    public static final Holder<Schema> choose(SchemaChooserContext schemaChooserContext) {
        boolean bl;
        Namespace namespace = schemaChooserContext.m_ns != null ? schemaChooserContext.m_ns : new Namespace();
        namespace.put(Context.class.getName(), (Object)schemaChooserContext.m_context);
        namespace.put("oracle.javatools.db.DBObjectProvider", (Object)schemaChooserContext.m_provider);
        namespace.put("NewObject", (Object)schemaChooserContext.m_current);
        namespace.put(USE_DEFAULT_KEY, (Object)(schemaChooserContext.m_current == null ? 1 : 0));
        SelectSchemaPanel selectSchemaPanel = new SelectSchemaPanel();
        TDialogLauncher tDialogLauncher = new TDialogLauncher((Component)Ide.getMainWindow(), schemaChooserContext.m_title, (Traversable)selectSchemaPanel, namespace);
        tDialogLauncher.setInitialSize(320, 200);
        JEWTDialog jEWTDialog = tDialogLauncher.initDialog();
        if (ModelUtil.hasLength((String)schemaChooserContext.m_headerText)) {
            DBDialogHeader dBDialogHeader = new DBDialogHeader();
            dBDialogHeader.setHeaderDescription(schemaChooserContext.m_headerText);
            jEWTDialog.setDialogHeader((Component)((Object)dBDialogHeader));
        }
        jEWTDialog.setName("SchemaChooser");
        boolean bl2 = bl = schemaChooserContext.m_listener != null;
        if (bl) {
            jEWTDialog.addVetoableChangeListener(schemaChooserContext.m_listener);
        }
        selectSchemaPanel.m_pickerSchema.setEditable(bl);
        return tDialogLauncher.showDialog() ? new Holder((Object)((Schema)namespace.find("NewObject"))) : null;
    }

    private final class CheckBoxListener
    implements ItemListener {
        private CheckBoxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl = SelectSchemaPanel.this.m_useDefault.isSelected();
            SelectSchemaPanel.this.enablePicker(bl);
            if (bl) {
                SelectSchemaPanel.this.m_previous = SelectSchemaPanel.this.m_pickerSchema.getDBObjectID();
                boolean bl2 = false;
                if (SelectSchemaPanel.this.m_prov != null) {
                    try {
                        SelectSchemaPanel.this.m_pickerSchema.setDBObject((DBObject)SelectSchemaPanel.this.m_prov.getDefaultSchema());
                        bl2 = true;
                    }
                    catch (DBException dBException) {
                        dBException.printStackTrace();
                    }
                }
                if (!bl2) {
                    SelectSchemaPanel.this.m_pickerSchema.setDBObject(null);
                }
            } else if (SelectSchemaPanel.this.m_previous != null) {
                SelectSchemaPanel.this.m_pickerSchema.setDBObjectID(SelectSchemaPanel.this.m_previous);
            }
        }
    }

    public static final class SchemaChooserContext {
        private Context m_context;
        private DBObjectProvider m_provider;
        private Schema m_current;
        private String m_title = UIBundle.get("CHOOSE_SCHEMA_TITLE");
        private String m_headerText = UIBundle.get("CHOOSE_SCHEMA_HEADER");
        private Namespace m_ns;
        private VetoableChangeListener m_listener;

        public final void setContext(Context context) {
            this.m_context = context;
        }

        public final void setProvider(DBObjectProvider dBObjectProvider) {
            this.m_provider = dBObjectProvider;
        }

        public final void setCurrent(Schema schema) {
            this.m_current = schema;
        }

        public final void setTitle(String string) {
            if (ModelUtil.hasLength((String)string)) {
                this.m_title = string;
            }
        }

        public final void setHeaderText(String string) {
            this.m_headerText = string;
        }

        public final void setNamespace(Namespace namespace) {
            this.m_ns = namespace;
        }

        public final void setListener(VetoableChangeListener vetoableChangeListener) {
            this.m_listener = vetoableChangeListener;
        }
    }
}

