/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.controls.DBObjectLabel;
import oracle.ide.db.controls.ReadOnlyScrollPane;
import oracle.ide.db.controls.ReadOnlyTextArea;
import oracle.ide.db.dialogs.SQLErrorDialog;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.CascadeRequiredException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBSQLException;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.util.DBObjectSet;
import oracle.javatools.util.ModelUtil;

public class DBExceptionDialog
extends SQLErrorDialog {
    private JWrappedLabel m_desc = new JWrappedLabel();
    private JPanel m_panel = new JPanel();
    private ExPanel m_expPanel;

    protected DBExceptionDialog() {
    }

    private void setError(DBException dBException, String string) {
        ArrayList<DBException> arrayList = new ArrayList<DBException>();
        while (dBException != null) {
            arrayList.add(dBException);
            dBException = dBException.getNextException();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (ModelUtil.hasLength((String)string)) {
            stringBuilder.append(string);
            stringBuilder.append("\n\n");
        }
        if (arrayList.size() > 1) {
            stringBuilder.append(UIBundle.get("DB_EXCEPTION_DESC"));
        } else {
            stringBuilder.append(UIBundle.get("DB_EXCEPTION_DESC_SINGLE"));
        }
        this.m_desc.setText(stringBuilder.toString());
        this.setErrors(arrayList);
    }

    @Override
    protected Component getExceptionComponent() {
        this.m_panel.setLayout(new BorderLayout());
        return this.m_panel;
    }

    @Override
    protected void updateExceptionComponent(Exception exception) {
        ExPanel exPanel = null;
        if (exception instanceof CascadeRequiredException) {
            if (!(this.m_expPanel instanceof CascadeExceptionPanel)) {
                exPanel = new CascadeExceptionPanel();
            }
        } else if (exception instanceof DBSQLException) {
            if (!(this.m_expPanel instanceof DBSQLExceptionPanel)) {
                exPanel = new DBSQLExceptionPanel();
            }
        } else if (exception instanceof DBException && !(this.m_expPanel instanceof DBExceptionPanel)) {
            exPanel = new DBExceptionPanel();
        }
        if (exPanel != null) {
            if (this.m_expPanel != null) {
                this.m_panel.remove(this.m_expPanel);
            }
            this.m_expPanel = exPanel;
            this.m_panel.add((Component)this.m_expPanel, "Center");
        }
        this.m_expPanel.setException((DBException)((Object)exception));
    }

    public static void showErrorDialog(Component component, String string, DBException dBException) {
        DBExceptionDialog.showErrorDialog(component, string, dBException, null);
    }

    public static void showErrorDialog(Component component, String string, DBException dBException, String string2) {
        DBExceptionDialog.showErrorDialog(component, string, null, dBException, string2);
    }

    public static void showErrorDialog(Component component, String string, String string2, DBException dBException, String string3) {
        DBExceptionDialog dBExceptionDialog = new DBExceptionDialog();
        dBExceptionDialog.setError(dBException, string2);
        dBExceptionDialog.runErrorDialog(component, string, string3);
    }

    public static boolean showConfirmDialog(Component component, String string, DBException dBException) {
        return DBExceptionDialog.showConfirmDialog(component, string, null, dBException);
    }

    public static boolean showConfirmDialog(Component component, String string, String string2, DBException dBException) {
        DBExceptionDialog dBExceptionDialog = new DBExceptionDialog();
        dBExceptionDialog.setError(dBException, null);
        return dBExceptionDialog.runConfirmDialog(component, string, string2);
    }

    private abstract class ExPanel
    extends JPanel {
        private ExPanel() {
        }

        protected abstract void setException(DBException var1);
    }

    private class CascadeExceptionPanel
    extends ExPanel {
        private CascadeExceptionPanel() {
        }

        private Collection<DBObject> getObjects(CascadeRequiredException cascadeRequiredException) {
            ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
            while (cascadeRequiredException != null) {
                arrayList.addAll(cascadeRequiredException.getObjects());
                DBException dBException = cascadeRequiredException.getNextException();
                cascadeRequiredException = dBException instanceof CascadeRequiredException ? (CascadeRequiredException)((Object)dBException) : null;
            }
            return arrayList;
        }

        private Collection<DBObjectID> getDependents(CascadeRequiredException cascadeRequiredException) {
            ArrayList<DBObjectID> arrayList = new ArrayList<DBObjectID>();
            while (cascadeRequiredException != null) {
                arrayList.addAll(cascadeRequiredException.getDependents());
                DBException dBException = cascadeRequiredException.getNextException();
                cascadeRequiredException = dBException instanceof CascadeRequiredException ? (CascadeRequiredException)((Object)dBException) : null;
            }
            return arrayList;
        }

        @Override
        protected void setException(DBException dBException) {
            CascadeRequiredException cascadeRequiredException = (CascadeRequiredException)((Object)dBException);
            this.removeAll();
            this.setLayout(new GridBagLayout());
            Insets insets = new Insets(0, 0, 0, 0);
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
            this.add((Component)new JWrappedLabel(UIBundle.get(DBExceptionDialog.this.isConfirm() ? "DB_CASCADE_OBJS" : "DB_CASCADE_OBJS_ERR")), gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.weighty = 0.5;
            gridBagConstraints.insets.top = 15;
            gridBagConstraints.fill = 1;
            this.add(this.createListPanel(this.getObjects(cascadeRequiredException), false), gridBagConstraints);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weighty = 0.0;
            Collection<DBObjectID> collection = this.getDependents(cascadeRequiredException);
            if (collection != null) {
                ++gridBagConstraints.gridy;
                this.add((Component)new JLabel(UIBundle.get("DB_CASCADE_OBJS_BECAUSE")), gridBagConstraints);
                ++gridBagConstraints.gridy;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 1;
                this.add(this.createListPanel(collection, true), gridBagConstraints);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weighty = 0.0;
            }
            if (DBExceptionDialog.this.isConfirm()) {
                ++gridBagConstraints.gridy;
                this.add((Component)new JLabel(UIBundle.get("DB_CASCADE_OBJS_QU")), gridBagConstraints);
            }
        }

        private Component createListPanel(Collection collection, boolean bl) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            Insets insets = new Insets(0, 5, 0, 5);
            Set set = null;
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, insets, 0, 0);
            for (Object e : collection) {
                DBObject dBObject = null;
                if (e instanceof DBObjectID) {
                    try {
                        dBObject = ((DBObjectID)e).resolveID();
                    }
                    catch (DBException dBException) {
                        DBLog.getLogger((Object)this).warning("Error resolving object id" + dBException.getMessage());
                    }
                } else {
                    dBObject = (DBObject)e;
                }
                if (dBObject != null) {
                    while (dBObject instanceof SQLFragment) {
                        dBObject = dBObject.getParent();
                    }
                }
                if (dBObject == null) continue;
                if (set == null) {
                    set = new DBObjectSet();
                }
                if (set.contains(dBObject)) continue;
                ++gridBagConstraints.gridy;
                jPanel.add((Component)new DBObjectLabel(dBObject, bl), gridBagConstraints);
                set.add(dBObject);
                gridBagConstraints.insets.top = 5;
            }
            ++gridBagConstraints.gridy;
            ++gridBagConstraints.gridx;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.weightx = 1.0;
            jPanel.add(Box.createGlue(), gridBagConstraints);
            JScrollPane jScrollPane = new JScrollPane(jPanel, 20, 31);
            jScrollPane.setBorder(null);
            return jScrollPane;
        }
    }

    private class DBSQLExceptionPanel
    extends ExPanel {
        private final JTextArea m_label = new ReadOnlyTextArea();
        private final JLabel m_sqlDesc = new JLabel();
        private final ReadOnlyScrollPane m_sqlStatement = new ReadOnlyScrollPane();

        private DBSQLExceptionPanel() {
            DBUIResourceHelper dBUIResourceHelper = new DBUIResourceHelper("DBSQLExceptionPanel");
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 15, 0), 0, 0);
            this.add((Component)DBExceptionDialog.this.m_desc, gridBagConstraints);
            this.m_label.setRows(3);
            ++gridBagConstraints.gridy;
            dBUIResourceHelper.setName(this.m_label, "Message");
            this.add((Component)this.m_label, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.m_sqlDesc.setText(UIBundle.get("DB_EXCEPTION_SHOW_SQL_DESC"));
            this.add((Component)this.m_sqlDesc, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.weighty = 0.5;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets.bottom = 0;
            dBUIResourceHelper.setName(this.m_sqlStatement, "SQL");
            this.add((Component)this.m_sqlStatement, gridBagConstraints);
        }

        @Override
        protected void setException(DBException dBException) {
            String string = dBException.getMessage();
            string = string.replaceFirst("java\\.sql\\.SQL.*Exception:", "").trim();
            this.m_label.setText(string);
            this.m_sqlStatement.setText(((DBSQLException)dBException).getSQL(), false);
        }
    }

    private class DBExceptionPanel
    extends ExPanel {
        private JTextArea m_label = new ReadOnlyTextArea();
        private DBObjectLabel m_object = new DBObjectLabel();

        private DBExceptionPanel() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 15, 0), 0, 0);
            this.add((Component)DBExceptionDialog.this.m_desc, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets.left = 5;
            this.m_object.setHideWhenNull(true);
            this.add((Component)this.m_object, gridBagConstraints);
            gridBagConstraints.insets.left = 0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets.bottom = 0;
            this.add((Component)this.m_label, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.weighty = 0.5;
            this.add(Box.createGlue(), gridBagConstraints);
            DBUIResourceHelper dBUIResourceHelper = new DBUIResourceHelper("DBExceptionPanel");
            dBUIResourceHelper.setName(this.m_object, "m_object");
            dBUIResourceHelper.setName(this.m_label, "m_label");
        }

        @Override
        protected void setException(DBException dBException) {
            StringBuilder stringBuilder = new StringBuilder();
            DBObject dBObject = dBException.getObject();
            this.m_object.setVisible(true);
            this.m_object.setObject(dBObject, true);
            stringBuilder.append(dBException.getMessage());
            this.m_label.setText(stringBuilder.toString());
            String string = this.m_object.getText();
            this.m_object.setVisible(ModelUtil.hasLength((String)string) && !string.equals(StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"null"})));
        }
    }
}

