/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.dialogs;

import java.awt.Component;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.db.ProviderOperator;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.ideimpl.db.dialogs.DBUIProgressBar;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.CascadeRequiredException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.property.PropertyAction;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.dialogs.MessageDialog;

public class CascadeConfirmDialog
extends DBExceptionDialog {
    private CascadeConfirmDialog() {
    }

    public static boolean confirmCascade(Component component, CascadeRequiredException cascadeRequiredException, String string, String string2) {
        if (string == null) {
            string = UIBundle.get("DB_CASCADE_TITLE");
        }
        return DBMessageDialog.useDialog() && CascadeConfirmDialog.showConfirmDialog(component, string, string2, (DBException)cascadeRequiredException);
    }

    public static boolean confirmReplace(DBEditorConfig dBEditorConfig) {
        PropertyAction.Type type;
        boolean bl = true;
        DBObjectProvider dBObjectProvider = dBEditorConfig.getProvider();
        final SystemObject systemObject = dBEditorConfig.getOriginalObject();
        final SystemObject systemObject2 = dBEditorConfig.getUpdatedObject();
        final PropertyManager propertyManager = dBObjectProvider.getPropertyManager();
        DBUIProgressBar dBUIProgressBar = new DBUIProgressBar(UIBundle.get("REPLACE_CONFIRM_TITLE"));
        PropertyAction propertyAction = dBUIProgressBar.execute(new DBUIProgressBar.ProgressCallable<PropertyAction, RuntimeException>(){

            @Override
            public PropertyAction call() {
                return propertyManager.canUpdateObject(systemObject, systemObject2);
            }
        });
        PropertyAction.Type type2 = type = propertyAction == null ? null : propertyAction.getType();
        if (type == PropertyAction.Type.CREATE || type == PropertyAction.Type.REPLACE) {
            if (systemObject != null && !dBEditorConfig.isReplaceAllowed()) {
                StringBuilder stringBuilder = new StringBuilder();
                for (String string : propertyAction.getProperties()) {
                    stringBuilder.append(PropertyDisplayRegistry.getDisplayName(string)).append("\n");
                }
                String string = stringBuilder.toString();
                if (MessageDialog.confirm((Component)DBMessageDialog.getDialogParent(), (Object)UIBundle.format("REPLACE_CONFIRM_TEXT", string), (String)UIBundle.get("REPLACE_CONFIRM_TITLE"), null, (boolean)true)) {
                    dBEditorConfig.setReplaceAllowed(true);
                } else {
                    bl = false;
                }
            }
        } else if (type == PropertyAction.Type.ALTER) {
            dBEditorConfig.setReplaceAllowed(false);
        }
        return bl;
    }

    public static boolean updateObjects(Component component, String string, DBObjectProvider dBObjectProvider, SystemObject[] systemObjectArray, SystemObject[] systemObjectArray2) {
        return CascadeConfirmDialog.updateObjects(component, string, dBObjectProvider, systemObjectArray, systemObjectArray2, false);
    }

    public static boolean updateObjects(Component component, String string, DBObjectProvider dBObjectProvider, SystemObject[] systemObjectArray, SystemObject[] systemObjectArray2, boolean bl) {
        try {
            Difference difference = dBObjectProvider.getDiffEngine().difference((Object)systemObjectArray, (Object)systemObjectArray2);
            return CascadeConfirmDialog.doUpdate(component, string, dBObjectProvider, difference, bl);
        }
        catch (DBException dBException) {
            DBExceptionDialog.showErrorDialog(component, string, dBException);
            return false;
        }
    }

    private static boolean doUpdate(Component component, String string, DBObjectProvider dBObjectProvider, Difference difference, boolean bl) throws DBException {
        boolean bl2 = false;
        try {
            dBObjectProvider.canUpdate(difference, bl, false);
        }
        catch (CascadeRequiredException cascadeRequiredException) {
            if (CascadeConfirmDialog.confirmCascade(component, cascadeRequiredException, string, null)) {
                bl2 = true;
            }
            return false;
        }
        dBObjectProvider.updateObjects(difference, bl, bl2);
        return true;
    }

    @Deprecated
    public static boolean updateObjects(Component component, String string, DBEditorConfig dBEditorConfig) {
        ProviderOperator providerOperator = new ProviderOperator(dBEditorConfig.getProvider());
        providerOperator.updateObjects(dBEditorConfig);
        return dBEditorConfig.getResult() == DBEditorConfig.Result.SUCCESS;
    }
}

