/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import javax.swing.JLabel;
import oracle.ide.db.components.ComponentContext;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.controls.NameTextField;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.icons.OracleIcons;

public class NameEditor<T extends SystemObject>
extends BaseEditorPanel<T> {
    private JLabel m_templateHint;
    private String m_initialName;
    private NameTextField m_nameField;
    private PanelLibrary m_panels;

    @Override
    protected void initialiseComponents() {
        this.m_panels = (PanelLibrary)this.getDataContext().find(PanelLibrary.class);
        DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
        this.layoutComponents(dBUILayoutHelper);
        dBUILayoutHelper.pushUp();
        dBUILayoutHelper.layout();
        if (this.m_nameField != null) {
            this.m_nameField.init((DBObject)this.getUpdatedObject(), (DBObject)this.getOriginalObject(), this.getProvider());
        }
    }

    @Override
    protected void commitPanel() throws TraversalException {
        if (this.m_nameField != null) {
            this.m_nameField.commit();
        }
        super.commitPanel();
    }

    protected void layoutComponents(DBUILayoutHelper dBUILayoutHelper) {
        String string;
        ComponentWrapper componentWrapper = this.getNameComponentWrapper();
        dBUILayoutHelper.add(componentWrapper);
        this.getComponentFactory().getResourceHelper().setName((Component)componentWrapper.getActiveComponent(), "Name");
        Object object = this.getUpdatedObject();
        if (this.childEditOnly()) {
            object = this.getEditorConfig().getChildObject();
        }
        if ((string = TemplateExpander.getTemplateObjectName(object)) != null) {
            this.m_templateHint = new JLabel();
            dBUILayoutHelper.nextRow();
            dBUILayoutHelper.add(this.m_templateHint, 2, 1, true, false);
            dBUILayoutHelper.getConstraints((Component)this.m_templateHint).anchor = 13;
            this.m_templateHint.setText(string);
            this.m_templateHint.setIcon(OracleIcons.getIcon((String)"copy.png"));
            if (object instanceof MaterializedView) {
                this.m_templateHint.setToolTipText(UIBundle.format("TEMPLATE_USAGE_HINT_MVIEW", string));
            } else if (object instanceof Table) {
                this.m_templateHint.setToolTipText(UIBundle.format("TEMPLATE_USAGE_HINT_TABLE", string));
            } else if (object instanceof PlSqlSourceObject) {
                this.m_templateHint.setToolTipText(UIBundle.format("TEMPLATE_USAGE_HINT_PLSQL", string));
            } else {
                this.m_templateHint.setToolTipText(UIBundle.format("TEMPLATE_USAGE_HINT_GENERAL", string));
            }
        } else {
            DBEditorFactory.EditorType editorType = this.getEditorConfig().getEditorType();
            if (editorType != DBEditorFactory.EditorType.CREATE_SIMPLE) {
                dBUILayoutHelper.pushLeft();
            }
        }
    }

    @Override
    protected boolean isEditable() {
        return super.isEditable() && !this.childEditOnly();
    }

    protected boolean childEditOnly() {
        return this.getEditorConfig().isChildEditOnly();
    }

    @Override
    protected void initialisePanel() {
        this.setInitialName(((SystemObject)this.getUpdatedObject()).getName());
        if (this.m_nameField != null) {
            this.m_nameField.initialiseObjectListener();
        }
    }

    @Deprecated
    public void commitName() {
    }

    protected final void setInitialName(String string) {
        this.m_initialName = string;
    }

    protected final String getInitialName() {
        return this.m_initialName;
    }

    @Deprecated
    protected final void changePanels(String string, Navigable[] navigableArray) throws TraversalException {
    }

    protected final PanelLibrary getPanelLibrary() {
        if (this.m_panels == null) {
            throw new IllegalStateException("Cannot call getPanelLibrary() until onEntry has been called");
        }
        return this.m_panels;
    }

    @Deprecated
    protected final void changePanels() throws TraversalException {
    }

    @Deprecated
    protected final void changePanels(Navigable[] navigableArray) throws TraversalException {
    }

    @Deprecated
    protected void validatePanelChange(TraversableContext traversableContext) throws TraversalException {
    }

    private ComponentWrapper getNameComponentWrapper() {
        NameTextFieldDummyWrapper<NameTextField> nameTextFieldDummyWrapper = null;
        if (this.isInFlatEditor()) {
            nameTextFieldDummyWrapper = this.getOrCreateWrapper("name");
        } else if (this.m_nameField == null) {
            ComponentContext componentContext = this.createComponentContext("name");
            this.m_nameField = new NameTextField();
            nameTextFieldDummyWrapper = new NameTextFieldDummyWrapper<NameTextField>(this.m_nameField);
            nameTextFieldDummyWrapper.initialise(componentContext);
            this.getComponentFactory().registerComponentWrapper(nameTextFieldDummyWrapper);
        } else {
            nameTextFieldDummyWrapper = this.getComponentFactory().findComponentWrapper("name");
        }
        return nameTextFieldDummyWrapper;
    }

    private class NameTextFieldDummyWrapper<NameTextField>
    extends ComponentWrapper {
        public NameTextFieldDummyWrapper(NameTextField NameTextField2) {
            super((Component)NameTextField2);
        }

        @Override
        public Object getPropertyValue() {
            return null;
        }

        @Override
        public void setPropertyValue(Object object) {
        }

        @Override
        protected void initialiseComponentListener() {
        }
    }
}

