/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.components;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.db.components.ComponentContext;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.components.AsynchronousDocumentComponentWrapper;
import oracle.ideimpl.db.controls.IdPanel;
import oracle.ideimpl.db.validate.DBValidationHandler;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.util.ModelUtil;

public class DBObjectIDComponentWrapper
extends AsynchronousDocumentComponentWrapper<IdPanel> {
    private final DBObjectChooser.ChangeListener m_chooserChangeListener = new DBObjectChooser.ChangeListener(){

        @Override
        public void chooserChanged(DBObjectChooser dBObjectChooser, DBObjectID dBObjectID) {
            DBObjectIDComponentWrapper.this.fireChangeEvent();
        }
    };
    private DBObjectChooser m_cmbSchema;
    private DBObjectChooser m_cmbParent;
    private DBObjectChooser m_cmbObject;

    public DBObjectIDComponentWrapper() {
        super(new IdPanel());
    }

    @Override
    public Object getPropertyValue() {
        return this.m_cmbObject.getDBObjectID();
    }

    @Override
    public void setValidationStatus(Collection<ValidationException> collection, DBValidationHandler dBValidationHandler) {
        this.setValidationStatus(this.m_cmbSchema, collection, dBValidationHandler);
        this.setValidationStatus(this.m_cmbParent, collection, dBValidationHandler);
        this.setValidationStatus(this.m_cmbObject, collection, dBValidationHandler);
    }

    private void setValidationStatus(DBObjectChooser dBObjectChooser, Collection<ValidationException> collection, DBValidationHandler dBValidationHandler) {
        if (dBObjectChooser != null) {
            if (dBObjectChooser != this.m_cmbObject && dBObjectChooser.getDBObjectID() != null) {
                collection = null;
            }
            dBValidationHandler.processValidation(dBObjectChooser.isEditable() ? dBObjectChooser.getEditorComponent() : dBObjectChooser, this, collection);
        }
    }

    @Override
    protected void setPropertyValueImpl(Object object) {
        DBObjectID dBObjectID = null;
        if (object instanceof DBObjectID) {
            dBObjectID = (DBObjectID)object;
        }
        DBObjectID dBObjectID2 = this.m_cmbObject.getDBObjectID();
        if (dBObjectID == null || !dBObjectID.equals(dBObjectID2, true)) {
            DBObjectID dBObjectID3 = DBUtil.getUppermostParent((DBObjectID)dBObjectID);
            this.setSelectedSchema(dBObjectID3);
            if (this.m_cmbParent != null) {
                this.m_cmbParent.setDBObjectID(dBObjectID3);
            }
            this.m_cmbObject.removeChangeListener(this.m_chooserChangeListener);
            this.m_cmbObject.setDBObjectID(dBObjectID);
            this.m_cmbObject.addChangeListener(this.m_chooserChangeListener);
        }
    }

    private void setSelectedSchema(DBObjectID dBObjectID) {
        if (this.m_cmbSchema != null) {
            String string;
            String string2;
            DBObjectProvider dBObjectProvider = this.getProvider();
            if (dBObjectID instanceof BaseObjectID) {
                string2 = ((BaseObjectID)dBObjectID).getSchemaName();
                string = ((BaseObjectID)dBObjectID).getDatabaseName();
            } else {
                string2 = DBUtil.getSchemaName((DBObjectID)dBObjectID);
                string = null;
            }
            Schema schema = this.getDefaultSchema();
            if (ModelUtil.hasLength((String)string) || ModelUtil.hasLength((String)string2)) {
                NameBasedID nameBasedID = null;
                try {
                    DBObjectCriteria dBObjectCriteria = new DBObjectCriteria(Schema.class, new String[0]);
                    dBObjectCriteria.setDatabaseName(string);
                    dBObjectCriteria.setName(string2);
                    Schema schema2 = (Schema)dBObjectProvider.getObject(dBObjectCriteria);
                    if (schema2 != null) {
                        nameBasedID = schema2.getID();
                    }
                }
                catch (DBException dBException) {
                    DBLog.getLogger((Object)this).warning(dBException.getMessage());
                }
                if (nameBasedID == null) {
                    nameBasedID = new NameBasedID("SCHEMA", null, string2);
                    nameBasedID.setDatabaseName(string);
                }
                this.m_cmbSchema.setDBObjectID((DBObjectID)nameBasedID);
            } else if (schema != null && ModelUtil.areDifferent((Object)schema.getName(), (Object)dBObjectProvider.getDescriptor().getPublicSchemaName())) {
                this.m_cmbSchema.setDBObject((DBObject)schema);
            } else {
                try {
                    this.m_cmbSchema.setDBObject((DBObject)dBObjectProvider.getDefaultSchema());
                }
                catch (DBException dBException) {
                    DBLog.getLogger((Object)this).warning(dBException.getMessage());
                }
            }
        }
    }

    @Override
    protected void initialiseComponent() {
        Object object;
        boolean bl;
        boolean bl2 = this.isFixedSchema();
        boolean bl3 = this.isEditable();
        Schema schema = this.getDefaultSchema();
        ComponentContext componentContext = this.getComponentContext();
        PropertyInfo propertyInfo = componentContext.getPropertyInfo();
        DBObjectProvider dBObjectProvider = this.getProvider();
        String string = componentContext.getPropertyName();
        String[] stringArray = this.getTypesFilterForProperty();
        String[] stringArray2 = null;
        boolean bl4 = componentContext.isInTable();
        DBUIResourceHelper dBUIResourceHelper = new DBUIResourceHelper("");
        boolean bl5 = false;
        if (!propertyInfo.isInternalReference()) {
            Metadata metadata = Metadata.getInstance();
            bl = false;
            boolean bl6 = false;
            boolean bl7 = false;
            for (String string2 : stringArray) {
                Class clazz = metadata.getObjectClass(string2);
                if (SchemaObject.class.isAssignableFrom(clazz)) {
                    bl = true;
                    continue;
                }
                if (ChildDBObject.class.isAssignableFrom(clazz)) {
                    bl7 = true;
                    continue;
                }
                bl6 = true;
            }
            object = dBObjectProvider.getPropertyManager().getAllowedReferenceParentTypes(componentContext.getUpdatedObject(), string);
            if (object != null && object.size() > 0) {
                stringArray2 = new String[object.size()];
                int n = 0;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string2;
                    string2 = (String)iterator.next();
                    if (metadata.isSchemaObject(string2)) {
                        bl = true;
                    }
                    stringArray2[n++] = string2;
                }
            }
            if (bl && bl6) {
                stringArray = DBUtil.filterSchemaObjectTypes((String[])stringArray);
            }
            if (bl7 && stringArray2 == null) {
                throw new IllegalStateException("Cannot pick child objects with a parent picker.");
            }
            boolean bl8 = bl5 = !bl4 && stringArray2 != null;
            if (bl && !bl2) {
                this.m_cmbSchema = new DBObjectChooser("SCHEMA");
                this.m_cmbSchema.setEditable(bl3);
                if (this.isShowDBLinkButton()) {
                    this.m_cmbSchema.setShowDBLinkButton(true);
                }
            }
            if (stringArray2 != null) {
                this.m_cmbParent = new DBObjectChooser(this.m_cmbSchema, stringArray2);
                this.m_cmbParent.setEditable(bl3);
            }
        }
        this.m_cmbObject = this.createObjectChooser(this.m_cmbParent == null ? this.m_cmbSchema : this.m_cmbParent, stringArray);
        this.m_cmbObject.setEditable(bl3);
        boolean bl9 = this.isShowAddButton();
        bl = this.isShowEditButton();
        if (this.getComponentContext().isInFlatEditor() && (bl9 || bl)) {
            this.m_cmbObject.setShowAddButton(bl9);
            this.m_cmbObject.setAddButtonProcessor(new DBObjectChooser.NewObjectProcessor(){

                @Override
                public void initialise(SystemObject systemObject) {
                    DBObjectIDComponentWrapper.this.initialiseNewObject(systemObject);
                }
            });
            this.m_cmbObject.setShowEditButton(bl);
        } else if (bl9) {
            this.m_cmbObject.setEditable(true);
        }
        if (PropertyDisplayRegistry.hasNlsStringForPropValue(string, null)) {
            this.m_cmbObject.setNullText(PropertyDisplayRegistry.getPropValueDisplay(string, null));
        }
        this.setupObjectChooser(this.m_cmbObject);
        if (this.m_cmbParent != null) {
            this.setupParentChooser(this.m_cmbParent);
        }
        DBObjectChooser dBObjectChooser = this.getTopChooser();
        dBObjectChooser.setProvider(dBObjectProvider);
        dBObjectChooser.setDBObject(null);
        if (propertyInfo.isInternalReference()) {
            this.m_cmbObject.setContextDBObjectID(componentContext.getEditorConfig().getUpdatedObject().getID());
        } else if (bl2) {
            DBObjectChooser dBObjectChooser2 = this.m_cmbParent == null ? this.m_cmbObject : this.m_cmbParent;
            dBObjectChooser2.setContextDBObjectID(schema.getID());
        } else if (this.isIncludeContextObject()) {
            DBObjectID dBObjectID = componentContext.getEditorConfig().getUpdatedObject().getID();
            object = dBObjectID.getType();
            if (Arrays.asList(stringArray).contains(object)) {
                this.m_cmbObject.addIDToList(dBObjectID);
            } else if (this.m_cmbParent != null && Arrays.asList(stringArray2).contains(object)) {
                this.m_cmbParent.addIDToList(dBObjectID);
            }
        }
        IdPanel idPanel = (IdPanel)this.getActiveComponent();
        idPanel.setName(string);
        idPanel.initialisePanel(this.m_cmbObject, this.m_cmbParent, this.m_cmbSchema, componentContext, this.getPropertyDisplayName(), bl5);
    }

    private DBObjectChooser getTopChooser() {
        DBObjectChooser dBObjectChooser = this.m_cmbSchema != null ? this.m_cmbSchema : (this.m_cmbParent != null ? this.m_cmbParent : this.m_cmbObject);
        return dBObjectChooser;
    }

    private String[] getTypesFilterForProperty() {
        DBObjectProvider dBObjectProvider = this.getProvider();
        PropertyInfo propertyInfo = this.getComponentContext().getPropertyInfo();
        Collection collection = dBObjectProvider.getPropertyManager().getAllowedReferenceTypes(propertyInfo);
        if (collection == null || collection.size() == 0) {
            throw new IllegalStateException("Property has insufficient @References metadata: " + propertyInfo.getPropertyName());
        }
        return collection.toArray(new String[collection.size()]);
    }

    @Override
    protected Document getDocument() {
        return null;
    }

    @Override
    protected void initialiseComponentListener() {
        if (this.isEditable()) {
            super.initialiseComponentListener();
            this.addDocumentListener(this.m_cmbObject);
            this.addDocumentListener(this.m_cmbParent);
            this.addDocumentListener(this.m_cmbSchema);
        }
        this.m_cmbObject.addChangeListener(this.m_chooserChangeListener);
    }

    private void addDocumentListener(DBObjectChooser dBObjectChooser) {
        Component component;
        if (dBObjectChooser != null && (component = dBObjectChooser.getEditorComponent()) instanceof JTextComponent) {
            this.addDocumentListener(((JTextComponent)component).getDocument());
        }
    }

    @Override
    protected void setActiveImpl(boolean bl) {
        boolean bl2 = this.getComponentContext().isInFlatEditor();
        this.activateChooser(this.m_cmbSchema, bl, bl2, bl2);
        this.activateChooser(this.m_cmbParent, bl, bl2, bl2);
        this.activateChooser(this.m_cmbObject, bl, bl2, bl2 || this.getComponentContext().getPropertyInfo().isInternalReference());
    }

    private void activateChooser(DBObjectChooser dBObjectChooser, boolean bl, boolean bl2, boolean bl3) {
        if (dBObjectChooser != null) {
            dBObjectChooser.setActive(bl, bl2, bl3);
        }
    }

    @Override
    public Component[] getFocusComponents() {
        Component[] componentArray;
        if (this.isEditable()) {
            ArrayList<Component> arrayList = new ArrayList<Component>();
            arrayList.add(this.m_cmbObject.getEditorComponent());
            if (this.m_cmbParent != null) {
                arrayList.add(this.m_cmbParent.getEditorComponent());
            }
            if (this.m_cmbSchema != null) {
                arrayList.add(this.m_cmbSchema.getEditorComponent());
            }
            componentArray = arrayList.toArray(new Component[arrayList.size()]);
        } else {
            componentArray = super.getFocusComponents();
        }
        return componentArray;
    }

    @Override
    public Component getDefaultFocusComponent() {
        return this.m_cmbObject.getDefaultFocusComponent();
    }

    protected void setupObjectChooser(DBObjectChooser dBObjectChooser) {
    }

    protected void setupParentChooser(DBObjectChooser dBObjectChooser) {
    }

    protected boolean isEditable() {
        return false;
    }

    protected boolean isIncludeContextObject() {
        return true;
    }

    protected boolean isFixedSchema() {
        return false;
    }

    protected Schema getDefaultSchema() {
        DBObject dBObject = this.getUpdatedObject();
        return DBUtil.getSchema((DBObject)dBObject);
    }

    protected boolean isShowAddButton() {
        return false;
    }

    protected boolean isShowEditButton() {
        return !"schema".equals(this.getPropertyName());
    }

    protected boolean isShowDBLinkButton() {
        return false;
    }

    protected void initialiseNewObject(SystemObject systemObject) {
    }

    protected DBObjectChooser createObjectChooser(DBObjectChooser dBObjectChooser, String ... stringArray) {
        return new DBObjectChooser(dBObjectChooser, stringArray);
    }

    protected final DBObjectChooser getSchemaChooser() {
        return this.m_cmbSchema;
    }

    protected final DBObjectChooser getParentChooser() {
        return this.m_cmbParent;
    }

    protected final DBObjectChooser getObjectChooser() {
        return this.m_cmbObject;
    }
}

