/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.components;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import oracle.ide.db.components.ComponentContext;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.dialogs.CascadeConfirmDialog;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.property.Property;

public abstract class ComponentFactory {
    private final DBUIResourceHelper m_resHelp;
    private final List<ComponentFactory> m_children = new ArrayList<ComponentFactory>();
    private Namespace m_dataContext;
    private String m_basePath;
    private final List<String> m_paths = new ArrayList<String>();
    private final List<ComponentWrapper> m_wrappers = new ArrayList<ComponentWrapper>();
    private boolean m_processed;
    private boolean m_editable = true;
    private boolean m_allowRecreate = true;

    public ComponentFactory(String string) {
        this(string, null);
    }

    public ComponentFactory(String string, ComponentFactory componentFactory) {
        this.m_resHelp = string == null && componentFactory != null ? componentFactory.m_resHelp : new DBUIResourceHelper(string);
        if (componentFactory != null) {
            componentFactory.m_children.add(this);
        }
    }

    public final DBUIResourceHelper getResourceHelper() {
        return this.m_resHelp;
    }

    public final Collection<String> getPaths() {
        HashSet<String> hashSet = new HashSet<String>();
        block0: for (String string : this.m_paths) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (string.startsWith(string2)) continue block0;
                if (!string2.startsWith(string)) continue;
                iterator.remove();
            }
            hashSet.add(string);
        }
        return hashSet;
    }

    public final Collection<ComponentWrapper> getComponentWrappers() {
        return this.getComponentWrappers(true);
    }

    private Collection<ComponentWrapper> getComponentWrappers(boolean bl) {
        Collection<ComponentWrapper> collection;
        if (!bl || this.m_children.isEmpty()) {
            collection = Collections.unmodifiableCollection(this.m_wrappers);
        } else {
            collection = new ArrayList<ComponentWrapper>();
            collection.addAll(this.m_wrappers);
            for (ComponentFactory componentFactory : this.m_children) {
                collection.addAll(componentFactory.getComponentWrappers(true));
            }
        }
        return collection;
    }

    public void setActive(boolean bl) {
        for (ComponentWrapper componentWrapper : this.getComponentWrappers()) {
            componentWrapper.setActive(bl);
        }
    }

    public void refreshComponents(DBObject dBObject) {
        boolean bl = false;
        for (ComponentWrapper componentWrapper : this.getComponentWrappers(false)) {
            bl = componentWrapper.refreshObject(dBObject) || bl;
        }
        if (bl) {
            this.m_processed = false;
        }
        this.processComponents();
    }

    public void setAllowRecreate(boolean bl) {
        this.m_allowRecreate = bl;
    }

    public boolean isEditable() {
        return this.m_editable;
    }

    public void setEditable(boolean bl) {
        this.m_editable = bl;
    }

    public void setEnabled(boolean bl) {
        for (ComponentWrapper componentWrapper : this.getComponentWrappers()) {
            componentWrapper.setEnabled(bl);
        }
    }

    public String getBasePath() {
        return this.m_basePath;
    }

    public void setBasePath(String ... stringArray) {
        this.m_basePath = Property.createPath((String[])stringArray);
    }

    public void setDataContext(Namespace namespace) {
        this.m_dataContext = namespace;
        for (ComponentWrapper componentWrapper : this.getComponentWrappers()) {
            componentWrapper.getComponentContext().setDataContext(namespace);
        }
    }

    protected DBEditorConfig getEditorConfig() {
        return this.m_dataContext == null ? null : (DBEditorConfig)this.m_dataContext.find(DBEditorConfig.class);
    }

    public synchronized void processComponents() {
        DBObjectProvider dBObjectProvider;
        DBEditorConfig dBEditorConfig = this.getEditorConfig();
        DBObjectProvider dBObjectProvider2 = dBObjectProvider = dBEditorConfig == null ? null : dBEditorConfig.getProvider();
        if (dBObjectProvider == null) {
            DBLog.getLogger((Object)this).severe("Cannot processComponent - no DBObjectProvider is available!");
        }
        if (dBObjectProvider != null) {
            for (ComponentWrapper componentWrapper : this.getComponentWrappers()) {
                if (this.m_processed && !componentWrapper.isVolatile()) continue;
                componentWrapper.processComponent(this.m_editable, this.m_allowRecreate);
            }
            this.m_processed = true;
        }
    }

    public synchronized void forceProcessComponents() {
        this.m_processed = false;
        this.processComponents();
    }

    public void processComponent(String string) {
        ComponentWrapper componentWrapper = this.findComponentWrapper(string);
        if (componentWrapper == null) {
            throw new IllegalStateException("Cannot process Component " + string + ": it is not registered");
        }
        componentWrapper.processComponent(this.m_editable, this.m_allowRecreate);
    }

    public void canCommit(DBEditorConfig dBEditorConfig) throws TraversalException {
        if (dBEditorConfig.getUpdatedObject() != null && !CascadeConfirmDialog.confirmReplace(dBEditorConfig)) {
            throw new TraversalException(null);
        }
    }

    public synchronized ComponentWrapper findComponentWrapper(String string) {
        ComponentWrapper componentWrapper;
        block2: {
            ComponentFactory componentFactory;
            String string2;
            String string3;
            componentWrapper = null;
            int n = this.m_paths.indexOf(string = Property.stripProperties((String)string));
            if (n >= 0) {
                componentWrapper = this.m_wrappers.get(n);
            }
            if (componentWrapper != null) break block2;
            Iterator<ComponentFactory> iterator = this.m_children.iterator();
            while (iterator.hasNext() && ((string3 = (string2 = (componentFactory = iterator.next()).getBasePath()) == null ? string : Property.stripStartingPath((String)string, (String[])new String[]{string2})) == null || (componentWrapper = componentFactory.findComponentWrapper(string3)) == null)) {
            }
        }
        return componentWrapper;
    }

    public synchronized void removeComponentWrapper(String string) {
        int n = this.m_paths.indexOf(string = Property.stripProperties((String)string));
        if (n >= 0) {
            this.m_wrappers.remove(n);
            this.m_paths.remove(n);
        } else {
            for (ComponentFactory componentFactory : this.m_children) {
                String string2 = componentFactory.getBasePath();
                String string3 = string2 == null ? string : Property.stripStartingPath((String)string, (String[])new String[]{string2});
                if (string3 == null) continue;
                componentFactory.removeComponentWrapper(string3);
            }
        }
    }

    public synchronized void registerComponentWrapper(ComponentWrapper componentWrapper) {
        String string = componentWrapper.getPropertyName();
        this.m_processed = false;
        this.m_wrappers.add(componentWrapper);
        String string2 = Property.stripProperties((String)string);
        this.m_paths.add(string2);
        componentWrapper.resourceComponent(this.m_resHelp);
    }

    public ComponentContext createComponentContext(String string, DBObject dBObject, DBObject dBObject2) {
        if (this.getEditorConfig() == null) {
            throw new IllegalStateException("Cannot create a ComponentContext - no DBEditorConfig has been set");
        }
        ComponentContext componentContext = new ComponentContext(string, dBObject, dBObject2, this.m_dataContext, this.m_resHelp.getPanelName());
        componentContext.setBasePath(this.getBasePath());
        return componentContext;
    }

    public abstract ComponentWrapper createWrapper(ComponentContext var1);

    public final void registerComponent(Component component, String string) {
        this.registerComponent(component, string, string);
    }

    public final void registerComponent(Component component, String string, String string2) {
        this.registerComponent(null, component, null, string, string2);
    }

    public final void registerComponent(AbstractButton abstractButton, String string, String string2) {
        this.registerComponent(abstractButton, string, string2, string2);
    }

    public final void registerComponent(AbstractButton abstractButton, String string, String string2, String string3) {
        this.registerComponent(null, abstractButton, null, string2, string3);
        this.getResourceHelper().resButton(abstractButton, string, string2);
    }

    public final void registerComponent(JLabel jLabel, Component component, String string, String string2) {
        this.registerComponent(jLabel, component, string, string2, string2);
    }

    public abstract void registerComponent(JLabel var1, Component var2, String var3, String var4, String var5);
}

