/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.db.DBTypeDisplayRegistryEntry;
import oracle.ide.db.DefaultDBTypeRegistry;
import oracle.ide.db.util.IconWithSmallOverlay;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.plsql.PlSqlTokenPattern;
import oracle.javatools.db.property.DisplayNames;
import oracle.javatools.db.token.TokenPattern;
import oracle.javatools.icons.OracleIcons;

public final class DBTypeDisplayRegistry {
    public static final String CONNECTIONS_TYPE = "Connections";
    private static List<DBTypeDisplayRegistryEntry> s_registries = new ArrayList<DBTypeDisplayRegistryEntry>();
    private static HashMap<String, Icon> s_generatedFolderIcons = new HashMap();

    private DBTypeDisplayRegistry() {
    }

    public static void addDBTypeRegistry(DBTypeDisplayRegistryEntry dBTypeDisplayRegistryEntry) {
        s_registries.add(0, dBTypeDisplayRegistryEntry);
    }

    public static Icon getFolderIcon(String string) {
        Icon icon = null;
        if (icon != null || string == null) {
            return icon;
        }
        for (DBTypeDisplayRegistryEntry dBTypeDisplayRegistryEntry : s_registries) {
            icon = dBTypeDisplayRegistryEntry.getFolderIcon(string);
            if (icon == null) continue;
            return icon;
        }
        if (DBTypeDisplayRegistry.getNodeIcon(string) != null) {
            icon = new FolderIcon(string);
            s_generatedFolderIcons.put(string, icon);
            return icon;
        }
        return null;
    }

    public static Icon getNodeIcon(String string) {
        Icon icon;
        block1: {
            DBTypeDisplayRegistryEntry dBTypeDisplayRegistryEntry;
            icon = null;
            if (string == null) break block1;
            Iterator<DBTypeDisplayRegistryEntry> iterator = s_registries.iterator();
            while (iterator.hasNext() && (icon = (dBTypeDisplayRegistryEntry = iterator.next()).getNodeIcon(string)) == null) {
            }
        }
        return icon;
    }

    public static Icon getNodeIcon(DBObject dBObject) {
        Icon icon = null;
        if (dBObject instanceof Constraint) {
            icon = DBTypeDisplayRegistry.getNodeIcon(((Constraint)dBObject).getConstraintType());
        } else if (dBObject != null) {
            String string = dBObject.getType();
            if (dBObject instanceof PlSqlSubProgram) {
                PlSqlSubProgram plSqlSubProgram = (PlSqlSubProgram)dBObject;
                if (SwingUtilities.isEventDispatchThread() && DBUtil.needsBuilding((DBObject)plSqlSubProgram, (String)"returnTypeReference")) {
                    String string2 = plSqlSubProgram.getSource();
                    String string3 = "TypeMethod".equals(string) ? "[ { NOT FINAL | <final FINAL> |     NOT OVERRIDING | <over OVERRIDING> |     <notInst  NOT INSTANTIABLE> | INSTANTIABLE }...] <methodType {MEMBER|STATIC|CONSTRUCTOR|MAP MEMBER|ORDER MEMBER}> { PROCEDURE <pname ?> <pparams [(...)]> |   FUNCTION <fname ?> <fparams [(...)]> RETURN <datatype {SELF AS RESULT|?%}> } [EXTERNAL {NAME <extname ?> | VARIABLE NAME <extvarname ?> } ][{DETERMINISTIC|PIPELINED|RESULT_CACHE}...][ {IS|AS} LANGUAGE     { JAVA NAME <javaname ?>     | C [NAME <cname ?>] LIBRARY <clibname ?.>       [AGENT IN ({^)}...) ]       [WITH <ccontext CONTEXT>]       [PARAMETERS ({^)}...) ]     } ]" : "{PROCEDURE <pname ?> <pparams [(...)]>|FUNCTION <fname ?> <fparams [(...)]> RETURN <datatype ?%>}";
                    PlSqlTokenPattern plSqlTokenPattern = new PlSqlTokenPattern(string3);
                    TokenPattern.PatternResult patternResult = plSqlTokenPattern.getResult(string2);
                    string = patternResult != null && patternResult.getNamedMatch("fname") != null ? "FUNCTION" : "PROCEDURE";
                } else {
                    string = ((PlSqlSubProgram)dBObject).getReturnTypeReference() == null ? "PROCEDURE" : "FUNCTION";
                }
            }
            icon = DBTypeDisplayRegistry.getNodeIcon(string);
        }
        return icon;
    }

    public static String getDisplayName(String string) {
        String string2 = null;
        if (string != null) {
            DBTypeDisplayRegistryEntry dBTypeDisplayRegistryEntry;
            Iterator<DBTypeDisplayRegistryEntry> iterator = s_registries.iterator();
            while (iterator.hasNext() && ((string2 = (dBTypeDisplayRegistryEntry = iterator.next()).getDisplayName(string)) == null || string2.equals(string))) {
            }
            if (string2 == null || string2.equals(string)) {
                string2 = DisplayNames.getTypePluralName((String)string);
            }
        }
        return string2;
    }

    public static String getSingularDisplayName(String string) {
        String string2 = null;
        if (string != null) {
            DBTypeDisplayRegistryEntry dBTypeDisplayRegistryEntry;
            Iterator<DBTypeDisplayRegistryEntry> iterator = s_registries.iterator();
            while (iterator.hasNext() && ((string2 = (dBTypeDisplayRegistryEntry = iterator.next()).getSingularDisplayName(string)) == null || string2.equals(string))) {
            }
            if (string2 == null || string2.equals(string)) {
                string2 = DisplayNames.getTypeDisplayName((String)string);
            }
        }
        return string2;
    }

    public static String getNewMenuItemText(String string) {
        String string2 = null;
        if (string != null) {
            DBTypeDisplayRegistryEntry dBTypeDisplayRegistryEntry;
            Iterator<DBTypeDisplayRegistryEntry> iterator = s_registries.iterator();
            while (iterator.hasNext() && (string2 = (dBTypeDisplayRegistryEntry = iterator.next()).getNewMenuItemText(string)) == null) {
            }
            if (string2 == null) {
                string2 = UIBundle.format("NEW_MENU_TEMPLATE", DBTypeDisplayRegistry.getSingularDisplayName(string));
            }
        }
        return string2;
    }

    public static String getDialogTitle(String string, boolean bl, boolean bl2) {
        String string2 = bl ? (bl2 ? "DBOBJECT_EDIT_ERR_TITLE" : "DBOBJECT_EDIT_TITLE") : (bl2 ? "DBOBJECT_CREATE_ERR_TITLE" : "DBOBJECT_CREATE_TITLE");
        String string3 = DBTypeDisplayRegistry.getSingularDisplayName(string);
        return UIBundle.format(string2, string3);
    }

    static {
        DBTypeDisplayRegistry.addDBTypeRegistry(new DefaultDBTypeRegistry());
    }

    private static class FolderIcon
    extends IconWithSmallOverlay {
        public FolderIcon(String string) {
            super(OracleIcons.getIcon((String)"folder.png"), DBTypeDisplayRegistry.getNodeIcon(string));
        }
    }
}

