/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.editor;

import java.awt.Component;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.editor.EditorComponentSetup;
import oracle.bali.inspector.editor.PropertyValueApplier;
import oracle.bali.inspector.editor.PropertyValueApplierUtil;
import oracle.bali.inspector.editor.TextFieldEditorBehavior;

public class TextFieldEditorSetup
extends EditorComponentSetup {
    @Override
    public boolean canConfigure(Component inlineEditor) {
        return inlineEditor instanceof JTextComponent;
    }

    @Override
    public void configure(PropertyEditorFactory2 propertyEditor, PropertyValueApplier applier, Component inlineEditor) {
        if (!this.canConfigure(inlineEditor)) {
            return;
        }
        JTextComponent editor = (JTextComponent)inlineEditor;
        PropertyValueApplierUtil.storePropertyValueApplier(applier, editor);
        this.addPropertyInspectorListeners(propertyEditor, editor);
    }

    private void addPropertyInspectorListeners(PropertyEditorFactory2 propertyEditor, JTextComponent editor) {
        TextFieldEditorBehavior listener = this.textFieldEditorBehavior(propertyEditor, editor);
        TextFieldEditorSetup.addTextFieldBehaviorTo(listener, editor);
        this.addAdditionalListeners(propertyEditor, editor);
    }

    public static void addTextFieldBehaviorTo(TextFieldEditorBehavior behavior, JTextComponent editor) {
        TextFieldEditorSetup.removeCurrentListeners(editor);
        editor.addFocusListener(behavior);
        editor.addKeyListener(behavior);
        Document document = editor.getDocument();
        if (document != null) {
            document.addDocumentListener(behavior);
        }
    }

    protected void addAdditionalListeners(PropertyEditorFactory2 propertyEditor, JTextComponent editor) {
    }

    private static void removeCurrentListeners(JTextComponent editor) {
        ArrayList<TextFieldEditorBehavior> behaviorListeners = new ArrayList<TextFieldEditorBehavior>();
        for (KeyListener l : editor.getKeyListeners()) {
            if (!(l instanceof TextFieldEditorBehavior)) continue;
            behaviorListeners.add((TextFieldEditorBehavior)l);
        }
        if (behaviorListeners.isEmpty()) {
            return;
        }
        for (TextFieldEditorBehavior l : behaviorListeners) {
            editor.removeFocusListener(l);
            editor.removeKeyListener(l);
            Document document = editor.getDocument();
            if (document == null) continue;
            document.removeDocumentListener(l);
        }
    }

    protected TextFieldEditorBehavior textFieldEditorBehavior(PropertyEditorFactory2 propertyEditor, JTextComponent editor) {
        return new TextFieldEditorBehavior(editor, propertyEditor);
    }
}

