/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.beans;

import java.beans.IndexedPropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.beans.AbstractPropertyEditorFactory;
import oracle.bali.share.util.IntegerUtils;

class IndexedPropertyEditorFactory
extends AbstractPropertyEditorFactory {
    private int _index;
    private IndexedPropertyDescriptor _descriptor;

    public IndexedPropertyEditorFactory(Object target, IndexedPropertyDescriptor descriptor, int index) {
        super(target);
        this._index = index;
        this._descriptor = descriptor;
    }

    public int getIndex() {
        return this._index;
    }

    public IndexedPropertyDescriptor getIndexedPropertyDescriptor() {
        return this._descriptor;
    }

    @Override
    public String getDisplayName() {
        return Integer.toString(this.getIndex());
    }

    @Override
    public String getName() {
        return this.getIndexedPropertyDescriptor().getName();
    }

    @Override
    public String getShortDescription() {
        return this.getIndexedPropertyDescriptor().getShortDescription();
    }

    @Override
    public boolean setValue(Object newValue) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        boolean changed = this.getCachedValue() != newValue;
        Method writeMethod = this.getIndexedPropertyDescriptor().getIndexedWriteMethod();
        if (writeMethod != null) {
            writeMethod.invoke(this.getTarget(), IntegerUtils.getInteger((int)this.getIndex()), newValue);
            this.setCachedValue(newValue);
            this.setCachedDisplayValue(INVALID_PROPERTY);
        }
        return changed;
    }

    @Override
    public Object getValue(Object target) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object cachedValue = this.getCachedValue();
        if (cachedValue == INVALID_PROPERTY) {
            Method readMethod = this.getIndexedPropertyDescriptor().getIndexedReadMethod();
            if (readMethod != null) {
                Integer i = IntegerUtils.getInteger((int)this.getIndex());
                cachedValue = readMethod.invoke(target, i);
            } else {
                cachedValue = PropertyModel.DOES_NOT_EXIST;
            }
            this.setCachedValue(cachedValue);
        }
        return cachedValue;
    }

    @Override
    public boolean isReadable() {
        return this.getIndexedPropertyDescriptor().getIndexedReadMethod() != null;
    }

    @Override
    public boolean isWritable() {
        return this.getIndexedPropertyDescriptor().getIndexedWriteMethod() != null;
    }

    @Override
    protected Object createPropertyID() {
        return new Object();
    }

    @Override
    public Class getType() {
        return this.getIndexedPropertyDescriptor().getIndexedPropertyType();
    }
}

