/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.beans;

import java.awt.Component;
import java.beans.PropertyEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.beans.AbstractPropertyEditorFactory;
import oracle.bali.inspector.beans.BorderlessTextField;

class BeansPropertyEditorValueEditor
extends DefaultCellEditor {
    private PropertyEditor _editor;
    private JTable _table;
    private int _row;
    private static TableCellEditor _sTextInstance;

    private BeansPropertyEditorValueEditor() {
        super(new BorderlessTextField());
    }

    public static TableCellEditor getTextFieldEditor() {
        if (_sTextInstance == null) {
            _sTextInstance = new BeansPropertyEditorValueEditor();
        }
        return _sTextInstance;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this._editor = BeansPropertyEditorValueEditor._getEditor(table, row);
        this._table = table;
        this._row = row;
        if (this._editor != null) {
            this._editor.setValue(value);
            value = this._editor.getAsText();
        }
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public boolean stopCellEditing() {
        if (this._editor != null) {
            try {
                this._editor.setAsText((String)super.getCellEditorValue());
            }
            catch (Exception e) {
                return false;
            }
        }
        return super.stopCellEditing();
    }

    @Override
    public Object getCellEditorValue() {
        if (this._editor != null) {
            this._editor.setAsText((String)super.getCellEditorValue());
            return this._editor.getValue();
        }
        return super.getCellEditorValue();
    }

    private static PropertyEditor _getEditor(JTable table, int row) {
        PropertyModel m = (PropertyModel)table.getModel();
        PropertyEditorFactory f = m.getPropertyEditorFactory(row);
        if (f instanceof AbstractPropertyEditorFactory) {
            return ((AbstractPropertyEditorFactory)f).__getPropertyEditor();
        }
        return null;
    }
}

