/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.beans;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditor;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.beans.AbstractPropertyEditorFactory;

class BeansPropertyEditorRenderer
extends DefaultTableCellRenderer {
    private PropertyEditor _editor;
    private static final TableCellRenderer _INSTANCE = new BeansPropertyEditorRenderer();

    private BeansPropertyEditorRenderer() {
    }

    public static TableCellRenderer getTableCellRenderer() {
        return _INSTANCE;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        PropertyModel model = (PropertyModel)table.getModel();
        PropertyEditorFactory editorFactory = model.getPropertyEditorFactory(row);
        this._editor = editorFactory instanceof AbstractPropertyEditorFactory ? ((AbstractPropertyEditorFactory)editorFactory).__getPropertyEditor() : null;
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.setValue(null);
        Rectangle r = this.getBounds();
        r.x = 0;
        r.y = 0;
        Color c = g.getColor();
        g.setColor(this.getBackground());
        g.fillRect(r.x, r.y, r.width, r.height);
        g.setColor(c);
        super.paintComponent(g);
        if (this._editor != null) {
            this._editor.paintValue(g, r);
        }
    }
}

