/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.beans;

import java.awt.Color;
import java.awt.Font;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import oracle.bali.ewt.graphics.FontUtils;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.beans.AbstractPropertyEditorFactory;
import oracle.bali.inspector.beans.ArrayPropertyEditorFactory;
import oracle.bali.inspector.beans.BeansGroupProvider;
import oracle.bali.inspector.beans.BeansPropertyEditorFactory;
import oracle.bali.inspector.beans.DefaultBeansGroupProvider;
import oracle.bali.inspector.beans.FieldPropertyEditorFactory;
import oracle.bali.inspector.beans.IndexedModel;
import oracle.bali.share.beans.JavaIntrospector;
import oracle.bali.share.util.IntegerUtils;

@Deprecated
public class BeansModel
extends PropertyModel {
    public static final int INDEX_COLUMN_ID = 0;
    public static final int INDEX_COLUMN_IS_DRILLABLE = 1;
    public static final int INDEX_COLUMN_EDITOR_FACTORY = 2;
    public static final int INDEX_COLUMN_VALUE = 3;
    public static final int INDEX_COLUMN_DISPLAY_VALUE = 4;
    public static final int INDEX_COLUMN_IS_WRITABLE = 5;
    public static final int INDEX_COLUMN_DISPLAY_NAME = 6;
    public static final int INDEX_COLUMN_VALUE_CLASS = 7;
    public static final int INDEX_COLUMN_IS_READABLE = 8;
    public static final int INDEX_COLUMN_GROUP = 9;
    public static final int INDEX_COLUMN_MODEL = 10;
    public static final int INDEX_COLUMN_DESCRIPTION = 11;
    public static final int INDEX_COLUMN_IS_EXPERT = 12;
    public static final int INDEX_COLUMN_IS_HIDDEN = 13;
    public static final int INDEX_COLUMN_NAME = 14;
    private static final Object[] _COLUMNS = new Object[]{PropertyModel.COLUMN_ID, PropertyModel.COLUMN_IS_DRILLABLE, PropertyModel.COLUMN_EDITOR_FACTORY, PropertyModel.COLUMN_VALUE, PropertyModel.COLUMN_DISPLAY_VALUE, PropertyModel.COLUMN_IS_WRITABLE, PropertyModel.COLUMN_DISPLAY_NAME, PropertyModel.COLUMN_VALUE_CLASS, PropertyModel.COLUMN_IS_READABLE, PropertyModel.COLUMN_GROUP, PropertyModel.COLUMN_MODEL, PropertyModel.COLUMN_DESCRIPTION, PropertyModel.COLUMN_IS_EXPERT, PropertyModel.COLUMN_IS_HIDDEN, PropertyModel.COLUMN_NAME};
    private static final String _RESOURCE_BUNDLE = "oracle.bali.inspector.resource.InspectorBundle";
    private static final Hashtable _sNameDescriptions = BeansModel._createNameDescriptions();
    private Object _target;
    private transient Hashtable _propertyHashtable;
    private transient BeanInfo _beanInfo;
    private transient AbstractPropertyEditorFactory[] _descriptors;
    private transient PropertyModel[] _models;
    private BeansModel _parentModel;
    private int _index;
    private BeansGroupProvider _groupProvider;
    private boolean _displayFields;
    private boolean _displayIndexedProperties;
    private boolean _displayArrays;
    private boolean _allowRecursion;
    private PropertyChangeListener _listener;

    public BeansModel(Object target) {
        if (target == null) {
            throw new IllegalArgumentException();
        }
        this._displayFields = true;
        this._displayArrays = true;
        this._displayIndexedProperties = true;
        this._allowRecursion = true;
        this._target = target;
        Class<?> targetClass = target.getClass();
        try {
            this._beanInfo = this.getBeanInfo(targetClass);
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        try {
            Class[] parameters = new Class[]{PropertyChangeListener.class};
            Method addChangeListener = targetClass.getMethod("addPropertyChangeListener", parameters);
            this._listener = new Listener();
            addChangeListener.invoke(target, this._listener);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected BeansModel(Object target, BeansModel parentModel, int index) {
        this(target);
        this._parentModel = parentModel;
        this._index = index;
    }

    public Object getTarget() {
        return this._target;
    }

    public BeansGroupProvider getGroupProvider() {
        if (this._groupProvider == null) {
            this._groupProvider = new DefaultBeansGroupProvider();
        }
        return this._groupProvider;
    }

    public void setGroupProvider(BeansGroupProvider provider) {
        if (this._groupProvider != provider) {
            this._groupProvider = provider;
            this.fireTableDataChanged();
        }
    }

    public void setDisplayFields(boolean displayFields) {
        if (this._displayFields != displayFields) {
            int oldCount;
            int n = oldCount = this._descriptors == null ? -1 : this.getRowCount();
            if (this._models != null) {
                int count = this._models.length;
                for (int i = 0; i < count; ++i) {
                    if (!(this._models[i] instanceof BeansModel)) continue;
                    ((BeansModel)this._models[i]).setDisplayFields(displayFields);
                }
            }
            this._displayFields = displayFields;
            this._reset(oldCount);
        }
    }

    public boolean isDisplayFields() {
        return this._displayFields;
    }

    public void setDisplayIndexedProperties(boolean displayIndexedProperties) {
        if (this._displayIndexedProperties != displayIndexedProperties) {
            int oldCount;
            int n = oldCount = this._descriptors == null ? -1 : this.getRowCount();
            if (this._models != null) {
                int count = this._models.length;
                for (int i = 0; i < count; ++i) {
                    if (!(this._models[i] instanceof BeansModel)) continue;
                    ((BeansModel)this._models[i]).setDisplayIndexedProperties(displayIndexedProperties);
                }
            }
            this._displayIndexedProperties = displayIndexedProperties;
            this._reset(oldCount);
        }
    }

    public boolean isDisplayIndexedProperties() {
        return this._displayIndexedProperties;
    }

    public void setDisplayArrayProperties(boolean displayArrayProperties) {
        if (this._displayArrays != displayArrayProperties) {
            int oldCount;
            int n = oldCount = this._descriptors == null ? -1 : this.getRowCount();
            if (this._models != null) {
                int count = this._models.length;
                for (int i = 0; i < count; ++i) {
                    if (!(this._models[i] instanceof BeansModel)) continue;
                    ((BeansModel)this._models[i]).setDisplayArrayProperties(displayArrayProperties);
                }
            }
            this._displayArrays = displayArrayProperties;
            this._reset(oldCount);
        }
    }

    public boolean isDisplayArrayProperties() {
        return this._displayArrays;
    }

    public void setRecursionAllowed(boolean allow) {
        if (allow != this.isRecursionAllowed()) {
            int oldCount;
            int n = oldCount = this._descriptors == null ? -1 : this.getRowCount();
            if (this._models != null) {
                int count = this._models.length;
                for (int i = 0; i < count; ++i) {
                    if (!(this._models[i] instanceof BeansModel)) continue;
                    ((BeansModel)this._models[i]).setRecursionAllowed(allow);
                }
            }
            this._allowRecursion = allow;
            this._reset(oldCount);
        }
    }

    public boolean isRecursionAllowed() {
        return this._allowRecursion;
    }

    @Override
    public String getTargetDisplayName() {
        Object target = this._target;
        if (target != null) {
            Method nameGetter = null;
            String objectName = null;
            try {
                nameGetter = target.getClass().getMethod("getName", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (nameGetter != null) {
                try {
                    objectName = (String)nameGetter.invoke(target, (Object[])null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (objectName == null && this._beanInfo != null) {
                objectName = this._beanInfo.getBeanDescriptor().getName();
            }
            return objectName;
        }
        return null;
    }

    @Override
    public Object[] getColumnMapping() {
        return _COLUMNS;
    }

    @Override
    public int getColumnCount() {
        return _COLUMNS.length;
    }

    @Override
    public int getRowCount() {
        AbstractPropertyEditorFactory[] factories = this._getDescriptors();
        return factories != null ? factories.length : 0;
    }

    @Override
    public Enumeration getPropertyIDs() {
        return this._getPropertyHashTable().keys();
    }

    @Override
    public void invalidateValueData() {
        AbstractPropertyEditorFactory[] descriptors = this._getDescriptors();
        int numDescriptors = descriptors == null ? 0 : descriptors.length;
        for (int i = 0; i < numDescriptors; ++i) {
            descriptors[i].invalidateCachedValues();
            if (this._models == null || this._models[i] == null) continue;
            this._models[i].invalidateValueData();
        }
        TableModelEvent event = new TableModelEvent(this, 0, this.getRowCount() - 1, 3);
        this.fireTableChanged(event);
    }

    @Override
    public void setPropertyByID(int columnIndex, Object propertyID, Object data) throws Exception {
        Integer rowIndex = (Integer)this._getPropertyHashTable().get(propertyID);
        if (rowIndex != null) {
            this.setValueAt(data, rowIndex, columnIndex);
        }
    }

    @Override
    public Object getPropertyByID(int columnIndex, Object propertyID) {
        Integer rowIndex = (Integer)this._getPropertyHashTable().get(propertyID);
        if (rowIndex != null) {
            return this.getValueAt(rowIndex, columnIndex);
        }
        return PropertyModel.DOES_NOT_EXIST;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        AbstractPropertyEditorFactory beansDescriptor = this._getDescriptor(rowIndex);
        if (beansDescriptor != null) {
            switch (columnIndex) {
                case 2: {
                    return beansDescriptor.getPropertyEditorFactory();
                }
                case 3: {
                    return this._getPropertyValue(beansDescriptor);
                }
                case 4: {
                    return this._getPropertyDisplayValue(beansDescriptor);
                }
                case 5: {
                    boolean writable = beansDescriptor.isWritable();
                    if (!writable && this._parentModel != null && !(beansDescriptor instanceof FieldPropertyEditorFactory)) {
                        writable = this.isPropertyWritable(beansDescriptor.getName(), this._parentModel, this._index);
                    }
                    return writable ? Boolean.TRUE : Boolean.FALSE;
                }
                case 6: {
                    return beansDescriptor.getDisplayName();
                }
                case 7: {
                    return beansDescriptor.getType();
                }
                case 8: {
                    return beansDescriptor.isReadable() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 0: {
                    return beansDescriptor.getPropertyID();
                }
                case 9: {
                    return this.getGroupProvider().getGroup(beansDescriptor.getName(), beansDescriptor.getType());
                }
                case 10: {
                    return this._getModel(rowIndex);
                }
                case 1: {
                    return this._isDrillable(rowIndex) ? Boolean.TRUE : Boolean.FALSE;
                }
                case 11: {
                    Object key;
                    String description = null;
                    String beansName = beansDescriptor.getName();
                    Object v0 = key = beansName == null ? null : _sNameDescriptions.get(beansName);
                    if (key != null) {
                        description = this._getTranslatedString(key);
                    }
                    if (description == null) {
                        description = beansDescriptor.getShortDescription();
                    }
                    return description;
                }
                case 12: {
                    return beansDescriptor.isExpert() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 13: {
                    return beansDescriptor.isHidden() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 14: {
                    return beansDescriptor.getName();
                }
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object data, int rowIndex, int columnIndex) {
        if (columnIndex == 3) {
            boolean changed = false;
            AbstractPropertyEditorFactory descriptor = this._getDescriptor(rowIndex);
            try {
                changed = this._parentModel != null && !descriptor.isWritable() ? this.setImmutableValue(descriptor.getName(), data, this._parentModel, this._index) : descriptor.setValue(data);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable th) {
                String dataString = data != null ? data.toString() : null;
                this.throwIllegalArgumentException(th, descriptor.getName(), dataString);
            }
            if (changed) {
                this._fireRowValueInvalidate(rowIndex);
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        try {
            Class<?> targetClass = this.getTarget().getClass();
            Class[] parameters = new Class[]{PropertyChangeListener.class};
            Method removeChangeListener = targetClass.getMethod("removePropertyChangeListener", parameters);
            removeChangeListener.invoke(this.getTarget(), this._listener);
        }
        catch (Exception targetClass) {
            // empty catch block
        }
        this._listener = null;
        this._descriptors = null;
        if (this._models != null) {
            for (int i = 0; i < this._models.length; ++i) {
                if (this._models[i] == null) continue;
                this._models[i].dispose();
            }
        }
        this._models = null;
        this._parentModel = null;
    }

    protected BeanInfo getBeanInfo(Class beanClass) throws IntrospectionException {
        return JavaIntrospector.getBeanInfo((Class)beanClass);
    }

    protected boolean setImmutableValue(String propertyName, Object newValue, BeansModel parentModel, int index) throws Exception {
        boolean changed;
        Class type = (Class)parentModel.getValueAt(index, 7);
        Object oldValue = parentModel.getPropertyValue(index);
        if (type == Color.class) {
            int i = (Integer)newValue;
            if ("RGB".equals(propertyName)) {
                newValue = new Color(i);
            } else {
                Color c = (Color)oldValue;
                if (c == null) {
                    c = Color.white;
                }
                if ("red".equals(propertyName)) {
                    newValue = new Color(i, c.getGreen(), c.getBlue());
                } else if ("green".equals(propertyName)) {
                    newValue = new Color(c.getRed(), i, c.getBlue());
                } else if ("blue".equals(propertyName)) {
                    newValue = new Color(c.getRed(), c.getGreen(), i);
                }
            }
        } else if (type == Font.class) {
            Font f = (Font)oldValue;
            if (f == null) {
                f = FontUtils.getDefaultDialogFont();
            }
            if ("name".equals(propertyName)) {
                String s = newValue.toString();
                newValue = new Font(s, f.getStyle(), f.getSize());
            } else if ("bold".equals(propertyName)) {
                boolean bold = Boolean.TRUE.equals(newValue);
                int style = 0;
                if (f.isPlain()) {
                    style |= 0;
                }
                if (f.isItalic()) {
                    style |= 2;
                }
                if (bold) {
                    style |= 1;
                }
                newValue = new Font(f.getName(), style, f.getSize());
            } else if ("plain".equals(propertyName)) {
                boolean plain = Boolean.TRUE.equals(newValue);
                int style = 0;
                if (plain) {
                    style |= 0;
                }
                if (f.isItalic()) {
                    style |= 2;
                }
                if (f.isBold()) {
                    style |= 1;
                }
                newValue = new Font(f.getName(), style, f.getSize());
            } else if ("italic".equals(propertyName)) {
                boolean italic = Boolean.TRUE.equals(newValue);
                int style = 0;
                if (f.isPlain()) {
                    style |= 0;
                }
                if (italic) {
                    style |= 2;
                }
                if (f.isBold()) {
                    style |= 1;
                }
                newValue = new Font(f.getName(), style, f.getSize());
            } else if ("size".equals(propertyName)) {
                Integer i = (Integer)newValue;
                newValue = new Font(f.getName(), f.getStyle(), i);
            } else if ("style".equals(propertyName)) {
                Integer i = (Integer)newValue;
                newValue = new Font(f.getName(), (int)i, f.getSize());
            } else if ("family".equals(propertyName)) {
                // empty if block
            }
        }
        boolean bl = changed = oldValue != newValue;
        if (changed) {
            parentModel.setValueAt(newValue, index, 3);
        }
        return changed;
    }

    protected boolean isPropertyWritable(String propertyName, BeansModel parentModel, int index) {
        boolean writable = Boolean.TRUE.equals(parentModel.getValueAt(index, 5));
        if (writable) {
            writable = false;
            Class type = (Class)parentModel.getValueAt(index, 7);
            if (type == Font.class) {
                if ("name".equals(propertyName) || "bold".equals(propertyName) || "italic".equals(propertyName) || "size".equals(propertyName)) {
                    writable = true;
                }
            } else if (type == Color.class && ("red".equals(propertyName) || "green".equals(propertyName) || "blue".equals(propertyName))) {
                writable = true;
            }
        }
        return writable;
    }

    protected BeansModel createBeansModel(Object target, BeansModel parentModel, int index) {
        return new BeansModel(target, parentModel, index);
    }

    protected final PropertyEditor getPropertyEditor(int row) {
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        AbstractPropertyEditorFactory f = this._getDescriptor(row);
        return f == null ? null : f.__getPropertyEditor();
    }

    AbstractPropertyEditorFactory[] createDescriptors() {
        AbstractPropertyEditorFactory[] instanceDescriptors;
        block8: {
            int i;
            BeanInfo beanInfo;
            PropertyDescriptor[] descriptors;
            int descriptorLength;
            int fieldLength;
            int numProperties;
            Class<?> targetClass;
            block6: {
                block7: {
                    instanceDescriptors = null;
                    Object target = this.getTarget();
                    targetClass = target.getClass();
                    if (!targetClass.isArray()) break block6;
                    if (!this.isDisplayArrayProperties()) break block7;
                    int itemCount = Array.getLength(this.getTarget());
                    instanceDescriptors = new AbstractPropertyEditorFactory[itemCount];
                    for (int i2 = 0; i2 < itemCount; ++i2) {
                        instanceDescriptors[i2] = new ArrayPropertyEditorFactory(this.getTarget(), i2);
                    }
                    break block8;
                }
                return new AbstractPropertyEditorFactory[0];
            }
            boolean displayFields = this.isDisplayFields();
            Field[] fields = null;
            if (displayFields) {
                try {
                    fields = targetClass.getFields();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            if ((numProperties = (fieldLength = fields == null ? 0 : fields.length) + (descriptorLength = (descriptors = (beanInfo = this._beanInfo) == null ? null : this._filterProperties(beanInfo.getPropertyDescriptors())) == null ? 0 : descriptors.length)) <= 0) break block8;
            instanceDescriptors = new AbstractPropertyEditorFactory[numProperties];
            for (i = 0; i < descriptorLength; ++i) {
                PropertyDescriptor currDescriptor = descriptors[i];
                instanceDescriptors[i] = new BeansPropertyEditorFactory(this._target, currDescriptor);
            }
            for (i = 0; i < fieldLength; ++i) {
                Field field = fields[i];
                instanceDescriptors[i + descriptorLength] = new FieldPropertyEditorFactory(this._target, field);
            }
        }
        return instanceDescriptors;
    }

    private PropertyDescriptor[] _filterProperties(PropertyDescriptor[] descriptors) {
        int filteredCount = descriptors.length;
        Vector<PropertyDescriptor> v = new Vector<PropertyDescriptor>(filteredCount);
        for (int i = 0; i < filteredCount; ++i) {
            PropertyDescriptor pd = descriptors[i];
            if (pd instanceof IndexedPropertyDescriptor) {
                if (!this.isDisplayIndexedProperties()) continue;
                v.add(pd);
                continue;
            }
            if (pd.getPropertyType().isArray()) {
                if (!this.isDisplayArrayProperties()) continue;
                v.add(pd);
                continue;
            }
            if (!this.isRecursionAllowed()) {
                if (this._parentModel != null) {
                    Object c;
                    Object name = this._parentModel.getValueAt(this._index, 14);
                    if (name != null && name.equals(pd.getName()) && (c = this._parentModel.getValueAt(this._index, 7)) == pd.getPropertyType()) continue;
                    v.add(pd);
                    continue;
                }
                v.add(pd);
                continue;
            }
            v.add(pd);
        }
        descriptors = new PropertyDescriptor[v.size()];
        v.copyInto(descriptors);
        return descriptors;
    }

    private void _reset(int oldCount) {
        if (oldCount == -1) {
            return;
        }
        this._descriptors = null;
        this._propertyHashtable = null;
        int newCount = this.getRowCount();
        int diff = newCount - oldCount;
        if (diff > 0) {
            this.fireTableRowsInserted(0, diff - 1);
        } else if (diff < 0) {
            this.fireTableRowsDeleted(0, -diff - 1);
        }
        this.fireTableRowsUpdated(0, newCount - 1);
    }

    private Hashtable _getPropertyHashTable() {
        if (this._propertyHashtable == null) {
            Hashtable<Object, Integer> propertyTable = new Hashtable<Object, Integer>();
            AbstractPropertyEditorFactory[] descriptors = this._getDescriptors();
            int numProperties = descriptors == null ? 0 : descriptors.length;
            for (int i = 0; i < numProperties; ++i) {
                propertyTable.put(descriptors[i].getPropertyID(), IntegerUtils.getInteger((int)i));
            }
            this._propertyHashtable = propertyTable;
        }
        return this._propertyHashtable;
    }

    private AbstractPropertyEditorFactory _getDescriptor(int rowIndex) {
        int count = this.getRowCount();
        if (count <= 0 || rowIndex >= count) {
            return null;
        }
        AbstractPropertyEditorFactory[] descriptors = this._getDescriptors();
        return descriptors[rowIndex];
    }

    private AbstractPropertyEditorFactory[] _getDescriptors() {
        if (this._descriptors == null) {
            this._descriptors = this.createDescriptors();
        }
        return this._descriptors;
    }

    private PropertyModel _getModel(int rowIndex) {
        int count = this.getRowCount();
        if (count == 0) {
            return null;
        }
        if (this._models == null) {
            this._models = new PropertyModel[count];
        }
        if (this._models[rowIndex] == null) {
            try {
                AbstractPropertyEditorFactory factory = this._getDescriptor(rowIndex);
                if (factory instanceof BeansPropertyEditorFactory && ((BeansPropertyEditorFactory)factory).getPropertyDescriptor() instanceof IndexedPropertyDescriptor) {
                    BeansPropertyEditorFactory bpfe = (BeansPropertyEditorFactory)factory;
                    IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)bpfe.getPropertyDescriptor();
                    this._models[rowIndex] = new IndexedModel(this.getTarget(), ipd);
                } else {
                    Object data = this._getPropertyValue(factory);
                    if (data != DOES_NOT_EXIST) {
                        BeansModel bm = this.createBeansModel(data, this, rowIndex);
                        bm.setDisplayFields(this.isDisplayFields());
                        bm.setDisplayArrayProperties(this.isDisplayArrayProperties());
                        bm.setDisplayIndexedProperties(this.isDisplayIndexedProperties());
                        bm.setRecursionAllowed(this.isRecursionAllowed());
                        this._models[rowIndex] = bm;
                    }
                }
            }
            catch (Exception e) {
                this._models[rowIndex] = null;
            }
        }
        return this._models[rowIndex];
    }

    static int __getIndexedPropertyCount(Object target, IndexedPropertyDescriptor ipd, BeansModel model) {
        Class<?> type = target.getClass();
        String propertyName = ipd.getName();
        String capitalizedName = propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        String methodName = "get" + capitalizedName + "Count";
        Method getCount = null;
        Object count = null;
        boolean tryArray = false;
        try {
            if (model.isDisplayIndexedProperties()) {
                getCount = type.getMethod(methodName, null);
                count = getCount == null ? null : getCount.invoke(target, (Object[])null);
            }
        }
        catch (Exception e) {
            tryArray = true;
        }
        if ((tryArray || count == null) && model.isDisplayArrayProperties()) {
            boolean isArray;
            Class<?> propertyType = ipd.getPropertyType();
            boolean bl = isArray = propertyType == null ? false : propertyType.isArray();
            if (isArray) {
                methodName = "get" + capitalizedName;
                try {
                    Method getArray = type.getMethod(methodName, null);
                    Object array = getArray.invoke(target, (Object[])null);
                    if (array != null) {
                        count = Array.getLength(array);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return count instanceof Integer ? (Integer)count : 0;
    }

    private boolean _isDrillable(int rowIndex) {
        boolean isArray;
        AbstractPropertyEditorFactory apef = this._getDescriptor(rowIndex);
        if (apef == null) {
            return false;
        }
        if (!this.isRecursionAllowed() && this.getTarget().getClass() == apef.getType()) {
            return false;
        }
        if (apef instanceof BeansPropertyEditorFactory && ((BeansPropertyEditorFactory)apef).getPropertyDescriptor() instanceof IndexedPropertyDescriptor) {
            BeansPropertyEditorFactory bpfe = (BeansPropertyEditorFactory)apef;
            IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)bpfe.getPropertyDescriptor();
            int count = BeansModel.__getIndexedPropertyCount(this.getTarget(), ipd, this);
            return count != 0;
        }
        Class type = apef.getType();
        boolean bl = isArray = type == null ? false : type.isArray();
        if (isArray) {
            Object target = this._getPropertyValue(apef);
            return target == PropertyModel.DOES_NOT_EXIST ? false : Array.getLength(target) != 0;
        }
        BeanInfo beanInfo = null;
        try {
            beanInfo = this.getBeanInfo(type);
            if (beanInfo == null) {
                return false;
            }
        }
        catch (IntrospectionException ie) {
            return false;
        }
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null || descriptors.length == 0) {
            return false;
        }
        return this._getModel(rowIndex) != null;
    }

    private Object _getPropertyValue(AbstractPropertyEditorFactory factory) {
        try {
            return factory.getValue(this._target);
        }
        catch (Exception e) {
            return PropertyModel.DOES_NOT_EXIST;
        }
    }

    private Object _getPropertyDisplayValue(AbstractPropertyEditorFactory factory) {
        try {
            return factory.getDisplayValue();
        }
        catch (Exception e) {
            return PropertyModel.DOES_NOT_EXIST;
        }
    }

    private void _fireRowValueInvalidate(int rowIndex) {
        this.fireTableCellUpdated(rowIndex, 3);
        if (this._models != null && this._models[rowIndex] != null) {
            this._models[rowIndex] = null;
            this.fireTableCellUpdated(rowIndex, 10);
        }
    }

    private String _getTranslatedString(String key) {
        String s = null;
        if (key != null) {
            ResourceBundle b = ResourceBundle.getBundle(_RESOURCE_BUNDLE, this.getLocale());
            s = b.getString(key);
        }
        return s;
    }

    private static Hashtable _createNameDescriptions() {
        Hashtable<String, String> descriptions = new Hashtable<String, String>();
        descriptions.put("background", "DESCRIPTION_BACKGROUND");
        descriptions.put("enabled", "DESCRIPTION_ENABLED");
        descriptions.put("font", "DESCRIPTION_FONT");
        descriptions.put("foreground", "DESCRIPTION_FOREGROUND");
        descriptions.put("name", "DESCRIPTION_NAME");
        descriptions.put("text", "DESCRIPTION_TEXT");
        descriptions.put("visible", "DESCRIPTION_VISIBLE");
        return descriptions;
    }

    private class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent changeEvent) {
            int numDescriptors;
            String changedProperty = changeEvent.getPropertyName();
            AbstractPropertyEditorFactory[] descriptors = BeansModel.this._getDescriptors();
            int n = numDescriptors = descriptors == null ? 0 : descriptors.length;
            if (changedProperty != null) {
                for (int i = 0; i < numDescriptors; ++i) {
                    AbstractPropertyEditorFactory currDescriptor = descriptors[i];
                    if (!currDescriptor.getName().equals(changedProperty) || !currDescriptor.updateValueIfNecessary(changeEvent.getNewValue())) continue;
                    BeansModel.this._fireRowValueInvalidate(i);
                }
            } else {
                BeansModel.this.invalidateValueData();
            }
        }
    }
}

