/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class TableResizer
extends MouseAdapter
implements MouseMotionListener {
    private static final int _TARGET = 5;
    private static final int _MIN_SIZE = 2;
    private int _resizeItem = -1;
    private boolean _dragged;
    private JTable _table;

    public TableResizer(JTable table) {
        this._table = table;
        this._table.addMouseListener(this);
        this._table.addMouseMotionListener(this);
    }

    public void dispose() {
        this._table.removeMouseListener(this);
        this._table.removeMouseMotionListener(this);
        this._table = null;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        JTable table = this._table;
        if (e.isConsumed() || !table.isEnabled()) {
            return;
        }
        Point point = new Point(e.getX(), e.getY());
        int column = table.columnAtPoint(point);
        int row = table.rowAtPoint(point);
        if (column < 0 || row < 0) {
            return;
        }
        if (TableResizer._isResizing(table, column, row, e.getX(), e.getY()) != -1) {
            table.setCursor(this._getResizeCursor());
            e.consume();
        } else {
            table.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        JTable table = this._table;
        if (e.isConsumed() || !table.isEnabled()) {
            return;
        }
        boolean left = SwingUtilities.isLeftMouseButton(e);
        if (!left) {
            return;
        }
        Point point = new Point(e.getX(), e.getY());
        int column = table.columnAtPoint(point);
        int row = table.rowAtPoint(point);
        if (column < 0 || row < 0) {
            return;
        }
        this._resizeItem = TableResizer._isResizing(table, column, row, e.getX(), e.getY());
        if (this._resizeItem != -1) {
            if (e.getClickCount() == 2) {
                int col = 0;
                int rowCount = table.getRowCount();
                int width = 0;
                int margin = table.getColumnModel().getColumnMargin() * 2;
                for (int i = 0; i < rowCount; ++i) {
                    TableCellRenderer tcr = table.getCellRenderer(i, col);
                    Component c = table.prepareRenderer(tcr, i, col);
                    Dimension d = c.getPreferredSize();
                    if (d.width + margin <= width) continue;
                    width = d.width + margin + 1;
                }
                this._setWidth(table.getColumnModel().getColumn(col), width);
            } else {
                this._dragged = false;
                table.setCursor(this._getResizeCursor());
                if (table.getCellEditor() != null) {
                    table.getCellEditor().stopCellEditing();
                }
                e.consume();
            }
        } else {
            table.setCursor(Cursor.getDefaultCursor());
            this._resizeItem = -1;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (this._resizeItem != -1) {
            this._dragged = true;
            this._setSize(e, false);
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (this._resizeItem != -1) {
            if (this._dragged) {
                this._setSize(e, true);
            }
            this._table.setCursor(Cursor.getDefaultCursor());
            e.consume();
        }
        this._resizeItem = -1;
        this._dragged = false;
    }

    private static int _isResizing(JTable table, int column, int row, int x, int y) {
        int toRet = -1;
        if ((x -= TableResizer._getColumnPosition(table, column)) >= 0 && x <= 5) {
            toRet = column - 1;
        } else {
            TableColumn tc = table.getColumnModel().getColumn(column);
            int width = tc.getWidth();
            if (x >= width - 5 && x <= width) {
                toRet = column;
            }
        }
        if (toRet == -1) {
            return -1;
        }
        if (toRet == table.getColumnCount() - 1) {
            return -1;
        }
        return toRet;
    }

    private static int _getColumnPosition(JTable table, int column) {
        TableColumnModel model = table.getColumnModel();
        int margin = model.getColumnMargin();
        int x = 0;
        for (int i = 0; i < column; ++i) {
            x += model.getColumn(i).getWidth() + margin;
        }
        return x;
    }

    private void _setSize(MouseEvent e, boolean finish) {
        JTable table = this._table;
        TableColumnModel model = table.getColumnModel();
        TableColumn column = model.getColumn(this._resizeItem);
        int x = e.getX() - TableResizer._getColumnPosition(this._table, this._resizeItem);
        if (x > table.getWidth() - 10) {
            x = table.getWidth() - 10;
        }
        this._setWidth(column, x);
    }

    private void _setWidth(TableColumn column, int x) {
        JTable table = this._table;
        TableColumnModel model = table.getColumnModel();
        int diff = x - column.getWidth();
        column.setWidth(x);
        column.setPreferredWidth(x);
        int lastColumnIndex = model.getColumnCount() - 1;
        TableColumn lastColumn = model.getColumn(lastColumnIndex);
        int newSize = lastColumn.getWidth() - diff;
        lastColumn.setWidth(newSize);
        lastColumn.setPreferredWidth(newSize);
        table.revalidate();
        table.repaint();
    }

    private Cursor _getResizeCursor() {
        return Cursor.getPredefinedCursor(10);
    }
}

