/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.lang.ref.WeakReference;
import javax.swing.JCheckBox;
import javax.swing.text.JTextComponent;
import oracle.bali.inspector.CustomEditorAction;
import oracle.bali.inspector.InspectorPropertyEditor;
import oracle.bali.inspector.JavaBeansEditorComponentInfo;
import oracle.bali.inspector.editor.EditorComponentInfo;
import oracle.bali.inspector.editor.PropertyValueApplier;
import oracle.bali.inspector.editor.TextFieldEditor;
import oracle.bali.inspector.editor.ToStringConverter;

public class JavaBeansPropertyEditorAdapter
extends InspectorPropertyEditor {
    private final PropertyEditor _editor;
    private Component _component;
    private ToStringConverter selectedItemToStringConverter;
    private PropertyChangeListener propertyChangeListener;

    public JavaBeansPropertyEditorAdapter(PropertyEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("PropertyEditor should not be null");
        }
        this._editor = editor;
        this.propertyChangeListener = new PropertyChangeListenerImpl(this);
        this._editor.addPropertyChangeListener(this.propertyChangeListener);
        this.setEditorComponentInfo(new JavaBeansEditorComponentInfo(editor));
    }

    public void detachFromProperyEditor() {
        this._editor.removePropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    public void setSelectedItemToStringConverter(ToStringConverter selectedItemToStringConverter) {
        this.selectedItemToStringConverter = selectedItemToStringConverter;
    }

    @Override
    public void setValue(Object value) {
        this._editor.setValue(value);
    }

    @Override
    public Object getValue() {
        return this._editor.getValue();
    }

    @Override
    public String getAsText() {
        return TextFieldEditor.cleanNullText(this._editor.getAsText());
    }

    @Override
    public boolean isPaintable() {
        return this._editor.isPaintable();
    }

    @Override
    public void paintValue(Graphics g, Rectangle r) {
        if (this.isPaintable()) {
            this._editor.paintValue(g, r);
        }
    }

    @Override
    public boolean hasInlineEditor() {
        return this.getAsText() != null;
    }

    @Override
    public Component getInlineEditor(EditorComponentInfo editorComponentInfo, PropertyValueApplier applier) {
        this.updateWithEditor(editorComponentInfo);
        return super.getInlineEditor(editorComponentInfo, applier);
    }

    private void updateWithEditor(EditorComponentInfo editorComponentInfo) {
        if (editorComponentInfo instanceof JavaBeansEditorComponentInfo) {
            JavaBeansEditorComponentInfo info = (JavaBeansEditorComponentInfo)editorComponentInfo;
            info.updateJavaBeansPropertyEditor(this._editor);
        }
    }

    @Override
    public CustomEditorAction customEditorAction() {
        if (!this._editor.supportsCustomEditor()) {
            return null;
        }
        return new CustomEditorAction(this._editor);
    }

    protected PropertyEditor getPropertyEditor() {
        return this._editor;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this._editor.setAsText(text);
    }

    void setComponent(Component component) {
        this._component = component;
    }

    Component getComponent() {
        return this._component;
    }

    @Override
    public ToStringConverter getSelectedItemToStringConverter() {
        return this.selectedItemToStringConverter;
    }

    private static class PropertyChangeListenerImpl
    implements PropertyChangeListener {
        private final WeakReference _adapterReference;
        private PropertyEditor _editorAttachedTo;

        public PropertyChangeListenerImpl(JavaBeansPropertyEditorAdapter adapter) {
            this._adapterReference = new WeakReference<JavaBeansPropertyEditorAdapter>(adapter);
            this._editorAttachedTo = adapter._editor;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            JavaBeansPropertyEditorAdapter adapter = (JavaBeansPropertyEditorAdapter)this._adapterReference.get();
            if (adapter == null) {
                if (this._editorAttachedTo != null) {
                    this._editorAttachedTo.removePropertyChangeListener(this);
                    this._editorAttachedTo = null;
                }
            } else {
                adapter.propertyChangeSupport().firePropertyChange(e);
                this.updateComponentValue(adapter);
            }
        }

        private void updateComponentValue(JavaBeansPropertyEditorAdapter adapter) {
            Component component = adapter._component;
            if (component == null) {
                return;
            }
            if (component instanceof JTextComponent) {
                JTextComponent textField = (JTextComponent)component;
                textField.setText(adapter.getAsText());
                return;
            }
            if (component instanceof JCheckBox) {
                boolean val;
                JCheckBox checkBox = (JCheckBox)component;
                Object o = adapter.getValue();
                if (o instanceof Boolean && (val = ((Boolean)o).booleanValue()) != checkBox.isSelected()) {
                    checkBox.setSelected(val);
                }
            }
        }
    }
}

