/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.util.Enumeration;
import java.util.NoSuchElementException;

class IntVector
implements Cloneable {
    private int[] _elementData;
    private int _elementCount;
    private int _capacityIncrement;

    public IntVector() {
        this(0);
    }

    public IntVector(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public IntVector(int initialCapacity, int capacityIncrement) {
        this._elementData = new int[initialCapacity];
        this._capacityIncrement = capacityIncrement;
    }

    public final synchronized void copyInto(int[] anArray) {
        System.arraycopy(this._elementData, 0, anArray, 0, this._elementCount);
    }

    public final synchronized void trimToSize() {
        int oldCapacity = this._elementData.length;
        if (this._elementCount < oldCapacity) {
            int[] oldData = this._elementData;
            this._elementData = new int[this._elementCount];
            System.arraycopy(oldData, 0, this._elementData, 0, this._elementCount);
        }
    }

    public final synchronized void ensureCapacity(int minCapacity) {
        if (minCapacity > this._elementData.length) {
            this._ensureCapacityHelper(minCapacity);
        }
    }

    public final synchronized void setSize(int newSize) {
        if (newSize > this._elementCount && newSize > this._elementData.length) {
            this._ensureCapacityHelper(newSize);
        }
        this._elementCount = newSize;
    }

    public final int capacity() {
        return this._elementData.length;
    }

    public final int size() {
        return this._elementCount;
    }

    public final boolean isEmpty() {
        return this._elementCount == 0;
    }

    public final synchronized Enumeration elements() {
        return new VectorEnumerator();
    }

    public final boolean contains(int elem) {
        return this.indexOf(elem, 0) >= 0;
    }

    public final int indexOf(int elem) {
        return this.indexOf(elem, 0);
    }

    public final synchronized int indexOf(int elem, int index) {
        for (int i = index; i < this._elementCount; ++i) {
            if (elem != this._elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOf(int elem) {
        return this.lastIndexOf(elem, this._elementCount - 1);
    }

    public final synchronized int lastIndexOf(int elem, int index) {
        for (int i = index; i >= 0; --i) {
            if (elem != this._elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public final synchronized int elementAt(int index) {
        if (index >= this._elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this._elementCount);
        }
        return this._elementData[index];
    }

    public final synchronized int firstElement() {
        if (this._elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this._elementData[0];
    }

    public final synchronized int lastElement() {
        if (this._elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this._elementData[this._elementCount - 1];
    }

    public final synchronized void setElementAt(int obj, int index) {
        if (index >= this._elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this._elementCount);
        }
        this._elementData[index] = obj;
    }

    public final synchronized void removeElementAt(int index) {
        if (index >= this._elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this._elementCount);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int j = this._elementCount - index - 1;
        if (j > 0) {
            System.arraycopy(this._elementData, index + 1, this._elementData, index, j);
        }
        --this._elementCount;
    }

    public final synchronized void insertElementAt(int obj, int index) {
        int newcount = this._elementCount + 1;
        if (index >= newcount) {
            throw new ArrayIndexOutOfBoundsException(index + " > " + this._elementCount);
        }
        if (newcount > this._elementData.length) {
            this._ensureCapacityHelper(newcount);
        }
        System.arraycopy(this._elementData, index, this._elementData, index + 1, this._elementCount - index);
        this._elementData[index] = obj;
        ++this._elementCount;
    }

    public final synchronized void addElement(int obj) {
        int newcount = this._elementCount + 1;
        if (newcount > this._elementData.length) {
            this._ensureCapacityHelper(newcount);
        }
        this._elementData[this._elementCount++] = obj;
    }

    public final synchronized boolean removeElement(int obj) {
        int i = this.indexOf(obj);
        if (i >= 0) {
            this.removeElementAt(i);
            return true;
        }
        return false;
    }

    public final synchronized void removeAllElements() {
        this._elementCount = 0;
    }

    public synchronized Object clone() {
        try {
            IntVector newVector = (IntVector)super.clone();
            newVector._elementData = new int[this._elementCount];
            System.arraycopy(this._elementData, 0, newVector._elementData, 0, this._elementCount);
            return newVector;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public final synchronized String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        Enumeration e = this.elements();
        buf.append("[");
        for (int i = 0; i <= max; ++i) {
            String s = e.nextElement().toString();
            buf.append(s);
            if (i >= max) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    private void _ensureCapacityHelper(int minCapacity) {
        int newCapacity;
        int oldCapacity = this._elementData.length;
        int[] oldData = this._elementData;
        int n = newCapacity = this._capacityIncrement > 0 ? oldCapacity + this._capacityIncrement : oldCapacity * 2;
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        this._elementData = new int[newCapacity];
        System.arraycopy(oldData, 0, this._elementData, 0, this._elementCount);
    }

    private class VectorEnumerator
    implements Enumeration {
        private IntVector _vector;
        private int _count = 0;

        @Override
        public boolean hasMoreElements() {
            return this._count < IntVector.this._elementCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object nextElement() {
            IntVector intVector = IntVector.this;
            synchronized (intVector) {
                if (this._count < IntVector.this._elementCount) {
                    return IntVector.this._elementData[this._count++];
                }
            }
            throw new NoSuchElementException("VectorEnumerator");
        }
    }
}

