/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javacompiler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.JarStorage;

class JavacClassLoader
extends ClassLoader {
    private Storage storage;
    private boolean isOldMacJdk;

    JavacClassLoader(File toolsJarWithJavac, ClassLoader parent) throws Exception {
        super(parent);
        this.storage = new JarStorage(toolsJarWithJavac);
        this.isOldMacJdk = toolsJarWithJavac.getName().equals("classes.jar");
    }

    void release() {
        if (this.storage != null) {
            this.storage.close();
            this.storage = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class loadClass(URL fromUrl, String name) {
        InputStream inputStream = null;
        try {
            URLConnection connection = fromUrl.openConnection();
            inputStream = connection.getInputStream();
            int count = inputStream.available();
            byte[] bytes = new byte[count];
            inputStream.read(bytes, 0, bytes.length);
            Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length);
            return clazz;
        }
        catch (IOException e) {
            Class clazz = null;
            return clazz;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class findJavacClass(String name) throws IOException {
        Class<?> loadedClass = this.findLoadedClass(name);
        if (loadedClass != null) {
            return loadedClass;
        }
        if (name.startsWith("oracle.jdevimpl.javacompiler.")) {
            Class clazz;
            URL url = this.getResource(name.replace('.', '/') + ".class");
            if (url != null && (clazz = this.loadClass(url, name)) != null) {
                return clazz;
            }
        } else {
            boolean tryLoadingClass = true;
            if (this.isOldMacJdk) {
                boolean bl = tryLoadingClass = name.startsWith("com.sun") || name.startsWith("sun");
            }
            if (tryLoadingClass) {
                Storage dirStorage = this.storage;
                String className = name;
                while (true) {
                    int index;
                    Object shortName = (index = className.indexOf(46)) > 0 ? className.substring(0, index) : className + ".class";
                    Storage storage = dirStorage.open((String)shortName);
                    if (index <= 0) {
                        if (storage == null || storage.isDirectory()) break;
                        try {
                            byte[] bytes = storage.read();
                            Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length);
                            return clazz;
                        }
                        finally {
                            storage.close();
                        }
                    }
                    if (storage == null || !storage.isDirectory()) break;
                    dirStorage = storage;
                    className = className.substring(index + 1);
                }
            }
        }
        return null;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.storage != null && !name.startsWith("java.")) {
            try {
                Class found = this.findJavacClass(name);
                if (found != null) {
                    if (resolve) {
                        this.resolveClass(found);
                    }
                    return found;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return super.loadClass(name, resolve);
    }
}

