/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.themes;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import oracle.javatools.ui.internal.StretchIcon;
import oracle.javatools.ui.themes.BufferedImageCachingPainter;
import oracle.javatools.ui.themes.CenteredIconPainter;
import oracle.javatools.ui.themes.EdgePainter;
import oracle.javatools.ui.themes.LinearGradientPainter;
import oracle.javatools.ui.themes.MattePainter;
import oracle.javatools.ui.themes.NullIcon;
import oracle.javatools.ui.themes.NullPainter;
import oracle.javatools.ui.themes.Painter;
import oracle.javatools.ui.themes.StretchIconPainter;
import oracle.javatools.ui.themes.SystemBoolean;
import oracle.javatools.ui.themes.VolatileImageCachingPainter;
import oracle.javatools.util.PlatformUtils;

public final class ThemeProperties {
    static final Logger LOG = Logger.getLogger(ThemeProperties.class.getName());
    private final Properties _properties;
    private final String _partId;
    private final Map _resolvedMap = new HashMap();
    private Map<FontEntry, Font> _fontCache;
    private ClassLoader _classLoader;
    private static final Map<String, PainterBuilder> PAINTER_BUILDERS = new HashMap<String, PainterBuilder>();
    private static final BufferedImage NULL_IMAGE;
    private static final SystemBoolean useVolatileImage;

    ThemeProperties(Properties properties, String partId) {
        this._properties = properties;
        this._partId = partId;
    }

    void setClassLoader(ClassLoader cl) {
        this._classLoader = cl;
    }

    ClassLoader getClassLoader() {
        return this._classLoader;
    }

    private URL getResource(String resource) {
        ClassLoader cl;
        if (resource.length() < 2) {
            return null;
        }
        if (resource.charAt(0) == '/') {
            resource = resource.substring(1);
        }
        if ((cl = this.getClassLoader()) == null) {
            cl = ThemeProperties.class.getClassLoader();
        }
        return cl.getResource(resource);
    }

    public Border getBorder(String id) {
        Border b = (Border)this._resolvedMap.get(id);
        if (b == null) {
            b = this.getBorderImpl(id);
            this._resolvedMap.put(id, b);
        }
        return b;
    }

    private Border getBorderImpl(String id) {
        String value = this.getString(id);
        if (value == null) {
            return BorderFactory.createEmptyBorder();
        }
        int pixelWidth = 0;
        Color color = Color.BLACK;
        StringTokenizer tok = new StringTokenizer(value, " ");
        if (tok.hasMoreTokens()) {
            String widthString = tok.nextToken();
            if ("thin".equals(widthString)) {
                pixelWidth = 1;
            } else if (widthString.endsWith("px")) {
                if (widthString.length() > 2) {
                    try {
                        pixelWidth = Integer.parseInt(widthString.substring(0, widthString.length() - 2));
                    }
                    catch (NumberFormatException ne) {
                        LOG.log(Level.SEVERE, "Invalid border size: " + value + " for " + this.getKeyName(id));
                    }
                } else {
                    LOG.log(Level.SEVERE, "No pixel border size specified for " + this.getKeyName(id));
                }
            }
        }
        if (tok.hasMoreTokens()) {
            String style = tok.nextToken();
            if ("none".equals(style)) {
                return BorderFactory.createEmptyBorder();
            }
            if ("hidden".equals(style)) {
                return BorderFactory.createEmptyBorder(pixelWidth, pixelWidth, pixelWidth, pixelWidth);
            }
        }
        if (tok.hasMoreTokens()) {
            String colorString = tok.nextToken();
            try {
                color = Color.decode(colorString);
            }
            catch (NumberFormatException e) {
                LOG.log(Level.SEVERE, "Invalid color for border " + this.getKeyName(id) + ": " + colorString);
            }
        }
        return BorderFactory.createMatteBorder(pixelWidth, pixelWidth, pixelWidth, pixelWidth, color);
    }

    public Font getFont(Font base, String id) {
        if (this._fontCache != null) {
            for (FontEntry fe : this._fontCache.keySet()) {
                if (!fe.equals(base, id)) continue;
                return this._fontCache.get(fe);
            }
        }
        return this.getFontImpl(base, id);
    }

    private Font getFontImpl(Font base, String id) {
        String fontSize;
        int style = base.getStyle();
        int size = base.getSize();
        String weight = this.getString(id + ".font-weight");
        if (weight != null) {
            if ("bold".equals(weight)) {
                style |= 1;
            } else if ("normal".equals(weight)) {
                if ((style & 1) != 0) {
                    --style;
                }
            } else {
                LOG.warning("Font weight '" + weight + "' not recognized for " + this.getKeyName(id));
            }
        }
        if ((fontSize = this.getString(id + ".font-size")) != null) {
            if (fontSize.endsWith("%")) {
                if (fontSize.length() > 1) {
                    String pct = fontSize.substring(0, fontSize.length() - 1);
                    try {
                        int pctInt = Integer.parseInt(pct);
                        size = (int)((double)size * ((double)pctInt / 100.0));
                    }
                    catch (NumberFormatException nfe) {
                        LOG.log(Level.SEVERE, "Bad font-size for " + this.getKeyName(id) + ": " + fontSize);
                    }
                } else {
                    LOG.log(Level.SEVERE, "Must specify an integer value for font-size % in " + this.getKeyName(id) + ": " + fontSize);
                }
            } else if (fontSize.endsWith("pt")) {
                if (fontSize.length() > 2) {
                    String points = fontSize.substring(0, fontSize.length() - 2);
                    try {
                        size = Integer.parseInt(points);
                    }
                    catch (NumberFormatException nfe) {
                        LOG.log(Level.SEVERE, "Bad font-size for " + this.getKeyName(id) + ": " + fontSize);
                    }
                } else {
                    LOG.log(Level.SEVERE, "Must specify an integer value for font-size pt in " + this.getKeyName(id) + ": " + fontSize);
                }
            } else {
                LOG.warning("Don't know how to interpret font-size for '" + this.getKeyName(id) + "': '" + fontSize + "'");
            }
        }
        if (weight != null || fontSize != null) {
            Font font = base.deriveFont(style, size);
            if (this._fontCache == null) {
                this._fontCache = new HashMap<FontEntry, Font>(2);
            }
            this._fontCache.put(new FontEntry(base, id), font);
            return font;
        }
        return base;
    }

    Color getColorOrNull(String id) {
        Object c = this._resolvedMap.get(id);
        if (c == null) {
            c = this.getColorImpl(id, null);
            if (c == null) {
                c = "nullPlaceholder";
            }
            this._resolvedMap.put(id, c);
        }
        if ("nullPlaceholder" == c) {
            return null;
        }
        return (Color)c;
    }

    public Color getColor(String id) {
        Color c = (Color)this._resolvedMap.get(id);
        if (c == null) {
            c = this.getColorImpl(id, new ColorUIResource(Color.BLACK));
            this._resolvedMap.put(id, c);
        }
        return c;
    }

    private Color getColorImpl(String id, Color defaultColor) {
        String colorString = this.getString(id);
        if (colorString == null) {
            return defaultColor;
        }
        if (colorString.length() > 3 && colorString.substring(0, 3).equals("ui:")) {
            String uiColor = colorString.substring(3);
            return UIManager.getColor(uiColor);
        }
        try {
            return new ColorUIResource(Color.decode(colorString));
        }
        catch (NumberFormatException e) {
            LOG.log(Level.SEVERE, "Invalid color for " + this.getKeyName(id) + ": " + colorString, e);
            return new ColorUIResource(Color.BLACK);
        }
    }

    public double getDouble(String id) {
        String doubleString = this.getString(id, "0.0");
        try {
            return Double.parseDouble(doubleString);
        }
        catch (NumberFormatException e) {
            LOG.log(Level.SEVERE, "Invalid double value for " + this.getKeyName(id) + ": " + doubleString);
            return 0.0;
        }
    }

    public int getInt(String id) {
        String intString = this.getString(id, "0");
        return this.parseInt(id, intString);
    }

    private int parseInt(String id, String intString) {
        try {
            return Integer.parseInt(intString);
        }
        catch (NumberFormatException e) {
            LOG.log(Level.SEVERE, "Invalid int for " + this.getKeyName(id) + ": " + intString, e);
            return 0;
        }
    }

    public Insets getInsets(String id) {
        Insets i = (Insets)this._resolvedMap.get(id);
        if (i == null) {
            i = this.getInsetsImpl(id);
            this._resolvedMap.put(id, i);
        }
        return i;
    }

    private Insets getInsetsImpl(String id) {
        String insetsString = this.getString(id, "0 0 0 0");
        StringTokenizer tok = new StringTokenizer(insetsString, " ");
        Insets result = new Insets(0, 0, 0, 0);
        if (tok.hasMoreTokens()) {
            result.top = this.parseInt(id, tok.nextToken());
        }
        if (tok.hasMoreTokens()) {
            result.left = this.parseInt(id, tok.nextToken());
        }
        if (tok.hasMoreTokens()) {
            result.bottom = this.parseInt(id, tok.nextToken());
        }
        if (tok.hasMoreTokens()) {
            result.right = this.parseInt(id, tok.nextToken());
        }
        return result;
    }

    public Painter getPainter(String id) {
        Painter p = (Painter)this._resolvedMap.get(id);
        if (p == null) {
            p = this.getPainterImpl(id);
            this._resolvedMap.put(id, p);
        }
        return p;
    }

    private Painter getPainterImpl(String id) {
        String type = this.getString(id + ".type");
        if (type == null) {
            LOG.warning("No painter type for " + this.getKeyName(id));
            return new NullPainter();
        }
        PainterBuilder builder = PAINTER_BUILDERS.get(type);
        if (builder == null) {
            LOG.warning("Unknown painter type: " + type);
            return new NullPainter();
        }
        return builder.buildPainter(this, id);
    }

    private BufferedImage getImage(String id) {
        BufferedImage i = (BufferedImage)this._resolvedMap.get(id);
        if (i == null) {
            i = this.getImageImpl(id);
            this._resolvedMap.put(id, i);
        }
        return i;
    }

    private BufferedImage getImageImpl(String id) {
        String imageBase = this._properties.getProperty("imagebase");
        if (imageBase == null) {
            return this.logAndReturnNullImage(Level.SEVERE, "No image base for active theme!");
        }
        String imageStr = this.getString(id);
        if (imageStr == null) {
            return this.logAndReturnNullImage(Level.SEVERE, this.createLogMessage("Missing icon key in theme: %s", id));
        }
        String imageLocation = imageBase + "/" + imageStr;
        URL iconURL = this.getResource(imageLocation);
        if (iconURL == null) {
            return this.logAndReturnNullImage(Level.SEVERE, this.createLogMessage("Icon not found for %s: %s", id, imageLocation));
        }
        try {
            BufferedImage image = ImageIO.read(iconURL);
            if (image == null) {
                return this.logAndReturnNullImage(Level.SEVERE, this.createLogMessage("Failed to load icon %s: %s", id, String.valueOf(iconURL)));
            }
            return this.convertToCompatibleImage(image);
        }
        catch (IOException e) {
            return this.logAndReturnNullImage(Level.SEVERE, this.createLogMessage("Failed to load icon %s: %s", id, String.valueOf(iconURL)));
        }
    }

    private BufferedImage convertToCompatibleImage(BufferedImage image) {
        BufferedImage compatibleImage = this.createCompatibleImage(image.getWidth(), image.getHeight());
        Graphics g = compatibleImage.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return compatibleImage;
    }

    private BufferedImage createCompatibleImage(int w, int h) {
        if (GraphicsEnvironment.isHeadless()) {
            return new BufferedImage(w, h, 2);
        }
        GraphicsConfiguration configuration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        return configuration.createCompatibleImage(w, h, 3);
    }

    public Icon getIcon(String id) {
        Icon i = (Icon)this._resolvedMap.get(id);
        if (i == null) {
            i = this.getIconImpl(id);
            this._resolvedMap.put(id, i);
        }
        return i;
    }

    private Icon getIconImpl(String id) {
        String imageBase = this._properties.getProperty("imagebase");
        if (imageBase == null) {
            return this.logAndReturnNullIcon(Level.WARNING, "No image base for active theme!");
        }
        String imageStr = this.getString(id);
        if (imageStr == null) {
            return this.logAndReturnNullIcon(Level.SEVERE, this.createLogMessage("Missing icon key in theme: %s", id));
        }
        String imageLocation = imageBase + "/" + imageStr;
        URL iconURL = this.getResource(imageLocation);
        if (iconURL == null) {
            return this.logAndReturnNullIcon(Level.SEVERE, this.createLogMessage("Icon not found for %s: %s", id, imageLocation));
        }
        return new ImageIcon(iconURL);
    }

    private Icon logAndReturnNullIcon(Level logLevel, String message) {
        LOG.log(logLevel, message);
        return new NullIcon();
    }

    private BufferedImage logAndReturnNullImage(Level logLevel, String message) {
        LOG.log(logLevel, message);
        return NULL_IMAGE;
    }

    private String createLogMessage(String baseMessage, String keyId) {
        return this.createLogMessage(baseMessage, keyId, new String[]{null});
    }

    private String createLogMessage(String baseMessage, String keyId, String ... otherParams) {
        return String.format(baseMessage, this.getKeyName(keyId), otherParams);
    }

    public String getString(String id, String defaultValue) {
        return this._properties.getProperty(this.getKeyName(id), defaultValue);
    }

    public String getString(String id) {
        return this._properties.getProperty(this.getKeyName(id));
    }

    private String getKeyName(String id) {
        return this._partId + id;
    }

    private static Painter cachedImagePainter(Painter delegate) {
        if (ThemeProperties.shouldUseVolatileImage()) {
            return new VolatileImageCachingPainter(delegate);
        }
        return new BufferedImageCachingPainter(delegate);
    }

    private static boolean shouldUseVolatileImage() {
        return !PlatformUtils.isWindowsVista() && useVolatileImage.booleanValue();
    }

    static {
        PAINTER_BUILDERS.put("empty", new EmptyPainterBuilder());
        PAINTER_BUILDERS.put("stretch", new StretchPainterBuilder());
        PAINTER_BUILDERS.put("center", new CenterPainterBuilder());
        PAINTER_BUILDERS.put("gradient", new GradientPainterBuilder());
        PAINTER_BUILDERS.put("matte", new MattePainterBuilder());
        PAINTER_BUILDERS.put("edge", new EdgePainterBuilder());
        NULL_IMAGE = new BufferedImage(1, 1, 2);
        useVolatileImage = new SystemBoolean("ide.themes.useVolatileImage", true);
    }

    private class FontEntry {
        private String _propId;
        private Font _baseFont;

        public FontEntry(Font baseFont, String propId) {
            this._baseFont = baseFont;
            this._propId = propId;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof FontEntry) {
                FontEntry compareEntry = (FontEntry)obj;
                return this.equals(compareEntry._baseFont, compareEntry._propId);
            }
            return false;
        }

        public boolean equals(Font base, String id) {
            return (this._baseFont != null && this._baseFont.equals(base) || this._baseFont == null && base == null) && (this._propId != null && this._propId.equals(id) || this._propId == null && id == null);
        }

        public int hashCode() {
            return (this._baseFont != null ? this._baseFont.hashCode() : 0) + (this._propId != null ? this._propId.hashCode() : 0);
        }
    }

    private static abstract class PainterBuilder {
        private PainterBuilder() {
        }

        final Painter logAndReturnNullPainter(Level logLevel, String message) {
            return this.logAndReturnNullPainter(logLevel, message, null);
        }

        final Painter logAndReturnNullPainter(Level logLevel, String message, Throwable thrown) {
            LOG.log(logLevel, message, thrown);
            return new NullPainter();
        }

        final String createLogMessageFrom(ThemeProperties properties, String message, String propertyId) {
            return properties.createLogMessage(message, propertyId);
        }

        public abstract Painter buildPainter(ThemeProperties var1, String var2);
    }

    private static class EmptyPainterBuilder
    extends PainterBuilder {
        private EmptyPainterBuilder() {
        }

        @Override
        public Painter buildPainter(ThemeProperties properties, String painterId) {
            return new NullPainter();
        }
    }

    private static class StretchPainterBuilder
    extends PainterBuilder {
        private StretchPainterBuilder() {
        }

        @Override
        public Painter buildPainter(ThemeProperties properties, String id) {
            BufferedImage icon = properties.getImage(id + ".image");
            if (icon == null) {
                this.logAndReturnNullPainter(Level.SEVERE, this.createLogMessageFrom(properties, "Missing icon for stretch painter: %s", id));
            }
            try {
                Insets sizingMargin = properties.getInsets(id + ".sizingmargin");
                return ThemeProperties.cachedImagePainter(new StretchIconPainter(new StretchIcon(icon, sizingMargin)));
            }
            catch (IOException e) {
                return this.logAndReturnNullPainter(Level.SEVERE, "IOException: " + e.getMessage(), e);
            }
        }
    }

    private static class CenterPainterBuilder
    extends PainterBuilder {
        private CenterPainterBuilder() {
        }

        @Override
        public Painter buildPainter(ThemeProperties properties, String id) {
            Icon icon = properties.getIcon(id + ".image");
            if (icon == null || icon instanceof NullIcon) {
                this.logAndReturnNullPainter(Level.SEVERE, this.createLogMessageFrom(properties, "Missing icon for center painter: %s", id));
            }
            return new CenteredIconPainter(icon);
        }
    }

    private static class GradientPainterBuilder
    extends PainterBuilder {
        private GradientPainterBuilder() {
        }

        @Override
        public Painter buildPainter(ThemeProperties properties, String id) {
            Color startColor = properties.getColor(id + ".startcolor");
            Color endColor = properties.getColor(id + ".endcolor");
            String direction = properties.getString(id + ".direction", "vertical");
            return new LinearGradientPainter(startColor, endColor, this.stringToIntDirection(direction));
        }

        private int stringToIntDirection(String directionAsString) {
            if ("vertical".equals(directionAsString)) {
                return 1;
            }
            if ("horizontal".equals(directionAsString)) {
                return 0;
            }
            LOG.warning("Unknown direction for gradient painter: " + directionAsString);
            return 1;
        }
    }

    private static class MattePainterBuilder
    extends PainterBuilder {
        private MattePainterBuilder() {
        }

        @Override
        public Painter buildPainter(ThemeProperties properties, String id) {
            return new MattePainter(properties.getColor(id + ".color"));
        }
    }

    private static class EdgePainterBuilder
    extends PainterBuilder {
        private EdgePainterBuilder() {
        }

        @Override
        public Painter buildPainter(ThemeProperties properties, String id) {
            BufferedImage icon = properties.getImage(id + ".image");
            if (icon == null) {
                this.logAndReturnNullPainter(Level.SEVERE, this.createLogMessageFrom(properties, "Missing icon for stretch painter: %s", id));
            }
            String edge = properties.getString(id + ".edge", "top");
            return ThemeProperties.cachedImagePainter(new EdgePainter(icon, EdgePainter.Edge.valueOf(edge.toUpperCase())));
        }
    }
}

