/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.segmented;

import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import oracle.ide.hover.Hover;
import oracle.ide.hover.HoverEvent;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.hover.HoverListener;
import oracle.ide.hover.Hoverable;
import oracle.ide.hover.HoverableRegistry;
import oracle.javatools.ui.infotip.InfoTipHover;
import oracle.javatools.ui.infotip.InfoTipOrientation;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.Template;
import oracle.javatools.ui.segmented.Segment;
import oracle.javatools.ui.segmented.SegmentButton;
import oracle.javatools.ui.segmented.SegmentedControl;

final class SegmentedControlHoverable<T>
implements Hoverable {
    private final SegmentedControl<T> control;
    private SegmentButton<T> buttonInHover = null;
    private InfoTipHover hover = null;
    private SegmentedControl.InfoTipTemplate<T> template = null;
    private InfoTipStyles style;
    private HoverFlavor flavor;
    private InfoTipOrientation orientation;

    private SegmentedControlHoverable(final SegmentedControl.InfoTipTemplate<T> template, InfoTipStyles style, SegmentedControl<T> control, HoverFlavor flavor, InfoTipOrientation orientation) {
        this.control = control;
        this.style = style;
        this.flavor = flavor;
        this.orientation = orientation;
        this.control.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                HoverableRegistry.registerComponent(SegmentedControlHoverable.this.control, (Hoverable)SegmentedControlHoverable.this);
                SegmentedControlHoverable.this.template = template;
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                HoverableRegistry.unregisterComponent(SegmentedControlHoverable.this.control, (Hoverable)SegmentedControlHoverable.this);
                SegmentedControlHoverable.this.template = null;
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    static <T> SegmentedControlHoverable<T> install(SegmentedControl.InfoTipTemplate<T> template, InfoTipStyles style, SegmentedControl<T> control, HoverFlavor flavor, InfoTipOrientation orientation) {
        return new SegmentedControlHoverable<T>(template, style, control, flavor, orientation);
    }

    public Hover hover(Point location, List<HoverFlavor> flavors) {
        SwingUtilities.convertPointFromScreen(location, this.control);
        SegmentButton<T> segBtAtPoint = this.getSegmentButtonAt(location);
        if (segBtAtPoint == null) {
            return null;
        }
        this.hover = this.createHover(this.template, segBtAtPoint);
        this.hover.setOrientation(this.orientation);
        this.hover.showHover();
        this.buttonInHover = segBtAtPoint;
        final List<SegmentButton<T>> buttons = this.control.getSegmentButtons();
        final int count = buttons.size();
        final MouseListener[] mouseListeners = new MouseListener[count];
        for (int i = 0; i < count; ++i) {
            final SegmentButton<T> button = buttons.get(i);
            MouseAdapter m = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    Segment seg = button.getSegment();
                    SegmentedControlHoverable.this.template.setSegment(seg);
                    SegmentedControlHoverable.this.buttonInHover = button;
                    SegmentedControlHoverable.this.hover.setLocation(button.getBounds());
                }
            };
            mouseListeners[i] = m;
            button.addMouseListener(m);
        }
        this.hover.addHoverListener(new HoverListener(){

            public void hoverChange(HoverEvent he) {
                if (he.isHidden()) {
                    SegmentedControlHoverable.this.buttonInHover = null;
                    SegmentedControlHoverable.this.hover.removeHoverListener(this);
                    for (int i = 0; i < count; ++i) {
                        SegmentButton button = (SegmentButton)buttons.get(i);
                        button.removeMouseListener(mouseListeners[i]);
                    }
                    SegmentedControlHoverable.this.hover = null;
                }
            }
        });
        return this.hover;
    }

    private SegmentButton<T> getSegmentButtonAt(Point loc) {
        List<SegmentButton<T>> buttons = this.control.getSegmentButtons();
        int count = buttons.size();
        for (int i = 0; i < count; ++i) {
            SegmentButton<T> bt = buttons.get(i);
            Rectangle r = bt.getBounds();
            if (r.x > loc.x || r.x + r.width < loc.x || r.y > loc.y || r.y + r.height < loc.y) continue;
            return bt;
        }
        return null;
    }

    private InfoTipHover createHover(SegmentedControl.InfoTipTemplate<T> template, SegmentButton<T> button) {
        Segment<T> seg = button.getSegment();
        template.setSegment(seg);
        SegmentedControlInfoTipHover infoTipHover = new SegmentedControlInfoTipHover(template, this.style, this.control, button.getBounds(), this.flavor);
        return infoTipHover;
    }

    private class SegmentedControlInfoTipHover
    extends InfoTipHover {
        private JComponent parent;

        public SegmentedControlInfoTipHover(Template template, InfoTipStyles style, JComponent parent, Rectangle location, HoverFlavor flavor) {
            super(template, style, parent, location, flavor);
            this.parent = parent;
        }

        @Override
        public boolean isPointWithinHover(Point p) {
            Rectangle r = this.parent.getBounds();
            Point compP = this.parent.getLocation();
            Container cp = this.parent.getParent();
            if (cp == null) {
                return false;
            }
            SwingUtilities.convertPointToScreen(compP, cp);
            r.setLocation(compP);
            r.grow(6, 6);
            if (r.contains(p)) {
                return true;
            }
            return super.isPointWithinHover(p);
        }
    }
}

