/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.search;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import oracle.javatools.ui.Components;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.search.FindHighlightService;
import oracle.javatools.ui.search.Highlight;
import oracle.javatools.ui.search.MiniSearchDialog;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.TextComponentFindPlugin;

public final class TextComponentSearchSupport {
    private static final int MINIMUM_LENGTH_TO_HIGHLIGHT = 2;
    private SearchEvent.Direction searchDirection = SearchEvent.Direction.FORWARD;
    private int lastFoundOffset = -1;
    private int anchorOffset = 0;
    private final Rectangle anchorRect = new Rectangle();
    private final JTextComponent component;
    private final MiniSearchDialog dialog = new MiniSearchDialog();
    private String forwardsTitle;
    private String backwardsTitle = this.forwardsTitle = UIBundle.get("SEARCH_LABEL");
    private String notFoundMessage = UIBundle.get("NO_MATCH_FOUND_MESSAGE");
    private String wrappedMessage = UIBundle.get("SEARCH_WRAPPED_MESSAGE");
    private String startOfBufferMessage = UIBundle.get("START_OF_BUFFER_MESSAGE");
    private String endOfBufferMessage = UIBundle.get("END_OF_BUFFER_MESSAGE");
    private boolean beepedForEndBuffer = false;
    private boolean beepedForNotFound = false;
    private final TextComponentFindPlugin findPlugin;
    private TextListener _tListener = new TextListener();

    public TextComponentSearchSupport(JTextComponent component) {
        this.component = component;
        this.findPlugin = new TextComponentFindPlugin(new TextComponentFindHighlightService(component));
        this.findPlugin.install(component);
        this.dialog.addSearchListener(new SearchListener(){

            @Override
            public void searchPerformed(SearchEvent se) {
                TextComponentSearchSupport.this.search(se.getDirection(), se.getSearchText());
            }

            @Override
            public void searchCategoryChanged(SearchEvent se) {
            }
        });
        this.dialog.setPreferredLocation(MiniSearchDialog.Location.ABOVE);
        this.dialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("miniSearchDialogDismissed" == e.getActionCommand()) {
                    TextComponentSearchSupport.this.clearHighlighting();
                }
            }
        });
        Document doc = component.getDocument();
        if (doc != null) {
            doc.addDocumentListener(this._tListener);
        }
        component.addPropertyChangeListener("document", this._tListener);
    }

    public void removeSearchSupport() {
        this.findPlugin.deinstall(this.component);
        Document doc = this.component.getDocument();
        if (doc != null) {
            doc.removeDocumentListener(this._tListener);
        }
        this.component.removePropertyChangeListener("document", this._tListener);
    }

    public void setSearchForwardsTitle(String title) {
        this.forwardsTitle = title;
    }

    public void setSearchBackwardsTitle(String title) {
        this.backwardsTitle = title;
    }

    public void setNotFoundMessage(String notFoundMessage) {
        this.notFoundMessage = notFoundMessage;
    }

    public void setWrappedMessage(String wrappedMessage) {
        this.wrappedMessage = wrappedMessage;
    }

    public void setStartOfBufferMessage(String startOfBufferMessage) {
        this.startOfBufferMessage = startOfBufferMessage;
    }

    public void setEndOfBufferMessage(String endOfBufferMessage) {
        this.endOfBufferMessage = endOfBufferMessage;
    }

    public MiniSearchDialog getMiniSearchDialog() {
        return this.dialog;
    }

    public void showSearchPrompt() {
        this.dialog.setTitle(this.forwardsTitle);
        this.dialog.show(this.component);
    }

    public void search(SearchEvent.Direction direction, String text) {
        if (this.searchDirection != direction) {
            this.setDirection(direction);
            if (this.lastFoundOffset != -1) {
                this.anchorOffset = this.lastFoundOffset;
                this.component.computeVisibleRect(this.anchorRect);
            }
            this.dialog.setMessage("");
        }
        this.doSearch(StartLocation.NEXT, text);
    }

    private void setDirection(SearchEvent.Direction direction) {
        this.dialog.setTitle(direction == SearchEvent.Direction.FORWARD ? this.forwardsTitle : this.backwardsTitle);
        this.searchDirection = direction;
    }

    private void doSearch(StartLocation location, String text) {
        this.dialog.setMessage("");
        Document document = this.component.getDocument();
        int documentEnd = document.getLength() - 1;
        if (text.length() == 0) {
            this.component.scrollRectToVisible(this.anchorRect);
            this.component.setCaretPosition(this.anchorOffset);
            this.lastFoundOffset = -1;
            this.clearHighlighting();
            return;
        }
        boolean matchCase = this.containsUpperCase(text);
        boolean searchForward = this.searchDirection == SearchEvent.Direction.FORWARD;
        boolean wrapAround = false;
        boolean highlightOccurrences = text.length() >= 2;
        int startOffset = 0;
        switch (location) {
            case ANCHOR: {
                startOffset = this.anchorOffset;
                break;
            }
            case CURRENT: {
                if (this.lastFoundOffset == -1) {
                    startOffset = this.anchorOffset;
                    break;
                }
                if (this.searchDirection == SearchEvent.Direction.FORWARD) {
                    startOffset = this.lastFoundOffset;
                    break;
                }
                int selectionStart = this.component.getSelectionStart();
                int selectionEnd = this.component.getSelectionEnd();
                int oldLength = selectionEnd - selectionStart;
                int newLength = text.length();
                startOffset = selectionEnd + (newLength - oldLength);
                startOffset = Math.max(0, startOffset);
                startOffset = Math.min(startOffset, documentEnd);
                break;
            }
            case NEXT: {
                startOffset = this.lastFoundOffset == -1 ? this.anchorOffset : (this.searchDirection == SearchEvent.Direction.FORWARD ? this.lastFoundOffset + 1 : this.component.getSelectionEnd() - 1);
            }
        }
        boolean notFound = false;
        boolean wrappedAround = false;
        int nextOffset = this.findText(text, startOffset, searchForward, matchCase, wrapAround, false, highlightOccurrences);
        if (nextOffset == -1) {
            wrappedAround = true;
            notFound = true;
            startOffset = this.searchDirection == SearchEvent.Direction.FORWARD ? 0 : documentEnd;
            nextOffset = this.findText(text, startOffset, searchForward, matchCase, wrapAround, false, highlightOccurrences);
        }
        if (nextOffset != -1) {
            if (wrappedAround && !this.beepedForEndBuffer) {
                this.beepedForEndBuffer = true;
                this.component.getToolkit().beep();
                String message = this.searchDirection == SearchEvent.Direction.FORWARD ? this.endOfBufferMessage : this.startOfBufferMessage;
                this.dialog.setMessage(message);
                wrappedAround = false;
            } else {
                int fNextOffset = nextOffset;
                String fText = text;
                Components.setCaretPositionCenter(this.component, fNextOffset);
                Components.moveCaretPositionCenter(this.component, fNextOffset + fText.length());
                this.lastFoundOffset = nextOffset;
                this.beepedForEndBuffer = false;
            }
            this.beepedForNotFound = false;
            notFound = false;
        }
        if (notFound) {
            if (!this.beepedForNotFound) {
                this.component.getToolkit().beep();
            }
            this.dialog.setMessage(this.notFoundMessage);
            this.beepedForNotFound = true;
        } else if (wrappedAround) {
            this.dialog.setMessage(this.wrappedMessage);
        }
    }

    public void clearHighlighting() {
        this.findPlugin.clearFindHighlighting();
    }

    private int findText(String text, int startOffset, boolean forward, boolean matchCase, boolean wrap, boolean wholeWordOnly, boolean highlight) {
        return this.findPlugin.findText(text, startOffset, forward, matchCase, wrap, wholeWordOnly, highlight);
    }

    private boolean containsUpperCase(String str) {
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            return true;
        }
        return false;
    }

    private class TextListener
    implements DocumentListener,
    PropertyChangeListener {
        private TextListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            TextComponentSearchSupport.this.lastFoundOffset = -1;
            TextComponentSearchSupport.this.anchorOffset = 0;
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            TextComponentSearchSupport.this.lastFoundOffset = -1;
            TextComponentSearchSupport.this.anchorOffset = 0;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            TextComponentSearchSupport.this.lastFoundOffset = -1;
            TextComponentSearchSupport.this.anchorOffset = 0;
        }

        @Override
        public void propertyChange(PropertyChangeEvent pe) {
            Document newDoc;
            Document oldDoc = (Document)pe.getOldValue();
            if (oldDoc != null) {
                oldDoc.removeDocumentListener(this);
            }
            if ((newDoc = (Document)pe.getNewValue()) != null) {
                newDoc.addDocumentListener(this);
            }
        }
    }

    private static class TextComponentFindHighlightService
    extends FindHighlightService {
        private final JTextComponent component;
        private List<Highlight> highlights = new ArrayList<Highlight>();
        private final AttributeSet highlightAttributes;

        TextComponentFindHighlightService(JTextComponent c) {
            this.component = c;
            SimpleAttributeSet attributes = new SimpleAttributeSet();
            StyleConstants.setBackground(attributes, Color.YELLOW);
            this.highlightAttributes = attributes;
        }

        private StyledDocument styledDocument() {
            return (StyledDocument)this.component.getDocument();
        }

        private void addStyleHighlight(int start, int end) {
            this.styledDocument().setCharacterAttributes(start, end - start, this.highlightAttributes, false);
        }

        private void removeStyleHighlight(HighlightHandle handle) {
            for (int i = handle.getStartOffset(); i < handle.getEndOffset(); ++i) {
                AttributeSet attributes = this.styledDocument().getCharacterElement(i).getAttributes();
                SimpleAttributeSet newAttributes = new SimpleAttributeSet(attributes);
                newAttributes.removeAttribute(StyleConstants.Background);
                this.styledDocument().setCharacterAttributes(i, 1, newAttributes, true);
            }
        }

        @Override
        public Highlight highlight(int start, int end) {
            this.addStyleHighlight(start, end);
            HighlightHandle handle = new HighlightHandle(start, end);
            this.highlights.add(handle);
            return handle;
        }

        @Override
        public void removeHighlight(Highlight h) {
            this.removeStyleHighlight((HighlightHandle)h);
            this.highlights.remove(h);
        }

        @Override
        public void removeAllHighlights() {
            for (Highlight h : new ArrayList<Highlight>(this.highlights)) {
                this.removeHighlight(h);
            }
        }
    }

    private static enum StartLocation {
        ANCHOR,
        CURRENT,
        NEXT;

    }

    private static class HighlightHandle
    implements Highlight {
        private final int startOffset;
        private final int endOffset;

        HighlightHandle(int startOffset, int endOffset) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        int getStartOffset() {
            return this.startOffset;
        }

        @Override
        public int getEndOffset() {
            return this.endOffset;
        }
    }
}

