/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.search;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import oracle.javatools.ui.search.FindHighlightService;
import oracle.javatools.ui.search.Highlight;

final class TextComponentFindPlugin
implements DocumentListener {
    private static final boolean FORWARD = true;
    private static final boolean BACKWARDS = false;
    private final FindHighlightService highlightService;
    private JTextComponent editor = null;
    private String lastSearchText;
    private boolean lastMatchCase;
    private boolean lastWholeWordOnly;
    private List<Integer> offsetList;
    private List<Highlight> highlightList;
    private List<Integer> tempOffsetList;
    private List<Highlight> tempHighlightList;
    private Segment segment = new Segment();

    public TextComponentFindPlugin(FindHighlightService service) {
        this.highlightService = service;
        this.lastSearchText = null;
        this.lastMatchCase = false;
        this.lastWholeWordOnly = false;
        this.offsetList = new ArrayList<Integer>();
        this.highlightList = new ArrayList<Highlight>();
        this.tempOffsetList = new ArrayList<Integer>();
        this.tempHighlightList = new ArrayList<Highlight>();
    }

    public void install(JTextComponent editor) {
        this.editor = editor;
        Document document = editor.getDocument();
        document.addDocumentListener(this);
    }

    public void deinstall(JTextComponent editor) {
        Document document = editor.getDocument();
        if (document != null) {
            document.removeDocumentListener(this);
        }
        editor = null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("document")) {
            Object newValue;
            Object oldValue = event.getOldValue();
            if (oldValue instanceof Document) {
                Document document = (Document)oldValue;
                document.removeDocumentListener(this);
            }
            if ((newValue = event.getNewValue()) instanceof Document) {
                Document document = (Document)newValue;
                document.addDocumentListener(this);
                this.highlightService.removeAllHighlights();
                this.highlightList.clear();
                this.offsetList.clear();
                if (this.lastSearchText != null) {
                    this.updateFindRegion(0, document.getLength());
                }
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        final int offset = event.getOffset();
        final int length = event.getLength();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextComponentFindPlugin.this.highlightService.documentReadLock();
                try {
                    TextComponentFindPlugin.this.insertUpdate(offset, length);
                }
                finally {
                    TextComponentFindPlugin.this.highlightService.documentReadUnlock();
                }
            }
        });
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        final int offset = event.getOffset();
        final int length = event.getLength();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextComponentFindPlugin.this.highlightService.documentReadLock();
                try {
                    TextComponentFindPlugin.this.removeUpdate(offset, length);
                }
                finally {
                    TextComponentFindPlugin.this.highlightService.documentReadUnlock();
                }
            }
        });
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
    }

    public int findText(String searchText, int startOffset, boolean searchForward, boolean matchCase, boolean wrapAround, boolean highlightOccurrences) {
        return this.findText(searchText, startOffset, searchForward, matchCase, wrapAround, false, highlightOccurrences);
    }

    public int findText(String searchText, int startOffset, boolean searchForward, boolean matchCase, boolean wrapAround, boolean wholeWordOnly, boolean highlightOccurrences) {
        if (highlightOccurrences) {
            boolean redoSearch = false;
            if (this.lastSearchText == null) {
                redoSearch = true;
            } else if (!searchText.equals(this.lastSearchText) || matchCase != this.lastMatchCase || wholeWordOnly != this.lastWholeWordOnly) {
                redoSearch = true;
            }
            if (redoSearch) {
                this.clearFindHighlighting();
                this.performFindHighlighting(searchText, matchCase, wholeWordOnly);
            }
            int foundOffset = -1;
            int listSize = this.offsetList.size();
            if (searchForward) {
                for (int highlightOffset : this.offsetList) {
                    if (highlightOffset < startOffset) continue;
                    foundOffset = highlightOffset;
                    break;
                }
                if (wrapAround && foundOffset == -1) {
                    for (int highlightOffset : this.offsetList) {
                        if (highlightOffset >= startOffset) continue;
                        foundOffset = highlightOffset;
                        break;
                    }
                }
            } else {
                int highlightOffset;
                int i;
                int textLength = searchText.length();
                for (i = listSize - 1; i >= 0; --i) {
                    highlightOffset = this.offsetList.get(i);
                    if (highlightOffset + textLength > startOffset) continue;
                    foundOffset = highlightOffset;
                    break;
                }
                if (wrapAround && foundOffset == -1) {
                    for (i = listSize - 1; i >= 0; --i) {
                        highlightOffset = this.offsetList.get(i);
                        if (highlightOffset + textLength <= startOffset) continue;
                        foundOffset = highlightOffset;
                        break;
                    }
                }
            }
            return foundOffset;
        }
        this.clearFindHighlighting();
        Document document = this.editor.getDocument();
        int foundOffset = -1;
        if (searchForward) {
            foundOffset = this.findTextInternal(searchText, true, matchCase, wholeWordOnly, startOffset, document.getLength());
            if (wrapAround && foundOffset == -1) {
                foundOffset = this.findTextInternal(searchText, true, matchCase, wholeWordOnly, 0, startOffset);
            }
        } else {
            foundOffset = this.findTextInternal(searchText, false, matchCase, wholeWordOnly, 0, startOffset);
            if (wrapAround && foundOffset == -1) {
                foundOffset = this.findTextInternal(searchText, false, matchCase, wholeWordOnly, startOffset, document.getLength());
            }
        }
        return foundOffset;
    }

    public void clearFindHighlighting() {
        this.highlightService.removeAllHighlights();
        this.lastSearchText = null;
        this.offsetList.clear();
        this.highlightList.clear();
    }

    public boolean hasFindHighlighting() {
        return this.lastSearchText != null;
    }

    public boolean getFirstHighlightAfter(int position, int[] range) {
        int i = Collections.binarySearch(this.offsetList, position);
        if (i < 0) {
            i = -i - 1;
        }
        while (i < this.offsetList.size()) {
            int offset = this.offsetList.get(i);
            if (offset > position) {
                Highlight highlightedText = this.highlightList.get(i);
                range[0] = offset;
                range[1] = highlightedText.getEndOffset();
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean getFirstHighlightBefore(int position, int[] range) {
        int i = Collections.binarySearch(this.offsetList, position);
        if (i < 0) {
            i = -i - 1;
        }
        while (--i >= 0) {
            int offset = this.offsetList.get(i);
            if (offset >= position) continue;
            Highlight highlightedText = this.highlightList.get(i);
            range[0] = offset;
            range[1] = highlightedText.getEndOffset();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performFindHighlighting(String searchText, boolean matchCase, boolean wholeWordOnly) {
        if (searchText == null) {
            return;
        }
        if (this.editor == null || this.editor.getDocument() == null) {
            return;
        }
        this.lastSearchText = searchText;
        this.lastMatchCase = matchCase;
        this.lastWholeWordOnly = wholeWordOnly;
        Document document = this.editor.getDocument();
        this.highlightService.documentReadLock();
        try {
            this.updateFindRegion(0, document.getLength());
        }
        finally {
            this.highlightService.documentReadUnlock();
        }
    }

    private void insertUpdate(int offset, int count) {
        if (this.lastSearchText != null) {
            Document document = this.editor.getDocument();
            int searchLen = this.lastSearchText.length();
            int startAffected = Math.max(0, offset - searchLen);
            int endAffected = offset;
            int listSize = this.offsetList.size();
            int removeStart = -1;
            int removeEnd = -1;
            boolean SEARCH_FOR_START = false;
            boolean SEARCH_FOR_END = true;
            int UPDATE_OFFSETS = 2;
            int state = 0;
            block5: for (int i = 0; i < listSize; ++i) {
                int highlightOffset = this.offsetList.get(i);
                switch (state) {
                    case 0: {
                        if (highlightOffset < startAffected) continue block5;
                        removeStart = i;
                        state = 1;
                        removeEnd = listSize;
                    }
                    case 1: {
                        if (highlightOffset <= endAffected) {
                            Highlight highlightToRemove = this.highlightList.get(i);
                            this.highlightService.removeHighlight(highlightToRemove);
                            continue block5;
                        }
                        removeEnd = i;
                        state = 2;
                    }
                    case 2: {
                        this.offsetList.set(i, highlightOffset += count);
                    }
                }
            }
            if (removeStart != removeEnd) {
                int countToRemove = removeEnd - removeStart;
                for (int i = 0; i < countToRemove; ++i) {
                    this.offsetList.remove(removeStart);
                    this.highlightList.remove(removeStart);
                }
            }
            int recomputeStart = startAffected;
            int recomputeEnd = Math.min(offset + count + searchLen, document.getLength());
            this.updateFindRegion(recomputeStart, recomputeEnd);
        }
    }

    private void removeUpdate(int offset, int count) {
        if (this.lastSearchText != null) {
            Document document = this.editor.getDocument();
            int searchLen = this.lastSearchText.length();
            int startAffected = Math.max(0, offset - searchLen);
            int endAffected = Math.min(document.getLength(), offset + count);
            int listSize = this.offsetList.size();
            int removeStart = -1;
            int removeEnd = -1;
            boolean SEARCH_FOR_START = false;
            boolean SEARCH_FOR_END = true;
            int UPDATE_OFFSETS = 2;
            int state = 0;
            block5: for (int i = 0; i < listSize; ++i) {
                int highlightOffset = this.offsetList.get(i);
                switch (state) {
                    case 0: {
                        if (highlightOffset < startAffected) continue block5;
                        removeStart = i;
                        state = 1;
                        removeEnd = listSize;
                    }
                    case 1: {
                        if (highlightOffset <= endAffected) {
                            Highlight highlightToRemove = this.highlightList.get(i);
                            this.highlightService.removeHighlight(highlightToRemove);
                            continue block5;
                        }
                        removeEnd = i;
                        state = 2;
                    }
                    case 2: {
                        this.offsetList.set(i, highlightOffset -= count);
                    }
                }
            }
            if (removeStart != removeEnd) {
                int countToRemove = removeEnd - removeStart;
                for (int i = 0; i < countToRemove; ++i) {
                    this.offsetList.remove(removeStart);
                    this.highlightList.remove(removeStart);
                }
            }
            int recomputeStart = startAffected;
            int recomputeEnd = Math.min(offset + searchLen, document.getLength());
            this.updateFindRegion(recomputeStart, recomputeEnd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFindRegion(int startOffset, int endOffset) {
        int listSize;
        if (this.lastSearchText == null) {
            return;
        }
        int insertPoint = listSize = this.offsetList.size();
        for (int i = 0; i < listSize; ++i) {
            int highlightOffset = this.offsetList.get(i);
            if (highlightOffset <= startOffset) continue;
            insertPoint = i;
            break;
        }
        int searchLen = this.lastSearchText.length();
        this.highlightService.beginHighlighting();
        try {
            int currentOffset = startOffset;
            while (currentOffset < endOffset) {
                int foundOffset = this.findTextInternal(this.lastSearchText, true, this.lastMatchCase, this.lastWholeWordOnly, currentOffset, endOffset);
                if (foundOffset == -1) {
                    break;
                }
                Highlight entry = this.highlightService.highlight(foundOffset, foundOffset + searchLen);
                this.tempOffsetList.add(foundOffset);
                this.tempHighlightList.add(entry);
                currentOffset = foundOffset + 1;
            }
        }
        finally {
            this.highlightService.endHighlighting();
        }
        if (this.tempOffsetList.size() > 0) {
            this.offsetList.addAll(insertPoint, this.tempOffsetList);
            this.highlightList.addAll(insertPoint, this.tempHighlightList);
        }
        this.tempOffsetList.clear();
        this.tempHighlightList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findTextInternal(String searchText, boolean searchForward, boolean matchCase, boolean wholeWordOnly, int startOffset, int endOffset) {
        this.highlightService.documentReadLock();
        try {
            int foundOffset;
            while (true) {
                foundOffset = -1;
                foundOffset = matchCase ? (searchForward ? this.searchForwardMatch(searchText, startOffset, endOffset) : this.searchBackwardMatch(searchText, startOffset, endOffset)) : (searchForward ? this.searchForwardNoMatch(searchText, startOffset, endOffset) : this.searchBackwardNoMatch(searchText, startOffset, endOffset));
                if (foundOffset == -1 || !wholeWordOnly || this.isWholeWordMatch(this.editor.getDocument(), foundOffset, searchText.length())) break;
                if (searchForward) {
                    startOffset = foundOffset + 1;
                    continue;
                }
                endOffset = foundOffset - 1;
            }
            int n = foundOffset;
            return n;
        }
        finally {
            this.highlightService.documentReadUnlock();
        }
    }

    private boolean isWholeWordMatch(Document document, int startOffset, int length) {
        int endOffset = startOffset + length;
        int wordStart = this.highlightService.getWordStart(document, startOffset);
        int wordEnd = this.highlightService.getWordEnd(document, endOffset - 1);
        return wordStart == startOffset && wordEnd == endOffset;
    }

    private char getChar(Document doc, int offset) {
        try {
            doc.getText(offset, 1, this.segment);
            return this.segment.first();
        }
        catch (BadLocationException e) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
    }

    private int searchForwardMatch(String searchText, int startOffset, int endOffset) {
        int searchLength = searchText.length();
        int lastOffset = endOffset - searchLength;
        block0: for (int currentOffset = startOffset; currentOffset <= lastOffset; ++currentOffset) {
            int stringOffset = 0;
            int textOffset = currentOffset;
            int lastTextOffset = currentOffset + searchLength;
            while (textOffset < lastTextOffset) {
                char s;
                char t = this.getChar(this.editor.getDocument(), textOffset++);
                if (t == (s = searchText.charAt(stringOffset++))) continue;
                continue block0;
            }
            return currentOffset;
        }
        return -1;
    }

    private int searchBackwardMatch(String searchText, int startOffset, int endOffset) {
        int searchLength = searchText.length();
        block0: for (int currentOffset = endOffset - searchLength; currentOffset >= startOffset; --currentOffset) {
            int stringOffset = 0;
            int textOffset = currentOffset;
            int lastTextOffset = currentOffset + searchLength;
            while (textOffset < lastTextOffset) {
                char s;
                char t = this.getChar(this.editor.getDocument(), textOffset++);
                if (t == (s = searchText.charAt(stringOffset++))) continue;
                continue block0;
            }
            return currentOffset;
        }
        return -1;
    }

    private int searchForwardNoMatch(String searchText, int startOffset, int endOffset) {
        int searchLength = searchText.length();
        int lastOffset = endOffset - searchLength;
        block0: for (int currentOffset = startOffset; currentOffset <= lastOffset; ++currentOffset) {
            int stringOffset = 0;
            int textOffset = currentOffset;
            int lastTextOffset = currentOffset + searchLength;
            while (textOffset < lastTextOffset) {
                char s2;
                char t2;
                char s1;
                char t1;
                char s;
                char t = this.getChar(this.editor.getDocument(), textOffset++);
                if (t == (s = searchText.charAt(stringOffset++)) || (t1 = Character.toUpperCase(t)) == (s1 = Character.toUpperCase(s)) || (t2 = Character.toLowerCase(t1)) == (s2 = Character.toLowerCase(s1))) continue;
                continue block0;
            }
            return currentOffset;
        }
        return -1;
    }

    private int searchBackwardNoMatch(String searchText, int startOffset, int endOffset) {
        int searchLength = searchText.length();
        block0: for (int currentOffset = endOffset - searchLength; currentOffset >= startOffset; --currentOffset) {
            int stringOffset = 0;
            int textOffset = currentOffset;
            int lastTextOffset = currentOffset + searchLength;
            while (textOffset < lastTextOffset) {
                char s2;
                char t2;
                char s1;
                char t1;
                char s;
                char t = this.getChar(this.editor.getDocument(), textOffset++);
                if (t == (s = searchText.charAt(stringOffset++)) || (t1 = Character.toUpperCase(t)) == (s1 = Character.toUpperCase(s)) || (t2 = Character.toLowerCase(t1)) == (s2 = Character.toLowerCase(s1))) continue;
                continue block0;
            }
            return currentOffset;
        }
        return -1;
    }
}

