/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.plaf.theme;

import com.jgoodies.looks.plastic.PlasticComboBoxButton;
import com.jgoodies.looks.plastic.PlasticComboBoxUI;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import oracle.javatools.ui.themes.Themes;

public class ThemedToolBarComboUI
extends PlasticComboBoxUI {
    private static Insets insets = new Insets(0, 0, 0, 0);
    private JButton button;

    public static ComponentUI createUI(JComponent c) {
        return new ThemedToolBarComboUI();
    }

    public void installDefaults() {
        super.installDefaults();
        insets = Themes.getActiveTheme().getPartProperties("toolbarbutton").getInsets("outermargin");
    }

    private boolean isEditorToolbar(JComponent c) {
        boolean editorToolbar = false;
        if (c.getParent() != null && c.getParent() instanceof JComponent && ((JComponent)c.getParent()).getClientProperty("isPrimary") == Boolean.TRUE || ((JComponent)c.getParent()).getClientProperty("isSecondary") == Boolean.TRUE) {
            editorToolbar = true;
        }
        return editorToolbar;
    }

    public void paint(Graphics g, JComponent c) {
        String state = this._getState();
        Themes.getActiveTheme().getStateProperties("toolbarbutton.edge1", state).getPainter("bg").paint(g, 0, 0, c.getWidth(), c.getHeight());
        Themes.getActiveTheme().getStateProperties("toolbarbutton.edge2", state).getPainter("bg").paint(g, 0, 0, c.getWidth() - 1, c.getHeight());
        Themes.getActiveTheme().getStateProperties("toolbarbutton.edge3", state).getPainter("bg").paint(g, ThemedToolBarComboUI.insets.left, 0, c.getWidth() - ThemedToolBarComboUI.insets.left - ThemedToolBarComboUI.insets.right, c.getHeight());
        Themes.getActiveTheme().getStateProperties("toolbarbutton.edge4", state).getPainter("bg").paint(g, ThemedToolBarComboUI.insets.left, 0, c.getWidth() - ThemedToolBarComboUI.insets.left - ThemedToolBarComboUI.insets.right, c.getHeight());
        Themes.getActiveTheme().getStateProperties("toolbarbutton.center", state).getPainter("bg").paint(g.create(), ThemedToolBarComboUI.insets.left, ThemedToolBarComboUI.insets.top, c.getWidth() - ThemedToolBarComboUI.insets.left - ThemedToolBarComboUI.insets.right, c.getHeight() - ThemedToolBarComboUI.insets.top - ThemedToolBarComboUI.insets.bottom);
        if (c.hasFocus()) {
            state = "focus";
            Themes.getActiveTheme().getStateProperties("toolbarbutton.edge1", state).getPainter("bg").paint(g, 0, 0, c.getWidth(), c.getHeight());
            Themes.getActiveTheme().getStateProperties("toolbarbutton.edge2", state).getPainter("bg").paint(g, 0, 0, c.getWidth() - 1, c.getHeight());
            Themes.getActiveTheme().getStateProperties("toolbarbutton.edge3", state).getPainter("bg").paint(g, ThemedToolBarComboUI.insets.left, 0, c.getWidth() - ThemedToolBarComboUI.insets.left - ThemedToolBarComboUI.insets.right, c.getHeight());
            Themes.getActiveTheme().getStateProperties("toolbarbutton.edge4", state).getPainter("bg").paint(g, ThemedToolBarComboUI.insets.left, 0, c.getWidth() - ThemedToolBarComboUI.insets.left - ThemedToolBarComboUI.insets.right, c.getHeight());
        }
    }

    private String _getState() {
        String state = "default";
        if (!this.comboBox.isEnabled()) {
            state = "disabled";
        } else if (this.comboBox.isPopupVisible() || this.button.getModel().isArmed() && this.button.getModel().isPressed()) {
            state = "down";
        } else if (this.button.getModel().isRollover()) {
            state = "over";
        }
        return state;
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
    }

    protected JButton createArrowButton() {
        Dimension d;
        this.button = new PlasticComboBoxButton(this.comboBox, Themes.getActiveTheme().getPartProperties("toolbarbutton.drop").getIcon("icon"), this.comboBox.isEditable(), this.currentValuePane, this.listBox);
        Insets innerInsets = Themes.getActiveTheme().getPartProperties("toolbarbutton.drop").getInsets("innermargin");
        this.button.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(insets), BorderFactory.createEmptyBorder(innerInsets.top, innerInsets.left, innerInsets.bottom, innerInsets.right)));
        this.button.setRolloverEnabled(true);
        int extraWidth = Themes.getActiveTheme().getPartProperties("toolbarbutton.drop").getInt("extrawidth");
        if (this.comboBox.isPreferredSizeSet()) {
            d = this.comboBox.getPreferredSize();
            d.width += extraWidth;
            this.comboBox.setPreferredSize(d);
        }
        if (this.comboBox.isMinimumSizeSet()) {
            d = this.comboBox.getMinimumSize();
            d.width += extraWidth;
            this.comboBox.setMinimumSize(d);
        }
        if (this.comboBox.isMaximumSizeSet()) {
            d = this.comboBox.getMaximumSize();
            d.width += extraWidth;
            this.comboBox.setMaximumSize(d);
        }
        return this.button;
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension d = super.getPreferredSize(c);
        int extraWidth = Themes.getActiveTheme().getPartProperties("toolbarbutton.drop").getInt("extrawidth");
        d.width += extraWidth;
        return d;
    }

    public Dimension getMinimumSize(JComponent c) {
        Dimension d = super.getMinimumSize(c);
        int extraWidth = Themes.getActiveTheme().getPartProperties("toolbarbutton.drop").getInt("extrawidth");
        d.width += extraWidth;
        return d;
    }
}

