/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.plaf;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.basic.BasicLabelUI;
import oracle.javatools.ui.SuperLabel;
import oracle.javatools.util.PlatformUtils;

public class SuperLabelUI
extends BasicLabelUI {
    private static final SuperLabelUI superLabelUI = new SuperLabelUI();
    private SuperLabel label;
    private final MouseL mouseL = new MouseL();
    private List<Hyperlink> hyperlinks = new ArrayList<Hyperlink>();
    private Hyperlink activeHyperlink = null;

    public static SuperLabelUI createUI(JLabel label) {
        return superLabelUI;
    }

    @Override
    public void installUI(JComponent c) {
        this.label = (SuperLabel)c;
        super.installUI(c);
        c.addMouseListener(this.mouseL);
        c.addMouseMotionListener(this.mouseL);
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.removeMouseListener(this.mouseL);
        c.removeMouseMotionListener(this.mouseL);
        this.label = null;
    }

    public void setActiveHyperlink(Hyperlink activeHyperlink) {
        this.activeHyperlink = activeHyperlink;
    }

    public Hyperlink getActiveHyperlink() {
        return this.activeHyperlink;
    }

    public List<Hyperlink> getHyperlinks() {
        return Collections.unmodifiableList(this.hyperlinks);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        SuperLabel label = (SuperLabel)jComponent;
        Insets insets = jComponent.getInsets();
        int width = ((SuperLabel)jComponent).getPreferredWrapWidth() - insets.left - insets.right;
        Dimension d = this.paintFull((Graphics2D)jComponent.getGraphics(), label, false, width);
        d.height += insets.bottom;
        d.width += insets.left + insets.right;
        return d;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        SuperLabel label = (SuperLabel)jComponent;
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Insets insets = jComponent.getInsets();
        int cWidth = jComponent.getWidth() - insets.left - insets.right;
        int cHeight = jComponent.getHeight();
        Dimension d = this.paintFull((Graphics2D)graphics, label, false, cWidth);
        if (!label.isEnabled()) {
            graphics.setColor(UIManager.getColor("Label.disabledForeground"));
        }
        if (d.width > cWidth || d.height > cHeight) {
            this.paintTruncated((Graphics2D)graphics, label, true);
        } else {
            this.paintFull((Graphics2D)graphics, label, true, cWidth);
        }
    }

    public Dimension paintFull(Graphics2D g, SuperLabel label, boolean paint, int width) {
        this.hyperlinks.clear();
        FontRenderContext frc = g == null ? new FontRenderContext(null, true, true) : g.getFontRenderContext();
        AttributedString as = this.getAttributedString(label);
        if (label.getText() == null || label.getText().length() == 0 || width < 1) {
            return new Dimension(1, 14);
        }
        LineBreakMeasurer lbm = new LineBreakMeasurer(as.getIterator(), frc);
        Deque<Integer> newLines = this.findNewLines(as.getIterator());
        Insets insets = label.getInsets();
        int maxWidth = 0;
        int maxHeight = 0;
        int y = insets.top;
        int pos = lbm.getPosition();
        int end = as.getIterator().getEndIndex();
        Integer nextNewLine = newLines.isEmpty() ? end : newLines.pop();
        TextLayout layout = null;
        while (pos < end) {
            if (pos == nextNewLine) {
                ++pos;
                nextNewLine = newLines.peek() == null ? end : newLines.pop();
            }
            layout = nextNewLine == null ? lbm.nextLayout(width) : lbm.nextLayout(width, nextNewLine, false);
            y = (int)((float)y + layout.getAscent());
            float x = layout.isLeftToRight() ? (float)insets.left : (float)width - layout.getVisibleAdvance();
            maxWidth = (int)Math.max((float)maxWidth, layout.getVisibleAdvance());
            maxHeight = y;
            switch (label.getHorizontalAlignment()) {
                case 4: {
                    x = (float)width - layout.getVisibleAdvance() + (float)insets.left;
                    break;
                }
                case 0: {
                    x = (float)(width / 2) - layout.getVisibleAdvance() / 2.0f;
                }
            }
            if (paint) {
                layout.draw(g, x, y);
            }
            this.processHyperlinks(label, y, pos, layout);
            y = (int)((float)y + (layout.getDescent() + layout.getLeading()));
            pos = lbm.getPosition();
        }
        if (layout != null) {
            maxHeight = (int)((float)maxHeight + layout.getDescent());
        }
        return new Dimension(maxWidth, maxHeight);
    }

    private void processHyperlinks(SuperLabel label, int y, int pos, TextLayout layout) {
        for (SuperLabel.HyperlinkRun run : label.getHyperlinkRuns()) {
            Hyperlink hyperlink;
            Rectangle bounds;
            int second;
            int first;
            int endPos = pos + layout.getCharacterCount() - 1;
            if (run.firstIndex >= pos - 1 && run.firstIndex < endPos) {
                first = run.firstIndex - pos;
                if (pos > 0) {
                    ++first;
                }
                second = run.lastIndex - pos + 1;
                second = Math.min(second, layout.getCharacterCount());
                bounds = layout.getLogicalHighlightShape(first, second).getBounds();
                bounds.y += y;
                hyperlink = new Hyperlink(run, bounds);
                this.hyperlinks.add(hyperlink);
                continue;
            }
            if (run.firstIndex >= pos - 1 || run.lastIndex < pos - 1) continue;
            first = 0;
            second = run.lastIndex - pos + 1;
            second = Math.min(second, layout.getCharacterCount());
            bounds = layout.getLogicalHighlightShape(first, second).getBounds();
            bounds.y += y;
            hyperlink = this.hyperlinks.get(this.hyperlinks.size() - 1);
            hyperlink.addBounds(bounds);
        }
    }

    private Deque<Integer> findNewLines(AttributedCharacterIterator it) {
        ArrayDeque<Integer> newLines = new ArrayDeque<Integer>();
        char c = it.first();
        while (c != '\uffff') {
            if (c == '\n') {
                newLines.add(it.getIndex());
            }
            c = it.next();
        }
        return newLines;
    }

    private AttributedString getAttributedString(SuperLabel label) {
        AttributedString as = label.getAttributedText();
        try {
            if (label.isPaintHyperlink() && this.activeHyperlink != null) {
                as = new AttributedString(as.getIterator());
                int s = this.activeHyperlink.hyperlinkRun.firstIndex;
                int e = this.activeHyperlink.hyperlinkRun.lastIndex;
                int max = as.getIterator().getEndIndex();
                if (s <= max && e <= max && s < e && s >= 0 && e >= 0) {
                    as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON, s, e);
                    as.addAttribute(TextAttribute.FOREGROUND, label.getHyperlinkForeground(), s, e);
                }
            }
        }
        catch (IllegalArgumentException e) {
            Logger.getLogger("global").log(Level.SEVERE, "bad offsets: " + label.getText() + " " + this.activeHyperlink.hyperlinkRun.firstIndex + "," + this.activeHyperlink.hyperlinkRun.lastIndex);
            e.printStackTrace();
        }
        return as;
    }

    private void paintTruncated(Graphics2D g, SuperLabel label, boolean paint) {
        this.hyperlinks.clear();
        AttributedString as = this.getAttributedString(label);
        LineBreakMeasurer lbm = new LineBreakMeasurer(as.getIterator(), g.getFontRenderContext());
        Deque<Integer> newLines = this.findNewLines(as.getIterator());
        int end = as.getIterator().getEndIndex();
        Integer nextNewLine = newLines.isEmpty() ? end : newLines.pop();
        Insets insets = label.getInsets();
        Rectangle r = label.getBounds();
        r.width = r.width - insets.left - insets.right;
        r.height = r.height - insets.top - insets.bottom;
        int width = r.width;
        int lines = this.findTruncatedLineCount(as, g, r);
        if (lines == 0) {
            int x = insets.left;
            switch (label.getHorizontalAlignment()) {
                case 4: {
                    x = width - 16;
                    break;
                }
                case 0: {
                    x = width / 2 - 8;
                }
            }
            if (paint) {
                g.drawString("\u2026", x, insets.top + 8);
            }
            return;
        }
        float x = 0.0f;
        int y = insets.top;
        int pos = lbm.getPosition();
        for (int line = 0; line < lines; ++line) {
            if (pos == nextNewLine) {
                ++pos;
                nextNewLine = newLines.peek() == null ? end : newLines.pop();
            }
            if (line == lines - 1) {
                width -= SwingUtilities.computeStringWidth(g.getFontMetrics(), "\u2026");
            }
            TextLayout layout = nextNewLine == end ? lbm.nextLayout(width) : lbm.nextLayout(width, nextNewLine, false);
            y = (int)((float)y + layout.getAscent());
            x = layout.isLeftToRight() ? (float)insets.left : (float)width - layout.getVisibleAdvance();
            switch (label.getHorizontalAlignment()) {
                case 4: {
                    x = (float)width - layout.getVisibleAdvance() + (float)insets.left;
                    break;
                }
                case 0: {
                    x = (float)(width / 2) - layout.getVisibleAdvance() / 2.0f;
                }
            }
            if (paint) {
                layout.draw(g, x, y);
            }
            this.processHyperlinks(label, y, pos, layout);
            if (line == lines - 1) {
                if (!paint) break;
                g.drawString("\u2026", layout.getVisibleAdvance(), (float)y);
                break;
            }
            y = (int)((float)y + (layout.getDescent() + layout.getLeading()));
            pos = lbm.getPosition();
        }
    }

    private int findTruncatedLineCount(AttributedString as, Graphics2D g, Rectangle r) {
        LineBreakMeasurer lbm = new LineBreakMeasurer(as.getIterator(), g.getFontRenderContext());
        Deque<Integer> newLines = this.findNewLines(as.getIterator());
        int end = as.getIterator().getEndIndex();
        Integer nextNewLine = newLines.isEmpty() ? end : newLines.pop();
        int width = r.width;
        float x = 0.0f;
        int y = 0;
        int pos = lbm.getPosition();
        int lines = 0;
        while (pos < end) {
            if (pos == nextNewLine) {
                ++pos;
                nextNewLine = newLines.peek() == null ? end : newLines.pop();
            }
            TextLayout layout = nextNewLine == null ? lbm.nextLayout(width) : lbm.nextLayout(width, nextNewLine, false);
            y = (int)((float)y + layout.getAscent());
            float f = x = layout.isLeftToRight() ? 0.0f : (float)width - layout.getAdvance();
            if ((float)r.width < layout.getVisibleAdvance() || (float)r.height < (float)y + layout.getDescent()) break;
            ++lines;
            y = (int)((float)y + (layout.getDescent() + layout.getLeading()));
            pos = lbm.getPosition();
        }
        return lines;
    }

    private class MouseL
    extends MouseInputAdapter {
        private MouseL() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.findHyperlink(e.getPoint(), true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.findHyperlink(e.getPoint(), false);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.findHyperlink(e.getPoint(), true);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            boolean ok = true;
            if (SuperLabelUI.this.label.isRequireModifierForHyperlink()) {
                ok = false;
                if (PlatformUtils.isMac() && e.isMetaDown()) {
                    ok = true;
                } else if (e.isControlDown()) {
                    ok = true;
                }
            }
            if (ok && SuperLabelUI.this.activeHyperlink != null) {
                SuperLabelUI.this.label.fireActionEvent(100001, SuperLabelUI.this.activeHyperlink.hyperlinkRun.value);
            }
        }

        private void findHyperlink(Point p, boolean check) {
            Hyperlink oldHyperlink = SuperLabelUI.this.activeHyperlink;
            SuperLabelUI.this.activeHyperlink = null;
            if (check) {
                for (Hyperlink link : SuperLabelUI.this.hyperlinks) {
                    for (Rectangle bounds : link.bounds) {
                        if (!bounds.contains(p)) continue;
                        SuperLabelUI.this.activeHyperlink = link;
                    }
                }
            }
            if (oldHyperlink != SuperLabelUI.this.activeHyperlink) {
                SuperLabelUI.this.label.repaint();
            }
        }
    }

    public static final class Hyperlink {
        private final SuperLabel.HyperlinkRun hyperlinkRun;
        private final List<Rectangle> bounds = new ArrayList<Rectangle>();

        private Hyperlink(SuperLabel.HyperlinkRun hyperlinkRun, Rectangle bounds) {
            this.bounds.add(bounds);
            this.hyperlinkRun = hyperlinkRun;
        }

        public String toString() {
            return this.hyperlinkRun + " " + this.bounds;
        }

        private void addBounds(Rectangle bounds) {
            this.bounds.add(bounds);
        }

        public String getValue() {
            return this.hyperlinkRun.value;
        }

        public List<Rectangle> getBounds() {
            return Collections.unmodifiableList(this.bounds);
        }
    }
}

