/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.plaf;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import oracle.bali.ewt.graphics.GraphicUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.StatusIndicator;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.border.SmallSquareButtonBorder;
import oracle.javatools.ui.internal.StretchIcon;
import org.jdesktop.animation.timing.Cycle;
import org.jdesktop.animation.timing.Envelope;
import org.jdesktop.animation.timing.TimingController;
import org.jdesktop.animation.timing.TimingTarget;

public final class FlatTabbedPaneUI
extends BasicTabbedPaneUI {
    public static String TABBEDPANE_TRANSPARENT = "TABBEDPANE_TRANSPARENT";
    private Listener _listener;
    private JTabbedPane _pane;
    private Font _boldFont;
    private TabAreaViewport _tabViewport;
    private AbstractButton _previous;
    private AbstractButton _next;
    private Rectangle[] _preferredTabRects;
    private static final Insets DEFAULT_TAB_INSETS = new Insets(3, 5, 3, 3);
    private static final Insets DEFAULT_CONTENT_BORDER_INSETS = new Insets(1, 1, 1, 1);
    private static final Insets DEFAULT_TAB_AREA_INSETS = new Insets(0, 2, 0, 0);
    private static final Insets DEFAULT_BUTTON_AREA_INSETS = new Insets(1, 1, 1, 1);
    private int _textIconGap;
    private Insets _tabInsets;
    private Insets _contentBorderInsets;
    private Insets _tabAreaInsets;
    private Insets _buttonAreaInsets;
    private int _buttonGap;
    private final StretchIcon icon = new StretchIcon(new ImageIcon(UIBundle.class.getResource("images/fingertab2.png")), new Insets(4, 3, 4, 2));
    private final StretchIcon iconTop = new StretchIcon(new ImageIcon(UIBundle.class.getResource("images/fingertab2_top.png")), new Insets(3, 3, 4, 2));
    private final StretchIcon iconFocus = new StretchIcon(new ImageIcon(UIBundle.class.getResource("images/fingertab2-focus.png")), new Insets(4, 3, 4, 2));
    private final StretchIcon iconTopFocus = new StretchIcon(new ImageIcon(UIBundle.class.getResource("images/fingertab2_top-focus.png")), new Insets(3, 3, 4, 2));

    @Override
    public void installUI(JComponent c) {
        this._pane = (JTabbedPane)c;
        super.installUI(c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this._pane = null;
    }

    @Deprecated
    public void setPaintTopRightBottomBorders(boolean paintBorders) {
    }

    @Override
    protected void installDefaults() {
        this._pane.setTabPlacement(2);
        this._pane.setOpaque(false);
        this._textIconGap = UIManager.getInt("TabbedPane.textIconGap");
        this._tabInsets = DEFAULT_TAB_INSETS;
        this._contentBorderInsets = DEFAULT_CONTENT_BORDER_INSETS;
        this._tabAreaInsets = DEFAULT_TAB_AREA_INSETS;
        this._buttonAreaInsets = DEFAULT_BUTTON_AREA_INSETS;
        this._buttonGap = 1;
    }

    @Override
    protected void installComponents() {
        if (this._tabViewport == null) {
            this._tabViewport = new TabAreaViewport();
            this._tabViewport.setView(new TabAreaView());
            this._pane.add(this._tabViewport);
        }
        if (this._previous == null) {
            this._previous = this.createScrollButton(true);
            this._pane.add(this._previous);
        }
        if (this._next == null) {
            this._next = this.createScrollButton(false);
            this._pane.add(this._next);
        }
    }

    private AbstractButton createScrollButton(boolean up) {
        TabAreaButton button = new TabAreaButton();
        button.addActionListener(new ScrollAction(up));
        button.setToolTipText(UIBundle.get(up ? "PREVIOUS_TAB" : "NEXT_TAB"));
        button.setBorder(new SmallSquareButtonBorder());
        button.setContentAreaFilled(false);
        button.setRequestFocusEnabled(false);
        button.setFocusable(false);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setIcon(OracleIcons.getIcon((String)(up ? "extras/up.gif" : "extras/down.gif")));
        return button;
    }

    @Override
    protected void uninstallComponents() {
        this._pane.remove(this._tabViewport);
        this._pane.remove(this._previous);
        this._pane.remove(this._next);
    }

    @Override
    public int tabForCoordinate(JTabbedPane pane, int x, int y) {
        return this._tabViewport.tabForCoordinate(x, y);
    }

    @Override
    public Rectangle getTabBounds(JTabbedPane pane, int index) {
        return this._tabViewport.getTabBounds(index);
    }

    @Override
    public int getTabRunCount(JTabbedPane pane) {
        return 0;
    }

    private boolean isSelected(int tabIndex) {
        return this._pane.getSelectedIndex() == tabIndex;
    }

    private void ensureTabRectsCreated() {
        int tabCount = this._pane.getTabCount();
        if (this._preferredTabRects == null || this._preferredTabRects.length != tabCount) {
            this._preferredTabRects = new Rectangle[tabCount];
            for (int i = 0; i < tabCount; ++i) {
                this._preferredTabRects[i] = new Rectangle();
            }
        }
    }

    private Dimension calculateMaxTabWidthAndHeight() {
        this.ensureTabRectsCreated();
        Dimension maxsize = new Dimension();
        int maxWidth = 0;
        int maxHeight = 0;
        for (int i = 0; i < this._preferredTabRects.length; ++i) {
            Dimension tabsize = this.calculatePreferredTabSize(i, maxsize);
            maxWidth = Math.max(tabsize.width, maxWidth);
            maxHeight = Math.max(tabsize.height, maxHeight);
        }
        maxsize.width = maxWidth;
        maxsize.height = maxHeight;
        return maxsize;
    }

    private Dimension calculatePreferredTabSize(int tab, Dimension d) {
        if (d == null) {
            d = new Dimension();
        }
        d.width = this._tabInsets.left + this._tabInsets.right;
        Icon icon = this.iconForTab(tab);
        if (icon != null) {
            d.width += icon.getIconWidth() + this._textIconGap;
        }
        FontMetrics fontMetrics = this.fontMetricsForTab(tab);
        String title = this._pane.getTitleAt(tab);
        d.width += fontMetrics.stringWidth(title);
        d.height = this._tabInsets.top + this._tabInsets.bottom;
        d.height = icon != null ? (d.height += Math.max(icon.getIconHeight(), fontMetrics.getHeight())) : (d.height += fontMetrics.getHeight());
        Icon statusIcon = this.statusIconForTab(tab);
        if (statusIcon != null) {
            d.width += statusIcon.getIconWidth() + this._textIconGap;
        }
        return d;
    }

    private FontMetrics fontMetricsForTab(int tabIndex) {
        return this._pane.getFontMetrics(this._getBoldFont());
    }

    private Font fontForTab(int tabIndex) {
        if (this.isSelected(tabIndex)) {
            return this._getBoldFont();
        }
        return this._pane.getFont();
    }

    private Font _getBoldFont() {
        if (this._boldFont == null) {
            this._boldFont = this._pane.getFont().deriveFont(1);
        }
        return this._boldFont;
    }

    private Icon iconForTab(int tab) {
        return !this._pane.isEnabled() || !this._pane.isEnabledAt(tab) ? this._pane.getDisabledIconAt(tab) : this._pane.getIconAt(tab);
    }

    private Icon statusIconForTab(int tab) {
        Object statusIndicatorObj;
        Component comp = this._pane.getTabComponentAt(tab);
        if (comp instanceof JComponent && (statusIndicatorObj = ((JComponent)comp).getClientProperty("status-indicator")) != null) {
            StatusIndicator statusIndicator = (StatusIndicator)statusIndicatorObj;
            statusIndicator.addPropertyChangeListener(this._listener);
            return statusIndicator.getIcon(StatusIndicator.OkPolicy.HIDE);
        }
        return null;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Boolean paintBg = (Boolean)this._pane.getClientProperty(TABBEDPANE_TRANSPARENT);
        if (!(paintBg != null && paintBg.booleanValue() || PlasticLookAndFeel.getHighContrastFocusColorsEnabled())) {
            g.setColor(Colors.TAB_PANE_BACKGROUND);
            g.fillRect(0, 0, this._pane.getWidth(), this._pane.getHeight());
        }
        Rectangle contentAreaRect = new Rectangle();
        Insets insets = this._pane.getInsets();
        int tabAreaWidth = this.getTabAreaWidth();
        contentAreaRect.x = insets.left + this.getTabAreaWidth();
        contentAreaRect.y = insets.top;
        contentAreaRect.width = this._pane.getWidth() - (insets.left + insets.right + tabAreaWidth);
        contentAreaRect.height = this._pane.getHeight() - (insets.top + insets.bottom);
        this.paintContentArea((Graphics2D)g, contentAreaRect);
    }

    private void paintContentArea(Graphics2D g, Rectangle rect) {
        if (rect.width <= 0 || rect.height <= 0) {
            return;
        }
        Color bg = UIManager.getColor("window");
        g.setColor(bg);
        g.fill(rect);
        g.setColor(Colors.FLAT_EDITOR_BORDER);
        if (this._pane.getTabCount() <= 1) {
            g.drawLine(rect.x, rect.y, rect.x, rect.y + rect.height - 1);
        }
        g.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
        g.drawLine(rect.x + rect.width - 1, rect.y, rect.x + rect.width - 1, rect.y + rect.height);
        g.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width, rect.y + rect.height - 1);
        if (this._tabViewport.getHeight() < rect.height) {
            g.drawLine(rect.x - 1, rect.y + this._tabViewport.getHeight(), rect.x - 1, rect.y + rect.height);
        }
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new PaneLayoutManager();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this._listener = new Listener();
        this._listener.install(this._pane);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this._listener.uninstall(this._pane);
    }

    @Override
    protected int getTabRunOffset(int tabPlacement, int tabCount, int tabIndex, boolean forward) {
        return 0;
    }

    private void throwNoMouseListenerException() {
        throw new IllegalStateException("Adding a mouse listener to this component breaks event propagation through the containment hierarchy.");
    }

    boolean requestFocusForVisibleComponent() {
        Component visibleComponent = this.getVisibleComponent();
        if (visibleComponent != null && FlatTabbedPaneUI.isFocusTraversable(visibleComponent)) {
            FlatTabbedPaneUI.compositeRequestFocus(visibleComponent);
            return true;
        }
        return visibleComponent instanceof JComponent && FlatTabbedPaneUI.requestDefaultFocus((JComponent)visibleComponent);
    }

    static Component compositeRequestFocus(Component component) {
        if (component instanceof Container) {
            FocusTraversalPolicy policy;
            Component comp;
            FocusTraversalPolicy policy2;
            Component comp2;
            Container container = (Container)component;
            if (container.isFocusCycleRoot() && (comp2 = (policy2 = container.getFocusTraversalPolicy()).getDefaultComponent(container)) != null) {
                comp2.requestFocus();
                return comp2;
            }
            Container rootAncestor = container.getFocusCycleRootAncestor();
            if (rootAncestor != null && (comp = (policy = rootAncestor.getFocusTraversalPolicy()).getComponentAfter(rootAncestor, container)) != null && SwingUtilities.isDescendingFrom(comp, container)) {
                comp.requestFocus();
                return comp;
            }
        }
        if (component.isFocusable()) {
            component.requestFocus();
            return component;
        }
        return null;
    }

    private int getTabAreaWidth() {
        if (this._pane.getTabCount() <= 1) {
            return 0;
        }
        Dimension size = this.calculateMaxTabWidthAndHeight();
        return size.width + this._tabAreaInsets.left + this._tabAreaInsets.right;
    }

    private static boolean isFocusTraversable(Component c) {
        return c.isFocusTraversable();
    }

    private static boolean requestDefaultFocus(JComponent c) {
        return c.requestDefaultFocus();
    }

    private class TabAreaViewport
    extends JViewport
    implements UIResource {
        private TimingController _aniTimer;
        private final Cycle _cycle = new Cycle(300, 33);
        private final Envelope _envelope = new Envelope(1.0, 0, Envelope.RepeatBehavior.FORWARD, Envelope.EndBehavior.HOLD);
        private boolean _animationEnabled = true;

        private TabAreaViewport() {
            this.setOpaque(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scrollToTab(int tabIndex, boolean animate) {
            if (tabIndex < 0 || tabIndex > FlatTabbedPaneUI.this._pane.getTabCount() - 1) {
                throw new IllegalArgumentException("No such tab: " + tabIndex);
            }
            this._animationEnabled = animate;
            try {
                Rectangle boundsInView = this.getTabBoundsInView(tabIndex);
                Rectangle viewRect = this.getViewRect();
                if (viewRect.contains(boundsInView)) {
                    return;
                }
                boundsInView.y -= this.getViewPosition().y;
                this.scrollRectToVisible(boundsInView);
            }
            finally {
                this._animationEnabled = true;
            }
        }

        public Rectangle getTabBounds(int tabIndex) {
            Rectangle bounds = this.getTabBoundsInView(tabIndex);
            Point position = this.getViewPosition();
            bounds.x -= position.x;
            bounds.y -= position.y;
            bounds.x += FlatTabbedPaneUI.this._tabAreaInsets.left;
            bounds.y += FlatTabbedPaneUI.this._tabAreaInsets.top;
            Insets paneInsets = FlatTabbedPaneUI.this._pane.getInsets();
            bounds.x += paneInsets.left;
            bounds.y += paneInsets.right;
            return bounds;
        }

        private Rectangle getTabBoundsInView(int tabIndex) {
            Rectangle bounds = new Rectangle();
            Dimension tabSize = FlatTabbedPaneUI.this.calculateMaxTabWidthAndHeight();
            bounds.y = tabSize.height * tabIndex;
            bounds.x = 0;
            bounds.width = tabSize.width;
            bounds.height = tabSize.height;
            return bounds;
        }

        public int tabForCoordinate(int x, int y) {
            Insets insets = FlatTabbedPaneUI.this._pane.getInsets();
            int viewX = x - insets.top;
            int viewY = y - insets.left;
            Point position = this.getViewPosition();
            viewY += position.y;
            if ((viewX += position.x) > this.getView().getWidth()) {
                return -1;
            }
            Dimension tabSize = FlatTabbedPaneUI.this.calculateMaxTabWidthAndHeight();
            int tabIndex = viewY / tabSize.height;
            if (tabIndex >= FlatTabbedPaneUI.this._pane.getTabCount()) {
                return -1;
            }
            return tabIndex;
        }

        private void setViewPositionDirectly(Point p) {
            super.setViewPosition(p);
        }

        private void stopAnimation() {
            if (this._aniTimer != null && this._aniTimer.isRunning()) {
                this._aniTimer.stop();
            }
        }

        private boolean viewIsLargerThanViewport() {
            Dimension viewSize = this.getViewSize();
            Dimension viewportSize = this.getSize();
            return viewSize.height > viewportSize.height || viewSize.width > viewportSize.width;
        }

        @Override
        public void setViewPosition(final Point p) {
            Point initialPosition = this.getViewPosition();
            if (initialPosition.x == p.x && initialPosition.y == p.y) {
                return;
            }
            if (!this._animationEnabled || !this.viewIsLargerThanViewport()) {
                this.stopAnimation();
                this.setViewPositionDirectly(p);
                return;
            }
            final int initialX = initialPosition.x;
            final int initialY = initialPosition.y;
            final int deltaX = p.x - initialX;
            final int deltaY = p.y - initialY;
            if (deltaX == 0 && deltaY == 0) {
                this.setViewPositionDirectly(p);
                return;
            }
            TimingTarget target = new TimingTarget(){

                public void end() {
                    TabAreaViewport.this.setViewPositionDirectly(p);
                }

                public void begin() {
                }

                public void timingEvent(long l, long l1, float f) {
                    Point p2 = new Point((int)((float)initialX + f * (float)deltaX), (int)((float)initialY + f * (float)deltaY));
                    TabAreaViewport.this.setViewPositionDirectly(p2);
                }
            };
            this._aniTimer = new TimingController(this._cycle, this._envelope, target);
            this._aniTimer.setDeceleration(1.0f);
            this._aniTimer.start();
        }

        @Override
        public synchronized void addMouseListener(MouseListener l) {
        }

        @Override
        public synchronized void addMouseMotionListener(MouseMotionListener l) {
        }

        @Override
        public synchronized void addMouseWheelListener(MouseWheelListener l) {
        }
    }

    private class TabAreaView
    extends JComponent
    implements UIResource {
        private final Rectangle rect = new Rectangle();
        private final Rectangle textRect = new Rectangle();
        private final Rectangle iconRect = new Rectangle();
        private final Rectangle viewRect = new Rectangle();

        private TabAreaView() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            Dimension tabSize = FlatTabbedPaneUI.this.calculateMaxTabWidthAndHeight();
            int x = FlatTabbedPaneUI.this._tabAreaInsets.left;
            int y = FlatTabbedPaneUI.this._tabAreaInsets.top;
            int width = this.getWidth() - (FlatTabbedPaneUI.this._tabAreaInsets.left + FlatTabbedPaneUI.this._tabAreaInsets.right);
            for (int i = 0; i < FlatTabbedPaneUI.this._pane.getTabCount(); ++i) {
                this.rect.setBounds(x, y, width, tabSize.height);
                this.paintTabBackground(g, this.rect, i);
                this.paintTabIconAndText(g, this.rect, i);
                y += tabSize.height;
            }
            this.paintRightBorder(g, tabSize);
        }

        private void paintTabBackground(Graphics g, Rectangle bounds, int tabIndex) {
            if (!FlatTabbedPaneUI.this.isSelected(tabIndex)) {
                return;
            }
            if (PlasticLookAndFeel.getHighContrastFocusColorsEnabled()) {
                g.setColor(UIManager.getColor("Label.foreground"));
                g.drawLine(bounds.x, bounds.y, bounds.x + bounds.width, bounds.y);
                g.drawLine(bounds.x, bounds.y, bounds.x, bounds.y + bounds.height);
                g.drawLine(bounds.x, bounds.y + bounds.height, bounds.x + bounds.width, bounds.y + bounds.height);
                return;
            }
            StretchIcon bgIcon = null;
            bgIcon = !FlatTabbedPaneUI.this.isSelected(tabIndex) || !FlatTabbedPaneUI.this._pane.hasFocus() ? (this.isTop(tabIndex) ? FlatTabbedPaneUI.this.iconTop : FlatTabbedPaneUI.this.icon) : (this.isTop(tabIndex) ? FlatTabbedPaneUI.this.iconTopFocus : FlatTabbedPaneUI.this.iconFocus);
            bgIcon.paintIcon(FlatTabbedPaneUI.this._pane, g, bounds);
        }

        private void paintTabIconAndText(Graphics g, Rectangle bounds, int tabIndex) {
            Icon icon = FlatTabbedPaneUI.this.iconForTab(tabIndex);
            String text = FlatTabbedPaneUI.this._pane.getTitleAt(tabIndex);
            this.textRect.setBounds(0, 0, 0, 0);
            this.iconRect.setBounds(0, 0, 0, 0);
            this.viewRect.setBounds(bounds.x + FlatTabbedPaneUI.this._tabInsets.left, bounds.y + FlatTabbedPaneUI.this._tabInsets.top, bounds.width - (FlatTabbedPaneUI.this._tabInsets.left + FlatTabbedPaneUI.this._tabInsets.right), bounds.height - (FlatTabbedPaneUI.this._tabInsets.top + FlatTabbedPaneUI.this._tabInsets.bottom));
            FontMetrics metrics = FlatTabbedPaneUI.this.fontMetricsForTab(tabIndex);
            String truncatedLabel = SwingUtilities.layoutCompoundLabel(this, metrics, text, icon, 0, 2, 0, 11, this.viewRect, this.iconRect, this.textRect, FlatTabbedPaneUI.this._textIconGap);
            g.setFont(FlatTabbedPaneUI.this.fontForTab(tabIndex));
            g.setColor(FlatTabbedPaneUI.this._pane.getForegroundAt(tabIndex));
            if (icon != null) {
                icon.paintIcon(this, g, this.iconRect.x, this.iconRect.y);
            }
            GraphicUtils.drawString((Graphics)g, (String)truncatedLabel, (int)this.textRect.x, (int)(this.textRect.y + metrics.getAscent()));
            Icon statusIcon = FlatTabbedPaneUI.this.statusIconForTab(tabIndex);
            if (statusIcon != null) {
                int statusx = this.textRect.x + this.textRect.width + FlatTabbedPaneUI.this._textIconGap;
                int statusy = this.textRect.y + this.textRect.height / 2 - statusIcon.getIconHeight() / 2;
                statusIcon.paintIcon(this, g, statusx, statusy);
            }
            this.paintFocus(g, tabIndex, this.textRect);
        }

        private void paintFocus(Graphics g, int tabIndex, Rectangle textRect) {
        }

        private void paintRightBorder(Graphics g, Dimension tabSize) {
            int selectedTab = FlatTabbedPaneUI.this._pane.getSelectedIndex();
            int x = this.getWidth() - 1;
            int yOfSelectedTab = selectedTab * tabSize.height;
            g.setColor(Colors.FLAT_EDITOR_BORDER);
            g.drawLine(x, 0, x, yOfSelectedTab);
            g.drawLine(x, yOfSelectedTab + tabSize.height, x, this.getHeight());
        }

        private boolean isTop(int tabIndex) {
            return tabIndex == 0;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = new Dimension();
            Dimension tabSize = FlatTabbedPaneUI.this.calculateMaxTabWidthAndHeight();
            size.width = tabSize.width;
            size.height = FlatTabbedPaneUI.this._pane.getTabCount() * tabSize.height;
            return size;
        }

        @Override
        public synchronized void addMouseListener(MouseListener l) {
            FlatTabbedPaneUI.this.throwNoMouseListenerException();
        }

        @Override
        public synchronized void addMouseMotionListener(MouseMotionListener l) {
            FlatTabbedPaneUI.this.throwNoMouseListenerException();
        }

        @Override
        public synchronized void addMouseWheelListener(MouseWheelListener l) {
            FlatTabbedPaneUI.this.throwNoMouseListenerException();
        }
    }

    private static class TabAreaButton
    extends JButton
    implements UIResource {
        private TabAreaButton() {
        }
    }

    private class ScrollAction
    implements ActionListener {
        private final boolean _up;

        ScrollAction(boolean up) {
            this._up = up;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (this._up && FlatTabbedPaneUI.this._pane.getSelectedIndex() > 0) {
                this.select(FlatTabbedPaneUI.this._pane.getSelectedIndex() - 1);
            } else if (!this._up && FlatTabbedPaneUI.this._pane.getSelectedIndex() < FlatTabbedPaneUI.this._pane.getTabCount() - 1) {
                this.select(FlatTabbedPaneUI.this._pane.getSelectedIndex() + 1);
            }
        }

        private void select(int tab) {
            FlatTabbedPaneUI.this._pane.setSelectedIndex(tab);
        }
    }

    private class Listener
    extends ComponentAdapter
    implements ChangeListener,
    ContainerListener,
    PropertyChangeListener,
    FocusListener,
    MouseListener {
        private Listener() {
        }

        private void install(JTabbedPane pane) {
            pane.addChangeListener(this);
            pane.addContainerListener(this);
            pane.addComponentListener(this);
            pane.addPropertyChangeListener(this);
            pane.addFocusListener(this);
            pane.addMouseListener(this);
        }

        private void uninstall(JTabbedPane pane) {
            pane.removeChangeListener(this);
            pane.removeContainerListener(this);
            pane.removeComponentListener(this);
            pane.removePropertyChangeListener(this);
            pane.removeFocusListener(this);
            pane.removeMouseListener(this);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.whenTabChanged();
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            this.enableOrDisableUpDownButtons();
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            Object statusIndicatorObj;
            this.enableOrDisableUpDownButtons();
            Component comp = e.getChild();
            if (comp instanceof JComponent && (statusIndicatorObj = ((JComponent)comp).getClientProperty("status-indicator")) != null) {
                StatusIndicator statusIndicator = (StatusIndicator)statusIndicatorObj;
                statusIndicator.removePropertyChangeListener(FlatTabbedPaneUI.this._listener);
            }
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.scrollToSelectedTab(false);
        }

        private void scrollToSelectedTab(boolean animate) {
            if (FlatTabbedPaneUI.this._pane.getSelectedIndex() == -1) {
                return;
            }
            FlatTabbedPaneUI.this._tabViewport.scrollToTab(FlatTabbedPaneUI.this._pane.getSelectedIndex(), animate);
        }

        private void whenTabChanged() {
            this.scrollToSelectedTab(true);
            this.enableOrDisableUpDownButtons();
        }

        private void enableOrDisableUpDownButtons() {
            FlatTabbedPaneUI.this._next.setEnabled(FlatTabbedPaneUI.this._pane.getSelectedIndex() < FlatTabbedPaneUI.this._pane.getTabCount() - 1);
            FlatTabbedPaneUI.this._previous.setEnabled(FlatTabbedPaneUI.this._pane.getSelectedIndex() > 0);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String pName = evt.getPropertyName();
            if ("tabPlacement".equals(pName)) {
                int newValue = (Integer)evt.getNewValue();
                if (newValue != 2) {
                    FlatTabbedPaneUI.this._pane.setTabPlacement(2);
                    throw new IllegalArgumentException("Cannot set tab placement to " + newValue);
                }
            } else if ("font".equals(pName)) {
                FlatTabbedPaneUI.this._boldFont = null;
            } else if ("status".equals(pName)) {
                FlatTabbedPaneUI.this._pane.repaint();
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            FlatTabbedPaneUI.this.tabPane.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            FlatTabbedPaneUI.this.tabPane.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!FlatTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            int tabIndex = FlatTabbedPaneUI.this.tabForCoordinate(FlatTabbedPaneUI.this.tabPane, e.getX(), e.getY());
            if (tabIndex >= 0 && FlatTabbedPaneUI.this.tabPane.isEnabledAt(tabIndex)) {
                if (tabIndex != FlatTabbedPaneUI.this.tabPane.getSelectedIndex()) {
                    FlatTabbedPaneUI.this.tabPane.setSelectedIndex(tabIndex);
                } else if (FlatTabbedPaneUI.this.tabPane.isRequestFocusEnabled()) {
                    FlatTabbedPaneUI.this.tabPane.requestFocus();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private class PaneLayoutManager
    implements LayoutManager {
        private PaneLayoutManager() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.calculateSize(false);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.calculateSize(true);
        }

        private Dimension calculateSize(boolean minimum) {
            Dimension result = new Dimension();
            this.addInsetSize(result);
            this.addChildComponentSize(minimum, result);
            this.addTabAreaSize(result);
            return result;
        }

        private void addInsetSize(Dimension result) {
            Insets insets = FlatTabbedPaneUI.this._pane.getInsets();
            result.width += insets.left + insets.right;
            result.height += insets.top + insets.bottom;
        }

        private void addChildComponentSize(boolean minimum, Dimension result) {
            Dimension zero = new Dimension(0, 0);
            int cwidth = 0;
            int cheight = 0;
            for (int i = 0; i < FlatTabbedPaneUI.this._pane.getTabCount(); ++i) {
                Component c = FlatTabbedPaneUI.this._pane.getComponentAt(i);
                if (c == null) continue;
                Dimension size = zero;
                Dimension dimension = size = minimum ? c.getMinimumSize() : c.getPreferredSize();
                if (size == null) {
                    size = zero;
                }
                cwidth = Math.max(size.width, cwidth);
                cheight = Math.max(size.height, cheight);
            }
            result.width += cwidth + (FlatTabbedPaneUI.this._contentBorderInsets.left + FlatTabbedPaneUI.this._contentBorderInsets.right);
            result.height += cheight + (FlatTabbedPaneUI.this._contentBorderInsets.top + FlatTabbedPaneUI.this._contentBorderInsets.bottom);
        }

        private void addTabAreaSize(Dimension result) {
            if (FlatTabbedPaneUI.this._pane.getTabCount() == 0) {
                return;
            }
            result.width += FlatTabbedPaneUI.this._tabAreaInsets.left + FlatTabbedPaneUI.this._tabAreaInsets.right;
            result.height += FlatTabbedPaneUI.this._tabAreaInsets.top + FlatTabbedPaneUI.this._tabAreaInsets.bottom;
            Dimension size = FlatTabbedPaneUI.this.calculateMaxTabWidthAndHeight();
            result.width += size.width;
            result.height += size.height;
        }

        private Component findFocusOwner(Component c) {
            return SwingUtilities.findFocusOwner(c);
        }

        private boolean updateVisibleComponent() {
            Component visibleComponent = FlatTabbedPaneUI.this.getVisibleComponent();
            boolean changeFocus = false;
            int selectedIndex = FlatTabbedPaneUI.this._pane.getSelectedIndex();
            if (selectedIndex < 0) {
                if (visibleComponent != null) {
                    FlatTabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                Component newComponent = FlatTabbedPaneUI.this._pane.getComponentAt(selectedIndex);
                if (newComponent != null && newComponent != visibleComponent && visibleComponent != null && this.findFocusOwner(visibleComponent) != null) {
                    changeFocus = true;
                }
                FlatTabbedPaneUI.this.setVisibleComponent(newComponent);
            }
            return changeFocus;
        }

        @Override
        public void layoutContainer(Container parent) {
            boolean changeFocus = this.updateVisibleComponent();
            int tabAreaWidth = FlatTabbedPaneUI.this.getTabAreaWidth();
            int tabAreaHeight = FlatTabbedPaneUI.this._pane.getTabCount() * FlatTabbedPaneUI.this.calculateMaxTabWidthAndHeight().height + FlatTabbedPaneUI.this._tabAreaInsets.top + FlatTabbedPaneUI.this._tabAreaInsets.bottom;
            Insets insets = parent.getInsets();
            int width = parent.getWidth() - (insets.left + insets.right);
            int height = parent.getHeight() - (insets.top + insets.bottom);
            tabAreaHeight = Math.max(height, tabAreaHeight);
            if (tabAreaHeight > height) {
                Dimension buttonPs = FlatTabbedPaneUI.this._previous.getPreferredSize();
                FlatTabbedPaneUI.this._next.setSize(buttonPs);
                FlatTabbedPaneUI.this._previous.setSize(buttonPs);
                int buttonY = parent.getHeight() - insets.bottom - buttonPs.height - FlatTabbedPaneUI.this._buttonAreaInsets.bottom;
                int buttonX = insets.left + tabAreaWidth - FlatTabbedPaneUI.this._buttonAreaInsets.right - buttonPs.width - FlatTabbedPaneUI.this._buttonGap - buttonPs.width;
                FlatTabbedPaneUI.this._previous.setLocation(buttonX, buttonY);
                FlatTabbedPaneUI.this._next.setLocation(buttonX += FlatTabbedPaneUI.this._buttonGap + buttonPs.width, buttonY);
                tabAreaHeight = height - FlatTabbedPaneUI.this._buttonAreaInsets.top - FlatTabbedPaneUI.this._buttonAreaInsets.bottom - buttonPs.height;
            } else {
                FlatTabbedPaneUI.this._next.setLocation(-1, 1);
                FlatTabbedPaneUI.this._next.setSize(0, 0);
                FlatTabbedPaneUI.this._previous.setLocation(-1, -1);
                FlatTabbedPaneUI.this._previous.setSize(0, 0);
            }
            FlatTabbedPaneUI.this._tabViewport.setBounds(insets.left, insets.top, tabAreaWidth, tabAreaHeight);
            width -= tabAreaWidth;
            for (int i = 0; i < FlatTabbedPaneUI.this._pane.getTabCount(); ++i) {
                FlatTabbedPaneUI.this._pane.getComponentAt(i).setBounds(insets.left + FlatTabbedPaneUI.this._tabViewport.getWidth() + FlatTabbedPaneUI.this._contentBorderInsets.left, insets.top + FlatTabbedPaneUI.this._contentBorderInsets.top, width - (FlatTabbedPaneUI.this._contentBorderInsets.left + FlatTabbedPaneUI.this._contentBorderInsets.right), height - (FlatTabbedPaneUI.this._contentBorderInsets.top + FlatTabbedPaneUI.this._contentBorderInsets.bottom));
            }
            if (changeFocus && !FlatTabbedPaneUI.this.requestFocusForVisibleComponent()) {
                FlatTabbedPaneUI.this.tabPane.requestFocus();
            }
        }
    }
}

