/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.list;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.javatools.ui.list.SimpleListModel;

public class ListEditor {
    private JList list;
    private final JTextField field = new JTextField();
    private final JPopupMenu popup = new JPopupMenu();
    private final Listener listener = new Listener();
    private State state = State.INACTIVE;

    public ListEditor(JList list) {
        this.popup.add(this.field);
        this.popup.setBorder(BorderFactory.createEmptyBorder());
        this.field.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ListEditor.this.commit();
                    ListEditor.this.popup.setVisible(false);
                } else if (e.getKeyCode() == 27) {
                    ListEditor.this.cancel();
                } else if (e.getKeyCode() == 38) {
                    ListEditor.this.commit();
                    ListEditor.this.popup.setVisible(false);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int sel = ListEditor.this.list.getSelectedIndex();
                            if (sel > 0) {
                                ListEditor.this.list.setSelectedIndex(sel - 1);
                            }
                        }
                    });
                } else if (e.getKeyCode() == 40) {
                    ListEditor.this.commit();
                    ListEditor.this.popup.setVisible(false);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int sel = ListEditor.this.list.getSelectedIndex();
                            if (sel < ListEditor.this.list.getModel().getSize() - 1) {
                                ListEditor.this.list.setSelectedIndex(sel + 1);
                            }
                        }
                    });
                }
            }
        });
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ListEditor.this.commit();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                ListEditor.this.commit();
            }
        });
        this.list = list;
        list.setPrototypeCellValue("W");
        new EditListener(list);
    }

    public void edit(int row) {
        if (row < 0 || !this.list.isEnabled()) {
            return;
        }
        this.list.ensureIndexIsVisible(row);
        this.field.setText(this.list.getModel().getElementAt(row).toString());
        JComponent rendererComp = (JComponent)this.list.getCellRenderer().getListCellRendererComponent(this.list, this.list.getModel().getElementAt(row), row, false, false);
        this.field.setFont(rendererComp.getFont());
        this.field.setForeground(rendererComp.getForeground());
        this.field.setBackground(rendererComp.getBackground());
        Insets insets = rendererComp.getInsets();
        this.field.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getColor("TextField.shadow")), BorderFactory.createEmptyBorder(Math.max(0, insets.top - 1), Math.max(0, insets.left - 1), Math.max(0, insets.bottom - 1), Math.max(0, insets.right - 1))));
        Rectangle bounds = this.list.getCellBounds(row, row);
        this.field.setPreferredSize(new Dimension((int)this.list.getVisibleRect().getWidth(), (int)bounds.getHeight()));
        this.field.selectAll();
        this.popup.show(this.list, (int)bounds.getX() + 1, (int)bounds.getY());
        this.setState(State.ACTIVE);
        this.field.requestFocus();
    }

    public void commit() {
        if (this.state == State.INACTIVE) {
            return;
        }
        this.setState(State.INACTIVE);
        int row = this.list.getSelectedIndex();
        if (this.list.getModel() instanceof DefaultListModel) {
            ((DefaultListModel)this.list.getModel()).setElementAt(this.field.getText(), row);
        } else if (this.list.getModel() instanceof SimpleListModel) {
            SimpleListModel model = (SimpleListModel)this.list.getModel();
            model.removeIndices(new int[]{row});
            model.insertAt(row, this.field.getText());
        } else {
            throw new IllegalStateException("Editable Lists must contain models of type DefaultListModel,or SimpleListModel. Found: " + this.list.getModel().getClass());
        }
        this.popup.setVisible(false);
    }

    public void cancel() {
        this.setState(State.INACTIVE);
        this.popup.setVisible(false);
    }

    private void setState(State state) {
        if (state == this.state) {
            return;
        }
        this.state = state;
        if (state == State.ACTIVE) {
            this.listener.attach();
        } else if (state == State.INACTIVE) {
            this.listener.detach();
        }
    }

    private class Listener
    extends WindowAdapter
    implements ComponentListener {
        private Listener() {
        }

        public void attach() {
            Window w = SwingUtilities.getWindowAncestor(ListEditor.this.list);
            w.addWindowListener(this);
            w.addComponentListener(this);
        }

        public void detach() {
            Window w = SwingUtilities.getWindowAncestor(ListEditor.this.list);
            w.removeWindowListener(this);
            w.removeComponentListener(this);
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            ListEditor.this.commit();
        }

        @Override
        public void windowLostFocus(WindowEvent e) {
            ListEditor.this.commit();
        }

        @Override
        public void windowClosing(WindowEvent e) {
            ListEditor.this.commit();
        }

        @Override
        public void componentResized(ComponentEvent e) {
            ListEditor.this.commit();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            ListEditor.this.commit();
        }
    }

    private static enum State {
        INACTIVE,
        ACTIVE;

    }

    private class EditListener
    extends MouseAdapter {
        private long selectionChangeTime = 0L;
        private final long TIME_BETWEEN_SELECTION_AND_EDIT = 250L;

        EditListener(final JList list) {
            list.addMouseListener(this);
            list.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    EditListener.this.selectionChangeTime = System.currentTimeMillis();
                }
            });
            String ENTER = "enter";
            list.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0, false), "enter");
            list.getActionMap().put("enter", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ListEditor.this.edit(list.getSelectedIndex());
                }
            });
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (System.currentTimeMillis() > this.selectionChangeTime + 250L) {
                ListEditor.this.edit(ListEditor.this.list.getSelectedIndex());
            }
        }
    }
}

