/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.infotip.templates;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.OverlayLayout;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import net.miginfocom.swing.MigLayout;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.EmptyIcon;
import oracle.javatools.ui.SpaceDecoratorIcon;
import oracle.javatools.ui.SuperLabel;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.BasicTemplate;
import oracle.javatools.ui.infotip.templates.ItemTemplate;
import oracle.javatools.ui.plaf.IconicButtonUI;

public final class SingleItemTemplate
extends BasicTemplate
implements ItemTemplate {
    public static final String CONFIGURE = "Configure";
    public static final String SUBMENU = "Submenu";
    private final SuperLabel titleLabel = new SuperLabel();
    private final DescriptionPane descriptionArea = new DescriptionPane();
    private final JScrollPane scrollPane = new JScrollPane();
    private final List<JComponent> expansionComponents = new ArrayList<JComponent>();
    private final Map<String, JMenu> menus = new LinkedHashMap<String, JMenu>();
    private boolean expanded = false;
    private static final int MAX_VISIBLE_ROWS = 16;
    private static final int PREFERRED_WIDTH = 400;

    public SingleItemTemplate(Severity severity, String title, String description, List<? extends Action> actions, InfoTipStyles infoTipStyle) {
        this(severity, title, description, actions, infoTipStyle, -1);
    }

    public SingleItemTemplate(Severity severity, String title, String description, List<? extends Action> actions, final InfoTipStyles infoTipStyle, int maxWidth) {
        super(new JPanel((LayoutManager)new MigLayout("insets 0, gapx 2, gapy 2, hidemode 3, fill, nogrid")));
        SpaceDecoratorIcon severityIcon;
        int FIX_ITEM_INDENT = 12;
        Border emptyBorder0 = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        Border emptyBorder1 = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        Border emptyBorder01 = BorderFactory.createEmptyBorder(0, 1, 0, 1);
        this.content.setOpaque(false);
        Icon errorIcon = infoTipStyle.scaleIcon(OracleIcons.getIcon((String)"error.png"));
        Icon warnIcon = infoTipStyle.scaleIcon(OracleIcons.getIcon((String)"warning.png"));
        Icon icon = infoTipStyle.scaleIcon(OracleIcons.getIcon((String)"incompletestatus.png"));
        Icon assistIcon = infoTipStyle.scaleIcon(OracleIcons.getIcon((String)"assist.png"));
        Icon fixIcon = infoTipStyle.scaleIcon(OracleIcons.getIcon((String)"fix.png"));
        int width = Math.max(Math.max(Math.max(errorIcon.getIconWidth(), warnIcon.getIconWidth()), Math.max(icon.getIconWidth(), assistIcon.getIconWidth())), fixIcon.getIconWidth());
        int height = Math.max(Math.max(Math.max(errorIcon.getIconHeight(), warnIcon.getIconHeight()), Math.max(icon.getIconHeight(), assistIcon.getIconHeight())), fixIcon.getIconHeight());
        switch (severity) {
            case ERROR: {
                severityIcon = new SpaceDecoratorIcon(errorIcon, width, height);
                break;
            }
            case WARNING: {
                severityIcon = new SpaceDecoratorIcon(warnIcon, width, height);
                break;
            }
            case INCOMPLETE: {
                severityIcon = new SpaceDecoratorIcon(icon, width, height);
                break;
            }
            default: {
                return;
            }
        }
        assistIcon = new SpaceDecoratorIcon(assistIcon, width, height);
        fixIcon = new SpaceDecoratorIcon(fixIcon, width, height);
        EmptyIcon emptyIcon = new EmptyIcon(width, height);
        JLabel severityIconLabel = new JLabel(severityIcon, 2);
        severityIconLabel.setVerticalAlignment(1);
        severityIconLabel.setAlignmentY(0.0f);
        severityIconLabel.setBorder(emptyBorder0);
        this.titleLabel.setLabelOverride(true);
        this.titleLabel.setPreferredWrapWidth(Math.max(400, maxWidth));
        this.titleLabel.setForeground(infoTipStyle.getItemTextColor());
        this.titleLabel.setFont(infoTipStyle.getItemTitleFont());
        this.titleLabel.setText(title);
        this.titleLabel.setBorder(emptyBorder1);
        this.titleLabel.setHorizontalAlignment(2);
        this.titleLabel.setVerticalAlignment(0);
        this.titleLabel.setAlignmentX(0.0f);
        this.titleLabel.setAlignmentY(0.5f);
        this.descriptionArea.setText(description);
        this.descriptionArea.setBorder(emptyBorder1);
        this.descriptionArea.setAlignmentX(0.0f);
        this.descriptionArea.setAlignmentY(0.0f);
        this.scrollPane.setBorder(emptyBorder0);
        this.scrollPane.setOpaque(false);
        this.scrollPane.getViewport().setOpaque(false);
        this.scrollPane.setViewportView(this.descriptionArea);
        this.scrollPane.setAlignmentX(0.0f);
        this.scrollPane.setAlignmentY(0.0f);
        this.content.add((Component)severityIconLabel, "grow 0, alignx left, aligny top");
        this.content.add((Component)this.titleLabel, "alignx left, width 100%, growy, aligny baseline");
        if (description != null && description.length() > 0) {
            JButton moreOrLessButton = new JButton(UIBundle.get("INFO_TIP_MORE"), null);
            moreOrLessButton.setFocusable(false);
            moreOrLessButton.setOpaque(false);
            moreOrLessButton.setContentAreaFilled(false);
            moreOrLessButton.setFont(moreOrLessButton.getFont().deriveFont(9.0f));
            moreOrLessButton.setBorder(null);
            moreOrLessButton.setForeground(infoTipStyle.getMoreTextColor());
            moreOrLessButton.setHorizontalAlignment(4);
            moreOrLessButton.setVerticalAlignment(3);
            moreOrLessButton.setAlignmentX(1.0f);
            moreOrLessButton.setAlignmentY(1.0f);
            moreOrLessButton.addActionListener(ae -> {
                this.toggleExpansion();
                moreOrLessButton.setText(UIBundle.get(this.expanded ? "INFO_TIP_LESS" : "INFO_TIP_MORE"));
            });
            this.content.add((Component)moreOrLessButton, "gapleft 16, alignx left, aligny bottom, grow 0");
        }
        if (description != null && description.length() > 0) {
            JLabel emptyIconLabel = new JLabel(emptyIcon, 0);
            emptyIconLabel.setHorizontalAlignment(0);
            emptyIconLabel.setVerticalAlignment(0);
            emptyIconLabel.setAlignmentX(0.0f);
            emptyIconLabel.setAlignmentY(0.5f);
            emptyIconLabel.setVisible(this.expanded);
            emptyIconLabel.setBorder(emptyBorder0);
            this.scrollPane.setVisible(this.expanded);
            this.expansionComponents.add(emptyIconLabel);
            this.expansionComponents.add(this.scrollPane);
            this.content.add((Component)emptyIconLabel, "newline, alignx left, aligny top, grow 0");
            this.content.add((Component)this.scrollPane, "gapleft 12, gapbottom 4, alignx left, aligny top, wmin 400, grow");
        }
        for (final Action action : actions) {
            JLabel fixIconLabel = new JLabel(fixIcon, 0);
            fixIconLabel.setHorizontalAlignment(0);
            fixIconLabel.setVerticalAlignment(0);
            fixIconLabel.setAlignmentX(0.0f);
            fixIconLabel.setAlignmentY(0.5f);
            fixIconLabel.setBorder(emptyBorder0);
            final SuperLabel fixItem = new SuperLabel((String)action.getValue("Name"));
            fixItem.setLabelOverride(true);
            fixItem.setPreferredWrapWidth(Math.max(400, maxWidth));
            fixItem.setBackground(null);
            fixItem.setOpaque(false);
            fixItem.setBorder(emptyBorder1);
            fixItem.setForeground(infoTipStyle.getHyperLinkTextColor(false));
            fixItem.setEnabled(action.isEnabled());
            fixItem.setHorizontalAlignment(2);
            fixItem.setVerticalAlignment(0);
            fixItem.setAlignmentX(0.0f);
            fixItem.setAlignmentY(0.5f);
            final Font normal = fixItem.getFont();
            Map<TextAttribute, ?> attributes = normal.getAttributes();
            attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            final Font underlined = normal.deriveFont(attributes);
            String menuName = (String)action.getValue(SUBMENU);
            if (menuName == null) {
                Icon configureIcon = infoTipStyle.scaleIcon(OracleIcons.getIcon((String)"configure.png"));
                final JButton configureButton = new JButton(configureIcon);
                IconicButtonUI.install(configureButton);
                configureButton.setToolTipText(UIBundle.get("INFO_TIP_CONFIGURE"));
                configureButton.setVisible(false);
                configureButton.setBorder(emptyBorder1);
                configureButton.setOpaque(false);
                configureButton.setHorizontalAlignment(4);
                configureButton.setVerticalAlignment(0);
                configureButton.setAlignmentX(1.0f);
                configureButton.setAlignmentY(0.5f);
                this.content.add((Component)fixIconLabel, "newline, alignx left, aligny center, grow 0");
                this.content.add((Component)fixItem, "gapbottom 1, gapleft 12, alignx left, aligny center, grow");
                this.content.add((Component)configureButton, "gapleft 0, align right, aligny center, grow 0");
                if (!action.isEnabled()) continue;
                MouseAdapter fixMouseAdapter = new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        fixItem.setFont(underlined);
                        fixItem.setForeground(infoTipStyle.getHyperLinkTextColor(true));
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        fixItem.setFont(normal);
                        fixItem.setForeground(infoTipStyle.getHyperLinkTextColor(false));
                        configureButton.setVisible(false);
                    }

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        SingleItemTemplate.this.fireActionPerformed("closeInfotipCommand");
                        action.actionPerformed(new ActionEvent(fixItem, 1001, "transform"));
                    }
                };
                fixIconLabel.addMouseListener(fixMouseAdapter);
                fixItem.addMouseListener(fixMouseAdapter);
                configureButton.addActionListener(e -> {
                    if (action.isEnabled()) {
                        action.actionPerformed(new ActionEvent(fixItem, 1001, CONFIGURE));
                    }
                });
                configureButton.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        fixItem.setFont(underlined);
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        fixItem.setFont(normal);
                        configureButton.setVisible(false);
                    }
                });
                continue;
            }
            final JMenu menu = this.menus.computeIfAbsent(menuName, s -> new JMenu(""));
            final JMenuItem menuItem = new JMenuItem(action);
            menuItem.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    menuItem.setFont(underlined);
                    menuItem.setForeground(infoTipStyle.getHyperLinkTextColor(true));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    menuItem.setFont(normal);
                    menuItem.setForeground(infoTipStyle.getHyperLinkTextColor(false));
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    menu.setPopupMenuVisible(false);
                    SingleItemTemplate.this.fireActionPerformed("closeInfotipCommand");
                }
            });
            menu.add(menuItem);
        }
        for (Map.Entry entry : this.menus.entrySet()) {
            JLabel assistIconLabel = new JLabel(assistIcon, 0);
            assistIconLabel.setHorizontalAlignment(0);
            assistIconLabel.setVerticalAlignment(0);
            assistIconLabel.setAlignmentX(0.0f);
            assistIconLabel.setAlignmentY(0.5f);
            assistIconLabel.setBorder(emptyBorder0);
            String menuName = (String)entry.getKey();
            final JMenu menu = (JMenu)entry.getValue();
            menu.setBackground(null);
            menu.setOpaque(false);
            menu.setForeground(infoTipStyle.getHyperLinkTextColor(false));
            menu.setEnabled(true);
            int PAD_RIGHT = 10;
            menu.setBorder(emptyBorder01);
            menu.setMargin(new Insets(0, 0, 0, 0));
            menu.setIconTextGap(0);
            menu.setHorizontalAlignment(2);
            menu.setVerticalAlignment(0);
            menu.setAlignmentX(0.0f);
            menu.setAlignmentY(0.5f);
            final JLabel menuLabel = new JLabel(menuName);
            menuLabel.setBorder(emptyBorder01);
            menuLabel.setIconTextGap(0);
            menuLabel.setBackground(null);
            menuLabel.setOpaque(false);
            menuLabel.setForeground(infoTipStyle.getHyperLinkTextColor(false));
            menuLabel.setHorizontalAlignment(2);
            menuLabel.setVerticalAlignment(0);
            menu.setAlignmentX(0.0f);
            menu.setAlignmentY(0.5f);
            JPanel menuPanel = new JPanel();
            menuPanel.setBackground(null);
            menuPanel.setOpaque(false);
            menuPanel.setBorder(emptyBorder0);
            OverlayLayout overlay = new OverlayLayout(menuPanel);
            menuPanel.setLayout(overlay);
            menuPanel.setAlignmentX(0.0f);
            menuPanel.setAlignmentY(0.5f);
            menuPanel.add(menu);
            menuPanel.add(menuLabel);
            final Font normal = menu.getFont();
            Map<TextAttribute, ?> attributes = normal.getAttributes();
            attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            final Font underlined = normal.deriveFont(attributes);
            menu.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    menuLabel.setFont(underlined);
                    menuLabel.setForeground(infoTipStyle.getHyperLinkTextColor(true));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    menuLabel.setFont(normal);
                    menuLabel.setForeground(infoTipStyle.getHyperLinkTextColor(false));
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getButton() != 1) {
                        return;
                    }
                    if (menu.isPopupMenuVisible()) {
                        menu.setPopupMenuVisible(false);
                    } else {
                        menu.getPopupMenu().show(menu, menu.getWidth() - 10 + 3, 0);
                    }
                }
            });
            this.content.add((Component)assistIconLabel, "newline, alignx left, aligny center");
            this.content.add((Component)menuPanel, "gapbottom 2, gapleft 12, alignx left, aligny center, grow, pad 0 0 0 10");
        }
    }

    public Collection<JMenu> getMenus() {
        return this.menus.values();
    }

    private void toggleExpansion() {
        this.expanded = !this.expanded;
        for (JComponent c : this.expansionComponents) {
            c.setVisible(this.expanded);
        }
        this.fireActionPerformed("sizeChangedCommand");
    }

    @Override
    public int getPreferredWidth() {
        return this.titleLabel.getPreferredSize().width;
    }

    @Override
    public void setPreferredWidth(int width) {
        this.descriptionArea.setSize(width, 99999999);
        Dimension prefSize = this.descriptionArea.getPreferredSize();
        this.descriptionArea.setPreferredSize(prefSize);
        int rowHeight = this.descriptionArea.getFontMetrics(this.descriptionArea.getFont()).getHeight();
        int height = Math.min(rowHeight * 16, this.descriptionArea.getPreferredSize().height);
        Insets insets = this.scrollPane.getInsets();
        this.scrollPane.setPreferredSize(new Dimension(width, height + insets.top + insets.bottom));
    }

    public static enum Severity {
        ERROR,
        WARNING,
        INCOMPLETE;

    }

    private static class DescriptionPane
    extends JEditorPane {
        public DescriptionPane() {
            super("text/html", "");
            this.setEditable(false);
            this.setOpaque(false);
            this.setForeground(UIManager.getColor("Label.foreground"));
            this.setBackground(UIManager.getColor("Label.background"));
            Font font = this.getFont();
            StyleSheet stylesheet = ((HTMLDocument)this.getDocument()).getStyleSheet();
            stylesheet.addRule("body {font-size: " + font.getSize() + "pt;font-family: " + font.getFamily() + ";font-weight: " + (font.isBold() ? "bold" : "normal") + ";font-style: " + (font.isItalic() ? "italic" : "normal") + ";color: #" + Integer.toHexString(this.getForeground().getRGB() & 0xFFFFFF) + "}");
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return true;
        }
    }
}

