/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.infotip.templates;

import java.awt.Font;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.javatools.ui.segmented.Segment;
import oracle.javatools.ui.segmented.SegmentedControl;

public class SegmentedControlTooltipTemplate
implements SegmentedControl.InfoTipTemplate {
    private JPanel contentPane;
    private JLabel titleLb;
    private JLabel descLb;
    private Map<Segment, String> titleMap;
    private Map<Segment, String> descMap;
    final int TITLE_DESC_GAP = 3;

    public SegmentedControlTooltipTemplate(Map<Segment, String> titleMap, Map<Segment, String> descMap) {
        if (titleMap == null && descMap == null) {
            throw new IllegalArgumentException("Both titleMap and descMap are null.");
        }
        this.titleMap = titleMap;
        this.descMap = descMap;
        this.contentPane = new JPanel();
        this.contentPane.setOpaque(false);
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
        if (titleMap != null) {
            this.titleLb = new JLabel();
            if (this.titleLb.getFont() != null) {
                Font titleFt = this.titleLb.getFont().deriveFont(1);
                this.titleLb.setFont(titleFt);
            }
            this.contentPane.add(this.titleLb);
        }
        if (titleMap != null && descMap != null) {
            this.contentPane.add(Box.createVerticalStrut(3));
        }
        if (descMap != null) {
            this.descLb = new JLabel();
            this.contentPane.add(this.descLb);
        }
    }

    @Override
    public JComponent getContent() {
        return this.contentPane;
    }

    public void setSegment(Segment s) {
        if (this.titleMap != null) {
            String titleText = this.titleMap.get(s);
            titleText = titleText == null ? "" : titleText;
            this.titleLb.setText(titleText);
        }
        if (this.descMap != null) {
            String descText = this.descMap.get(s);
            descText = descText == null ? "" : descText;
            this.descLb.setText(descText);
        }
    }
}

