/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.infotip.templates;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import oracle.javatools.ui.HyperlinkButton;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.infotip.InfoTipHover;
import oracle.javatools.ui.infotip.templates.Template;

public final class ColorTemplate
implements Template {
    private Color color;
    private final boolean selectable;
    private InfoTipHover hover = null;
    private final List<ActionListener> listeners = new CopyOnWriteArrayList<ActionListener>();
    private final ColorComponent colorComponent = new ColorComponent();
    public static final String ACTION_CHOSEN = "chosen";

    public ColorTemplate(Color color, boolean selectable) {
        this.color = color;
        this.selectable = selectable;
    }

    @Override
    public JComponent getContent() {
        if (!this.selectable) {
            return this.colorComponent;
        }
        JPanel content = new JPanel((LayoutManager)new MigLayout("ins 0, nogrid, hidemode 3"));
        content.setOpaque(false);
        final JPanel choosePanel = new JPanel((LayoutManager)new MigLayout("ins 0, fillx, alignx right, nogrid"));
        choosePanel.setOpaque(false);
        choosePanel.setVisible(false);
        final ColorComponent previewColorComponent = new ColorComponent();
        HyperlinkButton chooseButton = new HyperlinkButton(UIBundle.get("INFOTIP_COLOR_PICKER_CHOOSE"));
        chooseButton.setFocusable(false);
        chooseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<ActionListener> ls = new ArrayList<ActionListener>(ColorTemplate.this.listeners);
                ColorTemplate.this.hover.hideHover();
                ActionEvent ae = new ActionEvent(ColorTemplate.this, 1001, ColorTemplate.ACTION_CHOSEN);
                for (ActionListener listener : ls) {
                    listener.actionPerformed(ae);
                }
            }
        });
        choosePanel.add(previewColorComponent);
        choosePanel.add(chooseButton);
        final JColorChooser colorChooser = new JColorChooser(this.color);
        colorChooser.setOpaque(false);
        colorChooser.setPreviewPanel(new JPanel());
        colorChooser.setVisible(false);
        colorChooser.getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ColorTemplate.this.color = colorChooser.getColor();
                ColorTemplate.this.colorComponent.repaint();
                previewColorComponent.repaint();
            }
        });
        ColorTemplate.makeTransparent(colorChooser);
        final HyperlinkButton selectButton = new HyperlinkButton(UIBundle.get("INFOTIP_COLOR_PICKER_SELECT"));
        selectButton.setFocusable(false);
        selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                colorChooser.setVisible(true);
                selectButton.setVisible(false);
                ColorTemplate.this.colorComponent.setVisible(false);
                choosePanel.setVisible(true);
                ColorTemplate.this.hover.ensureVisible();
            }
        });
        content.add(this.colorComponent);
        content.add(selectButton);
        content.add(colorChooser);
        content.add((Component)choosePanel, "newline, alignx right");
        return content;
    }

    private static void makeTransparent(JComponent comp) {
        comp.setOpaque(false);
        for (Component c : comp.getComponents()) {
            if (!(c instanceof JComponent)) continue;
            ColorTemplate.makeTransparent((JComponent)c);
        }
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setHover(InfoTipHover hover) {
        assert (hover != null);
        this.hover = hover;
    }

    public void addActionListener(ActionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }

    private class ColorComponent
    extends JComponent {
        ColorComponent() {
            this.setPreferredSize(new Dimension(24, 16));
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(Color.WHITE);
            g2.fillRoundRect(1, 1, this.getWidth() - 2, this.getHeight() - 2, 4, 4);
            g2.setColor(ColorTemplate.this.color);
            g2.fillRoundRect(1, 1, this.getWidth() - 2, this.getHeight() - 2, 4, 4);
            g2.setColor(Color.LIGHT_GRAY);
            g2.drawRoundRect(1, 1, this.getWidth() - 2, this.getHeight() - 2, 4, 4);
        }
    }
}

