/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.combo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.javatools.ui.combo.FixListComboModel;
import oracle.javatools.ui.combo.JCustomComboBox;

public class JFixListCombo
extends JCustomComboBox {
    private JList scrollList;
    private JList fixList;
    private JScrollPane sp;
    private boolean fixListBelow = true;
    private int visibleRowCount = 10;

    public JFixListCombo() {
        this.init();
    }

    public JFixListCombo(ListModel scrollModel, ListModel fixedModel) {
        this.init();
        this.setModel(scrollModel, fixedModel);
    }

    public void setModel(ListModel scrollModel, ListModel fixedModel) {
        FixListComboModel flcModel = new FixListComboModel(this.scrollList, this.fixList, this.fixListBelow);
        super.setModel(flcModel);
        this.scrollList.setModel(scrollModel);
        this.fixList.setModel(fixedModel);
    }

    public void setRenderer(ListCellRenderer aRenderer) {
        super.setRenderer(aRenderer);
        if (this.fixList != null) {
            this.fixList.setCellRenderer(aRenderer);
            this.scrollList.setCellRenderer(aRenderer);
        }
    }

    private void init() {
        JPanel panel = new JPanel(new BorderLayout());
        this.scrollList = new JList();
        this.scrollList.setFocusable(false);
        this.fixList = new JList();
        this.fixList.setFocusable(false);
        this.fixList.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("List.foreground")));
        this.sp = new JScrollPane(this.scrollList, 20, 30);
        this.sp.setBorder(BorderFactory.createEmptyBorder());
        this.setPopupComponent(panel);
        this._addListsToPopup();
        ListMouseListener lml = new ListMouseListener();
        this.fixList.addMouseMotionListener(lml);
        this.scrollList.addMouseMotionListener(lml);
        ListClickListener lcl = new ListClickListener();
        this.fixList.addMouseListener(lcl);
        this.scrollList.addMouseListener(lcl);
        SingleListSelectionListener slsl = new SingleListSelectionListener();
        this.fixList.addListSelectionListener(slsl);
        this.scrollList.addListSelectionListener(slsl);
    }

    private void _addListsToPopup() {
        JComponent panel = this.getPopupComponent();
        if (this.fixListBelow) {
            panel.add((Component)this.sp, "North");
            panel.add((Component)this.fixList, "South");
        } else {
            panel.add((Component)this.fixList, "North");
            panel.add((Component)this.sp, "South");
        }
    }

    public boolean getFixListBelow() {
        return this.fixListBelow;
    }

    public void setFixListBelow(boolean fixListBelow) {
        if (fixListBelow == this.fixListBelow) {
            return;
        }
        this.fixListBelow = fixListBelow;
        this.getPopupComponent().removeAll();
        this._addListsToPopup();
        ((FixListComboModel)this.getModel()).setFixListBelow(this.fixListBelow);
    }

    public JList getScrollableList() {
        return this.scrollList;
    }

    public JList getFixList() {
        return this.fixList;
    }

    protected void updatePopupPreferredSize() {
        int visibleScrollRowCount = this.visibleRowCount - this.fixList.getModel().getSize();
        this.scrollList.setVisibleRowCount(Math.min(visibleScrollRowCount, this.scrollList.getModel().getSize()));
        this.sp.validate();
        int minViewWidth = this.getWidth();
        if (visibleScrollRowCount < this.scrollList.getModel().getSize()) {
            minViewWidth -= this.sp.getVerticalScrollBar().getPreferredSize().width + 1;
        }
        if (this.sp.getViewport().getWidth() < minViewWidth) {
            this.sp.getViewport().setPreferredSize(new Dimension(minViewWidth - 2, this.sp.getViewport().getPreferredSize().height));
        }
    }

    @Override
    public void firePopupMenuWillBecomeVisible() {
        this.updatePopupPreferredSize();
        Object selObj = this.getSelectedItem();
        ((FixListComboModel)this.getModel()).setSelectedItem(selObj);
        super.firePopupMenuWillBecomeVisible();
    }

    public void setVisibleRowCount(int visibleRowCount) {
        this.visibleRowCount = visibleRowCount;
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    private class ListMouseListener
    extends MouseMotionAdapter {
        private ListMouseListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JList list = (JList)e.getSource();
            int index = list.locationToIndex(e.getPoint());
            list.setSelectedIndex(index);
        }
    }

    private class ListClickListener
    extends MouseAdapter {
        private ListClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JList list = (JList)e.getSource();
            int index = list.locationToIndex(e.getPoint());
            if (e.getSource() == JFixListCombo.this.fixList) {
                index += JFixListCombo.this.scrollList.getModel().getSize();
            }
            JFixListCombo.this.setSelectedIndex(index);
            JFixListCombo.this.hidePopup();
        }
    }

    private class SingleListSelectionListener
    implements ListSelectionListener {
        private SingleListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getSource() == JFixListCombo.this.scrollList && JFixListCombo.this.scrollList.getSelectedIndex() >= 0) {
                JFixListCombo.this.fixList.clearSelection();
            }
            if (e.getSource() == JFixListCombo.this.fixList && JFixListCombo.this.fixList.getSelectedIndex() >= 0) {
                JFixListCombo.this.scrollList.clearSelection();
            }
        }
    }
}

