/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.combo;

import java.util.LinkedList;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataListener;
import javax.swing.table.DefaultTableModel;

public class CheckComboModel
extends DefaultTableModel
implements ComboBoxModel {
    public static final int COLUMN_SEL = 0;
    public static final int COLUMN_ITEM = 1;
    private ListModel _listModel;
    private ListSelectionModel _selModel;

    public CheckComboModel(ListModel listModel, ListSelectionModel selModel) {
        super(listModel.getSize(), 2);
        this._listModel = listModel;
        this._selModel = selModel;
    }

    public CheckComboModel(ListModel listModel) {
        this(listModel, new DefaultListSelectionModel());
    }

    public Object[] getSelectedItem() {
        LinkedList selList = new LinkedList();
        for (int i = this._selModel.getMinSelectionIndex(); i <= this._selModel.getMaxSelectionIndex(); ++i) {
            if (!this._selModel.isSelectedIndex(i)) continue;
            selList.add(this._listModel.getElementAt(i));
        }
        return selList.toArray();
    }

    @Override
    public void setSelectedItem(Object anItem) {
        if (anItem instanceof Object[]) {
            for (Object obj : (Object[])anItem) {
                for (int i = 0; i < this._listModel.getSize(); ++i) {
                    if (this._listModel.getElementAt(i) != obj) continue;
                    this._selModel.addSelectionInterval(i, i);
                }
            }
        }
    }

    @Override
    public void addListDataListener(ListDataListener l) {
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
    }

    @Override
    public Object getElementAt(int index) {
        return this._listModel.getElementAt(index);
    }

    @Override
    public int getSize() {
        return this._listModel.getSize();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        if (this._listModel == null) {
            return 0;
        }
        return this._listModel.getSize();
    }

    @Override
    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                return this._selModel.isSelectedIndex(row);
            }
            case 1: {
                return this._listModel.getElementAt(row);
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 0;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
    }

    public ListModel getListModel() {
        return this._listModel;
    }

    public ListSelectionModel getSelectionModel() {
        return this._selModel;
    }
}

