/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.checktree;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class TriStateNode
extends DefaultMutableTreeNode {
    private NodeState nodeState = NodeState.NO;
    private ArrayList<PropertyChangeListener> _pcListeners = new ArrayList();
    private boolean readOnly = false;
    public static final String PROP_STATE_CHANGE = "PROP_STATE_CHANGE";
    public static final String PROP_READONLY_CHANGE = "PROP_READONLY_CHANGE";

    public TriStateNode(Object userData) {
        super(userData);
    }

    public void setReadOnly(boolean readOnly) {
        if (readOnly == this.readOnly) {
            return;
        }
        this.readOnly = readOnly;
        this.firePropertyChange(PROP_READONLY_CHANGE, !readOnly, readOnly);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setNodeState(NodeState nodeState) {
        this.setNodeState(nodeState, true, true);
    }

    public void setNodeState(NodeState nodeState, boolean propagateStateUp, boolean propagateStateDown) {
        if (this.nodeState == nodeState) {
            return;
        }
        this.nodeState = nodeState;
        if (propagateStateDown) {
            this.propagateChangeDown(nodeState);
        }
        if (propagateStateUp) {
            this.propagateChangeUp();
        }
        this.firePropertyChange(PROP_STATE_CHANGE, null, (Object)nodeState);
    }

    public NodeState getNodeState() {
        return this.nodeState;
    }

    private void propagateChangeUp() {
        if (this.getParent() == null) {
            return;
        }
        TriStateNode parent = (TriStateNode)this.getParent();
        boolean hasYes = false;
        boolean hasNo = false;
        boolean hasPartial = false;
        for (int i = 0; i < parent.getChildCount(); ++i) {
            TriStateNode childNode = (TriStateNode)parent.getChildAt(i);
            if (childNode.getNodeState() == NodeState.YES) {
                hasYes = true;
                continue;
            }
            if (childNode.getNodeState() == NodeState.NO) {
                hasNo = true;
                continue;
            }
            if (childNode.getNodeState() != NodeState.PARTIAL) continue;
            hasPartial = true;
        }
        if (hasYes && hasNo) {
            parent.setNodeState(NodeState.PARTIAL, true, false);
        } else if (hasPartial) {
            parent.setNodeState(NodeState.PARTIAL, true, false);
        } else if (hasNo && !hasYes && !hasPartial) {
            parent.setNodeState(NodeState.NO, true, false);
        } else if (hasYes && !hasNo && !hasPartial) {
            parent.setNodeState(NodeState.YES, true, false);
        }
    }

    private void propagateChangeDown(NodeState state) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            TriStateNode childNode = (TriStateNode)this.getChildAt(i);
            childNode.setNodeState(state, false, true);
        }
    }

    public void sort() {
        if (this.children == null || this.children.size() < 2) {
            return;
        }
        Collections.sort(this.children);
        for (TreeNode child : this.children) {
            if (!(child instanceof TriStateNode)) continue;
            ((TriStateNode)child).sort();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (!this._pcListeners.contains(pcl)) {
            this._pcListeners.add(pcl);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this._pcListeners.remove(pcl);
    }

    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
        PropertyChangeEvent pce = new PropertyChangeEvent(this, name, oldValue, newValue);
        for (PropertyChangeListener pcl : this._pcListeners) {
            pcl.propertyChange(pce);
        }
    }

    public Icon getIcon() {
        return null;
    }

    public String getLabel() {
        return this.toString();
    }

    public static enum NodeState {
        NO,
        YES,
        PARTIAL;

    }
}

