/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.checktree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import oracle.bali.ewt.olaf2.OracleLookAndFeel;
import oracle.javatools.ui.TriStateCheckBox;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.checktree.TriStateNode;
import oracle.javatools.ui.internal.UICUtils;

public class CheckboxTree
extends JTree {
    private static final Border focusBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, UIManager.getColor("Tree.selectionBorderColor"));
    private static final Border normalBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private boolean readOnly = false;

    public CheckboxTree() {
        this._init();
    }

    public CheckboxTree(TreeModel model) {
        super(model);
        this._init();
    }

    @Override
    public void setModel(TreeModel model) {
        super.setModel(model);
    }

    private void _init() {
        this.setToggleClickCount(0);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                TreePath path = CheckboxTree.this.getSelectionPath();
                if (path != null && e.getKeyCode() == 32 && path.getLastPathComponent() instanceof TriStateNode) {
                    if (CheckboxTree.this.isReadOnly()) {
                        return;
                    }
                    TriStateNode node = (TriStateNode)path.getLastPathComponent();
                    if (node.isReadOnly()) {
                        return;
                    }
                    if (node.getNodeState() == TriStateNode.NodeState.YES) {
                        node.setNodeState(TriStateNode.NodeState.NO);
                    } else {
                        node.setNodeState(TriStateNode.NodeState.YES);
                    }
                    CheckboxTree.this.repaint();
                    CheckboxTree.this.fireAccessibleChange(path);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Rectangle pathBounds;
                TreePath path = CheckboxTree.this.getPathForLocation(e.getX(), e.getY());
                if (path != null && (pathBounds = CheckboxTree.this.getPathBounds(path)).contains(e.getPoint())) {
                    if (CheckboxTree.this.isReadOnly()) {
                        return;
                    }
                    CheckboxCellRenderer renderer = (CheckboxCellRenderer)CheckboxTree.this.getCellRenderer();
                    Rectangle rect = renderer.contentPanel.checkbox.getBounds();
                    rect.translate(pathBounds.x, pathBounds.y);
                    if (!rect.contains(e.getPoint())) {
                        return;
                    }
                    if (path.getLastPathComponent() instanceof TriStateNode) {
                        TriStateNode node = (TriStateNode)path.getLastPathComponent();
                        if (node.isReadOnly()) {
                            return;
                        }
                        if (node.getNodeState() == TriStateNode.NodeState.YES) {
                            node.setNodeState(TriStateNode.NodeState.NO);
                        } else {
                            node.setNodeState(TriStateNode.NodeState.YES);
                        }
                        CheckboxTree.this.repaint();
                        CheckboxTree.this.fireAccessibleChange(path);
                    }
                }
            }
        });
        this.setCellRenderer(new CheckboxCellRenderer());
    }

    private void fireAccessibleChange(TreePath path) {
        this.setSelectionPath(null);
        this.setSelectionPath(path);
    }

    public void setReadOnly(boolean readOnly) {
        if (readOnly == this.readOnly) {
            return;
        }
        this.readOnly = readOnly;
        this.firePropertyChange("read-only", !readOnly, readOnly);
        this.repaint();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new OracleLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
        TriStateNode root = new TriStateNode("Lunch");
        final TriStateNode sandwiches = new TriStateNode("Sandwiches");
        TriStateNode cheese = new TriStateNode("Cheese");
        TriStateNode beef = new TriStateNode("Beef");
        TriStateNode ham = new TriStateNode("Ham");
        root.add(sandwiches);
        sandwiches.add(cheese);
        sandwiches.add(beef);
        sandwiches.add(ham);
        cheese.add(new TriStateNode("With Pickle"));
        cheese.add(new TriStateNode("With Onion"));
        beef.add(new TriStateNode("With Mustard"));
        beef.add(new TriStateNode("With Horseradish"));
        beef.add(new TriStateNode("With Onions"));
        TriStateNode drink = new TriStateNode("Drinks");
        TriStateNode tea = new TriStateNode("Tea");
        TriStateNode cola = new TriStateNode("Cola");
        root.add(drink);
        drink.add(tea);
        drink.add(cola);
        tea.add(new TriStateNode("With Honey"));
        tea.add(new TriStateNode("With Sugar"));
        cola.add(new TriStateNode("Coke"));
        cola.add(new TriStateNode("Pepsi"));
        DefaultTreeModel model = new DefaultTreeModel(root);
        final CheckboxTree tree = new CheckboxTree(model);
        for (int row = 0; tree.getRowCount() > row; ++row) {
            tree.expandRow(row);
        }
        JScrollPane sp = new JScrollPane(tree);
        sp.setPreferredSize(new Dimension(180, 320));
        JPanel controlPanel = new JPanel((LayoutManager)new MigLayout("ins 0 4 0 4"));
        controlPanel.setOpaque(false);
        final JCheckBox readOnlyCheck = new JCheckBox("Read Only", false);
        readOnlyCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                tree.setReadOnly(readOnlyCheck.isSelected());
            }
        });
        readOnlyCheck.setOpaque(false);
        controlPanel.add(readOnlyCheck);
        final JCheckBox partialReadOnlyCheck = new JCheckBox("Partial Read Only (Sandwiches)", false);
        partialReadOnlyCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                sandwiches.setReadOnly(partialReadOnlyCheck.isSelected());
                tree.repaint();
            }
        });
        partialReadOnlyCheck.setOpaque(false);
        controlPanel.add((Component)partialReadOnlyCheck, "newline");
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)sp, "Center");
        content.add((Component)controlPanel, "East");
        UICUtils.runComponent(content);
    }

    private class CheckboxCellRenderer
    implements TreeCellRenderer {
        private ContentPanel contentPanel = new ContentPanel();
        private ContentPanel accessibleContentPanel = new ContentPanel();

        private CheckboxCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            ContentPanel c = this.contentPanel;
            if (!SwingUtilities.isEventDispatchThread() && CheckboxTree.this.isShowing()) {
                c = this.accessibleContentPanel;
            }
            this.updateContent(c, tree, value, selected);
            return c.content;
        }

        public void updateContent(ContentPanel content, JTree tree, Object value, boolean selected) {
            boolean readOnly = CheckboxTree.this.isReadOnly();
            if (value instanceof TriStateNode) {
                TriStateNode node = (TriStateNode)value;
                if (node.isReadOnly()) {
                    readOnly = true;
                }
                TriStateCheckBox.State oldState = content.checkbox.getState();
                String oldText = content.label.getText();
                if (node.getNodeState() == TriStateNode.NodeState.YES) {
                    content.checkbox.setState(TriStateCheckBox.State.TRUE);
                } else if (node.getNodeState() == TriStateNode.NodeState.NO) {
                    content.checkbox.setState(TriStateCheckBox.State.FALSE);
                } else {
                    content.checkbox.setState(TriStateCheckBox.State.PARTIAL);
                }
                String newText = node.getLabel();
                content.label.setText(newText);
                content.label.setIcon(node.getIcon());
                if (newText != null && newText.equals(oldText) && oldState != content.checkbox.getState()) {
                    this.updateAccessibleName(node.getLabel(), content.checkbox);
                }
            }
            content.label.setBackground(selected ? UIManager.getColor("Tree.selectionBackground") : tree.getBackground());
            content.label.setForeground(selected ? UIManager.getColor("Tree.selectionForeground") : (!readOnly && CheckboxTree.this.isEnabled() ? tree.getForeground() : UIManager.getColor("Label.disabledForeground")));
            content.label.setBorder(selected ? focusBorder : normalBorder);
        }

        private void updateAccessibleName(String text, TriStateCheckBox checkBox) {
            text = checkBox.isSelected() ? (String)text + " " + AccessibleState.CHECKED.toDisplayString() : UIBundle.format("CHECKABLE_COMBO_UNCHECKED", text);
            checkBox.putClientProperty("AccessibleName", text);
        }

        private class ContentPanel {
            private TriStateCheckBox checkbox = new TriStateCheckBox();
            private JLabel label = new JLabel();
            private JPanel content = new CustomAccessibleJPanel();

            ContentPanel() {
                this.checkbox.setFocusable(false);
                this.checkbox.setOpaque(false);
                this.checkbox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
                this.label.setFocusable(false);
                this.label.setFont(UIManager.getFont("Tree.font"));
                this.label.setOpaque(true);
                this.content.setLayout(new BorderLayout(1, 0));
                this.content.add((Component)this.checkbox, "Before");
                this.content.add((Component)this.label, "After");
                this.content.setOpaque(false);
                this.label.addPropertyChangeListener("text", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getNewValue() == null) {
                            return;
                        }
                        CheckboxCellRenderer.this.updateAccessibleName(evt.getNewValue().toString(), ContentPanel.this.checkbox);
                    }
                });
            }

            private class CustomAccessibleJPanel
            extends JPanel {
                private CustomAccessibleJPanel() {
                }

                @Override
                public AccessibleContext getAccessibleContext() {
                    return ContentPanel.this.checkbox.getAccessibleContext();
                }
            }
        }
    }
}

