/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.checklist;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.javatools.ui.RichHintLabel;
import oracle.javatools.ui.TransparentPanel;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.checklist.ChecklistHelper;
import oracle.javatools.ui.checklist.ChecklistModel;
import oracle.javatools.ui.checklist.ChecklistModelEvent;
import oracle.javatools.ui.checklist.ChecklistModelListener;
import oracle.javatools.ui.checklist.ContentActionEvent;
import oracle.javatools.ui.checklist.ContentActionListener;
import oracle.javatools.ui.checklist.ContentElement;
import oracle.javatools.ui.checklist.DefaultChecklistModel;
import oracle.javatools.ui.checklist.Step;
import oracle.javatools.ui.checklist.StepContent;
import oracle.javatools.ui.checklist.StepHeader;
import oracle.javatools.ui.checklist.StepPanel;

public class Checklist
extends JPanel {
    private static Icon _sBackIcon;
    private ChecklistModel _model;
    private JPanel _topPanel;
    private JPanel _centerPanel;
    private JPanel _bottomPanel;
    private JPanel _stepPanel;
    private HeaderComponent _headerComp;
    private StepHeader _complexStepHeader;
    private ChecklistListener _listener;
    private Action _showAction;
    private Action _hideAction;
    private Action _backAction;
    private HashMap<Step, StepPanel> _stepPanels;
    private Step _selected;
    private Step _expandedStep;
    private RichHintLabel _showAll;
    private RichHintLabel _hideAll;
    private JPanel _back;
    private int _bandRows;
    private Color[] _bandingColors;
    private boolean _substepView;
    private boolean _showStatus = true;
    private ChecklisHeaderBanding _headerBanding;
    private Rectangle _prevVisibleRect;

    public Checklist() {
        this(new DefaultChecklistModel());
    }

    public Checklist(ChecklistModel model) {
        this._createActions();
        this._createUI();
        this.setChecklistModel(model);
    }

    public void setChecklistModel(ChecklistModel model) {
        if (model != this._model) {
            ChecklistModel oldModel = this._model;
            if (this._model != null) {
                this._model.removeChecklistModelListener(this._listener);
                this._removeAllSteps();
            }
            this._model = model;
            if (this._model != null) {
                this._populateModel();
                this._updateShowHide();
                this._model.addChecklistModelListener(this._listener);
            }
            this.firePropertyChange("model", oldModel, this._model);
        }
    }

    public ChecklistModel getChecklistModel() {
        return this._model;
    }

    public void setHeaderIcon(Icon icon) {
        this._headerComp.setIcon(icon);
    }

    public Icon getHeaderIcon() {
        return this._headerComp.getIcon();
    }

    public void setHeaderText(String title) {
        this._headerComp.setTitle(title);
    }

    public String getHeaderText() {
        return this._headerComp.getTitle();
    }

    public void setHeaderDescription(String desc) {
        this._headerComp.setDescription(desc);
    }

    public String getHeaderDescription() {
        return this._headerComp.getDescription();
    }

    public void setStepHeaderBanding(int count, Color ... colors) {
        this._bandingColors = colors;
        this._bandRows = count;
        this.repaint();
    }

    public Color[] getStepHeaderBandingColors() {
        return this._bandingColors;
    }

    public int getStepHeaderBandingCount() {
        return this._bandRows;
    }

    public void setSelectedStep(Step step) {
        if (this._selected != step) {
            Step oldStep = this._selected;
            if (this._selected != null) {
                this._selected.setSelected(false);
            }
            this._selected = step;
            if (this._selected != null) {
                this._selected.setSelected(true);
            }
            this.firePropertyChange("selected", oldStep, this._selected);
        }
    }

    public Step getSelectedStep() {
        return this._selected;
    }

    public void setShowStatus(boolean show) {
        if (show != this.getShowStatus()) {
            this._showStatus = show;
            Iterator<Step> iter = this._stepPanels.keySet().iterator();
            while (iter.hasNext()) {
                this._stepPanels.get(iter.next()).getStepHeader().setShowStatus(this._showStatus);
            }
            if (this._complexStepHeader != null) {
                this._complexStepHeader.setShowStatus(show);
            }
            this.firePropertyChange("showStatus", !this._showStatus, this._showStatus);
        }
    }

    public boolean getShowStatus() {
        return this._showStatus;
    }

    public Step getDrilledDownStep() {
        return this._expandedStep;
    }

    public boolean isSubstepView() {
        return this._substepView;
    }

    public synchronized void addContentActionListener(ContentActionListener l) {
        this.listenerList.add(ContentActionListener.class, l);
    }

    public synchronized void removeContentActionListener(ContentActionListener l) {
        this.listenerList.remove(ContentActionListener.class, l);
    }

    public synchronized ContentActionListener[] getContentActionListener() {
        return (ContentActionListener[])this.listenerList.getListeners(ContentActionListener.class);
    }

    protected StepPanel createDefaultStepPanel(Step step, int index, boolean isSubstep) {
        return new StepPanel(step);
    }

    protected void expandSubsteps(Step step) {
        step.setSelected(true);
        this._complexStepHeader = new StepHeader(step);
        this._complexStepHeader.setShowStatus(this.getShowStatus());
        this._complexStepHeader.setComplexHeader(true);
        this._topPanel.add((Component)((Object)this._complexStepHeader), "South");
        this._stepPanel.removeAll();
        this._addSubsteps(step);
        this._centerPanel.setBorder(BorderFactory.createMatteBorder(0, 6, 0, 6, new Color(217, 217, 217)));
        if (this._backAction == null) {
            this._backAction = new BackAction();
            String backStr = UIBundle.get("CHECKLIST_BACK");
            RichHintLabel text = ChecklistHelper.createLinkLabel("<a class=bold href=\"http:back\">" + backStr + "</a>", "back", this._backAction);
            JButton backButton = new JButton(Checklist._sGetBackIcon());
            backButton.putClientProperty("AccessibleName", backStr);
            backButton.setBorder(null);
            backButton.setContentAreaFilled(false);
            backButton.addActionListener(this._backAction);
            this._back.add((Component)backButton, "West");
            this._back.add(text);
            JButton closeSubstep = new JButton(this._backAction);
            this._bottomPanel.add((Component)closeSubstep, "East");
        }
        MessageFormat format = new MessageFormat(UIBundle.get("CHECKLIST_CLOSE_STEP"));
        Object[] args = new Object[]{step.getIndex() + 1};
        this._backAction.putValue("Name", format.format(args));
        this._back.setVisible(true);
        this._bottomPanel.setVisible(true);
        this._expandedStep = step;
        this._substepView = true;
        this._updateShowHide();
        this.revalidate();
        this.repaint();
    }

    protected void collapseSubsteps() {
        this._topPanel.remove((Component)((Object)this._complexStepHeader));
        this._complexStepHeader = null;
        this._stepPanel.removeAll();
        this._addRootSteps();
        this._centerPanel.setBorder(null);
        this._bottomPanel.setVisible(false);
        this._back.setVisible(false);
        this._expandedStep = null;
        this._substepView = false;
        this._updateShowHide();
        this.revalidate();
        this.repaint();
    }

    protected void fireContentActionPerformed(ContentElement elem) {
        Object[] listeners = this.listenerList.getListenerList();
        ContentActionEvent event = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ContentActionListener.class) continue;
            if (event == null) {
                event = new ContentActionEvent(this, elem);
            }
            ((ContentActionListener)listeners[i + 1]).contentActionPerformed(event);
        }
    }

    private static Icon _sGetBackIcon() {
        if (_sBackIcon == null) {
            _sBackIcon = new ImageIcon(ImageUtils.getImageResource(Checklist.class, (String)"icons/back.png"));
        }
        return _sBackIcon;
    }

    private void _createUI() {
        this.setLayout(new BorderLayout());
        this._topPanel = this._createHeaderPanel();
        this.add((Component)this._topPanel, "North");
        this._centerPanel = this.createCenterPanel();
        this.add(this._centerPanel);
        this._bottomPanel = this._createBottomButtonBar();
        this._bottomPanel.setVisible(false);
        this.add((Component)this._bottomPanel, "South");
        this.setBackground(Color.white);
        this.setStepHeaderBanding(1, new Color(247, 247, 247), Color.white);
    }

    private JPanel _createHeaderPanel() {
        TransparentPanel p = this._createNavigationPanel();
        this._headerComp = new HeaderComponent();
        p.add((Component)this._headerComp, "North");
        return p;
    }

    private TransparentPanel _createNavigationPanel() {
        TransparentPanel navPanel = new TransparentPanel();
        navPanel.setLayout(new BorderLayout(0, 4));
        this._showAll = ChecklistHelper.createLinkLabel("<a href=\"http:showAllAction\">" + UIBundle.get("CHECKLIST_SHOWALL") + "</a>", "showAllAction", this._showAction);
        this._hideAll = ChecklistHelper.createLinkLabel("<a href=\"http:showAllAction\">" + UIBundle.get("CHECKLIST_HIDEALL") + "</a>", "showAllAction", this._hideAction);
        this._showAll.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, new Color(49, 106, 196)), BorderFactory.createEmptyBorder(0, 0, 0, 4)));
        TransparentPanel showHidePanel = new TransparentPanel();
        showHidePanel.setLayout(new BorderLayout(2, 0));
        showHidePanel.add((Component)this._showAll, "West");
        showHidePanel.add((Component)this._hideAll, "East");
        this._back = new JPanel(new BorderLayout(6, 0));
        this._back.setVisible(false);
        navPanel.add((Component)showHidePanel, "East");
        navPanel.add((Component)this._back, "West");
        return navPanel;
    }

    private JPanel createCenterPanel() {
        this._stepPanel = new StepsPanel();
        this._stepPanel.setOpaque(false);
        this._stepPanel.setLayout(new StepLayout());
        this._stepPanels = new HashMap();
        JScrollPane scroll = new JScrollPane(this._stepPanel);
        scroll.setOpaque(false);
        scroll.getViewport().setOpaque(false);
        scroll.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.add(scroll);
        return panel;
    }

    private JPanel _createBottomButtonBar() {
        JPanel footer = new JPanel(new BorderLayout());
        footer.setBorder(BorderFactory.createEmptyBorder(8, 6, 6, 6));
        footer.setBackground(new Color(217, 217, 217));
        return footer;
    }

    private void _createActions() {
        this._listener = new ChecklistListener();
        this._showAction = new ShowHideAction(true);
        this._hideAction = new ShowHideAction(false);
    }

    private void _populateModel() {
        for (int i = 0; i < this._model.getStepCount(); ++i) {
            this._addStep(this._model.getStepAt(i), i, false);
        }
    }

    private void _addRootSteps() {
        for (int i = 0; i < this._model.getStepCount(); ++i) {
            this._addStepPanel(this._model.getStepAt(i), i, false);
        }
    }

    private void _addStep(Step step, int index, boolean isSubstep) {
        step.setModel(this._model);
        step.addPropertyChangeListener(this._listener);
        StepContent content = step.getContent();
        if (content != null) {
            content.addContentActionListener(this._listener);
        }
        if (isSubstep) {
            if (this.isSubstepView() && step.getParent() == this.getDrilledDownStep()) {
                this._addStepPanel(step, index, isSubstep);
            }
        } else {
            this._addStepPanel(step, index, isSubstep);
            for (int i = 0; i < step.getSubstepCount(); ++i) {
                this._addStep(step.getSubstepAt(i), i, true);
            }
        }
        if (step.isSelected()) {
            this.setSelectedStep(step);
        }
        this._updateShowHide();
    }

    private void _addStepPanel(Step step, int index, boolean isSubstep) {
        this._stepPanel.add((Component)((Object)this._getStepPanel(step, index, isSubstep)));
    }

    private StepPanel _getStepPanel(Step step, int index, boolean isSubstep) {
        StepPanel panel = this._stepPanels.get(step);
        if (panel == null) {
            panel = this.createDefaultStepPanel(step, index, isSubstep);
            panel.getStepHeader().setHeaderBanding(this._getHeaderBand());
            panel.getStepHeader().setShowStatus(this.getShowStatus());
            this._stepPanels.put(step, panel);
        }
        return panel;
    }

    private StepHeader.HeaderBand _getHeaderBand() {
        if (this._headerBanding == null) {
            this._headerBanding = new ChecklisHeaderBanding();
        }
        return this._headerBanding;
    }

    private void _removeStep(Step step) {
        step.removePropertyChangeListener(this._listener);
        step.getContent().removeContentActionListener(this._listener);
        StepPanel panel = this._stepPanels.get(step);
        if (panel != null) {
            this.remove((Component)((Object)panel));
            this._stepPanels.remove(step);
        }
        this._updateShowHide();
    }

    private void _removeAllSteps() {
        int size = this._model.getStepCount();
        for (int i = 0; i < size; ++i) {
            this._removeStep(this._model.getStepAt(i));
        }
    }

    private Color _getStepHeaderColor(int index) {
        int colorIndex = index / this._bandRows;
        if (this._bandingColors != null && (colorIndex %= this._bandingColors.length) < this._bandingColors.length) {
            return this._bandingColors[colorIndex];
        }
        return null;
    }

    private void _addSubsteps(Step step) {
        for (int i = 0; i < step.getSubstepCount(); ++i) {
            this._addStepPanel(step.getSubstepAt(i), i, true);
        }
    }

    private void _updateShowHide() {
        this._showAll.setEnabled(this._isCollapsed());
        this._hideAll.setEnabled(this._isExpanded());
    }

    private boolean _isExpanded() {
        block3: {
            block2: {
                if (!this.isSubstepView()) break block2;
                Step step = this.getDrilledDownStep();
                if (step == null) break block3;
                for (int i = 0; i < step.getSubstepCount(); ++i) {
                    if (!step.getSubstepAt(i).isExpanded()) continue;
                    return true;
                }
                break block3;
            }
            for (int i = 0; i < this._model.getStepCount(); ++i) {
                if (!this._model.getStepAt(i).isExpanded()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean _isCollapsed() {
        block3: {
            block2: {
                if (!this.isSubstepView()) break block2;
                Step step = this.getDrilledDownStep();
                if (step == null) break block3;
                for (int i = 0; i < step.getSubstepCount(); ++i) {
                    if (step.getSubstepAt(i).isExpanded()) continue;
                    return true;
                }
                break block3;
            }
            for (int i = 0; i < this._model.getStepCount(); ++i) {
                if (this._model.getStepAt(i).isExpanded()) continue;
                return true;
            }
        }
        return false;
    }

    private class ChecklistListener
    implements ChecklistModelListener,
    PropertyChangeListener,
    ContentActionListener {
        private ChecklistListener() {
        }

        @Override
        public void stepAdded(ChecklistModelEvent event) {
            Checklist.this._addStep(event.getStep(), event.getIndex(), event.getStep().getParent() != null);
        }

        @Override
        public void stepRemoved(ChecklistModelEvent event) {
            Checklist.this._removeStep(event.getStep());
        }

        @Override
        public void propertyChange(PropertyChangeEvent pe) {
            if ("selected".equals(pe.getPropertyName())) {
                if (Boolean.TRUE.equals(pe.getNewValue())) {
                    Checklist.this.setSelectedStep((Step)pe.getSource());
                }
            } else if ("expanded".equals(pe.getPropertyName())) {
                Checklist.this._updateShowHide();
            } else if ("drillDownSubsteps".equalsIgnoreCase(pe.getPropertyName())) {
                Step step = (Step)pe.getSource();
                if (Boolean.TRUE.equals(pe.getNewValue())) {
                    Checklist.this._prevVisibleRect = Checklist.this._stepPanel.getVisibleRect();
                    Checklist.this.expandSubsteps(step);
                } else {
                    Checklist.this.collapseSubsteps();
                    if (Checklist.this._prevVisibleRect != null) {
                        Checklist.this._stepPanel.scrollRectToVisible(Checklist.this._prevVisibleRect);
                    }
                }
            } else if ("content".equals(pe.getPropertyName())) {
                StepContent old = (StepContent)pe.getOldValue();
                StepContent newContent = (StepContent)pe.getNewValue();
                if (old != null) {
                    old.removeContentActionListener(this);
                }
                if (newContent != null) {
                    newContent.addContentActionListener(this);
                }
            }
        }

        @Override
        public void contentActionPerformed(ContentActionEvent event) {
            Checklist.this.fireContentActionPerformed(event.getContentElement());
        }
    }

    private class HeaderComponent
    extends JComponent
    implements Accessible {
        private JLabel _headerIcon;
        private JLabel _headerTitle;
        private RichHintLabel _headerDescription;

        private HeaderComponent() {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
            this._headerIcon = new JLabel();
            this._headerTitle = new JLabel();
            this._headerTitle.setFont(this._headerTitle.getFont());
            this._headerDescription = ChecklistHelper.createLinkLabel();
            this.add((Component)this._headerIcon, new GridBagConstraints(0, 0, 1, 0, 0.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this._headerTitle, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 18, 2, new Insets(0, 6, 0, 0), 0, 0));
            this.add((Component)this._headerDescription, new GridBagConstraints(1, 1, 0, 0, 1.0, 1.0, 18, 1, new Insets(6, 6, 0, 0), 0, 0));
        }

        @Override
        public void addNotify() {
            super.addNotify();
            Font f = this._headerTitle.getFont();
            if (f != null && !f.isBold()) {
                this._headerTitle.setFont(f.deriveFont(f.getStyle() ^ 1));
            }
        }

        private void setIcon(Icon icon) {
            Icon oldIcon = this.getIcon();
            if (icon != oldIcon) {
                this._headerIcon.setIcon(icon);
                Checklist.this.firePropertyChange("headerIcon", oldIcon, icon);
            }
        }

        private Icon getIcon() {
            return this._headerIcon.getIcon();
        }

        private void setTitle(String title) {
            String oldTitle = this.getTitle();
            if (title != oldTitle) {
                this._headerTitle.setText(title);
                Checklist.this.firePropertyChange("headerTitle", oldTitle, title);
            }
        }

        private String getTitle() {
            return this._headerTitle.getText();
        }

        private void setDescription(String description) {
            String oldDescription = this.getDescription();
            if (description != oldDescription) {
                this._headerDescription.setText(description);
                Checklist.this.firePropertyChange("headerDescription", oldDescription, description);
            }
        }

        private String getDescription() {
            return this._headerDescription.getText();
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleHeader();
            }
            return this.accessibleContext;
        }

        private class AccessibleHeader
        extends JComponent.AccessibleJComponent {
            private AccessibleHeader() {
                super(HeaderComponent.this);
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.PANEL;
            }
        }
    }

    private class BackAction
    extends AbstractAction {
        private BackAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Step collapseStep = Checklist.this._selected;
            if (collapseStep.getParent() != null) {
                collapseStep.getParent().setSelected(true);
                collapseStep.getParent().setDrillDownSubsteps(false);
            } else if (collapseStep.getDrillDownSubsteps()) {
                collapseStep.setSelected(true);
                collapseStep.setDrillDownSubsteps(false);
            }
        }
    }

    private class StepsPanel
    extends JPanel
    implements Scrollable {
        private StepsPanel() {
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return super.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 20;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return this.getVisibleRect().height;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            int minWidth = this.getMinimumSize().width;
            Container parent = this.getParent();
            if (parent != null && parent.getWidth() < minWidth) {
                Insets inset = parent.getInsets();
                if (parent.getWidth() - inset.left - inset.right < minWidth) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public Dimension getPreferredSize() {
            if (!this.getScrollableTracksViewportWidth()) {
                return this.getMinimumSize();
            }
            return super.getPreferredSize();
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    private class StepLayout
    extends GridBagLayout {
        public StepLayout() {
            this.defaultConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        }

        @Override
        protected void ArrangeGrid(Container parent) {
            Component[] comps;
            StepPanel animatedPanel = null;
            for (Component c : comps = parent.getComponents()) {
                StepPanel spanel;
                if (!(c instanceof StepPanel) || !(spanel = (StepPanel)((Object)c)).isBeingAnimated()) continue;
                animatedPanel = spanel;
                break;
            }
            if (animatedPanel == null) {
                super.ArrangeGrid(parent);
            } else {
                boolean hitAnimatedPanel = false;
                int lastY = 0;
                for (Component c : comps) {
                    if (c == animatedPanel) {
                        c.setBounds(c.getX(), lastY, c.getWidth(), c.getPreferredSize().height);
                    } else if (hitAnimatedPanel) {
                        c.setBounds(c.getX(), lastY, c.getWidth(), c.getHeight());
                    }
                    lastY = c.getY() + c.getHeight();
                }
            }
        }

        @Override
        protected GridBagConstraints lookupConstraints(Component comp) {
            GridBagConstraints gbc = super.lookupConstraints(comp);
            if (comp instanceof StepPanel) {
                StepPanel panel = (StepPanel)((Object)comp);
                Step step = panel.getStep();
                if (step.getParent() == null) {
                    int index;
                    gbc.gridy = index = step.getIndex();
                    if (index == Checklist.this._model.getStepCount() - 1) {
                        gbc.weighty = 1.0;
                    }
                } else {
                    int index;
                    gbc.gridy = index = step.getIndex();
                    if (index == Checklist.this._model.getSubstepCount(step.getParent()) - 1) {
                        gbc.weighty = 1.0;
                    }
                }
            }
            return gbc;
        }
    }

    private class ShowHideAction
    extends AbstractAction {
        private boolean _show;

        public ShowHideAction(boolean show) {
            this._show = show;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (!((Component)ae.getSource()).isEnabled()) {
                return;
            }
            if (Checklist.this.isSubstepView()) {
                Step step = Checklist.this.getSelectedStep();
                if (step.getParent() != null) {
                    step = step.getParent();
                }
                for (int i = 0; i < step.getSubstepCount(); ++i) {
                    step.getSubstepAt(i).setExpanded(this._show);
                }
            } else {
                for (int i = 0; i < Checklist.this._model.getStepCount(); ++i) {
                    Checklist.this._model.getStepAt(i).setExpanded(this._show);
                }
            }
        }
    }

    private class ChecklisHeaderBanding
    implements StepHeader.HeaderBand {
        private ChecklisHeaderBanding() {
        }

        @Override
        public Color getBackground(int index) {
            return Checklist.this._getStepHeaderColor(index);
        }
    }
}

