/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.calendar;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.format.TextStyle;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.javatools.ui.calendar.CalendarModel;

final class TimeDisplayPanel
extends JPanel {
    private CalendarModel model;
    private DateFormat timeFormat;
    private JLabel timeLabel;
    private JLabel timeZoneLabel;

    public TimeDisplayPanel(CalendarModel model) {
        this.model = model;
        this.timeFormat = SimpleDateFormat.getTimeInstance(2, this.getLocale());
        this.timeLabel = new JLabel();
        this.timeZoneLabel = new JLabel();
        this.timeLabel.setHorizontalAlignment(0);
        this.timeLabel.setAlignmentX(0.5f);
        this.timeZoneLabel.setHorizontalAlignment(0);
        this.timeZoneLabel.setAlignmentX(0.5f);
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.timeLabel);
        this.add(this.timeZoneLabel);
        this.updateDisplay();
        model.addPropertyChangeListener(evt -> this.updateDisplay());
    }

    @Override
    public void setLocale(Locale l) {
        super.setLocale(l);
        this.timeFormat = SimpleDateFormat.getTimeInstance(2, this.getLocale());
        this.updateDisplay();
    }

    public void updateDisplay() {
        ZoneId zoneId = this.model.getZoneId();
        Date dateTime = this.model.getDateTime();
        TimeZone timeZone = TimeZone.getTimeZone(zoneId);
        this.timeFormat.setTimeZone(timeZone);
        this.timeLabel.setText(this.timeFormat.format(dateTime));
        this.timeZoneLabel.setText(zoneId.getDisplayName(TextStyle.FULL_STANDALONE, this.getLocale()));
    }

    public void setShowTimeZone(boolean showTimeZone) {
        this.timeZoneLabel.setVisible(showTimeZone);
    }

    public boolean getShowTimeZone() {
        return this.timeZoneLabel.isVisible();
    }

    public void setShowTime(boolean showTimeZone) {
        this.timeLabel.setVisible(showTimeZone);
    }

    public boolean getShowTime() {
        return this.timeLabel.isVisible();
    }
}

