/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.builders;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import oracle.javatools.ui.builders.BuiltTextField;
import oracle.javatools.ui.builders.ExAppBasicPanel;
import oracle.javatools.ui.builders.TextFieldBuilder;

final class ExAppTextFieldPanel
extends ExAppBasicPanel {
    private static BuiltTextField tc;

    ExAppTextFieldPanel() {
        this.selectTextArea.setText("String text = builtTextField.getText();");
    }

    @Override
    protected JComponent createControlPanel() {
        JPanel controlPanel = new JPanel((LayoutManager)new MigLayout("aligny top, ins 5 5 5 16, gapy 2"));
        JButton buildButton = new JButton("Build");
        buildButton.setFont(buildButton.getFont().deriveFont(1));
        buildButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExAppTextFieldPanel.this.build();
            }
        });
        controlPanel.add((Component)new JLabel("Select your configuration, then press:"), "gapbottom 16, span, split");
        controlPanel.add((Component)buildButton, "wrap");
        controlPanel.add(Text.cb);
        controlPanel.add((Component)Text.tf, "wrap");
        controlPanel.add(Label.cb);
        controlPanel.add((Component)Label.tf, "wrap");
        controlPanel.add(new JLabel("Columns: "));
        controlPanel.add((Component)Columns.sp, "wrap");
        controlPanel.add(Prompt.cb);
        controlPanel.add((Component)Prompt.tf, "wrap");
        controlPanel.add(Hint.cb);
        controlPanel.add((Component)Hint.tf, "wrap");
        controlPanel.add((Component)Expands.cb, "wrap");
        controlPanel.add((Component)Editable.cb, "wrap");
        controlPanel.add((Component)Enabled.cb, "wrap");
        controlPanel.add((Component)Completions.cb, "wrap");
        return controlPanel;
    }

    private void build() {
        TextFieldBuilder builder = new TextFieldBuilder();
        StringBuilder createSB = new StringBuilder("");
        StringBuilder selectSB = new StringBuilder("");
        createSB.append("TextFieldBuilder builder = new TextFieldBuilder();\n");
        Text.build(builder, createSB);
        Prompt.build(builder, createSB);
        Hint.build(builder, createSB);
        Label.build(builder, createSB);
        Columns.build(builder, createSB);
        Expands.build(builder, createSB);
        Editable.build(builder, createSB);
        Enabled.build(builder, createSB);
        Completions.build(builder, createSB);
        createSB.append("\nBuiltTextField builtTextField = builder.build();\n\nadd(builtTextField.getGUI());");
        this.constructTextArea.setText(createSB.toString());
        this.updateComponent(builder.build().getGUI());
    }

    @Override
    protected void dump() {
        if (tc != null) {
            System.out.println(tc.getText());
        }
    }

    private static class Text {
        static JCheckBox cb = new JCheckBox("Text");
        static JTextField tf = new JTextField("Text", 20);

        private Text() {
        }

        public static void build(TextFieldBuilder builder, StringBuilder createSB) {
            if (!cb.isSelected()) {
                return;
            }
            builder.setText(tf.getText());
            createSB.append("builder.setText(\"" + tf.getText() + "\");\n");
        }

        static {
            cb.setToolTipText("Set initial text");
        }
    }

    private static class Label {
        static JCheckBox cb = new JCheckBox("Label");
        static JTextField tf = new JTextField("&Label", 20);

        private Label() {
        }

        public static void build(TextFieldBuilder builder, StringBuilder createSB) {
            if (!cb.isSelected()) {
                return;
            }
            builder.setLabel(tf.getText());
            createSB.append("builder.setLabel(\"" + tf.getText() + "\");\n");
        }

        static {
            cb.setToolTipText("Set the label for a field");
        }
    }

    private static class Columns {
        static int def = 20;
        static JSpinner sp = new JSpinner(new SpinnerNumberModel(def, 1, 100, 1));

        private Columns() {
        }

        static void build(TextFieldBuilder builder, StringBuilder createSB) {
            int i = (Integer)sp.getValue();
            if (i != def) {
                builder.setColumns(i);
                createSB.append("builder.setColumns(" + i + ");\n");
            }
        }

        static {
            sp.setToolTipText("The number of columns (characters) wide to make the text field");
        }
    }

    private static class Prompt {
        static JCheckBox cb = new JCheckBox("Prompted");
        static JTextField tf = new JTextField("Prompt", 20);

        private Prompt() {
        }

        public static void build(TextFieldBuilder builder, StringBuilder createSB) {
            if (!cb.isSelected()) {
                return;
            }
            builder.setPrompt(tf.getText());
            createSB.append("builder.setPrompt(\"" + tf.getText() + "\");\n");
        }

        static {
            cb.setToolTipText("Add some prompt text which shows when the text field is empty");
        }
    }

    private static class Hint {
        static JCheckBox cb = new JCheckBox("Hint");
        static JTextField tf = new JTextField("Some hint text", 20);

        private Hint() {
        }

        public static void build(TextFieldBuilder builder, StringBuilder createSB) {
            if (!cb.isSelected()) {
                return;
            }
            builder.setHint(tf.getText());
            createSB.append("builder.setHint(\"" + tf.getText() + "\");\n");
        }

        static {
            cb.setToolTipText("Add some hint text that appears below the text field");
        }
    }

    private static class Expands {
        static boolean def = false;
        static JCheckBox cb = new JCheckBox("Expands", def);

        private Expands() {
        }

        public static void build(TextFieldBuilder builder, StringBuilder createSB) {
            if (cb.isSelected() == def) {
                return;
            }
            builder.setExpands(cb.isSelected());
            createSB.append("builder.setExpands(false);\n");
        }

        static {
            cb.setToolTipText("Field will temporarilly expand when there is too much text to display and it has focus");
        }
    }

    private static class Editable {
        static boolean def = true;
        static JCheckBox cb = new JCheckBox("Editable", def);

        private Editable() {
        }

        public static void build(TextFieldBuilder builder, StringBuilder createSB) {
            if (cb.isSelected() == def) {
                return;
            }
            builder.setEditable(cb.isSelected());
            createSB.append("builder.setEditable(false);\n");
        }

        static {
            cb.setToolTipText("Make the text field read only or editable by the user");
        }
    }

    private static class Enabled {
        static boolean def = true;
        static JCheckBox cb = new JCheckBox("Enabled", def);

        private Enabled() {
        }

        public static void build(TextFieldBuilder builder, StringBuilder createSB) {
            if (cb.isSelected() == def) {
                return;
            }
            builder.setEnabled(cb.isSelected());
            createSB.append("builder.setEnabled(false);\n");
        }

        static {
            cb.setToolTipText("Enable the text field and associated controls");
        }
    }

    private static class Completions {
        static boolean def = false;
        static JCheckBox cb = new JCheckBox("Completion", def);

        private Completions() {
        }

        public static void build(TextFieldBuilder builder, StringBuilder createSB) {
            if (cb.isSelected() == def) {
                return;
            }
            ArrayList<String> completions = new ArrayList<String>();
            for (Locale l : Locale.getAvailableLocales()) {
                if ("".equals(l.getDisplayCountry())) continue;
                completions.add(l.getDisplayCountry());
            }
            Collections.sort(completions);
            builder.setCompletion(completions);
            createSB.append("builder.setCompletion(Collection<String> completions);\n");
        }

        static {
            cb.setToolTipText("Supply a list of completions, matching ones will allpea in a popup as the user types");
        }
    }
}

