/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.builders;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.TreePath;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.TextLayer;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.breadcrumbs.Breadcrumb;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsButton;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsListener;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsModel;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsModelListener;
import oracle.javatools.ui.breadcrumbs.JBreadcrumbs;
import oracle.javatools.ui.builders.BreadcrumbsTableBuilder;
import oracle.javatools.ui.builders.BuiltBreadcrumbsTable;
import oracle.javatools.ui.builders.BuiltTable;
import oracle.javatools.ui.builders.BuiltTableImpl;
import oracle.javatools.ui.builders.TableBuilder;
import oracle.javatools.ui.list.LabelListCellRenderer;
import oracle.javatools.ui.simplestyle.StyledTextAttribute;
import oracle.javatools.ui.simplestyle.StyledTextModel;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.RowHeader;
import oracle.javatools.ui.treetable.NodeTableModelAdapter;
import oracle.javatools.ui.treetable.TreeTableModel;

final class BuiltBreadcrumbsTableImpl<T>
implements BuiltBreadcrumbsTable<T> {
    private BuiltTable<T> builtTable;
    private BreadcrumbsModelImpl breadcrumbsModel;
    private JPanel content = new JPanel(new BorderLayout());
    private JBreadcrumbs breadcrumbs;
    private JComponent trailingComponent;
    private RowHeader rowHeader;
    private NodeTableModelAdapter<T> nodeTableModelAdapter;
    private Action upAction = new UpAction();

    BuiltBreadcrumbsTableImpl(BreadcrumbsTableBuilder.BreadcrumbsTableInstructions instructions) {
        this.content.setOpaque(false);
        TableBuilder builder = new TableBuilder();
        this.nodeTableModelAdapter = new NodeTableModelAdapter(instructions.model, instructions.node);
        builder.setModel(this.nodeTableModelAdapter);
        builder.setTable(new CustomTable());
        this.builtTable = builder.build();
        ((BuiltTableImpl)this.builtTable).getGenericTable().setSelectAllEnabled(false);
        if (!instructions.showColumnSelector) {
            ((BuiltTableImpl)this.builtTable).getGenericTable().setColumnSelectorAvailable(false);
        }
        this.setModel(instructions.model, instructions.node);
        this.rowHeader = new ExpandRowHeader(this.builtTable.getTable());
        this.builtTable.getScrollPane().setRowHeaderView(this.rowHeader);
        if (instructions.breadcrumbMaker == null) {
            instructions.breadcrumbMaker = new DefaultBreadcrumbMaker();
        }
        this.breadcrumbsModel = new BreadcrumbsModelImpl(instructions.breadcrumbMaker);
        this.breadcrumbs = new CustomBreadcrumbs();
        this.breadcrumbs.setModel(this.breadcrumbsModel);
        this.breadcrumbsModel.add(instructions.node);
        this.breadcrumbs.addBreadcrumbsListener(new BreadcrumbsListener(){

            public void breadcrumbClicked(Breadcrumb crumb) {
                BreadcrumbsTableBuilder.TableBreadcrumb tableBreadcrumb = (BreadcrumbsTableBuilder.TableBreadcrumb)crumb;
                BuiltBreadcrumbsTableImpl.this.setSelectedNode(tableBreadcrumb.getUserObject());
            }

            public void breadcrumbContextClicked(Breadcrumb crumb, Point p) {
            }

            public void showBreadcrumbPeek(Breadcrumb crumb, Rectangle peekLocation) {
            }

            @Override
            public void hideBreadcrumbPeek() {
            }

            public void separatorClicked(Breadcrumb crumb, Rectangle separatorBounds) {
            }
        });
        this.breadcrumbsModel.addBreadcrumbsModelListener(new BreadcrumbsModelListener(){

            @Override
            public void breadcrumbsUpdated() {
                BuiltBreadcrumbsTableImpl.this.upAction.setEnabled(BuiltBreadcrumbsTableImpl.this.getBreadcrumbPath().getParentPath() != null);
                if (!BuiltBreadcrumbsTableImpl.this.builtTable.getTable().isShowing()) {
                    BuiltBreadcrumbsTableImpl.this.upAction.setEnabled(false);
                }
            }
        });
        this.trailingComponent = instructions.trailingComponent;
        this.content.add(this.builtTable.getGUI());
    }

    @Override
    public JTable getTable() {
        return this.builtTable.getTable();
    }

    @Override
    public JScrollPane getScrollPane() {
        return this.builtTable.getScrollPane();
    }

    @Override
    public JComponent getGUI() {
        return this.content;
    }

    @Override
    public TextLayer getEmptyTextLayer() {
        return this.builtTable.getEmptyTextLayer();
    }

    @Override
    public ComponentWithTitlebar getComponentWithTitlebar() {
        return null;
    }

    @Override
    public T getSelectedValue() {
        return this.builtTable.getSelectedValue();
    }

    @Override
    public List<T> getSelectedValues() {
        return this.builtTable.getSelectedValues();
    }

    @Override
    public int getSelectedRow() {
        return BuiltTableImpl.getSelectedRowImpl(this.builtTable.getTable());
    }

    @Override
    public List<Integer> getSelectedRows() {
        return BuiltTableImpl.getSelectedRowsImpl(this.builtTable.getTable());
    }

    @Override
    public List<Point> getSelectedCells() {
        return BuiltTableImpl.getSelectedCellsImpl(this.builtTable.getTable());
    }

    @Override
    public int indexOf(T rowObject) {
        T parent = this.getSelectedNode();
        return this.nodeTableModelAdapter.getTreeTableModel().getIndexOfChild(parent, rowObject);
    }

    @Override
    public TreeTableModel getModel() {
        return this.nodeTableModelAdapter.getTreeTableModel();
    }

    public T getNode() {
        return this.nodeTableModelAdapter.getNode();
    }

    @Override
    public void setModel(TreeTableModel model, T node) {
        this.nodeTableModelAdapter = new NodeTableModelAdapter<T>(model, node);
        this.builtTable.getTable().setModel(this.nodeTableModelAdapter);
        this.builtTable.getTable().setRowSorter(new TableRowSorter<NodeTableModelAdapter<T>>(this.nodeTableModelAdapter));
    }

    @Override
    public void setSelectedNode(T node) {
        this.setSelectedNode(node, true);
    }

    @Override
    public void setSelectedNode(T node, boolean scrollToVisible) {
        this.breadcrumbsModel.select(node);
        this.nodeTableModelAdapter.setNode(node);
        this.builtTable.getTable().getRowSorter().allRowsChanged();
        this.builtTable.getTable().getSelectionModel().clearSelection();
        if (this.builtTable.getTable().getRowCount() > 0 && scrollToVisible) {
            this.builtTable.getTable().scrollRectToVisible(this.builtTable.getTable().getCellRect(0, 0, true));
        }
        this.updateFocusAndSelection(node);
    }

    private void updateFocusAndSelection(T node) {
        Component focusedComp;
        boolean setFocusOnBreadcrumbButton = focusedComp instanceof BreadcrumbsButton;
        block0: for (focusedComp = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(); focusedComp != null; focusedComp = focusedComp.getParent()) {
            if (focusedComp != this.content && !(focusedComp instanceof BreadcrumbsButton)) continue;
            for (int i = 0; i < this.breadcrumbsModel.getBreadcrumbCount(); ++i) {
                if (!this.breadcrumbsModel.getBreadcrumb(i).getUserObject().equals(node)) continue;
                this.breadcrumbsModel.select(node);
                if (!setFocusOnBreadcrumbButton) break block0;
                this.breadcrumbs.setFocusedBreadcrumb(i);
                break block0;
            }
        }
    }

    @Override
    public TreePath getBreadcrumbPath() {
        TreePath tp = new TreePath(this.breadcrumbsModel.getBreadcrumbs().toArray());
        return tp;
    }

    @Override
    public void setBreadcrumbPath(TreePath treePath) {
        this.setBreadcrumbPath(treePath, true);
    }

    @Override
    public void setBreadcrumbPath(TreePath treePath, boolean scrollToVisible) {
        this.breadcrumbsModel.set(treePath, scrollToVisible);
    }

    private void expand(int index) {
        if (index < 0) {
            return;
        }
        index = this.builtTable.getTable().getRowSorter().convertRowIndexToModel(index);
        Object newNode = this.getModel().getChild(this.getNode(), index);
        if (this.getModel().getChildCount(newNode) == 0) {
            return;
        }
        this.breadcrumbsModel.add(newNode);
        this.setSelectedNode(newNode);
    }

    @Override
    public JBreadcrumbs getBreadcrumbs() {
        return this.breadcrumbs;
    }

    @Override
    public T getSelectedNode() {
        return this.nodeTableModelAdapter.getNode();
    }

    @Override
    public void addBreadcrumbsModelListener(BreadcrumbsModelListener listener) {
        this.breadcrumbsModel.addBreadcrumbsModelListener(listener);
    }

    @Override
    public void removeBreadcrumbsModelListener(BreadcrumbsModelListener listener) {
        this.breadcrumbsModel.removeBreadcrumbsModelListener(listener);
    }

    @Override
    public int[] getHiddenColumns() {
        return ((BuiltTableImpl)this.builtTable).getGenericTable().getHiddenColumns();
    }

    @Override
    public void setHiddenColumns(int ... hiddenColumns) {
        ((BuiltTableImpl)this.builtTable).getGenericTable().setHiddenColumns(hiddenColumns);
    }

    @Override
    public void setHiddenColumnsVisible(int[] columns) {
        ((BuiltTableImpl)this.builtTable).getGenericTable().setHiddenColumnsVisible(columns);
    }

    private class UpAction
    extends AbstractAction {
        UpAction() {
            super(null, OracleIcons.getIcon((String)"previous_message.png"));
            this.putValue("ShortDescription", UIBundle.get("BREADCRUMBS_NAVIGATE_UP_BUTTON"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath path = BuiltBreadcrumbsTableImpl.this.getBreadcrumbPath();
            if ((path = path.getParentPath()) != null) {
                BuiltBreadcrumbsTableImpl.this.setBreadcrumbPath(path);
            }
        }
    }

    private class CustomTable
    extends GenericTable {
        private JButton upButton;

        private CustomTable() {
        }

        @Override
        protected void configureEnclosingScrollPane() {
            super.configureEnclosingScrollPane();
            JPanel p = new JPanel();
            final JTableHeader header = this.getTableHeader();
            p.add(header);
            p.add(BuiltBreadcrumbsTableImpl.this.breadcrumbs);
            if (BuiltBreadcrumbsTableImpl.this.trailingComponent != null) {
                p.add(BuiltBreadcrumbsTableImpl.this.trailingComponent);
            }
            p.setOpaque(true);
            p.setBackground(BuiltBreadcrumbsTableImpl.this.builtTable.getTable().getBackground());
            p.setLayout(new LayoutManager(){

                @Override
                public void addLayoutComponent(String name, Component comp) {
                }

                @Override
                public void removeLayoutComponent(Component comp) {
                }

                @Override
                public Dimension preferredLayoutSize(Container parent) {
                    Dimension headerPref = header.getPreferredSize();
                    Dimension breadPref = BuiltBreadcrumbsTableImpl.this.breadcrumbs.getPreferredSize();
                    Dimension trailPref = BuiltBreadcrumbsTableImpl.this.trailingComponent == null ? new Dimension(0, 0) : BuiltBreadcrumbsTableImpl.this.trailingComponent.getPreferredSize();
                    Dimension d = new Dimension(Math.max(headerPref.width, breadPref.width + trailPref.width), headerPref.height + Math.max(breadPref.height, trailPref.height));
                    return d;
                }

                @Override
                public Dimension minimumLayoutSize(Container parent) {
                    Dimension headSize = header.getMinimumSize();
                    Dimension breadSize = BuiltBreadcrumbsTableImpl.this.breadcrumbs.getMinimumSize();
                    Dimension trailSize = BuiltBreadcrumbsTableImpl.this.trailingComponent == null ? new Dimension(0, 0) : BuiltBreadcrumbsTableImpl.this.trailingComponent.getMinimumSize();
                    Dimension d = new Dimension(Math.max(headSize.width, breadSize.width + trailSize.width), headSize.height + Math.max(breadSize.height, trailSize.height));
                    return d;
                }

                @Override
                public void layoutContainer(Container parent) {
                    Component corner;
                    int width = BuiltBreadcrumbsTableImpl.this.builtTable.getScrollPane().getViewport().getViewSize().width;
                    JScrollBar vSB = BuiltBreadcrumbsTableImpl.this.builtTable.getScrollPane().getVerticalScrollBar();
                    if (vSB != null && !vSB.isVisible() && (corner = BuiltBreadcrumbsTableImpl.this.builtTable.getScrollPane().getCorner("UPPER_TRAILING_CORNER")) != null) {
                        width -= corner.getWidth();
                    }
                    Dimension headerPref = header.getPreferredSize();
                    header.setBounds(0, 0, width, headerPref.height);
                    Dimension breadPref = BuiltBreadcrumbsTableImpl.this.breadcrumbs.getPreferredSize();
                    if (BuiltBreadcrumbsTableImpl.this.trailingComponent == null) {
                        BuiltBreadcrumbsTableImpl.this.breadcrumbs.setBounds(0, headerPref.height, width, breadPref.height);
                    } else {
                        Dimension trailPref = BuiltBreadcrumbsTableImpl.this.trailingComponent.getPreferredSize();
                        BuiltBreadcrumbsTableImpl.this.breadcrumbs.setBounds(0, headerPref.height, width - trailPref.width, breadPref.height);
                        BuiltBreadcrumbsTableImpl.this.trailingComponent.setBounds(width - trailPref.width, headerPref.height, trailPref.width, trailPref.height);
                    }
                }
            });
            BuiltBreadcrumbsTableImpl.this.builtTable.getScrollPane().setColumnHeaderView(p);
            this.configureCorners();
        }

        private void configureCorners() {
            JTable table = BuiltBreadcrumbsTableImpl.this.builtTable.getTable();
            this.upButton = new JButton(BuiltBreadcrumbsTableImpl.this.upAction);
            this.upButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 0));
            this.upButton.setPreferredSize(new Dimension(20, 14));
            this.upButton.setRolloverEnabled(true);
            this.upButton.setOpaque(true);
            this.upButton.setBackground(table.getBackground());
            this.upButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent me) {
                    CustomTable.this.upButton.setOpaque(true);
                }

                @Override
                public void mouseExited(MouseEvent me) {
                    CustomTable.this.upButton.setOpaque(false);
                }
            });
            this.upButton.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    CustomTable.this.upButton.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                }

                @Override
                public void focusLost(FocusEvent e) {
                    CustomTable.this.upButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 0));
                }
            });
            this.upButton.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent ke) {
                    if (ke.getKeyCode() == 40 && BuiltBreadcrumbsTableImpl.this.builtTable.getTable().getRowCount() > 0) {
                        BuiltBreadcrumbsTableImpl.this.rowHeader.requestFocus();
                        BuiltBreadcrumbsTableImpl.this.rowHeader.setSelectedIndex(0);
                        ke.consume();
                    } else if (ke.getKeyCode() == 39 && BuiltBreadcrumbsTableImpl.this.breadcrumbsModel.getBreadcrumbCount() > 0) {
                        BuiltBreadcrumbsTableImpl.this.breadcrumbs.setFocusedBreadcrumb(0);
                    }
                }
            });
            JPanel leftCornerPanel = new JPanel(new BorderLayout());
            leftCornerPanel.setOpaque(true);
            leftCornerPanel.setBackground(table.getBackground());
            leftCornerPanel.add(Box.createVerticalStrut(table.getTableHeader().getPreferredSize().height), "North");
            leftCornerPanel.add((Component)this.upButton, "Center");
            leftCornerPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, UIManager.getColor("Table.gridColor")));
            BuiltBreadcrumbsTableImpl.this.builtTable.getScrollPane().setCorner("UPPER_LEADING_CORNER", leftCornerPanel);
            JPanel rightCornerPanel = new JPanel(new BorderLayout());
            rightCornerPanel.setOpaque(true);
            rightCornerPanel.setBackground(table.getBackground());
            Component selector = BuiltBreadcrumbsTableImpl.this.builtTable.getScrollPane().getCorner("UPPER_TRAILING_CORNER");
            if (selector != null) {
                rightCornerPanel.add(selector, "Center");
            }
            rightCornerPanel.add(Box.createVerticalStrut(15), "South");
            BuiltBreadcrumbsTableImpl.this.builtTable.getScrollPane().setCorner("UPPER_TRAILING_CORNER", rightCornerPanel);
        }

        @Override
        protected void processKeyEvent(KeyEvent e) {
            if (e.getID() == 401) {
                if (e.getKeyCode() == 38 && !e.isControlDown() && BuiltBreadcrumbsTableImpl.this.breadcrumbsModel.getBreadcrumbCount() > 0 && BuiltBreadcrumbsTableImpl.this.builtTable.getSelectedRow() == 0) {
                    BuiltBreadcrumbsTableImpl.this.breadcrumbs.requestFocus();
                    BuiltBreadcrumbsTableImpl.this.breadcrumbs.setFocusedBreadcrumb(BuiltBreadcrumbsTableImpl.this.breadcrumbsModel.getBreadcrumbCount() - 1);
                } else if (e.getKeyCode() == 38 && e.isControlDown()) {
                    this.upButton.doClick();
                } else if (this.getSelectedColumn() == 0 && (e.getKeyCode() == 37 || e.getKeyCode() == 9 && e.isShiftDown())) {
                    BuiltBreadcrumbsTableImpl.this.rowHeader.requestFocus();
                    BuiltBreadcrumbsTableImpl.this.rowHeader.setSelectedIndex(this.getSelectedRow());
                } else if (this.getSelectedColumn() == this.getColumnCount() - 1 && e.getKeyCode() == 39) {
                    BuiltBreadcrumbsTableImpl.this.rowHeader.requestFocus();
                } else if (this.getSelectedColumn() == this.getColumnCount() - 1 && (e.getKeyCode() == 39 || e.getKeyCode() == 9 && !e.isShiftDown())) {
                    BuiltBreadcrumbsTableImpl.this.rowHeader.requestFocus();
                    int row = this.getSelectedRow() == this.getRowCount() - 1 ? 0 : this.getSelectedRow() + 1;
                    BuiltBreadcrumbsTableImpl.this.rowHeader.setSelectedIndex(row);
                } else {
                    super.processKeyEvent(e);
                }
            } else {
                super.processKeyEvent(e);
            }
        }
    }

    private class ExpandRowHeader
    extends RowHeader {
        private ExpandRowHeader(JTable table) {
            super(table);
            this.setCellRenderer(new ExpandableRowHeaderRenderer());
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int index = ExpandRowHeader.this.locationToIndex(e.getPoint());
                    if (index != -1 && ExpandRowHeader.this.getCellBounds(index, index).contains(e.getPoint())) {
                        BuiltBreadcrumbsTableImpl.this.expand(index);
                    }
                }
            });
        }

        @Override
        protected void processKeyEvent(KeyEvent e) {
            if (e.getID() == 401) {
                CustomTable table = (CustomTable)BuiltBreadcrumbsTableImpl.this.builtTable.getTable();
                int rowCount = table.getRowCount();
                int colCount = table.getColumnCount();
                if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                    int index = this.getSelectedIndex();
                    BuiltBreadcrumbsTableImpl.this.expand(index);
                    this.repaint();
                } else if (e.getKeyCode() == 38 && e.isControlDown()) {
                    table.upButton.doClick();
                } else if (e.getKeyCode() == 38 && !e.isControlDown() && table.getSelectedRow() == 0) {
                    if (table.upButton.isEnabled()) {
                        table.upButton.requestFocus();
                    }
                } else if (e.getKeyCode() == 39 || e.getKeyCode() == 9 && !e.isShiftDown()) {
                    table.requestFocus();
                    if (rowCount > 0 && colCount > 0) {
                        table.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
                    }
                } else if (e.getKeyCode() == 37) {
                    table.requestFocus();
                    if (rowCount > 0 && colCount > 0) {
                        table.getColumnModel().getSelectionModel().setSelectionInterval(0, colCount - 1);
                    }
                } else if (e.getKeyCode() == 9 && e.isShiftDown()) {
                    table.requestFocus();
                    if (rowCount > 0 && colCount > 0) {
                        int row = table.getSelectedRow() == 0 ? rowCount - 1 : table.getSelectedRow() - 1;
                        table.getSelectionModel().setSelectionInterval(row, row);
                        table.getColumnModel().getSelectionModel().setSelectionInterval(0, colCount - 1);
                    }
                } else {
                    super.processKeyEvent(e);
                }
            } else {
                super.processKeyEvent(e);
            }
        }

        @Override
        public boolean isManagingFocus() {
            return true;
        }

        private class ExpandableRowHeaderRenderer
        extends LabelListCellRenderer {
            private ExpandableRowHeaderRenderer() {
                this.setHorizontalAlignment(0);
            }

            public void formatLabel(JLabel label, JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                AccessibleContext ac;
                label.setIcon(UIManager.getIcon("Tree.collapsedIcon"));
                label.setPreferredSize(new Dimension(18, BuiltBreadcrumbsTableImpl.this.builtTable.getTable().getRowHeight(index)));
                Border border = cellHasFocus ? UIManager.getBorder("Table.focusCellHighlightBorder") : BorderFactory.createMatteBorder(0, 0, 0, 1, BuiltBreadcrumbsTableImpl.this.builtTable.getTable().getGridColor());
                label.setBorder(border);
                int filteredIndex = BuiltBreadcrumbsTableImpl.this.builtTable.getTable().convertRowIndexToModel(index);
                if (filteredIndex == -1) {
                    return;
                }
                int modelIndex = BuiltBreadcrumbsTableImpl.this.builtTable.getTable().convertRowIndexToModel(index);
                if (!BuiltBreadcrumbsTableImpl.this.nodeTableModelAdapter.isExpandable(modelIndex)) {
                    label.setIcon(null);
                }
                if ((ac = label.getAccessibleContext()) != null) {
                    ac.setAccessibleName(UIBundle.format("ACCESSIBLE_ROW_HEADER", index + 1));
                }
            }
        }
    }

    private static class DefaultBreadcrumbMaker
    implements BreadcrumbsTableBuilder.BreadcrumbMaker {
        private DefaultBreadcrumbMaker() {
        }

        public BreadcrumbsTableBuilder.TableBreadcrumb createBreadcrumb(Object node) {
            DefaultTableBreadcrumb crumb = new DefaultTableBreadcrumb(node);
            return crumb;
        }

        private static class DefaultTableBreadcrumb
        implements BreadcrumbsTableBuilder.TableBreadcrumb {
            private Object node;
            private Font boldFont = UIManager.getFont("Label.font").deriveFont(1);

            private DefaultTableBreadcrumb(Object node) {
                this.node = node;
            }

            @Override
            public StyledTextModel getShortName() {
                StyledTextAttribute attr = new StyledTextAttribute(this.boldFont, null);
                StyledTextModel text = new StyledTextModel(this.node.toString(), attr);
                return text;
            }

            @Override
            public StyledTextModel getLongName() {
                return this.getShortName();
            }

            @Override
            public Object getUserObject() {
                return this.node;
            }

            @Override
            public boolean hasChildren() {
                return false;
            }
        }
    }

    private class BreadcrumbsModelImpl
    implements BreadcrumbsModel {
        private BreadcrumbsTableBuilder.BreadcrumbMaker<T> breadcrumbConstructor;
        private List<BreadcrumbsTableBuilder.TableBreadcrumb<T>> crumbs = new ArrayList();
        private CopyOnWriteArrayList<BreadcrumbsModelListener> listeners = new CopyOnWriteArrayList();

        private BreadcrumbsModelImpl(BreadcrumbsTableBuilder.BreadcrumbMaker<T> breadcrumbConstructor) {
            this.breadcrumbConstructor = breadcrumbConstructor;
        }

        List<T> getBreadcrumbs() {
            ArrayList list = new ArrayList();
            for (BreadcrumbsTableBuilder.TableBreadcrumb crumb : this.crumbs) {
                list.add(crumb.getUserObject());
            }
            return list;
        }

        private void add(T node) {
            BreadcrumbsTableBuilder.TableBreadcrumb crumb = this.breadcrumbConstructor.createBreadcrumb(node);
            this.crumbs.add(crumb);
            this.fireBreadcrumbsEvent();
            BuiltBreadcrumbsTableImpl.this.builtTable.getTable().getRowSorter().allRowsChanged();
        }

        private void set(TreePath tp, boolean scrollToVisible) {
            this.crumbs.clear();
            for (Object o : tp.getPath()) {
                BreadcrumbsTableBuilder.TableBreadcrumb<Object> crumb = this.breadcrumbConstructor.createBreadcrumb(o);
                this.crumbs.add(crumb);
                this.fireBreadcrumbsEvent();
            }
            BuiltBreadcrumbsTableImpl.this.setSelectedNode(tp.getLastPathComponent(), scrollToVisible);
            BuiltBreadcrumbsTableImpl.this.builtTable.getTable().getRowSorter().allRowsChanged();
        }

        private void select(T node) {
            ArrayList newList = new ArrayList();
            for (BreadcrumbsTableBuilder.TableBreadcrumb crumb : this.crumbs) {
                newList.add(crumb);
                if (!crumb.getUserObject().equals(node)) continue;
                break;
            }
            this.crumbs = newList;
            this.fireBreadcrumbsEvent();
        }

        @Override
        public int getBreadcrumbCount() {
            return this.crumbs.size();
        }

        @Override
        public BreadcrumbsTableBuilder.TableBreadcrumb getBreadcrumb(int crumb) {
            return this.crumbs.get(crumb);
        }

        @Override
        public boolean hasChildren(Breadcrumb breadcrumb) {
            return ((BreadcrumbsTableBuilder.TableBreadcrumb)breadcrumb).hasChildren();
        }

        @Override
        public void addBreadcrumbsModelListener(BreadcrumbsModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeBreadcrumbsModelListener(BreadcrumbsModelListener l) {
            this.listeners.remove(l);
        }

        private void fireBreadcrumbsEvent() {
            for (BreadcrumbsModelListener l : this.listeners) {
                l.breadcrumbsUpdated();
            }
        }
    }

    private class CustomBreadcrumbs
    extends JBreadcrumbs {
        private CustomBreadcrumbs() {
        }

        @Override
        protected BreadcrumbsButton createBreadcrumbButton(int index) {
            BreadcrumbsButton breadcrumbButton = super.createBreadcrumbButton(index);
            breadcrumbButton.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent ke) {
                    if (ke.getKeyCode() == 40 && BuiltBreadcrumbsTableImpl.this.builtTable.getTable().getRowCount() > 0) {
                        BuiltBreadcrumbsTableImpl.this.builtTable.getTable().getSelectionModel().setSelectionInterval(0, 0);
                        BuiltBreadcrumbsTableImpl.this.builtTable.getTable().scrollRectToVisible(BuiltBreadcrumbsTableImpl.this.builtTable.getTable().getCellRect(0, 0, true));
                        BuiltBreadcrumbsTableImpl.this.rowHeader.requestFocus();
                        ke.consume();
                    } else if (ke.getKeyCode() == 37 && BuiltBreadcrumbsTableImpl.this.breadcrumbs.getFocusedBreadcrumb() == 0) {
                        JButton upButton = ((CustomTable)BuiltBreadcrumbsTableImpl.this.builtTable.getTable()).upButton;
                        if (upButton.isEnabled()) {
                            upButton.requestFocus();
                        }
                    } else if (ke.getKeyCode() == 39 && BuiltBreadcrumbsTableImpl.this.breadcrumbs.getFocusedBreadcrumb() == BuiltBreadcrumbsTableImpl.this.breadcrumbs.getModel().getBreadcrumbCount() - 1 && BuiltBreadcrumbsTableImpl.this.trailingComponent != null && BuiltBreadcrumbsTableImpl.this.trailingComponent.isFocusable() && BuiltBreadcrumbsTableImpl.this.trailingComponent.isEnabled()) {
                        BuiltBreadcrumbsTableImpl.this.trailingComponent.requestFocus();
                    }
                }
            });
            return breadcrumbButton;
        }
    }
}

