/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.breadcrumbs;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import oracle.javatools.ui.MouseHoverListener;
import oracle.javatools.ui.MouseHoverSupport;
import oracle.javatools.ui.breadcrumbs.Breadcrumb;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsButton;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsLayout;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsListener;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsModel;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsModelListener;

public class JBreadcrumbs
extends JPanel {
    private BreadcrumbsModel model;
    private ModelListener modelListener = new ModelListener();
    private BreadcrumbsLayout layout;
    private JViewport viewport = new JViewport();
    private JPanel contentPanel = new JPanel();
    private ScrollPanel leftSP;
    private ScrollPanel rightSP;
    private ButtonListener buttonListener = new ButtonListener();
    private LinkedList<BreadcrumbsListener> listeners = new LinkedList();

    public JBreadcrumbs() {
        this.init();
    }

    public BreadcrumbsModel getModel() {
        return this.model;
    }

    public void setModel(BreadcrumbsModel breadcrumbsModel) {
        if (this.model != null) {
            this.model.removeBreadcrumbsModelListener(this.modelListener);
        }
        assert (SwingUtilities.isEventDispatchThread());
        this.model = breadcrumbsModel;
        if (this.model != null) {
            this.layout = new BreadcrumbsLayout(this.model);
            this.contentPanel.setLayout(this.layout);
            this.model.addBreadcrumbsModelListener(this.modelListener);
            this.updateContents();
        } else {
            this.contentPanel.removeAll();
            this.layout = null;
            this.contentPanel.setLayout(null);
        }
    }

    public void addBreadcrumbsListener(BreadcrumbsListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeBreadcrumbsListener(BreadcrumbsListener l) {
        if (this.listeners.contains(l)) {
            this.listeners.remove(l);
        }
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    private void init() {
        this.setOpaque(false);
        this.contentPanel.add(new JLabel("Breadcrumbs will appear here..."));
        this.contentPanel.setOpaque(false);
        this.viewport.setOpaque(false);
        this.viewport.setView(this.contentPanel);
        this.setLayout(null);
        this.viewport.setBounds(0, 0, this.getWidth(), this.getHeight());
        this.leftSP = new ScrollPanel(true);
        this.add(this.leftSP);
        this.rightSP = new ScrollPanel(false);
        this.add(this.rightSP);
        this.leftSP.setBounds(0, 0, 10, 10);
        this.add(this.viewport);
        this.leftSP.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent me) {
                int adjust = (JBreadcrumbs.this.leftSP.getWidth() - me.getX()) / 4;
                JBreadcrumbs.this.updateViewOffset(adjust);
            }
        });
        this.rightSP.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent me) {
                int adjust = -me.getX() / 4;
                JBreadcrumbs.this.updateViewOffset(adjust);
            }
        });
        new MouseHoverSupport(this.leftSP, 25, true).addMouseHoverListener(new MouseHoverListener(){

            @Override
            public void mouseHovered(MouseEvent me) {
                int adjust = (JBreadcrumbs.this.leftSP.getWidth() - me.getX()) / 4;
                JBreadcrumbs.this.updateViewOffset(adjust);
            }
        });
        new MouseHoverSupport(this.rightSP, 25, true).addMouseHoverListener(new MouseHoverListener(){

            @Override
            public void mouseHovered(MouseEvent me) {
                int adjust = -me.getX() / 4;
                JBreadcrumbs.this.updateViewOffset(adjust);
            }
        });
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        h = this.contentPanel.getPreferredSize().height + 2;
        int shift = this.viewport.getWidth() - w;
        super.setBounds(x, y, w, h);
        this.viewport.setBounds(0, 0, w, h);
        this.leftSP.setBounds(0, 0, 20, this.getHeight());
        this.rightSP.setBounds(this.getWidth() - 20, 0, 20, this.getHeight());
        this.updateViewOffset(-shift);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.contentPanel.getPreferredSize();
    }

    private void updateViewOffset(int adjustment) {
        Point p = this.viewport.getViewPosition();
        p.x -= adjustment;
        int overWidth = this.getWidth();
        if (this.layout != null) {
            overWidth -= this.layout.getCurrentContentsWidth();
        }
        p.x = Math.min(-overWidth, p.x);
        p.x = Math.max(0, p.x);
        this.viewport.setViewPosition(p);
        this.leftSP.setVisible(p.x > 0);
        this.rightSP.setVisible(p.x + overWidth < 0);
        if (adjustment != 0) {
            this.fireShowBeadcrumbPeek(null, null);
        }
    }

    private void hoverAt(BreadcrumbsButton bButton) {
        if (this.model != null && this.model.getBreadcrumbCount() >= bButton.getIndex()) {
            Breadcrumb crumb = this.model.getBreadcrumb(bButton.getIndex());
            Rectangle rect = SwingUtilities.convertRectangle(bButton, new Rectangle(bButton.getSize()), this);
            this.fireShowBeadcrumbPeek(crumb, rect);
        }
    }

    private void updateContents() {
        this.contentPanel.removeAll();
        for (int i = 0; i < this.model.getBreadcrumbCount(); ++i) {
            this.createBreadcrumbButton(i);
        }
        this.resetViewportPos();
        this.repaint();
    }

    protected BreadcrumbsButton createBreadcrumbButton(int index) {
        Breadcrumb breadcrumb = this.model.getBreadcrumb(index);
        boolean hasPeers = this.model.hasChildren(breadcrumb);
        BreadcrumbsButton button = new BreadcrumbsButton(breadcrumb, breadcrumb.getLongName(), index, hasPeers);
        this.contentPanel.add(button);
        button.addMouseListener(this.buttonListener);
        button.addKeyListener(this.buttonListener);
        MouseHoverSupport hoverSup = new MouseHoverSupport(button, 1000, false);
        hoverSup.addMouseHoverListener(this.buttonListener);
        return button;
    }

    private void resetViewportPos() {
        this.viewport.validate();
        int maxX = this.viewport.getViewSize().width - this.viewport.getExtentSize().width;
        this.viewport.setViewPosition(new Point(maxX, 0));
    }

    public void setFocusedBreadcrumb(int index) {
        for (int i = 0; i < this.contentPanel.getComponentCount(); ++i) {
            if (index == 0) {
                this.contentPanel.getComponent(i).requestFocus();
                break;
            }
            if (!(this.contentPanel.getComponent(i) instanceof BreadcrumbsButton)) continue;
            --index;
        }
    }

    public int getFocusedBreadcrumb() {
        int index = 0;
        for (int i = 0; i < this.contentPanel.getComponentCount(); ++i) {
            Component c = this.contentPanel.getComponent(i);
            if (!(c instanceof BreadcrumbsButton)) continue;
            if (c.hasFocus()) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private void fireBeadcrumbClicked(int crumb) {
        for (BreadcrumbsListener l : this.listeners) {
            l.breadcrumbClicked(this.model.getBreadcrumb(crumb));
        }
    }

    private void fireBeadcrumbContextClicked(int crumb, Point p) {
        for (BreadcrumbsListener l : this.listeners) {
            l.breadcrumbContextClicked(this.model.getBreadcrumb(crumb), p);
        }
    }

    private void fireSeparatorClicked(Breadcrumb crumb, Rectangle r) {
        for (BreadcrumbsListener l : this.listeners) {
            l.separatorClicked(crumb, r);
        }
    }

    private void fireShowBeadcrumbPeek(Breadcrumb crumb, Rectangle r) {
        for (BreadcrumbsListener l : this.listeners) {
            l.showBreadcrumbPeek(crumb, r);
        }
    }

    private void fireHideBeadcrumbPeek() {
        for (BreadcrumbsListener l : this.listeners) {
            l.hideBreadcrumbPeek();
        }
    }

    private class ModelListener
    implements BreadcrumbsModelListener,
    Runnable {
        private ModelListener() {
        }

        @Override
        public void breadcrumbsUpdated() {
            if (SwingUtilities.isEventDispatchThread()) {
                this.run();
            } else {
                SwingUtilities.invokeLater(this);
            }
        }

        @Override
        public void run() {
            JBreadcrumbs.this.updateContents();
        }
    }

    private class ButtonListener
    extends KeyAdapter
    implements MouseListener,
    MouseHoverListener {
        private ButtonListener() {
        }

        @Override
        public void keyPressed(KeyEvent ke) {
            BreadcrumbsButton breadcrumbsButton = (BreadcrumbsButton)ke.getSource();
            int index = breadcrumbsButton.getIndex();
            if (ke.getKeyCode() == 32 || ke.getKeyCode() == 10) {
                JBreadcrumbs.this.fireBeadcrumbClicked(index);
                return;
            }
            if (ke.getKeyCode() == 40 && breadcrumbsButton.hasPeers()) {
                Rectangle peersRect = breadcrumbsButton.getPeersComponentRectangle();
                peersRect = SwingUtilities.convertRectangle(breadcrumbsButton, peersRect, JBreadcrumbs.this);
                JBreadcrumbs.this.fireSeparatorClicked(JBreadcrumbs.this.model.getBreadcrumb(index), peersRect);
                return;
            }
            int focusIndex = -1;
            if (ke.getKeyCode() == 37 && index > 0) {
                focusIndex = index - 1;
            } else if (ke.getKeyCode() == 39 && index < JBreadcrumbs.this.model.getBreadcrumbCount() - 1) {
                focusIndex = index + 1;
            }
            if (focusIndex > -1) {
                JBreadcrumbs.this.setFocusedBreadcrumb(focusIndex);
            }
        }

        @Override
        public void mouseHovered(MouseEvent me) {
            BreadcrumbsButton bButton = (BreadcrumbsButton)me.getSource();
            JBreadcrumbs.this.hoverAt(bButton);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), JBreadcrumbs.this);
            BreadcrumbsButton breadcrumbsButton = (BreadcrumbsButton)e.getSource();
            int index = breadcrumbsButton.getIndex();
            if (SwingUtilities.isRightMouseButton(e)) {
                JBreadcrumbs.this.fireBeadcrumbContextClicked(index, p);
            } else if (SwingUtilities.isLeftMouseButton(e)) {
                if (!breadcrumbsButton.hasPeers()) {
                    JBreadcrumbs.this.fireBeadcrumbClicked(index);
                } else {
                    Rectangle peersRect = breadcrumbsButton.getPeersComponentRectangle();
                    peersRect = SwingUtilities.convertRectangle((Component)e.getSource(), peersRect, JBreadcrumbs.this);
                    if (peersRect.contains(p)) {
                        JBreadcrumbs.this.fireSeparatorClicked(JBreadcrumbs.this.model.getBreadcrumb(index), peersRect);
                    } else if (index < JBreadcrumbs.this.model.getBreadcrumbCount()) {
                        JBreadcrumbs.this.fireBeadcrumbClicked(index);
                    }
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JBreadcrumbs.this.fireHideBeadcrumbPeek();
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }
    }

    private class ScrollPanel
    extends JPanel {
        static final int FADE_W = 20;
        boolean isLeft;

        ScrollPanel(boolean isLeft) {
            this.isLeft = isLeft;
            this.setOpaque(false);
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.getParent() != null) {
                return new Dimension(20, this.getParent().getHeight());
            }
            return new Dimension(20, 15);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (JBreadcrumbs.this.layout == null) {
                return;
            }
            int overWidth = JBreadcrumbs.this.layout.getCurrentContentsWidth() - this.getWidth();
            if (overWidth > 0) {
                BufferedImage fadeImage = new BufferedImage(20, this.getHeight(), 2);
                Graphics2D imageG = fadeImage.createGraphics();
                Color bg = this.getBackground();
                GradientPaint grad = new GradientPaint(0.0f, 0.0f, new Color(bg.getRed(), bg.getGreen(), bg.getBlue(), 255), 20.0f, 0.0f, new Color(bg.getRed(), bg.getGreen(), bg.getBlue(), 0));
                imageG.setPaint(grad);
                imageG.fillRect(0, 0, 20, this.getHeight());
                ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 1.0f));
                if (this.isLeft) {
                    g.drawImage(fadeImage, 0, 0, null);
                } else {
                    g.drawImage(fadeImage, this.getWidth(), 0, -this.getWidth(), this.getHeight(), null);
                }
                imageG.dispose();
            }
        }
    }
}

