/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.breadcrumbs;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import oracle.javatools.ui.breadcrumbs.Breadcrumb;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsButtonUI;
import oracle.javatools.ui.simplestyle.StyledTextModel;
import oracle.javatools.ui.simplestyle.StyledTextRenderer;

public class BreadcrumbsButton
extends JButton {
    private static final String uiClassID = "BreadcrumbsButtonUI";
    private Breadcrumb breadcrumb;
    private int index = -1;
    private StyledTextModel styledModel;
    private static int firstOverlapMargin;
    private static int overlapMargin;
    private static int noPeersMargin;
    private static int peersMargin;
    private static int peersSize;
    private JComponent peersComponent;
    private boolean hasPeers;

    public BreadcrumbsButton(Breadcrumb breadcrumb, StyledTextModel styledModel, int index) {
        this(breadcrumb, styledModel, index, false);
    }

    public BreadcrumbsButton(Breadcrumb breadcrumb, StyledTextModel styledModel, int index, boolean hasPeers) {
        this.breadcrumb = breadcrumb;
        this.index = index;
        this.styledModel = styledModel;
        this.hasPeers = hasPeers;
        this.setRolloverEnabled(true);
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setBorder(BorderFactory.createEmptyBorder(0, index == 0 ? firstOverlapMargin : overlapMargin, 1, hasPeers ? peersMargin : noPeersMargin));
        this.setOpaque(false);
        this.setLayout(null);
        this.setForeground(UIManager.getColor("TextArea.foreground"));
        if (hasPeers) {
            this.addPeersComponent();
        }
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((ButtonUI)UIManager.getUI(this));
        } else {
            this.setUI((ButtonUI)BreadcrumbsButtonUI.createUI(this));
        }
    }

    public boolean hasPeers() {
        return this.hasPeers;
    }

    public int getIndex() {
        return this.index;
    }

    public void setText(StyledTextModel styledModel) {
        this.styledModel = styledModel;
        this.setText(styledModel.toSimpleString(false));
    }

    public StyledTextModel getStyledText() {
        return this.styledModel;
    }

    public Breadcrumb getBreadcrumb() {
        return this.breadcrumb;
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (this.peersComponent != null) {
            this.peersComponent.setLocation(this.getWidth() - 1 - peersSize - 10, (this.getHeight() - 1) / 2 - peersSize / 2);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = StyledTextRenderer.getPreferredSize(this, this.styledModel);
        Insets insets = this.getInsets();
        d.width += insets.left + insets.right;
        d.height += insets.top + insets.bottom;
        return d;
    }

    @Override
    public BreadcrumbsButtonUI getUI() {
        return (BreadcrumbsButtonUI)super.getUI();
    }

    private void addPeersComponent() {
        this.peersComponent = new JLabel(this.getUI().getPeersIcon());
        this.peersComponent.setSize(peersSize, peersSize);
        this.peersComponent.setOpaque(false);
        this.add(this.peersComponent);
    }

    Rectangle getPeersComponentRectangle() {
        return this.peersComponent.getBounds();
    }

    static {
        if (UIManager.get(uiClassID) == null) {
            UIManager.put(uiClassID, "oracle.javatools.ui.breadcrumbs.BreadcrumbsButtonUI");
        }
        firstOverlapMargin = 4;
        overlapMargin = 14;
        noPeersMargin = 12;
        peersMargin = 23;
        peersSize = 8;
    }
}

