/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import javax.swing.ButtonGroup;
import javax.swing.JToggleButton;

public class TriStateButtonModel
extends JToggleButton.ToggleButtonModel {
    private boolean isPartial = false;
    private boolean userCanPartial = false;
    private boolean directionTruePartialFalse = true;

    public boolean isPartial() {
        return this.isPartial;
    }

    public void setPartial(boolean isPartial) {
        if (isPartial == this.isPartial) {
            return;
        }
        this.isPartial = isPartial;
        ButtonGroup group = this.getGroup();
        if (group != null) {
            group.setSelected(this, false);
        }
        this.stateMask &= 0xFFFFFFFD;
        this.fireStateChanged();
    }

    @Override
    public void setPressed(boolean b) {
        this.stateMask = b ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
        if (!b && this.isArmed()) {
            if (this.isPartial) {
                this.isPartial = false;
                this.setSelected(!this.directionTruePartialFalse);
            } else if (!this.userCanPartial) {
                this.setSelected(!this.isSelected());
            } else if (this.isSelected() && this.directionTruePartialFalse) {
                this.setPartial(true);
            } else if (this.isSelected() && !this.directionTruePartialFalse) {
                this.setSelected(false);
            } else if (!this.isSelected() && this.directionTruePartialFalse) {
                this.setSelected(true);
            } else {
                this.setPartial(true);
            }
        }
        this.fireStateChanged();
        if (!this.isPressed() && this.isArmed()) {
            int modifiers = 0;
            AWTEvent currentEvent = EventQueue.getCurrentEvent();
            if (currentEvent instanceof InputEvent) {
                modifiers = ((InputEvent)currentEvent).getModifiers();
            } else if (currentEvent instanceof ActionEvent) {
                modifiers = ((ActionEvent)currentEvent).getModifiers();
            }
            this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand(), EventQueue.getMostRecentEventTime(), modifiers));
        }
    }

    @Override
    public void setSelected(boolean b) {
        ButtonGroup group = this.getGroup();
        if (group != null) {
            group.setSelected(this, b);
            b = group.isSelected(this);
        }
        if (b == this.isSelected() && !this.isPartial) {
            return;
        }
        this.isPartial = false;
        this.stateMask = b ? (this.stateMask |= 2) : (this.stateMask &= 0xFFFFFFFD);
        this.fireStateChanged();
        this.fireItemStateChanged(new ItemEvent(this, 701, this, this.isSelected() ? 1 : 2));
    }

    public void setCanUserSetPartial(boolean userCanSetPartial) {
        this.userCanPartial = userCanSetPartial;
    }

    public boolean canUserSetPartial() {
        return this.userCanPartial;
    }

    public void setDirection(boolean directionTruePartialFalse) {
        this.directionTruePartialFalse = directionTruePartialFalse;
    }

    public boolean getDirection() {
        return this.directionTruePartialFalse;
    }
}

