/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;

public class SpaceDecoratorIcon
implements Icon {
    private final Icon icon;
    private final int x;
    private final int y;
    private final int width;
    private final int height;

    public SpaceDecoratorIcon(Icon icon, int top, int left, int bottom, int right) {
        this.icon = icon;
        this.x = left;
        this.y = top;
        this.width = left + icon.getIconWidth() + right;
        this.height = top + icon.getIconHeight() + bottom;
    }

    public SpaceDecoratorIcon(Icon icon, Insets insets) {
        this(icon, insets.top, insets.left, insets.bottom, insets.right);
    }

    public SpaceDecoratorIcon(Icon icon, int width, int height) {
        this.icon = icon;
        this.y = (height - icon.getIconHeight()) / 2;
        this.x = (width - icon.getIconWidth()) / 2;
        this.width = width;
        this.height = height;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.translate(this.x, this.y);
        this.icon.paintIcon(c, g, x, y);
        g.translate(-this.x, -this.y);
    }
}

