/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class SeparatorListCellRenderer
implements ListCellRenderer {
    private final ListCellRenderer decoratedRenderer;
    private final SeparatorModel separatorModel;
    private final Border lineBorder;

    public SeparatorListCellRenderer(SeparatorModel separatorModel) {
        this(new DefaultListCellRenderer(), separatorModel);
    }

    public SeparatorListCellRenderer(ListCellRenderer decoratedRenderer, SeparatorModel separatorModel) {
        this.decoratedRenderer = decoratedRenderer;
        this.separatorModel = separatorModel;
        this.lineBorder = SeparatorBorder.INSTANCE;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JComponent c = (JComponent)this.decoratedRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        Border b = c.getBorder();
        if (b instanceof CompoundBorder && ((CompoundBorder)b).getOutsideBorder() == this.lineBorder) {
            c.setBorder(((CompoundBorder)b).getInsideBorder());
        }
        if (index != -1 && this.separatorModel.hasTrailingSeparator(index, value)) {
            c.setBorder(BorderFactory.createCompoundBorder(this.lineBorder, c.getBorder()));
        }
        return c;
    }

    public static interface SeparatorModel {
        public boolean hasTrailingSeparator(int var1, Object var2);
    }

    private static class SeparatorBorder
    extends AbstractBorder {
        public static SeparatorBorder INSTANCE = new SeparatorBorder();

        private SeparatorBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(UIManager.getColor("Separator.background"));
            g.fillRect(x, y + height - 5, x + width, y + height);
            g.setColor(UIManager.getColor("Separator.foreground"));
            g.drawLine(x, y + height - 3, x + width, y + height - 3);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(0, 0, 5, 0);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.right = 0;
            insets.top = 0;
            insets.left = 0;
            insets.bottom = 5;
            return insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

