/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.LayerUI;
import oracle.javatools.ui.ResizeScrollPaneLayout;

public class ResizeComponent
extends JPanel {
    public static final String PROPERTY_USER_RESIZE_PREFERRED = "resize-user-preferred";
    public static final String PROPERTY_RESIZE_COMPONENT = "resize-component";
    private static final Dimension GRIP_SIZE = new Dimension(16, 16);
    private static final int EDGE_GRIP_SIZE = 4;
    private JLayer layer;
    private ScrollPaneListener spListener;
    private boolean allowEdgeResize = false;

    public ResizeComponent(JComponent componentToResize) {
        this(componentToResize, componentToResize instanceof JScrollPane ? (JScrollPane)componentToResize : null);
    }

    public ResizeComponent(JComponent componentToResize, JScrollPane sp) {
        this.layer = new JLayer<JComponent>(componentToResize, this.createLayer());
        this.setLayout(null);
        this.setOpaque(false);
        if (sp != null) {
            if (!(sp.getLayout() instanceof ResizeScrollPaneLayout)) {
                sp.setLayout(new ResizeScrollPaneLayout());
            }
            sp.setBackground(UIManager.getColor("TextArea.background"));
            this.spListener = new ScrollPaneListener(sp);
            this.spListener.addScrollBar(null, sp.getVerticalScrollBar());
            this.spListener.addScrollBar(null, sp.getHorizontalScrollBar());
            sp.addPropertyChangeListener(this.spListener);
            this.spListener.updateMouseWheelScrolling();
        }
        this.add(this.layer);
        componentToResize.putClientProperty(PROPERTY_RESIZE_COMPONENT, this);
    }

    public void setView(JComponent view) {
        this.layer.setView(view);
    }

    protected JLayer getLayer() {
        return this.layer;
    }

    public JComponent getView() {
        return (JComponent)this.layer.getView();
    }

    public void setAllowEdgeResize(boolean allowEdgeResize) {
        this.allowEdgeResize = allowEdgeResize;
    }

    public boolean isAllowEdgeResize() {
        return this.allowEdgeResize;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
    }

    @Override
    public void doLayout() {
        Insets insets = this.getInsets();
        this.layer.setLocation(insets.left, insets.top);
        this.layer.setSize(this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        Dimension size = this.layer.getPreferredSize();
        size.width += insets.left + insets.right;
        size.height += insets.top + insets.bottom;
        return size;
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        if (preferredSize != null) {
            Insets insets = this.getInsets();
            preferredSize.width -= insets.left + insets.right;
            preferredSize.height -= insets.top + insets.bottom;
        }
        this.layer.setPreferredSize(preferredSize);
    }

    @Override
    public Dimension getMinimumSize() {
        Insets insets = this.getInsets();
        Dimension size = this.layer.getMinimumSize();
        size.width += insets.left + insets.right;
        size.height += insets.top + insets.bottom;
        return size;
    }

    @Override
    public void setMaximumSize(Dimension maximumSize) {
        Insets insets = this.getInsets();
        maximumSize.width -= insets.left + insets.right;
        maximumSize.height -= insets.top + insets.bottom;
        this.layer.setMaximumSize(maximumSize);
    }

    @Override
    public void setMinimumSize(Dimension minimumSize) {
        if (minimumSize != null) {
            Insets insets = this.getInsets();
            minimumSize.width -= insets.left + insets.right;
            minimumSize.height -= insets.top + insets.bottom;
        }
        this.layer.setMinimumSize(minimumSize);
    }

    protected LayerUI createLayer() {
        return new ResizeLayer();
    }

    private class ScrollPaneListener
    extends ComponentAdapter
    implements PropertyChangeListener {
        private final JScrollPane sp;

        private ScrollPaneListener(JScrollPane sp) {
            this.sp = sp;
        }

        @Override
        public void propertyChange(PropertyChangeEvent pe) {
            String propertyName = pe.getPropertyName();
            if (propertyName == "verticalScrollBar") {
                this.addScrollBar((JScrollBar)pe.getOldValue(), (JScrollBar)pe.getNewValue());
            } else if (propertyName == "horizontalScrollBar") {
                this.addScrollBar((JScrollBar)pe.getOldValue(), (JScrollBar)pe.getNewValue());
            } else if ("wheelScrollingEnabled".equals(propertyName)) {
                this.updateMouseWheelScrolling();
            }
        }

        @Override
        public void componentShown(ComponentEvent e) {
            this.updateMouseWheelScrolling();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            this.updateMouseWheelScrolling();
        }

        private void addScrollBar(JScrollBar oldBar, JScrollBar newBar) {
            if (oldBar != null) {
                oldBar.removeComponentListener(this);
            }
            if (newBar != null) {
                newBar.addComponentListener(this);
            }
        }

        private void updateMouseWheelScrolling() {
            if (this.sp == null) {
                return;
            }
            JScrollBar vsb = this.sp.getVerticalScrollBar();
            JScrollBar hsb = this.sp.getHorizontalScrollBar();
            if (!(this.sp.isWheelScrollingEnabled() && (vsb != null || hsb != null) && (vsb != null && vsb.isVisible() || hsb != null && hsb.isVisible()))) {
                long eventMask = ResizeComponent.this.layer.getLayerEventMask();
                ResizeComponent.this.layer.setLayerEventMask(eventMask &= 0xFFFFFFFFFFFDFFFFL);
            } else {
                long eventMask = ResizeComponent.this.layer.getLayerEventMask();
                ResizeComponent.this.layer.setLayerEventMask(eventMask |= 0x20000L);
            }
        }
    }

    protected class ResizeLayer
    extends LayerUI {
        private final Stroke wideStroke = new BasicStroke(1.0f);
        private final Stroke thinStoke = new BasicStroke(0.5f);
        private final Color lightColor = UIManager.getColor("controlDkShadow");
        private final Color darkColor = UIManager.getColor("controlDkShadow").darker();
        private Dimension d = null;
        private JComponent autoscroll = null;

        protected ResizeLayer() {
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            super.paint(g, c);
            Object view = ResizeComponent.this.layer.getView();
            if (view == null) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int noLines = 3;
            int lineSpacing = 4;
            Color bgColor = ((Component)view).getBackground();
            if (view instanceof JScrollPane) {
                bgColor = ((JScrollPane)ResizeComponent.this.layer.getView()).getViewport().getView().getBackground();
            }
            g2.setColor(bgColor);
            GeneralPath cornerPath = new GeneralPath();
            cornerPath.moveTo(ResizeComponent.this.getWidth() - 12 - 1, ResizeComponent.this.getHeight());
            cornerPath.lineTo(ResizeComponent.this.getWidth(), ResizeComponent.this.getHeight() - 12 - 1);
            cornerPath.lineTo(ResizeComponent.this.getWidth(), ResizeComponent.this.getHeight());
            cornerPath.closePath();
            g2.fill(cornerPath);
            for (int i = 1; i <= 3; ++i) {
                g2.setColor(this.lightColor);
                g2.setStroke(this.wideStroke);
                g2.drawLine(ResizeComponent.this.getWidth() - i * 4, ResizeComponent.this.getHeight() - 2, ResizeComponent.this.getWidth() - 2, ResizeComponent.this.getHeight() - i * 4);
                g2.setColor(this.darkColor);
                g2.setStroke(this.thinStoke);
                g2.drawLine(ResizeComponent.this.getWidth() - i * 4, ResizeComponent.this.getHeight() - 2, ResizeComponent.this.getWidth() - 2, ResizeComponent.this.getHeight() - i * 4);
            }
            g2.dispose();
        }

        protected void processMouseMotionEvent(MouseEvent me, JLayer l) {
            if (me.getID() == 506) {
                if (this.d != null) {
                    Point p = me.getLocationOnScreen();
                    SwingUtilities.convertPointFromScreen(p, ResizeComponent.this.layer);
                    Dimension minSize = l.getMinimumSize();
                    Dimension maxSize = l.getMaximumSize();
                    Dimension newD = new Dimension(Math.max(p.x + this.d.width, (int)minSize.getWidth()), Math.max(p.y + this.d.height, (int)minSize.getHeight()));
                    newD = new Dimension(Math.min(newD.width, (int)maxSize.getWidth()), Math.min(newD.height, (int)maxSize.getHeight()));
                    Dimension oldD = ResizeComponent.this.layer.getSize();
                    ResizeComponent.this.layer.setPreferredSize(newD);
                    ResizeComponent.this.firePropertyChange(ResizeComponent.PROPERTY_USER_RESIZE_PREFERRED, oldD, newD);
                    ResizeComponent.this.revalidate();
                    me.consume();
                }
            } else {
                this.d = null;
                if (this.locationInGrip(me) != null) {
                    ResizeComponent.this.layer.getGlassPane().setCursor(Cursor.getPredefinedCursor(5));
                    ResizeComponent.this.layer.getGlassPane().setVisible(true);
                    me.consume();
                } else if (ResizeComponent.this.allowEdgeResize && this.locationInEdgeGrip(me) != null) {
                    ResizeComponent.this.layer.getGlassPane().setCursor(Cursor.getPredefinedCursor(11));
                    ResizeComponent.this.layer.getGlassPane().setVisible(true);
                    me.consume();
                } else {
                    ResizeComponent.this.layer.getGlassPane().setCursor(null);
                    ResizeComponent.this.layer.getGlassPane().setVisible(false);
                }
            }
        }

        @Override
        public void installUI(JComponent c) {
            super.installUI(c);
            ((JLayer)c).setLayerEventMask(48L);
        }

        protected void processMouseEvent(MouseEvent me, JLayer l) {
            Dimension loc = this.locationInGrip(me);
            if (loc == null && ResizeComponent.this.allowEdgeResize) {
                loc = this.locationInEdgeGrip(me);
            }
            if (me.getID() == 501 && loc != null) {
                this.d = loc;
                me.consume();
                if (l.getView() instanceof JComponent) {
                    JScrollPane sp;
                    JComponent view = (JComponent)l.getView();
                    if (view instanceof JScrollPane && (sp = (JScrollPane)view).getViewport().getView() instanceof JComponent) {
                        view = (JComponent)sp.getViewport().getView();
                    }
                    if (view.getAutoscrolls()) {
                        view.setAutoscrolls(false);
                        this.autoscroll = view;
                    }
                }
            } else if (me.getID() == 502 && this.autoscroll != null) {
                this.autoscroll.setAutoscrolls(true);
                this.autoscroll = null;
            }
        }

        private Dimension locationInGrip(MouseEvent me) {
            me = SwingUtilities.convertMouseEvent(me.getComponent(), me, ResizeComponent.this.layer);
            int xOff = ResizeComponent.this.layer.getWidth() - me.getX();
            int yOff = ResizeComponent.this.layer.getHeight() - me.getY();
            if (xOff < ResizeComponent.GRIP_SIZE.height && yOff < ResizeComponent.GRIP_SIZE.width && xOff + yOff < ResizeComponent.GRIP_SIZE.height) {
                return new Dimension(xOff, yOff);
            }
            return null;
        }

        private Dimension locationInEdgeGrip(MouseEvent me) {
            me = SwingUtilities.convertMouseEvent(me.getComponent(), me, ResizeComponent.this.layer);
            int xOff = ResizeComponent.this.layer.getWidth() - me.getX();
            int yOff = ResizeComponent.this.layer.getHeight() - me.getY();
            if (xOff < 4) {
                return new Dimension(xOff, yOff);
            }
            return null;
        }
    }
}

