/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreePath;
import oracle.javatools.ui.UIBundle;

public class KeyNavigationManager
implements MouseListener,
ComponentListener,
FocusListener {
    private static final boolean NEW_BEHAVIOR = true;
    private static final int X_TOOLTIP_PADDING = 5;
    private static final int Y_TOOLTIP_PADDING = 5;
    private static final int GOTO_PREV = -1;
    private static final int GOTO_NEXT = 0;
    private static final int GOTO_AFTER = 1;
    private StringBuffer _keys = new StringBuffer(50);
    private ArrayList _history = new ArrayList(5);
    private JToolTip _tip;
    private JWindow _tipWindow;
    private KeyComponentAdapter _kca;

    public KeyNavigationManager() {
        this(null);
    }

    public KeyNavigationManager(KeyComponentAdapter kca) {
        this.setKeyComponentAdapter(kca);
    }

    public void setKeyComponentAdapter(KeyComponentAdapter kca) {
        JComponent jc;
        if (this._kca != null && (jc = this._kca.getComponent()) != null) {
            jc.removeMouseListener(this);
        }
        this._kca = kca;
        if (this._kca != null && (jc = this._kca.getComponent()) != null) {
            jc.addMouseListener(this);
            if (jc instanceof JTree) {
                JTree tree = (JTree)jc;
                EventListener[] listeners = jc.getListeners(KeyListener.class);
                for (int i = 0; i < listeners.length; ++i) {
                    EventListener eventListener = listeners[i];
                    if (!(eventListener instanceof BasicTreeUI.KeyHandler)) continue;
                    tree.removeKeyListener((KeyListener)eventListener);
                }
            }
        }
    }

    public KeyComponentAdapter getKeyComponentAdapter() {
        return this._kca;
    }

    private boolean isVisible() {
        return this._tipWindow != null;
    }

    private void _updateLabel() {
        if (this._keys.length() > 0) {
            if (this._tip == null) {
                this._tip = new JToolTip();
            }
            this._tip.setTipText(UIBundle.format("KEY_NAV_MANAGER_SEARCHING_FOR", this._keys.toString()));
            this._showWindow();
            this._tip.revalidate();
            if (this._tipWindow != null) {
                this._tipWindow.pack();
            }
        } else {
            this._hideWindow();
        }
    }

    private void _clearAll() {
        this._keys.setLength(0);
        this._history.clear();
        this._updateLabel();
    }

    private void _removeLast() {
        int len = this._keys.length() - 1;
        if (len >= 0) {
            this._keys.deleteCharAt(len);
            int nHistLen = this._history.size();
            if (nHistLen != 0) {
                Object sel = this._history.remove(nHistLen - 1);
                this._kca.setSelection(sel);
            }
            this._updateLabel();
        }
    }

    private void _addChar(char c) {
        this._keys.append(c);
        Object selSave = this._kca.getSelection();
        if (this._gotoMatch(0)) {
            this._updateLabel();
            this._history.add(selSave);
        } else {
            if (this._keys.toString().trim().length() > 0) {
                Toolkit.getDefaultToolkit().beep();
            }
            this._keys = this._keys.deleteCharAt(this._keys.length() - 1);
            if (!this._history.isEmpty()) {
                this._kca.setSelection(this._history.get(this._history.size() - 1));
            }
        }
    }

    private boolean _gotoMatch(int nDir) {
        String name;
        Object selRow = this._kca.getSelection();
        int sel = this._kca.getRowPosition(selRow);
        int numRows = this._kca.getRowCount();
        int nRow = sel + numRows;
        int nInc = 1;
        switch (nDir) {
            case -1: {
                --nRow;
                nInc = -1;
                break;
            }
            case 0: {
                if (sel != -1) break;
                nRow = 0;
                break;
            }
            case 1: {
                ++nRow;
            }
        }
        boolean bRegExp = this._keys.charAt(0) == '*';
        String string = name = bRegExp ? this._keys.toString().substring(1) : this._keys.toString();
        if (name != null) {
            int nameLen = name.length();
            for (int i = 0; i < numRows; ++i) {
                int j = nRow % numRows;
                Object row = this._kca.getRow(j);
                String rowName = this._kca.toString(row);
                if (bRegExp ? KeyNavigationManager._contains(rowName, name) : rowName != null && rowName.regionMatches(true, 0, name, 0, nameLen)) {
                    this._kca.setSelection(row);
                    return true;
                }
                nRow += nInc;
            }
        }
        return false;
    }

    private static boolean _contains(String s, String sSub) {
        int n;
        int nLen = s.length();
        int nSubLen = sSub.length();
        for (int i = n = nLen - nSubLen; i >= 0; --i) {
            if (!s.regionMatches(true, i, sSub, 0, nSubLen)) continue;
            return true;
        }
        return false;
    }

    private void _hideWindow() {
        if (this._tipWindow != null) {
            this._tipWindow.setVisible(false);
            this._tipWindow.getOwner().removeComponentListener(this);
            this._tipWindow.dispose();
            this._tipWindow = null;
        }
        this._tip = null;
    }

    private void _showWindow() {
        if (this._tipWindow == null) {
            JComponent jc = this._kca.getComponent();
            jc.addFocusListener(this);
            Window parentWin = SwingUtilities.getWindowAncestor(jc);
            if (parentWin != null) {
                this._tipWindow = new JWindow(parentWin);
                parentWin.addComponentListener(this);
                this._tipWindow.getContentPane().add(this._tip);
                this._tipWindow.pack();
                this._updateWindowLocation();
                this._tipWindow.setVisible(true);
            }
        }
    }

    private void _updateWindowLocation() {
        if (this._tipWindow != null) {
            JComponent jc = this._kca.getComponent();
            Point pt = jc.getLocationOnScreen();
            Container c = jc.getParent();
            if (c instanceof JViewport) {
                Point viewPos = ((JViewport)c).getViewPosition();
                pt.x += viewPos.x;
                pt.y += viewPos.y;
            }
            int h = this._tipWindow.getHeight();
            int x = pt.x + 5;
            int y = pt.y - h + 5;
            this._tipWindow.setLocation(x, y);
        }
    }

    public void preProcessKeyEvent(KeyEvent e) {
        if (e.isConsumed()) {
            return;
        }
        switch (e.getID()) {
            case 401: {
                this.preKeyPressed(e);
                break;
            }
            case 400: {
                this.preKeyTyped(e);
                break;
            }
            case 402: {
                this.preKeyReleased(e);
            }
        }
    }

    public void postProcessKeyEvent(KeyEvent e) {
        if (e.isConsumed()) {
            return;
        }
        switch (e.getID()) {
            case 401: {
                this.postKeyPressed(e);
                break;
            }
            case 400: {
                this.postKeyTyped(e);
                break;
            }
            case 402: {
                this.postKeyReleased(e);
            }
        }
    }

    public void preKeyTyped(KeyEvent e) {
    }

    public void postKeyTyped(KeyEvent e) {
        char keyChar = e.getKeyChar();
        if (!(e.isAltDown() || e.isControlDown() || Character.isISOControl(keyChar))) {
            e.consume();
            this._addChar(keyChar);
        } else if (keyChar != '\b' && this._keys.length() > 0) {
            this._clearAll();
        }
    }

    public void preKeyPressed(KeyEvent e) {
        if (this.isVisible()) {
            int keyCode = e.getKeyCode();
            switch (keyCode) {
                case 27: {
                    e.consume();
                    this._clearAll();
                    break;
                }
                case 10: {
                    this._clearAll();
                    break;
                }
                case 37: 
                case 39: 
                case 226: 
                case 227: {
                    this._clearAll();
                    break;
                }
                case 38: 
                case 224: {
                    e.consume();
                    this._gotoMatch(-1);
                    break;
                }
                case 40: 
                case 225: {
                    e.consume();
                    this._gotoMatch(1);
                    break;
                }
                case 8: 
                case 127: {
                    e.consume();
                    this._removeLast();
                }
            }
        }
    }

    public void postKeyPressed(KeyEvent e) {
    }

    public void preKeyReleased(KeyEvent e) {
    }

    public void postKeyReleased(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this._clearAll();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this._clearAll();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this._updateWindowLocation();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this._updateWindowLocation();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public static JTree createNavigableTree() {
        return new JTree(){
            KeyNavigationManager knm = new KeyNavigationManager(new TreeKeyAdapter(this));

            @Override
            protected void processKeyEvent(KeyEvent e) {
                this.knm.preProcessKeyEvent(e);
                super.processKeyEvent(e);
                this.knm.postProcessKeyEvent(e);
            }
        };
    }

    public static interface KeyComponentAdapter {
        public JComponent getComponent();

        public int getRowCount();

        public Object getRow(int var1);

        public int getRowPosition(Object var1);

        public String toString(Object var1);

        public Object getSelection();

        public void setSelection(Object var1);
    }

    public static class ListKeyAdapter
    implements KeyComponentAdapter {
        private JList _list;

        public ListKeyAdapter(JList list) {
            this._list = list;
        }

        @Override
        public JComponent getComponent() {
            return this._list;
        }

        @Override
        public int getRowCount() {
            return this._list.getModel().getSize();
        }

        @Override
        public Object getRow(int i) {
            return i;
        }

        @Override
        public int getRowPosition(Object row) {
            return (Integer)row;
        }

        @Override
        public String toString(Object row) {
            int nRow = this.getRowPosition(row);
            ListModel listModel = this._list.getModel();
            Object obj = listModel.getElementAt(nRow);
            return obj != null ? obj.toString() : "";
        }

        @Override
        public Object getSelection() {
            ListSelectionModel selectionModel = this._list.getSelectionModel();
            int leadSelectionIndex = selectionModel.getLeadSelectionIndex();
            return leadSelectionIndex;
        }

        @Override
        public void setSelection(Object row) {
            int nRow = this.getRowPosition(row);
            Rectangle rect = this._list.getCellBounds(nRow, nRow);
            this._list.getSelectionModel().setSelectionInterval(nRow, nRow);
            this._list.scrollRectToVisible(rect);
        }
    }

    public static class TableKeyAdapter
    implements KeyComponentAdapter {
        private JTable _table;

        public TableKeyAdapter(JTable table) {
            this._table = table;
        }

        @Override
        public JComponent getComponent() {
            return this._table;
        }

        @Override
        public int getRowCount() {
            return this._table.getRowCount();
        }

        @Override
        public Object getRow(int i) {
            return i;
        }

        @Override
        public int getRowPosition(Object row) {
            return (Integer)row;
        }

        @Override
        public String toString(Object row) {
            int nRow = this.getRowPosition(row);
            int nCol = Math.max(this._table.getSelectedColumn(), 0);
            Object obj = this._table.getModel().getValueAt(nRow, nCol);
            return obj != null ? obj.toString() : "";
        }

        @Override
        public Object getSelection() {
            return this._table.getSelectedRow();
        }

        @Override
        public void setSelection(Object row) {
            int nRow = this.getRowPosition(row);
            Rectangle rect = this._table.getCellRect(nRow, 0, true);
            this._table.getSelectionModel().setSelectionInterval(nRow, nRow);
            this._table.scrollRectToVisible(rect);
        }
    }

    public static class TreeKeyAdapter
    implements KeyComponentAdapter {
        private JTree _tree;

        public TreeKeyAdapter(JTree tree) {
            this._tree = tree;
        }

        @Override
        public JComponent getComponent() {
            return this._tree;
        }

        @Override
        public int getRowCount() {
            return this._tree.getRowCount();
        }

        @Override
        public Object getRow(int i) {
            TreePath path = this._tree.getPathForRow(i);
            return path;
        }

        @Override
        public int getRowPosition(Object row) {
            TreePath path = (TreePath)row;
            return this._tree.getRowForPath(path);
        }

        @Override
        public String toString(Object row) {
            TreePath path = (TreePath)row;
            return path.getLastPathComponent().toString();
        }

        @Override
        public Object getSelection() {
            return this._tree.getSelectionPath();
        }

        @Override
        public void setSelection(Object row) {
            TreePath path = (TreePath)row;
            this._tree.setSelectionPath(path);
            this._tree.scrollPathToVisible(path);
        }
    }
}

